/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.trace.views.util.internal.Coverage;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;

public class PackageNameColumnLabel
extends ColumnLabelAdapter {
    public String getDisplayString(Object element, ColumnDisplayInfo info) {
        if (element == null) {
            return "";
        }
        TRCPackage pack = this.getTRCPackage(element, info);
        if (pack != null) {
            String displayString = this.getDisplyStringFromMap((EObject)pack);
            if (displayString == null) {
                EObject eObj = ContextUpdaterHelper.getEObject(element);
                IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider((String)this.getContext(eObj), (String)"package.name", (int)1);
                displayString = formatter.getDisplayStringFromElement((Object)pack.getName(), (Object)pack, 1);
                this.displayStringMap.put(pack, displayString);
            }
            if (info == null || info.mofObject instanceof TRCAgentProxy || info.mofObject instanceof TRCProcessProxy) {
                return displayString;
            }
            return String.valueOf(displayString) + " [" + pack.getProcess().getPid() + "]";
        }
        return "";
    }

    protected TRCPackage getTRCPackage(Object element, ColumnDisplayInfo info) {
        if (element == null) {
            return null;
        }
        if (element instanceof TRCPackage) {
            return (TRCPackage)element;
        }
        if (element instanceof TRCClass) {
            return ((TRCClass)element).getPackage();
        }
        if (element instanceof TRCMethod) {
            if (((TRCMethod)element).getDefiningClass() != null) {
                return ((TRCMethod)element).getDefiningClass().getPackage();
            }
            return null;
        }
        if (element instanceof TRCObjectReference) {
            TRCObjectReference ref = (TRCObjectReference)element;
            TRCHeapObject object = null;
            object = info.showReferTo ? ref.getOwner() : ref.getTarget();
            return PerftraceUtil.getClass((TRCObject)object).getPackage();
        }
        if (element instanceof TRCObject) {
            return PerftraceUtil.getClass((TRCObject)((TRCObject)element)).getPackage();
        }
        if (element instanceof Coverage) {
            return this.getTRCPackage(((Coverage)element).getTraceObj(), info);
        }
        return null;
    }

    public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
        if (element == null) {
            return null;
        }
        TRCPackage pack = this.getTRCPackage(element, info);
        if (pack != null) {
            EObject eObj = ContextUpdaterHelper.getEObject(element);
            IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider((String)this.getContext(eObj), (String)"package.name", (int)1);
            return this.createImage(formatter.getDisplayImageByElement((Object)pack.getName(), element, 1));
        }
        return null;
    }

    public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {
        return null;
    }
}

