/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.IColorChangedListener;
import org.eclipse.hyades.trace.views.util.internal.SpectrumColorMap;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public abstract class BufferedCanvas
extends Canvas
implements IColorChangedListener {
    private Image fBuffer;

    public BufferedCanvas(Composite parent, int flags) {
        super(parent, flags + 262144);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                BufferedCanvas.this.doubleBufferPaint(event.gc);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (BufferedCanvas.this.fBuffer != null) {
                    TraceUIPlugin.getDefault().removeColorChangedEventListener(BufferedCanvas.this);
                    BufferedCanvas.this.fBuffer.dispose();
                    BufferedCanvas.this.fBuffer = null;
                }
            }
        });
        TraceUIPlugin.getDefault().addColorChangedEventListener(this);
    }

    public abstract void doPaint(GC var1);

    private void doubleBufferPaint(GC dest) {
        Point size = this.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        if (this.fBuffer != null) {
            Rectangle r = this.fBuffer.getBounds();
            if (r.width != size.x || r.height != size.y) {
                this.fBuffer.dispose();
                this.fBuffer = null;
            }
        }
        if (this.fBuffer == null) {
            this.fBuffer = new Image((Device)this.getDisplay(), size.x, size.y);
        }
        GC gc = new GC((Drawable)this.fBuffer);
        try {
            gc.setBackground(this.getBackground());
            gc.fillRectangle(0, 0, size.x, size.y);
            this.doPaint(gc);
        }
        finally {
            gc.dispose();
        }
        dest.drawImage(this.fBuffer, 0, 0);
    }

    public void repaint() {
        if (!this.isDisposed()) {
            GC gc = new GC((Drawable)this);
            FontData data = SpectrumColorMap.getFontData();
            Font font = new Font((Device)this.getDisplay(), data);
            gc.setFont(font);
            this.doubleBufferPaint(gc);
            font.dispose();
            gc.dispose();
        }
    }

    public void handleColorChangedEvent() {
        if (!this.isDisposed()) {
            this.setBackground(SpectrumColorMap.getBackgroundColor());
            this.repaint();
        } else {
            TraceUIPlugin.getDefault().removeColorChangedEventListener(this);
        }
    }
}

