/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import java.util.ArrayList;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class ColumnsDialog
extends Dialog
implements SelectionListener {
    private Table _list;
    private ArrayList _nonVisibleList;
    private Button _moveUp;
    private Button _moveDown;
    private ArrayList _data;
    private String _defaultColumnsTemplate;
    private static final int _restoreDefaultsButtonId = 1025;
    private String _contextHelpId;
    private String _context;
    private Spinner _columnWidth;
    private String _title;

    public ColumnsDialog(Shell shell, String windowTitle, Image windowImage, ArrayList data, String defaultColumnsTemplate, String contextHelpId, String context) {
        super(shell);
        this._title = windowTitle;
        this._defaultColumnsTemplate = defaultColumnsTemplate;
        ColumnsDialog.setDefaultImage((Image)windowImage);
        this._contextHelpId = contextHelpId;
        this._data = new ArrayList(data.size());
        this._data.addAll(data);
        this._context = context;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this._title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 15;
        result.setLayout((Layout)layout);
        result.setLayoutData((Object)GridUtil.createFill());
        Label description = new Label(result, 0);
        GridData data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 3;
        description.setLayoutData((Object)data);
        description.setText(TraceUIMessages._63);
        Group dataComp = new Group(result, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        dataComp.setLayout((Layout)layout);
        data = GridUtil.createFill();
        data.horizontalSpan = 2;
        dataComp.setLayoutData((Object)data);
        dataComp.setText(TraceUIMessages.columnsGroup);
        this._list = new Table((Composite)dataComp, 2336);
        data = GridUtil.createFill();
        data.horizontalSpan = 2;
        this._list.setLayoutData((Object)data);
        Composite buttonWidget = new Composite(result, 0);
        data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        buttonWidget.setLayoutData((Object)data);
        GridLayout blayout = new GridLayout();
        blayout.numColumns = 1;
        buttonWidget.setLayout((Layout)blayout);
        this._moveUp = new Button(buttonWidget, 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this._moveUp.setLayoutData((Object)data);
        this._moveUp.setText(TraceUIMessages._64);
        this._moveDown = new Button(buttonWidget, 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this._moveDown.setLayoutData((Object)data);
        this._moveDown.setText(TraceUIMessages._65);
        this._list.addSelectionListener((SelectionListener)this);
        this._moveUp.addSelectionListener((SelectionListener)this);
        this._moveDown.addSelectionListener((SelectionListener)this);
        this._moveUp.setEnabled(false);
        this._moveDown.setEnabled(false);
        Label columnWidthLabel = new Label((Composite)dataComp, 0);
        columnWidthLabel.setLayoutData((Object)new GridData(16384, 128, true, false, 1, 1));
        columnWidthLabel.setText(TraceUIMessages.columnWidth);
        this._columnWidth = new Spinner((Composite)dataComp, 0);
        this._columnWidth.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        this._columnWidth.setMinimum(10);
        this._columnWidth.setMaximum(1000);
        this._columnWidth.setPageIncrement(10);
        this._columnWidth.setTextLimit(4);
        this._columnWidth.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Spinner spinner = (Spinner)e.widget;
                ColumnData cdata = (ColumnData)spinner.getData();
                if (cdata != null) {
                    cdata.width(spinner.getSelection());
                }
            }
        });
        columnWidthLabel.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ColumnsDialog.this._columnWidth.setFocus();
            }
        });
        this._nonVisibleList = new ArrayList();
        if (this._contextHelpId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this._contextHelpId);
        }
        this.populateList();
        return result;
    }

    protected void columnSelected(int idx) {
        ColumnData data;
        ColumnData columnData = data = idx >= 0 && idx < this._list.getItemCount() ? (ColumnData)this._list.getItem(idx).getData() : null;
        if (data != null && this._list.getItem(idx).getChecked()) {
            this._columnWidth.setEnabled(true);
            this._columnWidth.setData((Object)data);
            this._columnWidth.setSelection(data.width());
        } else {
            this._columnWidth.setEnabled(false);
            this._columnWidth.setData(null);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, TraceUIMessages._86, false);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this._data.clear();
            this._data.addAll(ColumnData.createColumnDataFromString(this._defaultColumnsTemplate));
            int idx = 0;
            while (idx < this._data.size()) {
                ColumnData data = (ColumnData)this._data.get(idx);
                data.setContext(this._context);
                ++idx;
            }
            this.populateList();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    public ArrayList getData() {
        return this._data;
    }

    protected void moveDown(int idx) {
        TableItem item = this._list.getItem(idx);
        ColumnData data = (ColumnData)item.getData();
        if (!data.isMovable()) {
            return;
        }
        TableItem newitem = new TableItem(this._list, 32, idx + 2);
        newitem.setChecked(item.getChecked());
        newitem.setText(item.getText());
        newitem.setData((Object)data);
        newitem.setGrayed(item.getGrayed());
        this._list.remove(idx);
        this._list.select(idx + 1);
    }

    protected void moveUp(int idx) {
        TableItem previousItem;
        ColumnData previousItemData;
        TableItem item = this._list.getItem(idx);
        ColumnData data = (ColumnData)item.getData();
        if (!data.isMovable()) {
            return;
        }
        if (idx > 0 && !(previousItemData = (ColumnData)(previousItem = this._list.getItem(idx - 1)).getData()).isMovable()) {
            return;
        }
        TableItem newitem = new TableItem(this._list, 32, idx - 1);
        newitem.setChecked(item.getChecked());
        newitem.setText(item.getText());
        newitem.setData((Object)data);
        newitem.setGrayed(item.getGrayed());
        this._list.remove(idx + 1);
        this._list.select(idx - 1);
    }

    protected void okPressed() {
        if (!this.validate()) {
            MessageDialog.openError((Shell)this.getShell(), (String)TraceMessages.TRC_MSGT, (String)TraceUIMessages._70);
            return;
        }
        this._data.clear();
        int idx = 0;
        int nvIdx = 0;
        while (idx < this._list.getItemCount() || nvIdx < this._nonVisibleList.size()) {
            ColumnData data = null;
            boolean checked = true;
            if (nvIdx < this._nonVisibleList.size()) {
                data = (ColumnData)this._nonVisibleList.get(nvIdx);
                if (data.getInitalPos() == this._data.size()) {
                    checked = true;
                    ++nvIdx;
                } else {
                    data = null;
                }
            }
            if (data == null) {
                TableItem item = this._list.getItem(idx);
                data = (ColumnData)item.getData();
                checked = item.getChecked();
                ++idx;
            }
            int style = data.getStyle();
            style = checked ? (style |= 1) : (style &= 0xFFFFFFFE);
            this._data.add(new ColumnData(data.key(), data.getInitalPos(), style, data.getAlignment(), data.width()));
        }
        super.okPressed();
    }

    private void populateList() {
        this._list.removeAll();
        while (this._nonVisibleList.size() > 0) {
            this._nonVisibleList.remove(0);
        }
        int idx = 0;
        while (idx < this._data.size()) {
            ColumnData data = (ColumnData)this._data.get(idx);
            if (data.visibleChooseColumns()) {
                TableItem item = new TableItem(this._list, 0);
                item.setText(data.name());
                item.setChecked(data.visible());
                item.setGrayed(data.isNonDeletable());
                item.setData((Object)data);
            } else {
                this._nonVisibleList.add(data);
            }
            ++idx;
        }
        this.columnSelected(this._list.getSelectionIndex());
    }

    private boolean validate() {
        boolean valid = false;
        int idx = 0;
        while (idx < this._list.getItemCount()) {
            TableItem item = this._list.getItem(idx);
            if (item.getChecked()) {
                return true;
            }
            ++idx;
        }
        return valid;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this._moveUp) {
            int idx = this._list.getSelectionIndex();
            if (idx > 0) {
                this.moveUp(idx);
            }
        } else if (e.widget == this._moveDown) {
            int idx = this._list.getSelectionIndex();
            if (idx != -1 && idx < this._list.getItemCount() - 1) {
                this.moveDown(idx);
            }
        } else if (e.widget instanceof Table) {
            TableItem[] items = this._list.getItems();
            int x = 0;
            while (x < items.length) {
                boolean checked = items[x].getChecked();
                ColumnData d = (ColumnData)items[x].getData();
                if (!checked && d.isNonDeletable()) {
                    items[x].setChecked(true);
                }
                ++x;
            }
        }
        int idx = this._list.getSelectionIndex();
        ColumnData data = null;
        ColumnData previousData = null;
        if (idx > 0) {
            previousData = (ColumnData)this._list.getItem(idx - 1).getData();
        }
        if (idx != -1) {
            data = (ColumnData)this._list.getItem(idx).getData();
        }
        this._moveUp.setEnabled(data != null && data.isMovable() && previousData != null && previousData.isMovable());
        this._moveDown.setEnabled(data != null && data.isMovable() && idx < this._list.getItemCount() - 1);
        this.columnSelected(idx);
    }
}

