/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.views.internal.FilteringUtil;
import org.eclipse.hyades.trace.views.util.internal.Coverage;
import org.eclipse.hyades.trace.views.util.internal.CoverageFolder;
import org.eclipse.hyades.trace.views.util.internal.CoverageLeaf;
import org.eclipse.hyades.trace.views.util.internal.CoverageUtil;

public class CoverageAnalysis {
    private CoverageFolder root = null;
    private HashMap coveragesMap = null;
    private SimpleSearchQuery _filter;

    public CoverageAnalysis(EObject object, SimpleSearchQuery filter) {
        this._filter = filter;
        Object[] packs = FilteringUtil.getFilteredPackages(this._filter, FilteringUtil.getProcessList(object)).toArray();
        BasicEList listPack = new BasicEList();
        int i = 0;
        while (i < packs.length) {
            if (!CoverageUtil.isFiltered((TRCPackage)packs[i])) {
                listPack.add(packs[i]);
            }
            ++i;
        }
        this.root = !listPack.isEmpty() ? this.compute((EList)listPack, object) : null;
    }

    public CoverageLeaf FindCoverageLeaf(CoverageFolder parent, EObject obj) {
        TRCMethod m;
        String fullSig;
        CoverageLeaf cl;
        if (this.coveragesMap == null) {
            this.coveragesMap = new HashMap();
        }
        if ((cl = (CoverageLeaf)this.coveragesMap.get(fullSig = CoverageUtil.getFullSig(m = (TRCMethod)obj))) == null) {
            cl = new CoverageLeaf(this, parent);
            this.coveragesMap.put(fullSig, cl);
            parent.getChilds().add(cl);
        }
        cl.addTraceObjects(obj);
        return cl;
    }

    public CoverageFolder FindCoverageFolder(CoverageFolder parent, EObject obj) {
        if (this.coveragesMap == null) {
            this.coveragesMap = new HashMap();
        }
        String fullSig = null;
        if (obj instanceof TRCClass) {
            TRCClass c = (TRCClass)obj;
            fullSig = CoverageUtil.getFullSig(c);
        } else if (obj instanceof TRCPackage) {
            TRCPackage p = (TRCPackage)obj;
            fullSig = CoverageUtil.getFullSig(p);
        } else {
            fullSig = obj.toString();
        }
        CoverageFolder cf = (CoverageFolder)this.coveragesMap.get(fullSig);
        if (cf == null) {
            cf = new CoverageFolder(this, parent, this._filter);
            this.coveragesMap.put(fullSig, cf);
            parent.getChilds().add(cf);
        }
        cf.addTraceObjects(obj);
        return cf;
    }

    protected CoverageFolder compute(EList listPack, EObject proc) {
        CoverageFolder cov = new CoverageFolder(this, null, this._filter);
        cov.addTraceObjects(proc);
        cov.parse(listPack);
        cov.compute();
        return cov;
    }

    public Coverage getClassLevel() {
        CoverageFolder classLevel = this.duplicate(this.root);
        ArrayList classList = new ArrayList();
        classList.clear();
        ArrayList packList = this.root.getChilds();
        int i = 0;
        while (i < packList.size()) {
            Coverage covPack = (Coverage)packList.get(i);
            ArrayList list = covPack.getChilds();
            int j = 0;
            while (j < list.size()) {
                classList.add(list.get(j));
                ++j;
            }
            ++i;
        }
        classLevel.setChilds(classList);
        return classLevel;
    }

    public Coverage getMethodLevel() {
        int j;
        ArrayList list = new ArrayList();
        ArrayList classList = new ArrayList();
        ArrayList methodList = new ArrayList();
        ArrayList methodListF = new ArrayList();
        CoverageFolder methodLevel = this.duplicate(this.root);
        ArrayList packList = this.root.getChilds();
        int i = 0;
        while (i < packList.size()) {
            Coverage covPack = (Coverage)packList.get(i);
            list = covPack.getChilds();
            j = 0;
            while (j < list.size()) {
                classList.add(list.get(j));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < classList.size()) {
            Coverage covClass = (Coverage)classList.get(i);
            list = covClass.getChilds();
            j = 0;
            while (j < list.size()) {
                methodList.add(list.get(j));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < methodList.size()) {
            Coverage covElement = (Coverage)methodList.get(i);
            if (covElement.getTraceObj() instanceof TRCClass) {
                list = covElement.getChilds();
                j = 0;
                while (j < list.size()) {
                    methodListF.add(list.get(j));
                    ++j;
                }
            } else {
                methodListF.add(covElement);
            }
            ++i;
        }
        methodLevel.setChilds(methodListF);
        return methodLevel;
    }

    protected CoverageFolder duplicate(CoverageFolder covArg) {
        CoverageFolder cov = new CoverageFolder(this, null, covArg, this._filter);
        return cov;
    }

    public CoverageFolder getRoot() {
        return this.root;
    }
}

