/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCFilter;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCSourceInfo;

public class CoverageUtil {
    private static final String Path_Separator = ".";
    private static String externFilterPattern = null;

    private static String getSourceSig(TRCSourceInfo e) {
        return e != null ? String.valueOf(e.getLocation()) + ":" : "";
    }

    public static String getFullSig(TRCMethod e) {
        return String.valueOf(CoverageUtil.getSourceSig(e.getSourceInfo())) + e.getLineNo() + ":" + CoverageUtil.getSig(e.getDefiningClass()) + Path_Separator + e.getName() + e.getSignature();
    }

    public static String getFullSig(TRCClass e) {
        return String.valueOf(CoverageUtil.getSourceSig(e.getSourceInfo())) + e.getLineNo() + ":" + CoverageUtil.getSig(e);
    }

    public static String getFullSig(TRCPackage e) {
        return e.getName();
    }

    private static String getSig(TRCClass e) {
        return String.valueOf(e.getPackage().getName() == null ? "" : String.valueOf(e.getPackage().getName()) + Path_Separator) + e.getName();
    }

    public static boolean isFiltered(TRCPackage pac) {
        if (pac.getClasses() == null || pac.getClasses().size() == 0) {
            return true;
        }
        EList cllist = pac.getClasses();
        int remaining = cllist.size();
        int idx = 0;
        while (idx < remaining) {
            Object obj = cllist.get(idx);
            if (obj instanceof TRCClass && CoverageUtil.isFiltered((TRCClass)obj)) {
                --remaining;
            }
            ++idx;
        }
        return remaining == 0;
    }

    public static boolean isFiltered(TRCClass cl) {
        if (cl.getMethods() == null || cl.getMethods().size() == 0) {
            return true;
        }
        Object[] conflist = cl.getPackage().getProcess().getAgent().getAgentProxy().getConfigurations().toArray();
        int idxmax = conflist.length;
        int idx = 0;
        while (idx < idxmax) {
            TRCConfiguration c = (TRCConfiguration)conflist[idx];
            if (c.isActive()) {
                Object[] filtlist = c.getFilters().toArray();
                int k = 0;
                while (k < filtlist.length) {
                    LocalBoolean exclude;
                    TRCFilter f = (TRCFilter)filtlist[k];
                    if (f.getActive().booleanValue() && CoverageUtil.isFilteredClass(f, cl, exclude = new LocalBoolean(true))) {
                        return exclude.bool;
                    }
                    ++k;
                }
            }
            ++idx;
        }
        return false;
    }

    private static boolean isFilteredClass(TRCFilter filter, TRCClass cl, LocalBoolean exclude) {
        String methodPattern;
        String pattern = filter.getPattern();
        String mode = filter.getMode();
        String type = filter.getType();
        if (type.equals(mode)) {
            type = CoverageUtil.parseFilterPattern(pattern);
            pattern = externFilterPattern;
        }
        if ((methodPattern = filter.getOperation()) != null && methodPattern.length() > 0 && !methodPattern.equals("*")) {
            return false;
        }
        String clname = cl.getName();
        String fullname = String.valueOf(cl.getPackage().getName()) + Path_Separator + clname;
        exclude.bool = !mode.equals("INCLUDE");
        if (type.equals("NONE")) {
            if (fullname.equals(pattern)) {
                return true;
            }
            if (clname.equals(pattern)) {
                return true;
            }
        } else if (type.equals("PREFIX")) {
            if (fullname.endsWith(pattern)) {
                return true;
            }
            if (clname.endsWith(pattern)) {
                return true;
            }
        } else if (type.equals("SUFFIX")) {
            if (fullname.startsWith(pattern)) {
                return true;
            }
            if (clname.startsWith(pattern)) {
                return true;
            }
        }
        return false;
    }

    private static String parseFilterPattern(String filterPattern) {
        String genericPattern = "NONE";
        if (filterPattern.length() == 0) {
            externFilterPattern = filterPattern;
            return genericPattern;
        }
        int p = filterPattern.indexOf(42);
        if (p == 0) {
            genericPattern = "PREFIX";
            externFilterPattern = filterPattern.substring(1);
        } else if (p == filterPattern.length() - 1) {
            genericPattern = "SUFFIX";
            externFilterPattern = filterPattern.substring(0, filterPattern.length() - 1);
        } else {
            externFilterPattern = filterPattern;
        }
        return genericPattern;
    }

    public static boolean isCoverageSupport(EObject mofObject) {
        boolean isSupport;
        block9: {
            block12: {
                block11: {
                    block10: {
                        isSupport = false;
                        if (mofObject == null) break block9;
                        if (!(mofObject instanceof TRCAgentProxy)) break block10;
                        EList configs = ((TRCAgentProxy)mofObject).getConfigurations();
                        int i = 0;
                        while (i < configs.size()) {
                            TRCConfiguration config = (TRCConfiguration)configs.get(i);
                            EList options = config.getOptions();
                            int opt = 0;
                            while (opt < options.size()) {
                                TRCOption option = (TRCOption)options.get(opt);
                                if (option.getKey().equals("METHOD_COUNTS")) {
                                    isSupport = Boolean.valueOf(option.getValue());
                                    return isSupport;
                                }
                                ++opt;
                            }
                            ++i;
                        }
                        break block9;
                    }
                    if (!(mofObject instanceof TRCProcessProxy)) break block11;
                    Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                    int idx = 0;
                    while (idx < agents.length) {
                        isSupport = CoverageUtil.isCoverageSupport((EObject)((TRCAgentProxy)agents[idx]));
                        if (isSupport) {
                            return true;
                        }
                        ++idx;
                    }
                    break block9;
                }
                if (!(mofObject instanceof TRCNode)) break block12;
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                int idx = 0;
                while (idx < processes.length) {
                    isSupport = CoverageUtil.isCoverageSupport((EObject)((TRCProcessProxy)processes[idx]));
                    if (isSupport) {
                        return true;
                    }
                    ++idx;
                }
                break block9;
            }
            if (!(mofObject instanceof TRCMonitor)) break block9;
            Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
            int k = 0;
            while (k < nodes.length) {
                isSupport = CoverageUtil.isCoverageSupport((EObject)((TRCNode)nodes[k]));
                if (isSupport) {
                    return true;
                }
                ++k;
            }
        }
        return isSupport;
    }

    private static class LocalBoolean {
        public boolean bool;

        public LocalBoolean(boolean b) {
            this.bool = b;
        }
    }
}

