/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadDeadEvent;
import org.eclipse.hyades.models.trace.TRCThreadDeadLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadRunningEvent;
import org.eclipse.hyades.models.trace.TRCThreadSleepingEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent;

public class ThreadDetails {
    public static final int UNKNOWN = 0;
    public static final int RUNNING = 1;
    public static final int SLEEPING = 2;
    public static final int WAITING = 3;
    public static final int BLOCKED = 4;
    public static final int DEADLOCK = 5;
    public static final int STOPPED = 6;
    protected static final int[] _colorCodes = new int[]{1, 5, 9, 13, 7, 3, 16};
    protected TRCThread _thread;
    protected int _threadState;
    protected double _runningTime;
    protected double _sleepingTime;
    protected double _waitingTime;
    protected double _blockedTime;
    protected double _deadlockedTime;
    protected int _blockCount;
    protected int _deadlockCount;

    public ThreadDetails(TRCThread thread) {
        this._thread = thread;
        this.updateNumbers();
    }

    public TRCThread getThread() {
        return this._thread;
    }

    public int getState() {
        return this._threadState;
    }

    public double getRunningTime() {
        return this._runningTime;
    }

    public int getBlockCount() {
        return this._blockCount;
    }

    public int getDeadlockCount() {
        return this._deadlockCount;
    }

    public double getBlockedTime() {
        return this._blockedTime;
    }

    public double getDeadlockedTime() {
        return this._deadlockedTime;
    }

    public double getSleepingTime() {
        return this._sleepingTime;
    }

    public double getWaitingTime() {
        return this._waitingTime;
    }

    public static int getStateColor(int state) {
        return _colorCodes[state];
    }

    protected int getEventType(TRCThreadEvent event) {
        if (event instanceof TRCThreadRunningEvent) {
            return 1;
        }
        if (event instanceof TRCThreadSleepingEvent) {
            return 2;
        }
        if (event instanceof TRCThreadDeadLockEvent) {
            return 5;
        }
        if (event instanceof TRCThreadWaitingForLockEvent) {
            return 4;
        }
        if (event instanceof TRCThreadWaitingForObjectEvent) {
            return 3;
        }
        if (event instanceof TRCThreadDeadEvent) {
            return 6;
        }
        return 0;
    }

    protected void updateNumbers() {
        EList events = this._thread.getThreadEvents();
        int count = events.size();
        if (count < 1) {
            return;
        }
        TRCThreadEvent event = (TRCThreadEvent)events.get(0);
        int i = 1;
        while (i < count) {
            TRCThreadEvent next = (TRCThreadEvent)events.get(i);
            double timeSpan = Math.max(next.getTime() - event.getTime(), 0.0);
            this.addEvent(this.getEventType(event), timeSpan);
            event = next;
            ++i;
        }
        this._threadState = this.getEventType(event);
        double timeSpan = Math.max(this._thread.getProcess().getLastEventTime() - event.getTime(), 0.0);
        this.addEvent(this._threadState, timeSpan);
    }

    protected void addEvent(int eventType, double timeSpan) {
        switch (eventType) {
            case 4: {
                this._blockedTime += timeSpan;
                ++this._blockCount;
                break;
            }
            case 5: {
                this._deadlockedTime += timeSpan;
                ++this._deadlockCount;
                break;
            }
            case 2: {
                this._sleepingTime += timeSpan;
                break;
            }
            case 3: {
                this._waitingTime += timeSpan;
                break;
            }
            case 1: {
                this._runningTime += timeSpan;
            }
        }
    }
}

