/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class TraceSDUtil {
    public static final String UML2SD_TRACE_VIEW_ID = "org.eclipse.hyades.uml2sd.trace.view.TraceSDView";
    private static URL BASIC_URL = null;
    private static Hashtable images = null;
    public static boolean debugMatch = TraceSDUtil.checkForDebugTrace("org.eclipse.hyades.uml2sd.trace/match");
    public static boolean debugLoader = TraceSDUtil.checkForDebugTrace("org.eclipse.hyades.uml2sd.trace/loader");
    public static boolean debugEvents = TraceSDUtil.checkForDebugTrace("org.eclipse.hyades.uml2sd.trace/events");
    public static boolean debugPlugin = TraceSDUtil.checkForDebugTrace("org.eclipse.hyades.uml2sd.trace/plugin");

    public static void shutdown() throws Exception {
        if (images != null) {
            for (Object next : images.values()) {
                if (!(next instanceof Image) || ((Image)next).isDisposed()) continue;
                ((Image)next).dispose();
            }
            images.clear();
            images = null;
        }
        TraceSDUtil.debugUml2SDTracePlugin("stop finished");
    }

    public static Image getResourceImage(String _name) {
        ImageDescriptor imgd;
        if (TraceUIPlugin.getDefault() == null) {
            return null;
        }
        if (images != null) {
            Image img = (Image)images.get(_name);
            if (img != null && !img.isDisposed()) {
                TraceSDUtil.debugUml2SDTracePlugin("Optimizing for image " + _name);
                return img;
            }
        } else {
            images = new Hashtable();
        }
        if ((imgd = TraceSDUtil.getResourceImageDescriptor(_name)) == null) {
            return null;
        }
        Image img = imgd.createImage();
        images.put(_name, img);
        return img;
    }

    public static ImageDescriptor getResourceImageDescriptor(String _name) {
        ImageDescriptor imgd;
        if (BASIC_URL == null) {
            try {
                BASIC_URL = new URL("platform", "localhost", "plugin");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            URL url = new URL(BASIC_URL, "plugin/org.eclipse.hyades.trace.views/icons/" + _name);
            imgd = ImageDescriptor.createFromURL((URL)url);
            TraceSDUtil.debugUml2SDTracePlugin("Getting image " + url);
        }
        catch (MalformedURLException malformedURLException) {
            imgd = ImageDescriptor.getMissingImageDescriptor();
            TraceSDUtil.debugUml2SDTracePlugin("Missing image " + BASIC_URL + _name);
        }
        return imgd;
    }

    private static boolean checkForDebugTrace(String option) {
        String value = Platform.getDebugOption((String)option);
        return value != null && value.equalsIgnoreCase("true");
    }

    public static void debugUml2SDTraceMatch(String msg) {
        if (debugMatch) {
            System.out.println(msg);
        }
    }

    public static void debugUml2SDTraceLoader(String msg) {
        if (debugLoader) {
            System.out.println(msg);
        }
    }

    public static void debugUml2SDTraceEvents(String msg) {
        if (debugEvents) {
            System.out.println(msg);
        }
    }

    public static void debugUml2SDTracePlugin(String msg) {
        if (debugPlugin) {
            System.out.println(msg);
        }
    }
}

