/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.actions.internal;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.uml2sd.trace.actions.internal.OpenObjectInteractions;
import org.eclipse.hyades.uml2sd.trace.loaders.TraceInteractions;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcess;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcesses;
import org.eclipse.hyades.uml2sd.trace.selection.IDateSelection;
import org.eclipse.hyades.uml2sd.trace.util.TIUtils;
import org.eclipse.hyades.uml2sd.ui.load.BackgroundLoader;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;

public class OpenObjectInteractionsAndScrollToTime
extends Action {
    private void showTimeInTrace(TRCAgent agent, final double targetTime) {
        PDProjectExplorer pdExplorer = PDProjectExplorer.getFromActivePerspective();
        pdExplorer.selectObject((Object)agent.getAgentProxy());
        OpenObjectInteractions ooi = new OpenObjectInteractions();
        ooi.run();
        BackgroundLoader.getInstance().newSubsequentTask(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        TimeSelection ts = new TimeSelection(targetTime);
                        TraceInteractions.setExternalDateSelection(ts);
                    }
                });
            }
        });
    }

    private void runTheExampleAction() {
        TraceProcesses processes = TraceProcesses.getTraceProcesses(HyadesUtil.getMofObject(), new IProgressMonitor(){

            public void beginTask(String name, int totalWork) {
            }

            public void done() {
            }

            public void internalWorked(double work) {
            }

            public boolean isCanceled() {
                return false;
            }

            public void setCanceled(boolean value) {
            }

            public void setTaskName(String name) {
            }

            public void subTask(String name) {
            }

            public void worked(int work) {
            }
        });
        if (processes.size() < 1) {
            System.err.println("No processes here");
            return;
        }
        TraceProcess tp = (TraceProcess)processes.get(0);
        TRCProcess process = tp.getProcess();
        TRCAgent agent = process.getAgent();
        double targetTime = TIUtils.getAbsoluteEntryTime(process) + (process.getStartTime() + process.getStopTime()) / 2.0;
        this.showTimeInTrace(agent, targetTime);
        IWorkbenchPage persp = UIPlugin.getActivePage();
        SDView sdView = (SDView)persp.findView("org.eclipse.hyades.uml2sd.trace.view.TraceSDView");
        if (sdView == null) {
            System.err.println("View not found");
        }
    }

    public void run() {
        this.runTheExampleAction();
    }

    private class TimeSelection
    implements IDateSelection {
        private double targetTime;

        public TimeSelection(double targetTime_) {
            this.targetTime = targetTime_;
        }

        public int getMeaning() {
            return 0;
        }

        public double getStartDate() {
            return this.targetTime;
        }

        public double getEndDate() {
            return this.getStartDate();
        }

        public EObject getEObject() {
            return null;
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + ":" + this.hashCode() + "[" + this.targetTime + "]";
        }
    }
}

