/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.loaders;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.uml2sd.trace.loaders.BaseLifelineLoader;
import org.eclipse.hyades.uml2sd.trace.loaders.ClassInteractions;

public class ObjectInteractions
extends BaseLifelineLoader {
    public ObjectInteractions() {
        this.parent = new ClassInteractions();
    }

    public EObject getLifelineEObjectFromMethodInvocation(TRCFullMethodInvocation mi) {
        if (mi.getOwningObject() == null || mi.getOwningObject().getIsA() == mi.getProcess().getClassClass()) {
            return mi.getMethod().getDefiningClass();
        }
        return mi.getOwningObject();
    }

    public String getLifeLineTitle(EObject eo, boolean long_) {
        TRCClass cl;
        String owningObject = "";
        if (eo instanceof TRCTraceObject) {
            TRCTraceObject to = (TRCTraceObject)eo;
            cl = to.getIsA();
            owningObject = ":" + to.getId();
        } else {
            cl = (TRCClass)eo;
        }
        return String.valueOf(cl.getName()) + owningObject + (!long_ && cl.getPackage() != null ? " (" + cl.getPackage().getName() + ")" : "");
    }

    public String getDistinguishedLifeLineTitle(EObject eo, int rank) {
        TRCProcess process = eo instanceof TRCTraceObject ? ((TRCTraceObject)eo).getProcess() : ((TRCClass)eo).getPackage().getProcess();
        return String.valueOf(this.getLifeLineTitle(eo, true)) + " [" + process.getPid() + "]";
    }

    public String getLifeLineId(EObject eo) {
        TRCAgentProxy ap = eo instanceof TRCTraceObject ? ((TRCTraceObject)eo).getProcess().getAgent().getAgentProxy() : ((TRCClass)eo).getPackage().getProcess().getAgent().getAgentProxy();
        return String.valueOf(ap.getRuntimeId()) + "#" + this.getLifeLineTitle(eo, true);
    }

    public int getLifeLineCategory(EObject eo) {
        if (eo instanceof TRCClass) {
            return 0;
        }
        return 1;
    }

    public String getFinalTitleString() {
        return TraceUIPlugin.getResourceString("41");
    }

    public boolean drillDownEnabled(String value) {
        return "false".equalsIgnoreCase(value);
    }

    public String getLifelineType(EObject eObject) {
        if (eObject instanceof TRCClass) {
            return TraceUIMessages._143;
        }
        return TraceUIMessages._144;
    }

    public String getLifelineTypeName() {
        return TraceUIMessages._145;
    }
}

