/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.loaders;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.ui.filters.FilterActions;
import org.eclipse.hyades.ui.filters.IFilterQueryProvider;
import org.eclipse.hyades.ui.filters.IFilterViewer;
import org.eclipse.hyades.uml2sd.trace.TraceSDUtil;
import org.eclipse.hyades.uml2sd.trace.actions.internal.ChangeLifelineLoaderAction;
import org.eclipse.hyades.uml2sd.trace.actions.internal.UndoDrillDownMenuAction;
import org.eclipse.hyades.uml2sd.trace.loaders.BaseLifelineLoader;
import org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions;
import org.eclipse.hyades.uml2sd.trace.loaders.ILifelineLoader;
import org.eclipse.hyades.uml2sd.trace.loaders.ObjectInteractions;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.FilterQuery;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.FoundInPage;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.ITraceMessage;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCallStack;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCollapsableSyncMessage;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCollapsableSyncMessageReturn;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCollapsedLifelines;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCollapsedSyncMessage;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCollapsedSyncMessageReturn;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUpdate;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUtils;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceLifeline;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceLifelineDraft;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceMessageAndCallAssociation;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TracePage;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcess;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceRootProperty;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceSyncMessage;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceSyncMessageReturn;
import org.eclipse.hyades.uml2sd.trace.preferences.ITraceInteractionPreferenceListener;
import org.eclipse.hyades.uml2sd.trace.selection.IDateSelection;
import org.eclipse.hyades.uml2sd.trace.selection.IEObjectSelection;
import org.eclipse.hyades.uml2sd.trace.util.TIUtils;
import org.eclipse.hyades.uml2sd.ui.actions.provider.IExtendedFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDCollapseProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDInternalMesFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDPagingProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDPropertiesProvider;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.FilterCriteria;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.FilterListDialog;
import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.ITimeRange;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;
import org.eclipse.hyades.uml2sd.ui.drawings.IImage;
import org.eclipse.hyades.uml2sd.ui.drawings.impl.ImageImpl;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.hyades.uml2sd.util.SDUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class TraceInteractions
extends BaseTraceInteractions
implements IExtendedFilterProvider,
ISDAdvancedPagingProvider,
ISDInternalMesFilterProvider,
ISDCollapseProvider,
ITraceInteractionPreferenceListener,
ISDPropertiesProvider,
ISDFilterProvider,
IFilterViewer {
    public static final int CATEGORY_CLASSES = 0;
    public static final int CATEGORY_OBJECTS = 1;
    public static final int CATEGORY_NODE = 2;
    public static final int CATEGORY_AGENT = 3;
    public static final int CATEGORY_PROCESS = 4;
    public static final int CATEGORY_THREAD = 5;
    public static final int CATEGORY_COLLAPSED = 6;
    public static final int CATEGORY_CARD = 7;
    private static LifelineCategories[] traceCategories = new LifelineCategories[7];
    private boolean internalMessagesFiltered = false;
    private SimpleSearchQuery filter;
    private IFilterQueryProvider filterQueryProvider;
    private int maximumMessagesByPage = (int)TraceUIPlugin.getDefault().getPreferenceStore().getLong("page_size");
    private int nbMessages;
    private int nbMessagesInThisPage;
    private int pageNumber = 0;
    private boolean hasNextPage = false;
    private int totalNbMessages;
    private int pages;
    private ArrayList tracePages;
    private HashMap instancesMap;
    private HashMap lifelinesByName;
    private ArrayList lifelinesToDistinguish;
    protected Timer subscribeSelectionTimer;
    private static final String INTERNAL_MESSAGES = "internalMessages";
    private List currentFilters;
    private boolean hasPositiveFilters = false;
    private String drillDownBreadcrump = "";
    private UndoDrillDownMenuAction undoDrillDownMenuAction;
    private static FilterCriteria unmatchFilterCriteria;
    private static final String HORIZONTAL_COLLAPSING = "horizontalCollapsing";
    private HashMap collapsedLifelines;
    private HashMap collapsedMessages;
    private static final String VERTICAL_COLLAPSING = "verticalCollapsing";
    private ArrayList lifelineReordered = null;
    private static TraceInteractions instance;
    private ILifelineLoader lifelineLoader;

    static {
        TraceInteractions.traceCategories[0] = new LifelineCategories();
        traceCategories[0].setName(TraceUIMessages._143);
        traceCategories[0].setImage((IImage)new ImageImpl(TraceSDUtil.getResourceImage("full/obj16/class.gif")));
        TraceInteractions.traceCategories[1] = new LifelineCategories();
        traceCategories[1].setName(TraceUIMessages._144);
        traceCategories[1].setImage((IImage)new ImageImpl(TraceSDUtil.getResourceImage("full/obj16/classobject_obj.gif")));
        TraceInteractions.traceCategories[2] = new LifelineCategories();
        traceCategories[2].setName(TraceUIMessages._139);
        traceCategories[2].setImage((IImage)new ImageImpl(TraceSDUtil.getResourceImage("full/obj16/node_obj.gif")));
        TraceInteractions.traceCategories[3] = new LifelineCategories();
        traceCategories[3].setName(TraceUIMessages._141);
        traceCategories[3].setImage((IImage)new ImageImpl(TraceSDUtil.getResourceImage("full/obj16/agent_obj.gif")));
        TraceInteractions.traceCategories[4] = new LifelineCategories();
        traceCategories[4].setName(TraceUIMessages._140);
        traceCategories[4].setImage((IImage)new ImageImpl(TraceSDUtil.getResourceImage("full/obj16/process_obj.gif")));
        TraceInteractions.traceCategories[5] = new LifelineCategories();
        traceCategories[5].setName(TraceUIMessages._142);
        traceCategories[5].setImage((IImage)new ImageImpl(TraceSDUtil.getResourceImage("full/obj16/thread_obj.gif")));
        TraceInteractions.traceCategories[6] = new LifelineCategories();
        traceCategories[6].setName(TraceUIMessages._152);
        traceCategories[6].setImage((IImage)new ImageImpl(TraceSDUtil.getResourceImage("full/obj16/collapsed_obj.gif")));
        unmatchFilterCriteria = new FilterCriteria(null, true, false, null);
    }

    public void onSetViewer() {
        this.view.setExtendedFilterProvider((IExtendedFilterProvider)this);
        this.view.setSDFilterProvider((ISDFilterProvider)this);
        this.view.setSDPagingProvider((ISDPagingProvider)this);
        this.view.setInternalMessageFilterProvider((ISDInternalMesFilterProvider)this);
        this.view.setCollapsingProvider((ISDCollapseProvider)this);
        this.view.getSDWidget().setReorderMode(true);
        this.view.setSDPropertiesProvider((ISDPropertiesProvider)this);
        this.currentFilters = FilterListDialog.getGlobalFilters();
        this.updateHasPositiveLifelineFilters();
        this.collapsedLifelines = this.loadCollapsedLifelines();
        this.collapsedMessages = this.loadCollapsedMessages();
    }

    public void clearInternals() {
        super.clearInternals();
        this.pageNumber = 0;
        this.tracePages = null;
        this.lifelineReordered = null;
    }

    protected TraceInteractionUpdate createTraceInteractionUpdate() {
        TraceInteractionUpdate ret = new TraceInteractionUpdate();
        return ret;
    }

    protected synchronized void parseModel(List list) {
        long start = 0L;
        if (TraceSDUtil.debugEvents) {
            start = System.currentTimeMillis();
        }
        if (TraceSDUtil.debugEvents) {
            TraceSDUtil.debugUml2SDTraceEvents("Start parseModel()");
        }
        this.clearInternals();
        this.currentMofObjectsFromPDProjectExplorer = list;
        this.createFrame();
        if (this.isEmpty()) {
            if (this.view != null && !this.view.getSDWidget().isDisposed()) {
                this.setFrameName();
                this.view.setFrameSync(this.frame);
            }
            if (TraceSDUtil.debugEvents) {
                TraceSDUtil.debugUml2SDTraceEvents("Abort parseModel()");
            }
            return;
        }
        try {
            this.computeModel();
            this.fillPage(new TraceInteractionUpdate());
            if (this.view != null && !this.view.getSDWidget().isDisposed() && this.frame != null && !this.isCurrentLoadCanceled()) {
                this.setFrameName();
                this.view.setFrameSync(this.frame);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (TraceSDUtil.debugEvents) {
            if (this.isCurrentLoadCanceled()) {
                TraceSDUtil.debugUml2SDTraceEvents("Cancelled parseModel() after " + (System.currentTimeMillis() - start) + "ms");
            } else {
                TraceSDUtil.debugUml2SDTraceEvents("End parseModel() after " + (System.currentTimeMillis() - start) + "ms");
            }
        }
    }

    protected synchronized void updateSD(TraceInteractionUpdate update) {
        if (this.currentProcesses == null) {
            return;
        }
        Frame oldFrame = this.frame;
        if (!(this.frame == null || update.isDateSelectionChanged() || update.isPageChanged() || update.isFindRequired() || update.isFindInvocationRequired())) {
            double visibleDate = 0.0;
            this.currentProcesses.init();
            TraceSyncMessage firstSM = (TraceSyncMessage)this.frame.getSyncMessage(this.frame.getFirstVisibleSyncMessage());
            if (firstSM != null) {
                visibleDate = firstSM.getStartDate() + this.currentProcesses.getStartTime();
            } else {
                TraceSyncMessageReturn firstSMR = (TraceSyncMessageReturn)this.frame.getSyncMessageReturn(this.frame.getFirstVisibleSyncMessageReturn());
                if (firstSMR != null) {
                    visibleDate = firstSMR.getStartDate() + this.currentProcesses.getStartTime();
                }
            }
            if (visibleDate != 0.0) {
                update.setDateSelectionChanged(true);
                update.setDateToShow(visibleDate);
            }
            if (TraceSDUtil.debugLoader) {
                TraceSDUtil.debugUml2SDTraceLoader("visibleDate=" + visibleDate + " " + update.isPageChanged() + " " + update.isDateSelectionChanged());
            }
        }
        this.createFrame();
        if (this.currentProcesses == null) {
            return;
        }
        try {
            if (!update.isPageChanged() && (update.isLifelineLoaderChanged() || update.isInternalMessageFilteringChanged() || update.isMaxMessagesByPageChanged() || update.isFilteringChanged() || update.isHorizontalCollapsingChanged() || update.isVerticalCollapsingChanged())) {
                this.computeModel();
            }
            this.fillPage(update);
        }
        catch (FoundInPage foundInPage) {
            if (TraceSDUtil.debugLoader) {
                foundInPage.printStackTrace(System.out);
            }
            if (update.isDateSelectionChanged() || update.isFindRequired() || update.isFindInvocationRequired()) {
                update.setPageChanged(true);
                this.pageNumber = foundInPage.getPage();
                this.updateSD(update);
                return;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (!update.isPageChanged()) {
            if (update.isDateSelectionChanged() && this.frame.lifeLinesCount() > 0 && update.getVisibleGraphNode() == null) {
                update.setPageChanged(true);
                this.pageNumber = this.pages - 1;
                this.createFrame();
                try {
                    this.fillPage(update);
                }
                catch (FoundInPage foundInPage) {}
                update.setPreviousVisibleGraphNode(null);
                update.setVisibleGraphNode((GraphNode)this.frame.getSyncMessageReturn(this.frame.syncMessageReturnCount() - 1));
            } else {
                if (update.isFindRequired() && (update.getFindResults() == null || update.getFindResults().size() == 0)) {
                    this.frame = oldFrame;
                    return;
                }
                if (update.isFindInvocationRequired() && update.getFindInvocationResult() == null) {
                    this.frame = oldFrame;
                    return;
                }
            }
        }
        if (this.view != null && !this.view.getSDWidget().isDisposed() && !this.isCurrentLoadCanceled()) {
            this.setFrameName();
            if (update.getVisibleGraphNode() != null) {
                GraphNode firstVisibleGraphNode = update.getPreviousVisibleGraphNode();
                if (firstVisibleGraphNode == null || !(firstVisibleGraphNode instanceof BaseMessage) || !(update.getVisibleGraphNode() instanceof BaseMessage)) {
                    firstVisibleGraphNode = update.getVisibleGraphNode();
                }
                if (update.getVisibleX() != 0) {
                    this.view.setFrameAndEnsureVisibleSync(this.frame, Math.min(this.frame.getX() + this.frame.getWidth(), update.getVisibleX()), firstVisibleGraphNode.getY());
                } else {
                    this.view.setFrameAndEnsureVisibleSync(this.frame, firstVisibleGraphNode);
                }
                if (update.isExternalDateSelectionChanged() && firstVisibleGraphNode == update.getPreviousVisibleGraphNode()) {
                    this.view.getTimeCompressionBar().highlightRegionSync((BaseMessage)update.getPreviousVisibleGraphNode(), (BaseMessage)update.getVisibleGraphNode());
                }
            } else {
                this.view.setFrameSync(this.frame);
            }
        }
    }

    protected void createFrame() {
        super.createFrame();
        this.frame.setLifelineCategories(traceCategories);
        if (TraceSDUtil.debugLoader) {
            TraceSDUtil.debugUml2SDTraceLoader("TraceInteractions.createFrame()");
        }
    }

    public void setFrameName() {
        if (this.frame == null) {
            return;
        }
        if (!this.isEmpty()) {
            if (this.currentProcesses.size() == 1) {
                TRCProcess process = ((TraceProcess)this.currentProcesses.get(0)).getProcess();
                this.frame.setName(String.valueOf(process.getAgent().getAgentProxy().getProcessProxy().getName()) + " [Pid " + process.getPid() + "]" + this.getDrillDownOrHideIndication() + this.pageMessage());
            } else {
                this.frame.setName(String.valueOf(TraceUIMessages._150) + this.getDrillDownOrHideIndication() + this.pageMessage());
            }
        } else {
            this.frame.setName(TraceUIMessages._151);
        }
        if (TraceSDUtil.debugLoader) {
            TraceSDUtil.debugUml2SDTraceLoader("setFrameName() " + this.frame.getName());
        }
    }

    protected boolean isFullInfoCollected() {
        if (this.lifelineLoader instanceof ObjectInteractions) {
            if (this.currentProcesses != null && this.currentProcesses.size() > 0) {
                Iterator iter = this.currentProcesses.iterator();
                while (iter.hasNext()) {
                    TRCProcess process = ((TraceProcess)iter.next()).getProcess();
                    if (process == null || process.getClassClass() == null || process.getObjects() == null || process.getClassClass().getObjects() == null || process.getClassClass().getObjects().size() == process.getObjects().size()) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    protected boolean isEmpty() {
        return this.currentProcesses == null || this.currentProcesses.size() < 1;
    }

    public String getTitleString() {
        String ret = String.valueOf(this.getFinalTitleString()) + this.getDrillDownOrHideIndication();
        if (!this.isFullInfoCollected()) {
            ret = String.valueOf(ret) + " " + TraceUIMessages._232;
        }
        return String.valueOf(ret) + this.pageMessage();
    }

    private String getDrillDownOrHideIndication() {
        if (this.drillDownBreadcrump == null || this.drillDownBreadcrump.length() == 0) {
            if (this.currentFilters != null && this.currentFilters.size() > 0 && !this.hasPositiveFilters) {
                return " " + TraceUIMessages._231;
            }
            return "";
        }
        return " " + TraceUIMessages._228 + this.drillDownBreadcrump;
    }

    protected String pageMessage() {
        if (this.pages <= 1) {
            return "";
        }
        StringBuffer m = new StringBuffer("");
        m.append(" [").append(1 + this.pageNumber).append("/").append(this.pages).append(" ").append(TraceUIMessages._154).append("]");
        return m.toString();
    }

    protected void computeModel() {
        if (TraceSDUtil.debugLoader) {
            TraceSDUtil.debugUml2SDTraceLoader("computeModel() " + this.maximumMessagesByPage);
        }
        this.totalNbMessages = 0;
        this.instancesMap = new HashMap();
        this.currentProcesses.init();
        TRCFullMethodInvocation methodInvocation = this.currentProcesses.consumeMethodInvocation();
        while (methodInvocation != null && !this.isCurrentLoadCanceled()) {
            block10: {
                String name;
                TRCFullMethodInvocation invokedBy;
                block11: {
                    invokedBy = (TRCFullMethodInvocation)methodInvocation.getInvokedBy();
                    if (this.isMessageCollapsed(invokedBy)) break block10;
                    EObject instanceFrom = null;
                    EObject instanceTo = null;
                    if (invokedBy == null) break block11;
                    instanceFrom = this.getLifelineEObjectFromMethodInvocation(invokedBy);
                    instanceTo = this.getLifelineEObjectFromMethodInvocation(methodInvocation);
                    if (this.internalMessagesFiltered && instanceFrom == instanceTo) break block10;
                }
                TraceLifelineDraft traceLifelineTo = this.getTraceLifelineDraftForMethodInvocation(null, methodInvocation);
                TraceLifelineDraft traceLifelineFrom = null;
                if (invokedBy != null) {
                    traceLifelineFrom = this.getTraceLifelineDraftForMethodInvocation(null, invokedBy);
                }
                if (!(traceLifelineTo.isFiltered() || traceLifelineFrom != null && traceLifelineFrom.isFiltered() || this.isSyncMessageFiltered(name = methodInvocation.getMethod().getName()))) {
                    ++this.totalNbMessages;
                    if (methodInvocation.getExitTime() > 0.0) {
                        ++this.totalNbMessages;
                    }
                }
            }
            methodInvocation = this.currentProcesses.consumeMethodInvocation();
        }
        this.pages = this.totalNbMessages / this.maximumMessagesByPage;
        if (this.totalNbMessages % this.maximumMessagesByPage > 0) {
            ++this.pages;
        }
        this.instancesMap = null;
        if (TraceSDUtil.debugLoader) {
            TraceSDUtil.debugUml2SDTraceLoader("computeModel() interrupted(" + this.isCurrentLoadCanceled() + ") has counted " + this.pages + " pages");
        }
    }

    public void fillPage(TraceInteractionUpdate update) {
        this.tracePages = new ArrayList();
        this.instancesMap = new HashMap();
        this.traceThreadMap = new HashMap();
        this.traceThreadList = new ArrayList();
        this.lifelinesByName = new HashMap();
        this.nbMessages = 0;
        this.nbMessagesInThisPage = 0;
        this.hasNextPage = false;
        this.currentProcesses.init();
        TRCFullMethodInvocation methodInvocation = this.currentProcesses.consumeMethodInvocation();
        while (methodInvocation != null && !this.isCurrentLoadCanceled() && this.nbMessagesInThisPage < this.maximumMessagesByPage) {
            if (TraceSDUtil.debugLoader) {
                TraceSDUtil.debugUml2SDTraceLoader(String.valueOf(this.nbMessages) + ":" + this.nbMessages / this.maximumMessagesByPage + " " + methodInvocation);
            }
            this.finishPendingReturns(update, TIUtils.getAbsoluteEntryTime(methodInvocation), methodInvocation.getTicket(), methodInvocation.getThread(), methodInvocation.getStackDepth());
            TraceSyncMessage syncMessage = this.createSyncMessage(methodInvocation, update);
            TraceCallStack traceCallStack = this.getTraceCallStack(methodInvocation.getThread());
            traceCallStack.pushCall(syncMessage, methodInvocation);
            methodInvocation = this.currentProcesses.consumeMethodInvocation();
        }
        this.finishPendingReturns(update, Double.MAX_VALUE, Long.MAX_VALUE, null, (short)Short.MAX_VALUE);
        Set c = this.instancesMap.entrySet();
        for (Map.Entry entry : c) {
            TraceLifelineDraft draft = (TraceLifelineDraft)entry.getValue();
            if (TraceSDUtil.debugLoader) {
                TraceSDUtil.debugUml2SDTraceLoader(draft.getLifeline() + ":" + draft.getNbUser());
            }
            if (draft.getNbUser() <= 0) continue;
            draft.setEnd(this.nbMessagesInThisPage + 1);
            if (draft.getStart() == Integer.MAX_VALUE) {
                draft.setStart(0);
            }
            this.setExecutionOccurence(draft);
        }
        this.reorderLifelinesAgain();
        this.distinguishLifelinesByName();
        this.instancesMap = null;
        this.traceThreadMap = null;
        this.traceThreadList = null;
        this.lifelinesByName = null;
    }

    protected void finishPendingReturns(TraceInteractionUpdate update, double uptodate, long ticket, TRCThread thread, short stackDepth) {
        double traceThreadListFirstTime = this.getTraceThreadListFirstTime();
        long traceThreadListFirstTicket = this.getTraceThreadListFirstTicket();
        while (traceThreadListFirstTime < uptodate || traceThreadListFirstTime == uptodate && (traceThreadListFirstTicket < ticket || traceThreadListFirstTicket == ticket && thread != null && this.getTraceThreadListFirstThread() == thread && stackDepth != Short.MAX_VALUE && this.getTraceThreadListFirstStackDepth() >= stackDepth)) {
            TraceCallStack callStack = (TraceCallStack)this.traceThreadList.get(0);
            TraceMessageAndCallAssociation tmaca = callStack.popCall();
            TRCFullMethodInvocation methodInvocation = tmaca.getMethodInvocation();
            if (methodInvocation.getExitTime() > 0.0) {
                TraceSyncMessageReturn syncMessageReturn = this.createSyncMessageReturn(methodInvocation, update);
                if (tmaca.getMessage() != null && syncMessageReturn != null) {
                    syncMessageReturn.setMessage(tmaca.getMessage());
                }
            }
            traceThreadListFirstTime = this.getTraceThreadListFirstTime();
            traceThreadListFirstTicket = this.getTraceThreadListFirstTicket();
        }
    }

    private TraceSyncMessage createSyncMessage(TRCFullMethodInvocation methodInvocation, TraceInteractionUpdate update) {
        TRCFullMethodInvocation invokedBy = (TRCFullMethodInvocation)methodInvocation.getInvokedBy();
        if (this.isMessageCollapsed(invokedBy)) {
            return null;
        }
        TraceLifelineDraft traceLifelineTo = this.getTraceLifelineDraftForMethodInvocation(this.frame, methodInvocation);
        TraceLifelineDraft traceLifelineFrom = null;
        if (invokedBy != null) {
            traceLifelineFrom = this.getTraceLifelineDraftForMethodInvocation(this.frame, invokedBy);
        }
        if (traceLifelineTo.isFiltered() || traceLifelineFrom != null && traceLifelineFrom.isFiltered()) {
            return null;
        }
        if (this.internalMessagesFiltered && traceLifelineFrom == traceLifelineTo) {
            return null;
        }
        if (this.isSyncMessageFiltered(methodInvocation.getMethod().getName())) {
            return null;
        }
        ++this.nbMessages;
        String name = this.getMessageName(methodInvocation, traceLifelineFrom == null);
        if (TraceSDUtil.debugLoader) {
            TraceSDUtil.debugUml2SDTraceLoader("in:" + this.nbMessages + ":" + this.nbMessages / this.maximumMessagesByPage + " " + name + " " + TraceInteractionUtils.getAbsoluteEntryTime(methodInvocation));
        }
        if (this.nbMessagesInThisPage == this.maximumMessagesByPage) {
            this.hasNextPage = true;
            return null;
        }
        if (traceLifelineFrom != null && traceLifelineFrom != traceLifelineTo) {
            traceLifelineFrom.addAUser();
        }
        traceLifelineTo.addAUser();
        if ((this.nbMessages - 1) % this.maximumMessagesByPage == 0) {
            this.tracePages.add(new TracePage(TIUtils.getAbsoluteEntryTime(methodInvocation)));
        } else if ((this.nbMessages - 1) % this.maximumMessagesByPage == this.maximumMessagesByPage - 1) {
            ((TracePage)this.tracePages.get(this.tracePages.size() - 1)).setLastTime(TIUtils.getAbsoluteExitTime(methodInvocation));
        }
        if (update.isPageChanged() && this.nbMessages - 1 < this.pageNumber * this.maximumMessagesByPage) {
            return null;
        }
        if (!update.isPageChanged()) {
            if (update.isDateSelectionChanged()) {
                if (TIUtils.getAbsoluteEntryTime(methodInvocation) < update.getDateToShow()) {
                    return null;
                }
                throw new FoundInPage(this.tracePages.size() - 1);
            }
            if (update.isFindRequired() && update.getFindCriteria().isSyncMessageSelected()) {
                if (update.getFindStartingPage() <= this.tracePages.size() - 1 && TIUtils.matchCriteria(name, update.getFindCriteria())) {
                    throw new FoundInPage(this.tracePages.size() - 1);
                }
                return null;
            }
            if (update.isFindInvocationRequired()) {
                if (!update.isFindInvocationReturn() && methodInvocation == update.getFindInvocationModel()) {
                    throw new FoundInPage(this.tracePages.size() - 1);
                }
                return null;
            }
        }
        if (traceLifelineFrom != null && traceLifelineFrom != traceLifelineTo && traceLifelineFrom.getNbUser() == 1) {
            traceLifelineFrom.setStart(this.nbMessagesInThisPage + 1);
        }
        if (traceLifelineTo.getNbUser() == 1) {
            traceLifelineTo.setStart(this.nbMessagesInThisPage + 1);
        }
        TraceSyncMessage syncMessage = this.isMessageCollapsed(methodInvocation) ? new TraceCollapsedSyncMessage() : (methodInvocation.getInvokes() != null && methodInvocation.getInvokes().size() > 0 ? new TraceCollapsableSyncMessage() : new TraceSyncMessage());
        if (update.isPageChanged()) {
            if (update.isDateSelectionChanged()) {
                if (TIUtils.getAbsoluteEntryTime(methodInvocation) < update.getDateToShow()) {
                    update.setPreviousVisibleGraphNode((GraphNode)syncMessage);
                } else if (update.getVisibleGraphNode() == null) {
                    update.setVisibleGraphNode((GraphNode)syncMessage);
                }
            }
            if (update.isFindRequired() && update.getFindCriteria().isSyncMessageSelected() && TIUtils.matchCriteria(name, update.getFindCriteria())) {
                update.addFindResult((GraphNode)syncMessage);
            }
            if (update.isFindInvocationRequired() && !update.isFindInvocationReturn() && methodInvocation == update.getFindInvocationModel()) {
                update.setFindInvocationResult(syncMessage);
            }
        }
        syncMessage.model = methodInvocation;
        if (traceLifelineFrom != null) {
            traceLifelineFrom.getLifeline().setCurrentEventOccurrence(this.nbMessagesInThisPage + 1);
            syncMessage.setStartLifeline(traceLifelineFrom.getLifeline());
        } else {
            traceLifelineTo.getLifeline().setCurrentEventOccurrence(this.nbMessagesInThisPage + 1);
        }
        syncMessage.setName(name);
        syncMessage.setEndLifeline(traceLifelineTo.getLifeline());
        syncMessage.setTime(TIUtils.getAbsoluteEntryTime(methodInvocation));
        if (this.isCurrentLoadCanceled()) {
            return null;
        }
        this.frame.addMessage((BaseMessage)syncMessage);
        ++this.nbMessagesInThisPage;
        return syncMessage;
    }

    private TraceSyncMessageReturn createSyncMessageReturn(TRCFullMethodInvocation methodInvocation, TraceInteractionUpdate update) {
        TRCFullMethodInvocation invokedBy = (TRCFullMethodInvocation)methodInvocation.getInvokedBy();
        if (this.isMessageCollapsed(invokedBy)) {
            return null;
        }
        TraceLifelineDraft traceLifelineTo = this.getTraceLifelineDraftForMethodInvocation(this.frame, methodInvocation);
        TraceLifelineDraft traceLifelineFrom = null;
        if (invokedBy != null) {
            traceLifelineFrom = this.getTraceLifelineDraftForMethodInvocation(this.frame, invokedBy);
        }
        if (traceLifelineTo.isFiltered() || traceLifelineFrom != null && traceLifelineFrom.isFiltered()) {
            return null;
        }
        if (this.internalMessagesFiltered && traceLifelineFrom == traceLifelineTo) {
            return null;
        }
        if (this.isSyncMessageFiltered(methodInvocation.getMethod().getName())) {
            return null;
        }
        ++this.nbMessages;
        String name = this.getMessageName(methodInvocation, traceLifelineFrom == null);
        if (TraceSDUtil.debugLoader) {
            TraceSDUtil.debugUml2SDTraceLoader("out:" + this.nbMessages + ":" + this.nbMessages / this.maximumMessagesByPage + " " + name + " " + TraceInteractionUtils.getAbsoluteExitTime(methodInvocation));
        }
        if (this.nbMessagesInThisPage == this.maximumMessagesByPage) {
            this.hasNextPage = true;
            return null;
        }
        if (traceLifelineFrom != null && traceLifelineFrom != traceLifelineTo) {
            traceLifelineFrom.removeAUser();
        }
        traceLifelineTo.removeAUser();
        if ((this.nbMessages - 1) % this.maximumMessagesByPage == 0) {
            this.tracePages.add(new TracePage(TIUtils.getAbsoluteExitTime(methodInvocation)));
        } else if ((this.nbMessages - 1) % this.maximumMessagesByPage == this.maximumMessagesByPage - 1) {
            ((TracePage)this.tracePages.get(this.tracePages.size() - 1)).setLastTime(TIUtils.getAbsoluteExitTime(methodInvocation));
        }
        if (update.isPageChanged() && this.nbMessages - 1 < this.pageNumber * this.maximumMessagesByPage) {
            return null;
        }
        if (!update.isPageChanged()) {
            if (update.isDateSelectionChanged()) {
                if (TIUtils.getAbsoluteExitTime(methodInvocation) < update.getDateToShow()) {
                    return null;
                }
                throw new FoundInPage(this.tracePages.size() - 1);
            }
            if (update.isFindRequired() && update.getFindCriteria().isSyncMessageSelected()) {
                if (update.getFindStartingPage() <= this.tracePages.size() - 1 && TIUtils.matchCriteria(name, update.getFindCriteria())) {
                    throw new FoundInPage(this.tracePages.size() - 1);
                }
                return null;
            }
            if (update.isFindInvocationRequired()) {
                if (update.isFindInvocationReturn() && methodInvocation == update.getFindInvocationModel()) {
                    throw new FoundInPage(this.tracePages.size() - 1);
                }
                return null;
            }
        }
        if (traceLifelineFrom != null && traceLifelineFrom != traceLifelineTo && traceLifelineFrom.getNbUser() == 0) {
            traceLifelineFrom.setEnd(this.nbMessagesInThisPage + 1);
            this.setExecutionOccurence(traceLifelineFrom);
        }
        if (traceLifelineTo.getNbUser() == 0) {
            traceLifelineTo.setEnd(this.nbMessagesInThisPage + 1);
            this.setExecutionOccurence(traceLifelineTo);
        }
        TraceSyncMessageReturn syncMessageReturn = this.isMessageCollapsed(methodInvocation) ? new TraceCollapsedSyncMessageReturn() : (methodInvocation.getInvokes() != null && methodInvocation.getInvokes().size() > 0 ? new TraceCollapsableSyncMessageReturn() : new TraceSyncMessageReturn());
        if (update.isPageChanged()) {
            if (update.isDateSelectionChanged()) {
                if (TIUtils.getAbsoluteExitTime(methodInvocation) < update.getDateToShow()) {
                    update.setPreviousVisibleGraphNode((GraphNode)syncMessageReturn);
                } else if (update.getVisibleGraphNode() == null) {
                    update.setVisibleGraphNode((GraphNode)syncMessageReturn);
                }
            }
            if (update.isFindRequired() && update.getFindCriteria().isSyncMessageSelected() && TIUtils.matchCriteria(name, update.getFindCriteria())) {
                update.addFindResult((GraphNode)syncMessageReturn);
            }
            if (update.isFindInvocationRequired() && update.isFindInvocationReturn() && methodInvocation == update.getFindInvocationModel()) {
                update.setFindInvocationResult(syncMessageReturn);
            }
        }
        syncMessageReturn.model = methodInvocation;
        if (traceLifelineFrom != null) {
            traceLifelineFrom.getLifeline().setCurrentEventOccurrence(this.nbMessagesInThisPage + 1);
            syncMessageReturn.setEndLifeline(traceLifelineFrom.getLifeline());
        } else {
            traceLifelineTo.getLifeline().setCurrentEventOccurrence(this.nbMessagesInThisPage + 1);
        }
        syncMessageReturn.setName(name);
        syncMessageReturn.setStartLifeline(traceLifelineTo.getLifeline());
        syncMessageReturn.setTime(TIUtils.getAbsoluteExitTime(methodInvocation));
        if (this.isCurrentLoadCanceled()) {
            return null;
        }
        this.frame.addMessage((BaseMessage)syncMessageReturn);
        ++this.nbMessagesInThisPage;
        return syncMessageReturn;
    }

    private String getMessageName(TRCFullMethodInvocation methodInvocation, boolean withThread) {
        if (withThread) {
            StringBuffer buffer = new StringBuffer(methodInvocation.getMethod().getName());
            return buffer.append(" (").append(methodInvocation.getThread().getName()).append(")").toString();
        }
        return methodInvocation.getMethod().getName();
    }

    protected TraceLifelineDraft getTraceLifelineDraftForMethodInvocation(Frame f, TRCFullMethodInvocation mi) {
        EObject obj = this.getLifelineEObjectFromMethodInvocation(mi);
        String name = this.getLifeLineTitle(obj, true);
        String id = this.getLifeLineId(obj);
        TraceLifelineDraft draft = (TraceLifelineDraft)this.instancesMap.get(id);
        if (draft == null) {
            ArrayList list;
            draft = new TraceLifelineDraft(obj);
            if (this.isLifelineFiltered(obj) || this.isLifelineLocallyFiltered(name, mi)) {
                draft.setFiltered(true);
                this.instancesMap.put(id, draft);
                return draft;
            }
            ArrayList arrayList = list = this.collapsedLifelines != null ? (ArrayList)this.collapsedLifelines.get(id) : null;
            if (list != null) {
                ArrayList l = (ArrayList)this.collapsedLifelines.get(list);
                while (l != null) {
                    list = l;
                    l = (ArrayList)this.collapsedLifelines.get(l);
                }
                name = this.getCollapsedLifelineName(list);
                if (name.length() > 300) {
                    name = String.valueOf(name.substring(0, 297)) + "...";
                }
                if (this.isLifelineFiltered(obj) || this.isLifelineLocallyFiltered(name, mi)) {
                    draft.setFiltered(true);
                    this.putInstancesMap(list, draft);
                    return draft;
                }
                if (f == null) {
                    return draft;
                }
                TraceCollapsedLifelines traceCollapsedLifelines = new TraceCollapsedLifelines();
                draft.setLifeline(traceCollapsedLifelines);
                traceCollapsedLifelines.setCollapsedLifelines(list);
                traceCollapsedLifelines.setName(name);
                this.putInstancesMap(list, draft);
                traceCollapsedLifelines.setCategory(6);
            } else {
                if (f == null) {
                    return draft;
                }
                TraceLifeline traceLifeline = new TraceLifeline();
                draft.setLifeline(traceLifeline);
                traceLifeline.setEObject(obj);
                this.instancesMap.put(id, draft);
                traceLifeline.setName(name);
                this.addLifelineByName(traceLifeline);
                traceLifeline.setCategory(this.getLifeLineCategory(obj));
            }
            f.addLifeLine(draft.getLifeline());
            draft.setStart(Integer.MAX_VALUE);
            draft.setEnd(0);
        }
        return draft;
    }

    private void addLifelineByName(TraceLifeline traceLifeline) {
        ArrayList<TraceLifeline> list = (ArrayList<TraceLifeline>)this.lifelinesByName.get(traceLifeline.getName());
        if (list == null) {
            list = new ArrayList<TraceLifeline>(1);
            this.lifelinesByName.put(traceLifeline.getName(), list);
        }
        list.add(traceLifeline);
        if (list.size() == 2) {
            if (this.lifelinesToDistinguish == null) {
                this.lifelinesToDistinguish = new ArrayList(1);
            }
            this.lifelinesToDistinguish.add(list);
        }
    }

    private void distinguishLifelinesByName() {
        if (this.lifelinesToDistinguish == null) {
            return;
        }
        for (List list : this.lifelinesToDistinguish) {
            int j = 0;
            while (j < list.size()) {
                TraceLifeline traceLifeline = (TraceLifeline)list.get(j);
                traceLifeline.setName(this.getDistinguishedLifeLineTitle(traceLifeline.getEObject(), j));
                ++j;
            }
        }
        this.lifelinesToDistinguish = null;
    }

    private void putInstancesMap(ArrayList list, TraceLifelineDraft draft) {
        for (Object oo : list) {
            if (oo instanceof String) {
                this.instancesMap.put(oo, draft);
                continue;
            }
            if (!(oo instanceof ArrayList)) continue;
            this.putInstancesMap((ArrayList)oo, draft);
        }
    }

    private String getCollapsedLifelineName(List list) {
        StringBuffer ret = new StringBuffer("[");
        int j = 0;
        for (Object oo : list) {
            if (oo instanceof String) {
                String[] split;
                if (j > 0) {
                    ret.append(",");
                }
                ret.append((split = ((String)oo).split("#")).length == 2 ? split[1] : (String)oo);
            } else if (oo instanceof List) {
                if (j > 0) {
                    ret.append(",");
                }
                ret.append(this.getCollapsedLifelineName((List)oo));
            }
            ++j;
        }
        return ret.append("]").toString();
    }

    private void externalDateSelectionChanged(IDateSelection selection, TraceInteractionUpdate update) {
        double absoluteDateSelection;
        if (TraceSDUtil.debugEvents) {
            TraceSDUtil.debugUml2SDTraceEvents("External Date selection is " + selection);
        }
        IDateSelection ids = selection;
        EObject eo = selection.getEObject();
        if (this.currentProcesses == null || eo != null && (!(eo instanceof TRCProcess) || !this.currentProcesses.contains((TRCProcess)eo))) {
            return;
        }
        double dateSelection = ids.getStartDate();
        if (eo != null) {
            absoluteDateSelection = dateSelection;
            TRCProcess process = (TRCProcess)eo;
            double absoluteEntryTime = TIUtils.getAbsoluteEntryTime(process.getAgent());
            if (absoluteDateSelection < absoluteEntryTime) {
                absoluteDateSelection += absoluteEntryTime;
            } else {
                dateSelection -= absoluteEntryTime;
            }
            if (TraceSDUtil.debugEvents) {
                TraceSDUtil.debugUml2SDTraceEvents("dateSelection=" + dateSelection + "; absoluteDateSelection=" + absoluteDateSelection + "; getAbsoluteEntryTime(process)=" + TraceInteractionUtils.getAbsoluteEntryTime(process));
            }
        } else {
            absoluteDateSelection = dateSelection;
        }
        if (ids.getMeaning() == 0) {
            ITimeRange[] bounds = new ITimeRange[2];
            if (this.frame.findDateBounds(absoluteDateSelection, bounds)) {
                if (bounds[0] instanceof GraphNode) {
                    this.view.getSDWidget().ensureVisible((GraphNode)bounds[0]);
                    this.view.getTimeCompressionBar().highlightRegion((BaseMessage)bounds[0], (BaseMessage)bounds[1]);
                    if (TraceSDUtil.debugEvents) {
                        TraceSDUtil.debugUml2SDTraceEvents("Found a graph node");
                    }
                    return;
                }
                if (TraceSDUtil.debugEvents) {
                    TraceSDUtil.debugUml2SDTraceEvents("Found something else than a graph node: ignored");
                }
                this.frame.resetTimeCompression();
                return;
            }
            this.frame.resetTimeCompression();
            if (this.pages == 1) {
                ITimeRange sm;
                ITimeRange iTimeRange = sm = bounds[0] != null ? bounds[0] : bounds[1];
                if (sm != null && sm instanceof GraphNode) {
                    this.view.getSDWidget().ensureVisible((GraphNode)sm);
                    if (TraceSDUtil.debugEvents) {
                        TraceSDUtil.debugUml2SDTraceEvents(bounds[0] == null ? "Before any graph node" : "After any graph node");
                    }
                    return;
                }
                if (TraceSDUtil.debugEvents) {
                    TraceSDUtil.debugUml2SDTraceEvents("Found something else than a graph node (#2): ignored");
                }
                return;
            }
            if (this.tracePages != null && this.tracePages.size() > 0 && dateSelection <= ((TracePage)this.tracePages.get(this.tracePages.size() - 1)).getLastTime()) {
                int i = 0;
                while (i < this.tracePages.size()) {
                    TracePage tp = (TracePage)this.tracePages.get(i);
                    if (dateSelection >= tp.getFirstTime() && dateSelection <= tp.getLastTime()) {
                        update.setDateSelectionChanged(true);
                        update.setExternalDateSelectionChanged(true);
                        update.setDateToShow(absoluteDateSelection);
                        update.setPageChanged(true);
                        this.pageNumber = i;
                        if (TraceSDUtil.debugEvents) {
                            TraceSDUtil.debugUml2SDTraceEvents("Found in a previous page");
                        }
                        return;
                    }
                    ++i;
                }
            }
            update.setDateSelectionChanged(true);
            update.setExternalDateSelectionChanged(true);
            update.setDateToShow(absoluteDateSelection);
            if (TraceSDUtil.debugEvents) {
                TraceSDUtil.debugUml2SDTraceEvents("Looking in all pages");
            }
        }
    }

    public static void findInvocation(TRCMethodInvocation model, boolean isReturn) {
        if (instance != null && TraceInteractions.instance.frame != null) {
            instance.updateOnFindInvocation(model, isReturn);
        }
    }

    private void updateOnFindInvocation(TRCMethodInvocation model, boolean isReturn) {
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setFindInvocationRequired(true);
        update.setFindInvocationModel(model);
        update.setFindInvocationReturn(isReturn);
        if (TraceSDUtil.debugLoader) {
            TraceSDUtil.debugUml2SDTraceLoader("updateOnFindInvocation: model=" + model + " isReturn=" + isReturn);
        }
        this.updateSD(update);
        if (update.isFindInvocationRequired() && update.getFindInvocationResult() != null) {
            final GraphNode graphNode = (GraphNode)update.getFindInvocationResult();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (TraceInteractions.this.frame == null) {
                        return;
                    }
                    TraceInteractions.this.view.getSDWidget().moveTo(graphNode);
                }
            });
        }
    }

    public static void setExternalDateSelection(IDateSelection selection) {
        if (instance != null && TraceInteractions.instance.frame != null) {
            instance.updateOnExternalDateSelection(selection);
        }
    }

    private void updateOnExternalDateSelection(IDateSelection selection) {
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        this.externalDateSelectionChanged(selection, update);
        if (TraceSDUtil.debugLoader) {
            TraceSDUtil.debugUml2SDTraceLoader("updateOnExternalDateSelection: selection=" + selection);
        }
        if (update.needsUpdate()) {
            this.updateSDBackground(update);
        }
    }

    private void subscribeForDateSelectionChanged(final IDateSelection selection) {
        if (this.subscribeSelectionTimer != null) {
            this.subscribeSelectionTimer.cancel();
        }
        this.subscribeSelectionTimer = new Timer();
        this.subscribeSelectionTimer.schedule(new TimerTask(){

            public void run() {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        if ((this).TraceInteractions.this.frame == null) {
                            return;
                        }
                        TraceInteractions.this.updateOnExternalDateSelection(selection);
                    }
                });
                TraceInteractions.this.subscribeSelectionTimer = null;
            }
        }, 50L);
    }

    protected void finishExternalExtendedSelection(TraceInteractionUpdate update) {
    }

    protected boolean externalExtendedSelectionChanged(IWorkbenchPart part, Object selection, TraceInteractionUpdate update) {
        if (TraceSDUtil.debugEvents) {
            TraceSDUtil.debugUml2SDTraceEvents("TraceInteractions: External extended selection from " + part + " is " + selection);
        }
        if (selection instanceof IDateSelection) {
            if (TraceSDUtil.debugEvents) {
                TraceSDUtil.debugUml2SDTraceEvents("TraceInteractions: IDateSelection: " + ((IDateSelection)selection).getStartDate());
            }
            this.subscribeForDateSelectionChanged((IDateSelection)selection);
            return true;
        }
        if (selection instanceof IEObjectSelection) {
            EObject eObject = ((IEObjectSelection)selection).getEObject();
            if (TraceSDUtil.debugEvents) {
                TraceSDUtil.debugUml2SDTraceEvents("TraceInteractions: IEObjectSelection: " + eObject);
            }
            return false;
        }
        return false;
    }

    public boolean hasNextPage() {
        return this.hasNextPage;
    }

    public boolean hasPrevPage() {
        return this.pageNumber > 0;
    }

    public void nextPage() {
        ++this.pageNumber;
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setPageChanged(true);
        this.updateSDBackground(update);
    }

    public void prevPage() {
        --this.pageNumber;
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setPageChanged(true);
        this.updateSDBackground(update);
    }

    public int maxItemsByPageCount() {
        return this.maximumMessagesByPage;
    }

    public int itemsTotalCount() {
        return this.totalNbMessages;
    }

    public String noItemsText() {
        return TraceUIMessages._155;
    }

    public String oneItemText() {
        return TraceUIMessages._156;
    }

    public String itemsText() {
        return TraceUIMessages._157;
    }

    public int currentPage() {
        return this.pageNumber;
    }

    public int pagesCount() {
        return this.pages;
    }

    public void pageSettingsChanged(int maxItemsByPage_, int pageNumber_) {
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setMaxMessagesByPageChanged(this.maximumMessagesByPage != maxItemsByPage_);
        this.maximumMessagesByPage = maxItemsByPage_;
        update.setPageChanged(this.pageNumber != pageNumber_);
        this.pageNumber = pageNumber_;
        if (update.isMaxMessagesByPageChanged() || update.isPageChanged()) {
            this.updateSDBackground(update);
        }
    }

    public void pageNumberChanged(int pageNumber_) {
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setPageChanged(this.pageNumber != pageNumber_);
        this.pageNumber = pageNumber_;
        if (update.isPageChanged()) {
            this.updateSDBackground(update);
        }
    }

    public boolean notFoundYet(Criteria toSearch) {
        if (this.pages > 1 && this.pageNumber + 1 < this.pages) {
            TraceInteractionUpdate update = new TraceInteractionUpdate();
            update.setFindRequired(true);
            update.setFindCriteria(toSearch);
            update.setFindStartingPage(this.pageNumber + 1);
            this.updateSD(update);
            ArrayList findResults_ = update.getFindResults();
            if (findResults_ != null && !findResults_.isEmpty()) {
                this.findResults = findResults_;
                this.currentFindIndex = 0;
                GraphNode current = (GraphNode)this.findResults.get(this.currentFindIndex);
                this.view.getSDWidget().moveTo(current);
                return true;
            }
        }
        return false;
    }

    public void setInternalMessageFiltered(boolean value) {
        if (this.internalMessagesFiltered != value) {
            this.internalMessagesFiltered = value;
            DialogSettings settings = (DialogSettings)TraceUIPlugin.getDefault().getDialogSettings();
            settings.put(INTERNAL_MESSAGES, this.internalMessagesFiltered);
            TraceInteractionUpdate update = new TraceInteractionUpdate();
            update.setInternalMessageFilteringChanged(true);
            this.updateSDBackground(update);
        }
    }

    public boolean getInternalMessageFiltered() {
        DialogSettings settings = (DialogSettings)TraceUIPlugin.getDefault().getDialogSettings();
        this.internalMessagesFiltered = settings.getBoolean(INTERNAL_MESSAGES);
        return this.internalMessagesFiltered;
    }

    private FilterCriteria isLifelineFiltered(String name, String loaderClassName) {
        for (FilterCriteria tf : this.currentFilters) {
            if (!tf.isActive() || !tf.getCriteria().isLifeLineSelected()) continue;
            if (tf.getLoaderClassName() != null && tf.isPositive() && tf.getLoaderClassName().equals(loaderClassName)) {
                if (TIUtils.matchCriteria(name, tf.getCriteria())) {
                    if (TraceSDUtil.debugMatch) {
                        TraceSDUtil.debugUml2SDTraceMatch("isLifelineFiltered(" + name + " ," + loaderClassName + ") returns " + tf);
                    }
                    return tf;
                }
                if (TraceSDUtil.debugMatch) {
                    TraceSDUtil.debugUml2SDTraceMatch("isLifelineFiltered(" + name + " ," + loaderClassName + ") returns " + unmatchFilterCriteria);
                }
                return unmatchFilterCriteria;
            }
            if (tf.getLoaderClassName() != null || tf.isPositive() || !TIUtils.matchCriteria(name, tf.getCriteria())) continue;
            if (TraceSDUtil.debugMatch) {
                TraceSDUtil.debugUml2SDTraceMatch("isLifelineFiltered(" + name + " ," + loaderClassName + ") returns " + unmatchFilterCriteria);
            }
            return unmatchFilterCriteria;
        }
        if (TraceSDUtil.debugMatch) {
            TraceSDUtil.debugUml2SDTraceMatch("isLifelineFiltered(" + name + " ," + loaderClassName + ") returns null");
        }
        return null;
    }

    private boolean isLifelineLocallyFiltered(String name, TRCFullMethodInvocation mi) {
        if (this.currentFilters != null && this.currentFilters.size() > 0) {
            FilterCriteria tf = this.isLifelineFiltered(name, this.lifelineLoader.getClass().getName());
            if (tf != null) {
                return !tf.isPositive();
            }
            if (this.hasPositiveFilters) {
                boolean hasPositiveFilterMatching = false;
                ILifelineLoader loader = this.lifelineLoader.getParent();
                while (loader != null) {
                    tf = this.isLifelineFiltered(loader.getLifeLineTitle(loader.getLifelineEObjectFromMethodInvocation(mi), true), loader.getClass().getName());
                    if (tf != null && tf.isPositive()) {
                        hasPositiveFilterMatching = true;
                    } else if (tf == unmatchFilterCriteria) {
                        return true;
                    }
                    loader = loader.getParent();
                }
                return !hasPositiveFilterMatching;
            }
        }
        return false;
    }

    private boolean isSyncMessageFiltered(String name) {
        if (this.currentFilters != null) {
            for (FilterCriteria tf : this.currentFilters) {
                if (!tf.isActive() || !tf.getCriteria().isSyncMessageSelected() || !TIUtils.matchCriteria(name, tf.getCriteria())) continue;
                return !tf.isPositive();
            }
        }
        return false;
    }

    private void filterGraphNodeInOrOut(ArrayList graphNodes, boolean in, String loaderClassName) {
        if (this.currentFilters == null) {
            this.currentFilters = new ArrayList();
        }
        for (GraphNode gn : graphNodes) {
            FilterCriteria fc;
            int position;
            EObject eo;
            Criteria c = new Criteria();
            if (gn instanceof IEObjectSelection && (eo = ((IEObjectSelection)gn).getEObject()) instanceof TRCFullMethodInvocation) {
                c.setExpression(((TRCFullMethodInvocation)eo).getMethod().getName());
            }
            c.setCaseSenstiveSelected(true);
            if (gn instanceof TraceLifeline) {
                c.setExpression(this.lifelineLoader.getLifeLineTitle(((TraceLifeline)gn).getEObject(), true));
                c.setLifeLineSelected(true);
            } else if (gn instanceof TraceSyncMessage) {
                c.setExpression(((TRCFullMethodInvocation)((TraceSyncMessage)gn).getEObject()).getMethod().getName());
                c.setSyncMessageSelected(true);
            } else if (gn instanceof TraceSyncMessageReturn) {
                c.setExpression(((TRCFullMethodInvocation)((TraceSyncMessageReturn)gn).getEObject()).getMethod().getName());
                c.setSyncMessageSelected(true);
            }
            if (in) {
                position = 0;
                fc = new FilterCriteria(c, true, true, loaderClassName);
            } else {
                position = -1;
                fc = new FilterCriteria(c, true, false);
            }
            FilterCriteria efc = FilterCriteria.find((FilterCriteria)fc, (List)this.currentFilters);
            if (efc == null) {
                if (position == 0) {
                    this.currentFilters.add(0, fc);
                    continue;
                }
                this.currentFilters.add(fc);
                continue;
            }
            efc.setActive(true);
        }
        this.updateHasPositiveLifelineFilters();
        FilterListDialog.saveFiltersCriteria((List)this.currentFilters);
    }

    public void filterSelectedGraphNodes(ArrayList graphNodes) {
        if (TraceSDUtil.debugEvents) {
            TraceSDUtil.debugUml2SDTraceEvents("filterGraphNodes(" + (graphNodes != null ? graphNodes.size() : 0) + " selected graph nodes)");
        }
        this.filterGraphNodeInOrOut(graphNodes, false, null);
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setFilteringChanged(true);
        this.updateSDBackground(update);
    }

    public boolean filter(List filters) {
        if (TraceSDUtil.debugEvents) {
            TraceSDUtil.debugUml2SDTraceEvents("filter(" + (filters != null ? filters.size() : 0) + " filters)");
        }
        this.currentFilters = filters;
        this.updateHasPositiveLifelineFilters();
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setFilteringChanged(true);
        this.updateSDBackground(update);
        return true;
    }

    public Action getFilterAction() {
        return (Action)FilterActions.getFiltersSelectionAction((IFilterViewer)this);
    }

    public void filterUpdated() {
        this.filter = this.filterQueryProvider.getCurrentFilter();
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setFilteringChanged(true);
        this.updateSDBackground(update);
    }

    public void setFilterQueryProvider(IFilterQueryProvider filterQueryProvider_) {
        this.filterQueryProvider = filterQueryProvider_;
        SimpleSearchQuery currentFilter = this.filterQueryProvider.getCurrentFilter();
        this.filter = currentFilter != null ? (SimpleSearchQuery)EcoreUtil.copy((EObject)currentFilter) : null;
    }

    public String[] getFilterScope() {
        String[] scope = new String[]{"ProfilingAgentScope"};
        return scope;
    }

    private boolean isLifelineFiltered(EObject source) {
        if (this.filter == null) {
            return false;
        }
        return !FilterQuery.isMatchingFilter(source, this.filter);
    }

    private void updateHasPositiveLifelineFilters() {
        this.drillDownBreadcrump = "";
        this.hasPositiveFilters = false;
        boolean drillDownActive = false;
        if (this.currentFilters != null) {
            for (FilterCriteria fc : this.currentFilters) {
                if (!fc.isActive() || !fc.isPositive() || !fc.getCriteria().isLifeLineSelected()) continue;
                this.hasPositiveFilters = true;
                if (fc.getLoaderClassName() == null) continue;
                this.drillDownBreadcrump = " > " + fc.getCriteria().getGraphNodeSummary((ISDFilterProvider)this, fc.getLoaderClassName()) + " " + fc.getCriteria().getExpression() + this.drillDownBreadcrump;
                drillDownActive = true;
            }
        }
        if (this.undoDrillDownMenuAction != null) {
            this.undoDrillDownMenuAction.setEnabled(this.hasPositiveFilters);
        }
        try {
            IContributionItem item = this.view.getViewSite().getActionBars().getToolBarManager().find("org.eclipse.hyades.uml2sd.trace.actions.internal.ResetDrillDown");
            if (item != null) {
                item.setVisible(drillDownActive);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void drillDown(ArrayList graphNodes) {
        if (TraceSDUtil.debugEvents) {
            TraceSDUtil.debugUml2SDTraceEvents("drillDown(" + (graphNodes != null ? graphNodes.size() : 0) + " selected graph nodes)");
        }
        this.filterGraphNodeInOrOut(graphNodes, true, this.lifelineLoader.getClass().getName());
        List loaders = SDUtil.getLoaders((String)this.view.getViewSite().getId());
        String className = null;
        Iterator i = loaders.iterator();
        while (i.hasNext()) {
            IConfigurationElement c = (IConfigurationElement)i.next();
            if (!c.getAttribute("class").equals(this.lifelineLoader.getClass().getName()) || !i.hasNext()) continue;
            c = (IConfigurationElement)i.next();
            className = c.getAttribute("class");
            break;
        }
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setFilteringChanged(true);
        if (className != null) {
            this.setLifelineLoader((BaseLifelineLoader)LoadersManager.getLoadersManager().createLoaderInstance(className, this.getClass().getClassLoader()));
            SDUtil.getInstance().setLastLoader(this.lifelineLoader.getClass().getName(), this.view.getSite().getId());
            update.setLifelineLoaderChanged(true);
        }
        this.updateSDBackground(update);
    }

    private void undoDrillDown(boolean all) {
        if (this.currentFilters != null) {
            FilterCriteria lastRemovedFilterCriteria = null;
            ILifelineLoader parent = this.lifelineLoader;
            Object[] array = this.currentFilters.toArray();
            int i = 0;
            while (i < array.length) {
                FilterCriteria fc = (FilterCriteria)array[i];
                if (fc.isActive() && fc.isPositive() && fc.getCriteria().isLifeLineSelected() && fc.getLoaderClassName() != null) {
                    lastRemovedFilterCriteria = fc;
                    this.currentFilters.remove(lastRemovedFilterCriteria);
                    if (parent != null) {
                        parent = parent.getParent();
                    }
                    if (!all) break;
                }
                ++i;
            }
            this.updateHasPositiveLifelineFilters();
            FilterListDialog.saveFiltersCriteria((List)this.currentFilters);
            if (lastRemovedFilterCriteria != null && parent != null && parent.getClass().getName().equals(lastRemovedFilterCriteria.getLoaderClassName())) {
                this.setLifelineLoader(lastRemovedFilterCriteria.getLoaderClassName());
            } else {
                TraceInteractionUpdate update = new TraceInteractionUpdate();
                update.setFilteringChanged(true);
                this.updateSDBackground(update);
            }
        }
    }

    public void backLastDrillDown() {
        this.undoDrillDown(false);
    }

    public void resetDrillDown() {
        this.undoDrillDown(true);
    }

    public void filterIn(ArrayList graphNodes) {
        this.filterGraphNodeInOrOut(graphNodes, true, null);
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setFilteringChanged(true);
        this.updateSDBackground(update);
    }

    public void collapseLifelines(List graphNodes) {
        if (TraceSDUtil.debugEvents) {
            TraceSDUtil.debugUml2SDTraceEvents("collapseLifelines(" + (graphNodes != null ? graphNodes.size() : 0) + ")");
        }
        if (this.collapsedLifelines == null) {
            this.collapsedLifelines = new HashMap();
        }
        ArrayList<ArrayList> list = new ArrayList<ArrayList>();
        for (GraphNode gn : graphNodes) {
            Object key = null;
            if (gn instanceof TraceCollapsedLifelines) {
                key = ((TraceCollapsedLifelines)gn).getCollapsedLifelines();
            } else {
                if (!(gn instanceof TraceLifeline)) continue;
                key = this.getLifeLineId(((TraceLifeline)gn).getEObject());
            }
            list.add((ArrayList)key);
            this.collapsedLifelines.put(key, list);
        }
        this.saveCollapsedLifelines();
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setHorizontalCollapsingChanged(true);
        update.setVisibleX(this.frame.getVisibleAreaX());
        this.updateSDBackground(update);
    }

    public void expandLifelines(List graphNodes) {
        if (TraceSDUtil.debugEvents) {
            TraceSDUtil.debugUml2SDTraceEvents("expandLifelines(" + (graphNodes != null ? graphNodes.size() : 0) + ")");
        }
        int index = Integer.MAX_VALUE;
        for (GraphNode gn : graphNodes) {
            if (!(gn instanceof TraceCollapsedLifelines)) continue;
            TraceCollapsedLifelines traceCollapsedLifelines = (TraceCollapsedLifelines)gn;
            if (index > traceCollapsedLifelines.getIndex()) {
                index = traceCollapsedLifelines.getIndex();
            }
            ArrayList sublist = traceCollapsedLifelines.getCollapsedLifelines();
            for (Object key : sublist) {
                this.collapsedLifelines.put(key, null);
            }
        }
        this.saveCollapsedLifelines();
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setHorizontalCollapsingChanged(true);
        update.setVisibleX(this.frame.getVisibleAreaX());
        this.updateSDBackground(update);
    }

    public void collapseTwoLifelines(Lifeline lifeline1, Lifeline lifeline2) {
        ArrayList<Lifeline> list = new ArrayList<Lifeline>();
        list.add(lifeline2);
        list.add(lifeline1);
        this.collapseLifelines(list);
    }

    private String parseHorizontalCollapsingTree(Object o) {
        String result = null;
        if (o instanceof List) {
            List list = (List)o;
            result = "{";
            String prefix = "";
            for (Object u : list) {
                String parsingResult = this.parseHorizontalCollapsingTree(u);
                if (parsingResult == null) continue;
                result = String.valueOf(result) + prefix + parsingResult;
                prefix = ",";
            }
            result = String.valueOf(result) + "}";
        } else if (o instanceof String) {
            result = (String)o;
        }
        return result;
    }

    private void saveCollapsedLifelines() {
        String result = "";
        if (this.collapsedLifelines != null) {
            Set entries = this.collapsedLifelines.entrySet();
            ArrayList uniqueTopLists = new ArrayList();
            for (Map.Entry e : entries) {
                Object value = e.getValue();
                if (this.collapsedLifelines.get(value) != null || uniqueTopLists.contains(value)) continue;
                uniqueTopLists.add(value);
            }
            String prefix = "{";
            Iterator i = uniqueTopLists.iterator();
            while (i.hasNext()) {
                String parsingResult = this.parseHorizontalCollapsingTree(i.next());
                if (parsingResult == null) continue;
                result = String.valueOf(result) + prefix + parsingResult;
                prefix = ",";
            }
        }
        if (result.length() > 0) {
            result = String.valueOf(result) + "}";
        }
        DialogSettings settings = (DialogSettings)TraceUIPlugin.getDefault().getDialogSettings();
        settings.put(HORIZONTAL_COLLAPSING, result);
        TraceSDUtil.debugUml2SDTraceEvents("Saving horizontalCollapsing=" + result);
    }

    private List splitOneLevel(String input) {
        ArrayList<String> list = new ArrayList<String>();
        int level = 0;
        int start = 1;
        int end = input.length() - 1;
        int i = 1;
        while (i < end) {
            char c = input.charAt(i);
            if (c == '{') {
                ++level;
            } else if (c == '}') {
                --level;
            } else if ((c == ',' || i == end - 1) && level == 0) {
                String member = input.substring(start, c == ',' ? i : i + 1);
                list.add(member);
                start = i + 1;
            }
            ++i;
        }
        return list;
    }

    private Object parseHorizontalCollapsingString(String input, boolean deep) {
        if (input != null && input.length() > 2 && input.charAt(0) == '{' && input.charAt(input.length() - 1) == '}') {
            List members = this.splitOneLevel(input);
            if (members != null && members.size() > 0) {
                ArrayList<Object> list = new ArrayList<Object>();
                Iterator i = members.iterator();
                while (i.hasNext()) {
                    Object o = this.parseHorizontalCollapsingString((String)i.next(), true);
                    if (o == null || !deep) continue;
                    list.add(o);
                    this.collapsedLifelines.put(o, list);
                }
                if (list.size() > 0) {
                    return list;
                }
            }
        } else if (input != null && input.length() > 0) {
            String[] parts = input.split("#");
            if (parts.length != 2 || TIUtils.doesAgentProxyStillExists(parts[0])) {
                return input;
            }
            return null;
        }
        return null;
    }

    private HashMap loadCollapsedLifelines() {
        DialogSettings settings = (DialogSettings)TraceUIPlugin.getDefault().getDialogSettings();
        String result = settings.get(HORIZONTAL_COLLAPSING);
        this.collapsedLifelines = new HashMap();
        this.parseHorizontalCollapsingString(result, false);
        return this.collapsedLifelines;
    }

    private Object getMethodInvocationContainerKey(TRCFullMethodInvocation methodInvocation) {
        return methodInvocation.getProcess().getAgent().getAgentProxy().getRuntimeId();
    }

    private Object getMethodInvocationCollapsingId(TRCFullMethodInvocation methodInvocation) {
        return String.valueOf(methodInvocation.getThread().getId()) + ":" + methodInvocation.getTicket();
    }

    private HashSet getContainerKeyHashSet(TRCFullMethodInvocation methodInvocation) {
        if (this.collapsedMessages == null) {
            return null;
        }
        Object object = this.collapsedMessages.get(this.getMethodInvocationContainerKey(methodInvocation));
        return object != null ? (HashSet)object : null;
    }

    private void saveCollapsedMessages() {
        StringBuffer result = new StringBuffer();
        if (this.collapsedMessages != null) {
            Set keys = this.collapsedMessages.keySet();
            for (String key : keys) {
                HashSet containerSet = (HashSet)this.collapsedMessages.get(key);
                if (containerSet.size() <= 0) continue;
                result.append(key).append("=");
                Iterator j = containerSet.iterator();
                while (j.hasNext()) {
                    String value = (String)j.next();
                    result.append(value).append(j.hasNext() ? ";" : "");
                }
                result.append("]");
            }
        }
        DialogSettings settings = (DialogSettings)TraceUIPlugin.getDefault().getDialogSettings();
        settings.put(VERTICAL_COLLAPSING, result.toString());
    }

    private HashMap loadCollapsedMessages() {
        DialogSettings settings = (DialogSettings)TraceUIPlugin.getDefault().getDialogSettings();
        HashMap ret = null;
        String result = settings.get(VERTICAL_COLLAPSING);
        if (result != null && result.length() > 1) {
            String[] agents = result.split("]");
            int i = 0;
            while (i < agents.length) {
                String[] parts = agents[i].split("=");
                if (TIUtils.doesAgentProxyStillExists(parts[0])) {
                    String[] values = parts[1].split(";");
                    if (values.length > 0) {
                        if (ret == null) {
                            ret = new HashMap();
                        }
                        HashSet<String> containerSet = new HashSet<String>();
                        ret.put(parts[0], containerSet);
                        int j = 0;
                        while (j < values.length) {
                            containerSet.add(values[j]);
                            TraceSDUtil.debugUml2SDTraceEvents("Load: key=" + parts[0] + " ticket=" + values[j]);
                            ++j;
                        }
                    }
                } else {
                    TraceSDUtil.debugUml2SDTraceEvents("Agent proxy " + parts[0] + " does no longer exist");
                }
                ++i;
            }
        }
        return ret;
    }

    private boolean isMessageCollapsed(TRCFullMethodInvocation methodInvocation) {
        if (methodInvocation == null || this.collapsedMessages == null) {
            return false;
        }
        HashSet containerSet = this.getContainerKeyHashSet(methodInvocation);
        if (containerSet != null && containerSet.contains(this.getMethodInvocationCollapsingId(methodInvocation))) {
            return true;
        }
        TRCFullMethodInvocation invokedBy = (TRCFullMethodInvocation)methodInvocation.getInvokedBy();
        while (invokedBy != null) {
            containerSet = this.getContainerKeyHashSet(invokedBy);
            if (containerSet != null && containerSet.contains(this.getMethodInvocationCollapsingId(invokedBy))) {
                return true;
            }
            invokedBy = (TRCFullMethodInvocation)invokedBy.getInvokedBy();
        }
        return false;
    }

    public void collapseCalledMessages(ArrayList graphNodes) {
        if (TraceSDUtil.debugEvents) {
            TraceSDUtil.debugUml2SDTraceEvents("collapseCalledMessages(" + (graphNodes != null ? graphNodes.size() : 0) + ")");
        }
        for (Object gn : graphNodes) {
            TRCFullMethodInvocation methodInvocation = null;
            if (gn instanceof TraceSyncMessage) {
                TraceSyncMessage sm = (TraceSyncMessage)gn;
                methodInvocation = (TRCFullMethodInvocation)sm.getEObject();
            } else if (gn instanceof TraceSyncMessageReturn) {
                TraceSyncMessageReturn smr = (TraceSyncMessageReturn)gn;
                methodInvocation = (TRCFullMethodInvocation)smr.getEObject();
            }
            this.collapseCalledMessage(methodInvocation);
        }
        this.saveCollapsedMessages();
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setVerticalCollapsingChanged(true);
        this.updateSDBackground(update);
    }

    private void collapseCalledMessage(TRCFullMethodInvocation methodInvocation) {
        if (methodInvocation != null) {
            HashSet<Object> containerSet;
            if (this.collapsedMessages == null) {
                this.collapsedMessages = new HashMap();
            }
            if ((containerSet = this.getContainerKeyHashSet(methodInvocation)) == null) {
                containerSet = new HashSet<Object>();
                this.collapsedMessages.put(this.getMethodInvocationContainerKey(methodInvocation), containerSet);
            }
            containerSet.add(this.getMethodInvocationCollapsingId(methodInvocation));
        }
    }

    public void expandCalledMessages(ArrayList graphNodes) {
        if (TraceSDUtil.debugEvents) {
            TraceSDUtil.debugUml2SDTraceEvents("expandCalledMessages(" + (graphNodes != null ? graphNodes.size() : 0) + ")");
        }
        for (Object gn : graphNodes) {
            HashSet containerSet;
            TRCFullMethodInvocation methodInvocation = null;
            if (gn instanceof TraceSyncMessage) {
                TraceSyncMessage sm = (TraceSyncMessage)gn;
                methodInvocation = (TRCFullMethodInvocation)sm.getEObject();
            } else if (gn instanceof TraceSyncMessageReturn) {
                TraceSyncMessageReturn smr = (TraceSyncMessageReturn)gn;
                methodInvocation = (TRCFullMethodInvocation)smr.getEObject();
            }
            if (methodInvocation == null || (containerSet = this.getContainerKeyHashSet(methodInvocation)) == null) continue;
            containerSet.remove(this.getMethodInvocationCollapsingId(methodInvocation));
        }
        this.saveCollapsedMessages();
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setVerticalCollapsingChanged(true);
        this.updateSDBackground(update);
    }

    public void highlightCallStack(ArrayList graphNodes) {
        IEObjectSelection eos;
        EObject eo;
        if (graphNodes.get(0) instanceof ITraceMessage && (eo = (eos = (IEObjectSelection)graphNodes.get(0)).getEObject()) instanceof TRCFullMethodInvocation) {
            TRCFullMethodInvocation mi = (TRCFullMethodInvocation)eo;
            LinkedList<TRCFullMethodInvocation> callStack = new LinkedList<TRCFullMethodInvocation>();
            callStack.add(mi);
            mi = (TRCFullMethodInvocation)mi.getInvokedBy();
            while (mi != null) {
                callStack.addFirst(mi);
                mi = (TRCFullMethodInvocation)mi.getInvokedBy();
            }
            Iterator it = callStack.iterator();
            Object eo1 = (EObject)it.next();
            ArrayList<SyncMessage> newSelection = new ArrayList<SyncMessage>();
            int i = 0;
            while (eo1 != null && i < this.frame.syncMessageCount()) {
                EObject eo2 = ((IEObjectSelection)this.frame.getSyncMessage(i)).getEObject();
                if (eo1 == eo2) {
                    newSelection.add(this.frame.getSyncMessage(i));
                    eo1 = it.hasNext() ? (EObject)it.next() : null;
                }
                ++i;
            }
            this.view.getSDWidget().clearSelection();
            this.view.getSDWidget().addSelection(newSelection);
            this.view.getSDWidget().ensureVisible((GraphNode)newSelection.get(newSelection.size() - 1));
            this.view.getSDWidget().redraw();
        }
    }

    private void reorderLifelinesAgain() {
        ArrayList lastLifelineReordered;
        if (this.view != null && this.view.getSDWidget() != null && (lastLifelineReordered = this.view.getSDWidget().getLifelineReoderList()) != null) {
            if (this.lifelineReordered == null) {
                this.lifelineReordered = new ArrayList();
            }
            this.lifelineReordered.addAll(lastLifelineReordered);
        }
        if (this.lifelineReordered == null || this.lifelineReordered.size() == 0 || this.frame == null) {
            return;
        }
        ArrayList<Lifeline[]> newList = new ArrayList<Lifeline[]>();
        for (Lifeline[] op : this.lifelineReordered) {
            Lifeline[] nop;
            if (op.length != 2 || (nop = new Lifeline[]{this.getNewerLifeline(op[0]), this.getNewerLifeline(op[1])})[0] == null || nop[1] == null) continue;
            newList.add(nop);
        }
        this.frame.reorder(newList);
        this.lifelineReordered = newList;
    }

    private Lifeline getNewerLifeline(Lifeline op) {
        block3: {
            try {
                TraceLifelineDraft traceLifelineDraft;
                EObject eObject = ((TraceLifeline)op).getEObject();
                if (eObject != null && (traceLifelineDraft = (TraceLifelineDraft)this.instancesMap.get(this.getLifeLineId(eObject))) != null) {
                    return traceLifelineDraft.getLifeline();
                }
            }
            catch (Exception e) {
                if (!TraceSDUtil.debugLoader) break block3;
                e.printStackTrace();
            }
        }
        return null;
    }

    public void applyPreferences() {
        int max = (int)TraceUIPlugin.getDefault().getPreferenceStore().getLong("page_size");
        if (this.maximumMessagesByPage == max) {
            return;
        }
        TraceInteractionUpdate update = new TraceInteractionUpdate();
        update.setMaxMessagesByPageChanged(true);
        this.maximumMessagesByPage = max;
        this.updateSDBackground(update);
    }

    public void supplementCoolbarContent(IActionBars bar) {
        super.supplementCoolbarContent(bar);
        MenuManager changeTraceKind = new MenuManager(TraceUIMessages._138);
        bar.getMenuManager().appendToGroup("UML2SD_VIEW_MODES", (IContributionItem)changeTraceKind);
        List list = ChangeLifelineLoaderAction.getChangeLifelineLoaderActions(this.view.getViewSite().getId());
        Iterator i = list.iterator();
        while (i.hasNext()) {
            ChangeLifelineLoaderAction a;
            a.setEnabled(!(a = (ChangeLifelineLoaderAction)((Object)i.next())).getLoaderClassName().equals(this.lifelineLoader.getClass().getName()));
            changeTraceKind.add((IAction)a);
        }
        this.undoDrillDownMenuAction = new UndoDrillDownMenuAction();
        bar.getMenuManager().appendToGroup("UML2SD_FILTERING", this.undoDrillDownMenuAction.getBackLastDrillDownAction());
        bar.getMenuManager().appendToGroup("UML2SD_FILTERING", this.undoDrillDownMenuAction.getResetDrillDownAction());
        bar.getToolBarManager().appendToGroup("UML2SD_FILTERING", (IAction)this.undoDrillDownMenuAction);
        this.undoDrillDownMenuAction.setEnabled(this.hasPositiveFilters);
    }

    public static TraceInteractions getInstance() {
        if (instance == null) {
            instance = new TraceInteractions();
        }
        return instance;
    }

    public void setLifelineLoader(String className) {
        this.lifelineLoader = (ILifelineLoader)LoadersManager.getLoadersManager().createLoaderInstance(className, this.getClass().getClassLoader());
        if (this.view != null) {
            TraceInteractionUpdate update = new TraceInteractionUpdate();
            update.setLifelineLoaderChanged(true);
            this.updateSDBackground(update);
        } else {
            LoadersManager.getLoadersManager().createLoader(className, this.getClass().getClassLoader(), this.view);
        }
        SDUtil.getInstance().setLastLoader(className, this.view.getSite().getId());
    }

    public void setLifelineLoader(BaseLifelineLoader lifelineLoader_) {
        this.lifelineLoader = lifelineLoader_;
    }

    public ILifelineLoader getLifelineLoader() {
        return this.lifelineLoader;
    }

    public String getFinalTitleString() {
        if (this.lifelineLoader != null) {
            return this.lifelineLoader.getFinalTitleString();
        }
        return null;
    }

    protected EObject getLifelineEObjectFromMethodInvocation(TRCFullMethodInvocation mi) {
        if (this.lifelineLoader != null) {
            return this.lifelineLoader.getLifelineEObjectFromMethodInvocation(mi);
        }
        return null;
    }

    protected String getLifeLineTitle(EObject to, boolean long_) {
        if (this.lifelineLoader != null) {
            return this.lifelineLoader.getLifeLineTitle(to, long_);
        }
        return null;
    }

    protected String getDistinguishedLifeLineTitle(EObject to, int rank) {
        if (this.lifelineLoader != null) {
            return this.lifelineLoader.getDistinguishedLifeLineTitle(to, rank);
        }
        return null;
    }

    protected String getLifeLineId(EObject to) {
        if (this.lifelineLoader != null) {
            return this.lifelineLoader.getLifeLineId(to);
        }
        return null;
    }

    protected int getLifeLineCategory(EObject to) {
        if (this.lifelineLoader != null) {
            return this.lifelineLoader.getLifeLineCategory(to);
        }
        return 0;
    }

    public String getNodeName(int nodeType, String loaderClassName) {
        ILifelineLoader loader = loaderClassName == null ? this.lifelineLoader : (ILifelineLoader)LoadersManager.getLoadersManager().createLoaderInstance(loaderClassName, this.getClass().getClassLoader());
        switch (nodeType) {
            case 0: {
                return loader.getLifelineTypeName();
            }
            case 1: {
                return loader.getMessageTypeName();
            }
        }
        return "";
    }

    public IPropertySheetPage getPropertySheetEntry() {
        PropertySheetPage pse = new PropertySheetPage();
        pse.setRootEntry((IPropertySheetEntry)new TraceRootProperty());
        return pse;
    }
}

