/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.util.internal.SSQEEvalResult;
import org.eclipse.hyades.models.hierarchy.util.internal.SimpleSearchQueryEngine;

public class FilterQuery {
    public static boolean isMatchingFilter(EObject source, SimpleSearchQuery filter) {
        filter.getSources().clear();
        filter.getSources().add((Object)EcoreUtil.getURI((EObject)source).toString());
        filter.getOutputElements().clear();
        SimpleOperand outputElement = ExtensionsFactory.eINSTANCE.createSimpleOperand();
        outputElement.setType(source.eClass());
        filter.getOutputElements().add((Object)outputElement);
        SimpleSearchQueryEngine engine = new SimpleSearchQueryEngine(filter, source.eResource().getResourceSet());
        SimpleSearchQueryEngine.SimpleSearchQueryEvaluator evaluator = new SimpleSearchQueryEngine.SimpleSearchQueryEvaluator(engine);
        SSQEEvalResult result = evaluator.prepareEvalResult();
        result.eval(source);
        return result.isComplete() ? (result.booleanValue() != null ? result.booleanValue() : true) : true;
    }

    private static String printExpr(Object expr) {
        String result = "";
        result = expr instanceof BinaryExpression ? String.valueOf(result) + FilterQuery.printBinaryExpression((BinaryExpression)expr) : (expr instanceof LogicalExpression ? String.valueOf(result) + FilterQuery.printLogicalExpression((LogicalExpression)expr) : (expr instanceof SimpleOperand ? String.valueOf(result) + FilterQuery.printSimpleOperand((SimpleOperand)expr) : String.valueOf(result) + expr.toString()));
        return result;
    }

    private static String printBinaryExpression(BinaryExpression expr) {
        String result = "[BE: ";
        result = String.valueOf(result) + FilterQuery.printExpr(expr.getLeftOperand());
        result = String.valueOf(result) + " " + expr.getOperator().getName() + "(";
        Iterator i = expr.getRightOperands().iterator();
        while (i.hasNext()) {
            result = String.valueOf(result) + "," + FilterQuery.printExpr(i.next());
        }
        result = String.valueOf(result) + ")]";
        return result;
    }

    private static String printLogicalExpression(LogicalExpression expr) {
        String result = "[LE: ";
        result = String.valueOf(result) + expr.getOperator().getName() + "(";
        Iterator i = expr.getArguments().iterator();
        while (i.hasNext()) {
            result = String.valueOf(result) + "," + FilterQuery.printExpr(i.next());
        }
        result = String.valueOf(result) + ")]";
        return result;
    }

    private static String printSimpleOperand(SimpleOperand operand) {
        if (operand.getRawValue() != null) {
            return operand.getRawValue();
        }
        if (operand.getFeature() != null) {
            return String.valueOf(operand.getFeature().getEContainingClass().getName()) + "." + operand.getFeature().getName();
        }
        return "x";
    }
}

