/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import java.util.Stack;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceMessageAndCallAssociation;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceSyncMessage;
import org.eclipse.hyades.uml2sd.trace.util.TIUtils;

public class TraceCallStack {
    private final BaseTraceInteractions interactions;
    private TRCThread eThread;
    private Stack callStack;

    public TraceCallStack(BaseTraceInteractions interactions_, TRCThread eThread) {
        this.setEThread(eThread);
        this.interactions = interactions_;
        this.callStack = new Stack();
    }

    public void setEThread(TRCThread eThread) {
        this.eThread = eThread;
    }

    public TRCThread getEThread() {
        return this.eThread;
    }

    public void pushCall(TraceSyncMessage syncMessage, TRCFullMethodInvocation methodInvocation) {
        this.callStack.push(new TraceMessageAndCallAssociation(syncMessage, methodInvocation));
        this.interactions.sortTraceThreadList(this);
    }

    public TraceMessageAndCallAssociation popCall() {
        if (this.callStack.size() == 0) {
            return null;
        }
        TraceMessageAndCallAssociation ret = (TraceMessageAndCallAssociation)this.callStack.pop();
        this.interactions.sortTraceThreadList(this);
        return ret;
    }

    public TraceMessageAndCallAssociation getCurrentCall() {
        if (this.callStack.size() > 0) {
            return (TraceMessageAndCallAssociation)this.callStack.lastElement();
        }
        return null;
    }

    public double getCurrentExitTime() {
        if (this.callStack.size() > 0) {
            double ret = TIUtils.getAbsoluteExitTime(this.getCurrentCall().getMethodInvocation());
            if (ret > 0.0) {
                return ret;
            }
            return 1.7976931348623158E307;
        }
        return Double.MAX_VALUE;
    }

    public long getCurrentTicket() {
        if (this.callStack.size() > 0) {
            return this.getCurrentCall().getMethodInvocation().getTicket();
        }
        return Long.MAX_VALUE;
    }

    public short getCurrentStackDepth() {
        if (this.callStack.size() > 0) {
            return this.getCurrentCall().getMethodInvocation().getStackDepth();
        }
        return Short.MAX_VALUE;
    }
}

