/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.uml2sd.trace.TraceSDUtil;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcess;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcesses;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;
import org.eclipse.jface.viewers.IStructuredSelection;

public class TIUtils {
    private static final boolean unitTestDebug = false;

    public static void searchTRCProcesses(EObject object, TraceProcesses list, IProgressMonitor monitor) {
        EList invocations;
        TRCAgent agent;
        TRCProcess process;
        if (monitor.isCanceled()) {
            return;
        }
        if (object instanceof TRCMonitor) {
            TRCMonitor m = (TRCMonitor)object;
            if (m.getNodes() == null || m.getNodes().isEmpty()) {
                return;
            }
            Iterator i = m.getNodes().iterator();
            while (i.hasNext() && !monitor.isCanceled()) {
                TIUtils.searchTRCProcesses((EObject)i.next(), list, monitor);
            }
        } else if (object instanceof TRCNode) {
            TRCNode n = (TRCNode)object;
            if (n.getProcessProxies() == null || n.getProcessProxies().isEmpty()) {
                return;
            }
            Iterator i = n.getProcessProxies().iterator();
            while (i.hasNext() && !monitor.isCanceled()) {
                TIUtils.searchTRCProcesses((EObject)i.next(), list, monitor);
            }
        } else if (object instanceof TRCProcessProxy) {
            TRCProcessProxy pp = (TRCProcessProxy)object;
            if (pp.getAgentProxies() == null || pp.getAgentProxies().isEmpty()) {
                return;
            }
            Iterator i = pp.getAgentProxies().iterator();
            while (i.hasNext() && !monitor.isCanceled()) {
                TIUtils.searchTRCProcesses((EObject)i.next(), list, monitor);
            }
        } else if (object instanceof TRCAgentProxy && ((TRCAgentProxy)object).getType().equals("Profiler") && (process = TraceUtils.getProcess((TRCAgent)(agent = ((TRCAgentProxy)object).getAgent()))) != null && (invocations = process.getInvocations()) != null && invocations.size() > 0 && invocations.get(0) instanceof TRCFullMethodInvocation) {
            list.add(new TraceProcess(process));
        }
    }

    public static List getProfileAgents(TRCProcessProxy processProxy) {
        ArrayList<TRCAgentProxy> profileAgents = new ArrayList<TRCAgentProxy>();
        if (processProxy != null) {
            EList agents = processProxy.getAgentProxies();
            TRCAgentProxy agentProxy2 = null;
            for (TRCAgentProxy agentProxy2 : agents) {
                if (!"Profiler".equals(agentProxy2.getType())) continue;
                profileAgents.add(agentProxy2);
            }
        }
        return profileAgents;
    }

    public static double getAbsoluteEntryTime(TRCFullMethodInvocation methodInvocation) {
        return TIUtils.getAbsoluteEntryTime(methodInvocation.getProcess().getAgent()) + methodInvocation.getEntryTime();
    }

    public static double getAbsoluteEntryTime(TRCAgent agent) {
        double delta = agent.getAgentProxy().getProcessProxy().getNode().getDeltaTime() * 1.0E-6;
        return delta + agent.getStartTime();
    }

    public static double getAbsoluteEntryTime(TRCProcess process) {
        return TIUtils.getAbsoluteEntryTime(process.getAgent()) + process.getStartTime();
    }

    public static double getAbsoluteEntryTime(TRCThread thread) {
        return TIUtils.getAbsoluteEntryTime(thread.getProcess().getAgent()) + thread.getStartTime();
    }

    public static double getAbsoluteExitTime(TRCFullMethodInvocation methodInvocation) {
        double start = TIUtils.getAbsoluteEntryTime(methodInvocation.getProcess().getAgent());
        if (methodInvocation.getExitTime() != 0.0) {
            return start + methodInvocation.getExitTime();
        }
        if (methodInvocation.getInvokes() == null || methodInvocation.getInvokes().size() == 0) {
            return TIUtils.getAbsoluteExitTime(methodInvocation.getThread());
        }
        TRCFullMethodInvocation lastCalled = (TRCFullMethodInvocation)methodInvocation.getInvokes().get(methodInvocation.getInvokes().size() - 1);
        if (lastCalled.getExitTime() == 0.0) {
            return TIUtils.getAbsoluteExitTime(lastCalled);
        }
        return start + lastCalled.getExitTime();
    }

    public static double getAbsoluteExitTime(TRCAgent agent) {
        double delta = agent.getAgentProxy().getProcessProxy().getNode().getDeltaTime() * 1.0E-6;
        return delta + agent.getStopTime();
    }

    public static double getAbsoluteExitTime(TRCProcess process) {
        if (process.getStopTime() == 0.0) {
            return TIUtils.getAbsoluteExitTime(process.getAgent());
        }
        return TIUtils.getAbsoluteEntryTime(process.getAgent()) + process.getStopTime();
    }

    public static double getAbsoluteExitTime(TRCThread thread) {
        if (thread.getStopTime() == 0.0) {
            return TIUtils.getAbsoluteExitTime(thread.getProcess().getAgent());
        }
        return TIUtils.getAbsoluteEntryTime(thread.getProcess().getAgent()) + thread.getStopTime();
    }

    public static boolean doesAgentProxyStillExists(String agentProxyRuntimeId) {
        ArrayList monitors = PDContentProvider.getMonitors();
        for (TRCMonitor monitor : monitors) {
            EList nodes = monitor.getNodes();
            for (TRCNode node : nodes) {
                EList pps = node.getProcessProxies();
                for (TRCProcessProxy pp : pps) {
                    EList aps = pp.getAgentProxies();
                    for (TRCAgentProxy ap : aps) {
                        if (!agentProxyRuntimeId.equals(ap.getRuntimeId())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean matchCharacter(char c1, char c2, boolean isCaseSensitive) {
        return c1 == c2 || !isCaseSensitive && Character.toLowerCase(c1) == Character.toLowerCase(c2);
    }

    private static boolean trailingStars(char[] s, int l) {
        int i = l;
        while (i < s.length && s[i] == '*') {
            ++i;
        }
        return i == s.length;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean matchCriteria(String s, Criteria criteria) {
        block18: {
            try {
                e = criteria.getExpression();
                ea = e.toCharArray();
                i = 0;
                j = 0;
lbl7:
                // 2 sources

                while (true) {
                    block22: {
                        block21: {
                            block20: {
                                if (i >= s.length()) break block20;
                                if (j < ea.length) break block21;
                            }
                            return i == s.length() && TIUtils.trailingStars(ea, j) != false;
                        }
                        sc = s.charAt(i);
                        ec = ea[j];
                        if (ec == 42) {
                            if (j + 1 == ea.length) {
                                return true;
                            }
                            if (ea[j + 1] == '?') {
                                ea[j] = 63;
                                ec = 63;
                                ea[j + 1] = 42;
                            }
                        }
                        if (ec != 42) break block22;
                        k = 1;
                        if (true) ** GOTO lbl50
                    }
                    if (ec == 63) {
                        if (i + 1 < s.length() && j + 1 < ea.length) {
                            ++j;
                            break block18;
                        } else {
                            return i + 1 == s.length() && TIUtils.trailingStars(ea, j + 1) != false;
                        }
                    }
                    if (!TIUtils.matchCharacter(sc, (char)ec, criteria.isCaseSenstiveSelected())) {
                        return false;
                    }
                    ++j;
                    break block18;
                    break;
                }
            }
            catch (Exception e) {
                if (TraceSDUtil.debugMatch) {
                    e.printStackTrace();
                }
                return false;
            }
            do {
                if (ea[j + k] == '*' || ea[j + k] == '?') {
                    j += k;
                    i += k - 2;
                    break;
                }
                if (!TIUtils.matchCharacter(s.charAt(i + k - 1), ea[j + k], criteria.isCaseSenstiveSelected())) break;
                ++k;
lbl50:
                // 2 sources

                if (i + k - 1 >= s.length()) break;
            } while (j + k < ea.length);
            if (i + k - 1 == s.length() && TIUtils.trailingStars(ea, j + k)) {
                return true;
            }
        }
        ++i;
        ** while (true)
    }

    public static boolean hasObjectInteractions(TRCAgentProxy agent_proxy) {
        boolean collects_object_instances = false;
        switch (agent_proxy.getCollectionMode().getValue()) {
            case 2: 
            case 5: 
            case 6: {
                collects_object_instances = true;
                break;
            }
            default: {
                collects_object_instances = false;
            }
        }
        return collects_object_instances;
    }

    public static boolean hasInvocationData(TRCAgentProxy agentProxy) {
        boolean stackInformation = false;
        if (agentProxy != null && agentProxy.getType().equals("Profiler")) {
            EList configs = agentProxy.getConfigurations();
            if (configs == null) {
                return false;
            }
            for (TRCConfiguration config : configs) {
                EList options = config.getOptions();
                if (options == null) continue;
                for (TRCOption option : options) {
                    if (!option.getKey().equals("STACK_INFORMATION") || option.getValue().equals("none")) continue;
                    stackInformation = true;
                }
            }
        }
        return stackInformation;
    }

    public static void searchTRCAgentProxies(EObject object, List list) {
        if (object instanceof TRCMonitor) {
            TRCMonitor m = (TRCMonitor)object;
            if (m.getNodes() == null || m.getNodes().isEmpty()) {
                return;
            }
            Iterator i = m.getNodes().iterator();
            while (i.hasNext()) {
                TIUtils.searchTRCAgentProxies((EObject)i.next(), list);
            }
        } else if (object instanceof TRCNode) {
            TRCNode n = (TRCNode)object;
            if (n.getProcessProxies() == null || n.getProcessProxies().isEmpty()) {
                return;
            }
            Iterator i = n.getProcessProxies().iterator();
            while (i.hasNext()) {
                TIUtils.searchTRCAgentProxies((EObject)i.next(), list);
            }
        } else if (object instanceof TRCProcessProxy) {
            TRCProcessProxy pp = (TRCProcessProxy)object;
            if (pp.getAgentProxies() == null || pp.getAgentProxies().isEmpty()) {
                return;
            }
            Iterator i = pp.getAgentProxies().iterator();
            while (i.hasNext()) {
                TIUtils.searchTRCAgentProxies((EObject)i.next(), list);
            }
        } else if (object instanceof TRCAgentProxy) {
            TRCAgentProxy agentProxy = (TRCAgentProxy)object;
            if (!list.contains(agentProxy)) {
                list.add(agentProxy);
            }
        } else if (TraceSDUtil.debugEvents) {
            TraceSDUtil.debugUml2SDTraceEvents("WARNING! searchTRCAgentProxies(): Found a " + object);
        }
    }

    public static List collectMultiSelectionInNavigator() {
        INavigator nav = HyadesUtil.getActiveNavigator();
        IStructuredSelection selection = nav == null ? null : nav.getStructuredSelection();
        ArrayList list = new ArrayList();
        if (selection != null) {
            for (Object obj : selection) {
                if (obj instanceof INavigatorItem) {
                    obj = ((INavigatorItem)obj).getData();
                }
                if (obj instanceof EObject) {
                    TIUtils.searchTRCAgentProxies((EObject)obj, list);
                    continue;
                }
                if (!TraceSDUtil.debugEvents) continue;
                TraceSDUtil.debugUml2SDTraceEvents("WARNING! collectMultiSelectionInNavigator(): Found a " + obj.getClass().getName() + " " + obj);
            }
        }
        return list;
    }
}

