/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.hierarchy;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;

public class XMLnodeLoader
extends IgnoredXMLFragmentLoader {
    protected String hostname;
    protected String ipaddress;
    protected String nodeId;
    protected double timezone;

    public void addAttribute(String name, String value) {
        if (value == null || value.trim().length() == 0) {
            return;
        }
        if (name.equals("nodeId")) {
            this.nodeId = value;
        } else if (name.equals("hostname")) {
            this.hostname = value;
        } else if (name.equals("ipaddress")) {
            this.ipaddress = value;
        } else if (name.equals("timezone")) {
            this.timezone = Double.parseDouble(value);
        }
    }

    public void addYourselfInContext() {
        TRCNode node;
        TRCMonitor monitor = this.context.getMonitor();
        if (monitor == null) {
            return;
        }
        if (this.nodeId == null) {
            this.nodeId = "0";
        }
        if (this.hostname == null) {
            this.hostname = "unknown";
        }
        if ((node = this.context.getNode()) == null) {
            node = LoadersUtils.locateNodeFromMonitor(this.context.getMonitor(), this.hostname, this.ipaddress, this.nodeId);
        } else {
            String rId = node.getRuntimeId();
            if (rId != null && !rId.equals(this.nodeId)) {
                node = LoadersUtils.locateNodeFromMonitor(monitor, this.hostname, this.ipaddress, this.nodeId);
            }
        }
        if (node == null) {
            String monitorFolder = LoadersUtils.getMonitorFolder(monitor);
            Resource nDoc = null;
            if (monitorFolder != null) {
                String nName = String.valueOf(monitor.getName()) + "_" + this.hostname.trim();
                String nodeFileName = String.valueOf(monitorFolder) + nName;
                URI uri = SaveUtil.createURI(String.valueOf(nodeFileName) + ".trcnxmi#").trimFragment();
                nDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
                nDoc.setModified(true);
                HierarchyResourceSetImpl.getInstance().getResources().add((Object)nDoc);
            }
            node = HierarchyFactory.eINSTANCE.createTRCNode();
            node.setName(this.hostname);
            node.setRuntimeId(this.nodeId);
            node.setMonitor(monitor);
            if (nDoc != null) {
                nDoc.getContents().add((Object)node);
            }
        } else {
            node.setIpAddress(this.ipaddress);
            node.setRuntimeId(this.nodeId);
            node.setTimezone(this.timezone);
        }
        this.context.setNode(node);
    }

    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        this.hostname = null;
        this.ipaddress = null;
        this.nodeId = null;
        this.timezone = 0.0;
    }
}

