/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.hierarchy;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;

public class XMLprocessCreateLoader
extends IgnoredXMLFragmentLoader {
    protected String application_executable;
    protected String pName;
    protected String nodeIdRef;
    protected String processId;
    protected TRCProcessProxy process;
    protected int pid;

    public void addAttribute(String name, String value) {
        if (value == null || value.trim().length() == 0) {
            return;
        }
        if (name.equals("processId")) {
            this.processId = value;
        } else if (name.equals("nodeIdRef")) {
            this.nodeIdRef = value;
        } else if (name.equals("name")) {
            this.pName = value;
        } else if (name.equals("pid")) {
            this.pid = Integer.parseInt(value);
        } else if (name.equals("application_executable")) {
            this.application_executable = value;
        }
    }

    protected TRCNode getNodeById(TRCMonitor monitor) {
        if (this.nodeIdRef == null) {
            return null;
        }
        TRCNode node = null;
        for (TRCNode n : monitor.getNodes()) {
            if (n.eIsProxy() || !this.nodeIdRef.equals(n.getRuntimeId())) continue;
            node = n;
            break;
        }
        return node;
    }

    protected TRCProcessProxy getProcess(TRCNode node, int id) {
        TRCProcessProxy proc = null;
        EList<TRCProcessProxy> processList = node.getProcessProxies();
        int i = 0;
        while (i < processList.size()) {
            TRCProcessProxy p = (TRCProcessProxy)processList.get(i);
            if (p.getPid() == id) {
                proc = p;
                break;
            }
            ++i;
        }
        return proc;
    }

    protected TRCNode getNodeByPid(TRCMonitor monitor) {
        if (this.processId == null) {
            return null;
        }
        TRCNode node = null;
        for (TRCNode n : monitor.getNodes()) {
            TRCProcessProxy proc;
            if (n.eIsProxy() || (proc = this.getProcess(n, this.pid)) == null) continue;
            node = n;
            break;
        }
        return node;
    }

    protected TRCNode getNode(TRCMonitor monitor) {
        return this.nodeIdRef != null ? this.getNodeById(monitor) : this.getNodeByPid(monitor);
    }

    public void addYourselfInContext() {
        TRCMonitor monitor = this.context.getMonitor();
        if (monitor == null) {
            return;
        }
        TRCNode node = this.context.getNode();
        if (node == null) {
            node = this.getNode(monitor);
            if (node == null) {
                return;
            }
            this.context.setNode(node);
        }
        this.process = LoadersUtils.locateProcessFromNode(node, this.pid, this.processId);
        if (this.process == null) {
            String monitorFolder = LoadersUtils.getMonitorFolder(monitor);
            Resource procDoc = null;
            if (monitorFolder != null) {
                StringBuffer buffer = new StringBuffer(monitor.getName()).append("_").append(node.getName()).append("_").append(this.pid).append("_").append(this.processId);
                String pName = buffer.toString();
                pName = StringUtil.change(pName, "\"", "");
                String pFileName = String.valueOf(monitorFolder) + pName;
                URI uri = SaveUtil.createURI(String.valueOf(pFileName) + ".trcpxmi#").trimFragment();
                procDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
                procDoc.setModified(true);
                HierarchyResourceSetImpl.getInstance().getResources().add((Object)procDoc);
            }
            this.process = HierarchyFactory.eINSTANCE.createTRCProcessProxy();
            this.process.setNode(node);
            if (procDoc != null) {
                procDoc.getContents().add((Object)this.process);
            }
        }
        this.process.setPid(this.pid);
        if (this.processId != null) {
            this.process.setRuntimeId(this.processId);
        } else if (this.process.getRuntimeId() == null) {
            this.process.setRuntimeId("0");
        }
        this.setProcessArguments(this.process);
        if (this.process.getName() == null || this.process.getName().equals("unknown")) {
            this.process.setName(this.pName);
        }
        this.context.setProcessProxy(this.process);
    }

    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        this.processId = "0";
        this.nodeIdRef = "0";
        this.application_executable = "";
        this.pName = "unknown";
        this.process = null;
        this.pid = -1;
    }

    protected void setProcessArguments(TRCProcessProxy process) {
        if (this.application_executable == null) {
            return;
        }
        String params = "";
        String vmparam = "";
        String classpath = "";
        int java_index = this.application_executable.indexOf("java.exe");
        if (java_index < 0) {
            java_index = this.application_executable.indexOf("javaw.exe");
            if (java_index > 0) {
                java_index += "javaw.exe".length();
            }
        } else {
            java_index += "java.exe".length();
        }
        if (java_index > 0) {
            String exeName = this.application_executable.substring(java_index).trim();
            int idx = exeName.indexOf(" ");
            if (!exeName.startsWith("-") && idx != -1 && idx < exeName.length() + 1) {
                exeName = exeName.substring(idx + 1);
            }
            while (exeName.startsWith("-")) {
                if (exeName.startsWith("-cp") || exeName.startsWith("-classpath")) {
                    idx = exeName.indexOf(" ");
                    if (idx != -1) {
                        exeName = exeName.substring(idx).trim();
                    }
                    if ((idx = exeName.indexOf(" ")) == -1) continue;
                    classpath = exeName.substring(0, idx);
                    exeName = exeName.substring(idx).trim();
                    continue;
                }
                idx = exeName.indexOf(" ");
                if (idx == -1) continue;
                vmparam = String.valueOf(vmparam) + exeName.substring(0, idx) + " ";
                exeName = exeName.substring(idx).trim();
            }
            idx = exeName.indexOf(" ");
            if (idx != -1) {
                if (this.pName.equals("unknown")) {
                    this.pName = exeName.substring(0, idx);
                }
                params = exeName.substring(idx).trim();
            } else if (this.pName.equals("unknown") && exeName.trim().length() > 0) {
                this.pName = exeName;
            }
        }
        process.setClasspath(classpath);
        process.setParameters(params);
        process.setVmArguments(vmparam);
    }
}

