/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.internal.binary;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.hyades.loaders.internal.binary.BFHeader;
import org.eclipse.hyades.loaders.internal.binary.BFParser;
import org.eclipse.hyades.loaders.internal.binary.BFReader;
import org.eclipse.hyades.loaders.internal.binary.v1.ParserImpl1;
import org.eclipse.hyades.loaders.util.HierarchyContext;

public class BFParserFactory {
    private static final Class[] constructorArgs = new Class[]{HierarchyContext.class, BFReader.class};
    private final Map parsers = new HashMap();

    public BFParserFactory() {
        ParserImpl1.register(this);
    }

    public BFParser get(BFHeader header, HierarchyContext context, BFReader reader) {
        Class parserClass = (Class)this.parsers.get(new Double(header.getVersion().getVersion()));
        if (parserClass == null) {
            return null;
        }
        try {
            return (BFParser)parserClass.getConstructor(constructorArgs).newInstance(context, reader);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void put(Double version, Class parser) {
        this.parsers.put(version, parser);
    }
}

