/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.internal.binary;

import java.io.IOException;
import org.eclipse.hyades.loaders.internal.binary.BFReader;
import org.eclipse.hyades.loaders.internal.binary.Offset;

public class BinaryFragment {
    public static final int HEADER_LENGTH = 6;
    Short id;
    int length;
    int bodyOffset;
    byte[] body;

    public BinaryFragment(byte[] header, int offset, BFReader reader) throws IOException {
        Offset headerMarker = new Offset(offset, offset + 6);
        this.id = new Short((short)reader.readUnsignedShort(header, headerMarker));
        this.length = (int)reader.readUnsignedInt(header, headerMarker);
    }

    public Short getId() {
        return this.id;
    }

    public int getLength() {
        return this.length;
    }

    public int getBodyOffset() {
        return this.bodyOffset;
    }

    public void setBodyOffset(int bodyOffset) {
        this.bodyOffset = bodyOffset;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public static boolean isEOF(byte[] header, int offset) {
        int headerOffset = offset + 6;
        if (headerOffset > header.length) {
            return true;
        }
        int i = offset;
        while (i < headerOffset) {
            if (header[i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

