/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.internal.binary;

import org.eclipse.hyades.loaders.internal.binary.BFReader;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragment;
import org.eclipse.hyades.loaders.internal.binary.IgnoredBinaryFragmentLoader;
import org.eclipse.hyades.loaders.internal.binary.Offset;
import org.eclipse.hyades.loaders.util.BinaryFragmentLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoaderExtensions;

public abstract class BinaryFragmentParser {
    public static final String AGENT_ID = "agentId";
    public static final String AGENT_ID_REF = "agentIdRef";
    public static final String AGENT_NAME = "agentName";
    public static final String AGENT_TYPE = "agentType";
    public static final String PROCESS_ID_REF = "processIdRef";
    public static final String AGENT_PARAMETERS = "agentParameters";
    public static final String VERSION = "version";
    public static final String THREAD_ID = "threadId";
    public static final String THREAD_ID_REF = "threadIdRef";
    public static final String TRANS_THREAD_ID_REF = "transientThreadIdRef";
    public static final String TRANS_THREAD_ID = "transientThreadId";
    public static final String GROUP_NAME = "groupName";
    public static final String PARENT_NAME = "parentName";
    public static final String THREAD_NAME = "threadName";
    public static final String METHOD_ID = "methodId";
    public static final String METHOD_ID_REF = "methodIdRef";
    public static final String A_METHOD_ID_REF = "aMethodIdRef";
    public static final String TIME = "time";
    public static final String BASE_TIME = "baseTime";
    public static final String MIN_TIME = "minTime";
    public static final String MAX_TIME = "maxTime";
    public static final String CPU_TIME = "cpuTime";
    public static final String TIMEOUT = "timeout";
    public static final String THREAD_CPU_TIME = "cpuTime";
    public static final String COUNT = "count";
    public static final String NUM_INTERFACES = "numInterfaces";
    public static final String INTERFACE_NAMES = "interfaceNames";
    public static final String CLASS_ID = "classId";
    public static final String CLASS_ID_REF = "classIdRef";
    public static final String TRANS_CLASS_ID = "transientClassId";
    public static final String TRANS_CLASS_ID_REF = "transientClassIdRef";
    public static final String CLASS_LOADER = "classLoader";
    public static final String SUPER_CLASS = "superClass";
    public static final String SOURCE_NAME = "sourceName";
    public static final String OBJ_ID_REF = "objIdRef";
    public static final String OBJ_ID = "objId";
    public static final String TRANS_OBJ_ID_REF = "transientObjIdRef";
    public static final String OWNER_OBJ_ID_REF = "ownerObjIdRef";
    public static final String TARGET_OBJ_ID_REF = "targetObjIdRef";
    public static final String OBJ_AGE = "objAge";
    public static final String NAME_ATTR = "name";
    public static final String ACCESS = "access";
    public static final String NUM_STATIC_FIELDS = "numStaticFields";
    public static final String NUM_METHODS = "numMethods";
    public static final String NUM_INSTANCE_FIELDS = "numInstanceFields";
    public static final String COLLATION_VALUE = "collationValue";
    public static final String TRACE_ID = "traceId";
    public static final String TRACE_ID_REF = "traceIdRef";
    public static final String PATTERN = "pattern";
    public static final String GENERIC_PATTERN = "genericPattern";
    public static final String MODE = "mode";
    public static final String METHOD_PATTERN = "methodPattern";
    public static final String METHOD_GENERIC_PATTERN = "methodGenericPattern";
    public static final String METHOD_MODE = "methodMode";
    public static final String TOTAL_OBJECT_SPACE = "totalObjectSpace";
    public static final String USED_OBJECT_SPACE = "usedObjectSpace";
    public static final String USED_OBJECTS = "usedObjects";
    public static final String TYPE = "type";
    public static final String HEAP_DUMP_ID_REF = "heapDumpIdRef";
    public static final String SIGNATURE = "signature";
    public static final String VISIBILITY = "visibility";
    public static final String IS_NATIVE = "isNative";
    public static final String IS_ABSTRACT = "isAbstract";
    public static final String IS_STATIC = "isStatic";
    public static final String IS_SYNCHRONIZED = "isSynchronized";
    public static final String IS_ARRAY = "isArray";
    public static final String EXCEPTIONS = "exceptions";
    public static final String START_LINE_NUMBER = "startLineNumber";
    public static final String END_LINE_NUMBER = "endLineNumber";
    public static final String LINE = "line";
    public static final String A_LINE_NR = "aLineNr";
    public static final String SIGNATURE_NOTATION = "signatureNotation";
    public static final String TICKET = "ticket";
    public static final String SEQUENCE_COUNTER = "sequenceCounter";
    public static final String STACK_DEPTH = "stackDepth";
    public static final String ANNOTATION = "annotation";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String CALL_STACK_METHODS = "callStackDumpMethods";
    public static final String CALL_STACK_LINES = "callStackDumpLineNumbers";
    public static final String THREAD_OWNER = "threadOwner";
    public static final String NODE_ID = "nodeId";
    public static final String NODE_ID_REF = "nodeIdRef";
    public static final String HOSTNAME = "hostname";
    public static final String IPADDRESS = "ipaddress";
    public static final String TIMEZONE = "timezone";
    public static final String TIMESTAMP = "timestamp";
    public static final String SIZE = "size";
    public static final String CONTEXT_DATA = "contextData";
    public static final String PROCESS_ID = "processId";
    public static final String PID = "pid";
    public static final String APPLICATION_EXECUTABLE = "applicationExecutable";
    public static final String IS_NOTIFY_ALL = "isNotifyAll";
    private BinaryFragmentLoader loader;
    private String name;

    public BinaryFragmentParser() {
        this.loader = new IgnoredBinaryFragmentLoader();
    }

    protected BinaryFragmentParser(Short id, String name) {
        this.loader = (BinaryFragmentLoader)LoaderExtensions.getInstance().get(name);
        if (this.loader == null) {
            this.loader = new IgnoredBinaryFragmentLoader();
        }
        this.name = name;
    }

    public BinaryFragmentLoader getLoader() {
        return this.loader;
    }

    public abstract boolean parse(BinaryFragment var1, Offset var2, BFReader var3);

    public void addYourselfInContext() {
        this.loader.addYourselfInContext();
    }

    public void initialize(HierarchyContext context) {
        if (this.name != null) {
            this.loader.initialize(context, this.name);
        }
    }

    protected void addAnnotation(BinaryFragmentLoader loader, Object[] data, String name) {
        loader.startChild(ANNOTATION);
        loader.addAttribute(NAME_ATTR, name);
        int i = 0;
        while (i < data.length) {
            char[] charData = data[i].toString().toCharArray();
            loader.startChild(VALUE);
            loader.addCharacters(charData, 0, charData.length);
            loader.endChild(VALUE);
            ++i;
        }
        loader.endChild(ANNOTATION);
    }
}

