/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.internal.binary;

public class Offset {
    private int offset;
    private final long length;

    public Offset(int offset, long length) {
        if (offset < 0 || length > 0L && (long)offset > length) {
            throw new IllegalArgumentException("Offset should be between 0 and " + length);
        }
        this.offset = offset;
        this.length = length;
    }

    public Offset(int offset) {
        this(offset, 0L);
    }

    public int increaseOffset(int delta) {
        int oldOffset = this.offset;
        int newOffset = this.offset + delta;
        if (this.length > 0L && (long)newOffset > this.length) {
            return -1;
        }
        this.offset = newOffset;
        return oldOffset;
    }

    public int getOffset() {
        return this.offset;
    }

    public long getLength() {
        return this.length;
    }
}

