/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.internal.binary.v1;

import org.eclipse.hyades.loaders.internal.binary.BFReader;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragment;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragmentParser;
import org.eclipse.hyades.loaders.internal.binary.Offset;
import org.eclipse.hyades.loaders.util.BinaryFragmentLoader;

public class BFMonContendedEnterParser
extends BinaryFragmentParser {
    public static final Short ID = new Short(1034);
    public static final String NAME = "monContendedEnter";

    public BFMonContendedEnterParser() {
        super(ID, NAME);
    }

    public boolean parse(BinaryFragment fragment, Offset offset, BFReader reader) {
        byte[] data = fragment.getBody();
        BinaryFragmentLoader loader = this.getLoader();
        loader.addAttribute("threadIdRef", (int)reader.readLong(data, offset));
        loader.addAttribute("time", reader.readTimestampAsString(data, offset));
        loader.addAttribute("objIdRef", reader.readLong(data, offset));
        loader.addAttribute("threadOwner", (int)reader.readLong(data, offset));
        long stackDepth = reader.readUnsignedInt(data, offset);
        Object[] stackMethods = reader.readStringArray(data, (int)stackDepth, offset);
        this.addAnnotation(loader, stackMethods, "callStackDumpMethods");
        Object[] stackLines = reader.readLongArray(data, (int)stackDepth, offset);
        this.addAnnotation(loader, stackLines, "callStackDumpLineNumbers");
        return true;
    }
}

