/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.internal.binary.v1;

import org.eclipse.hyades.loaders.internal.binary.BFReader;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragment;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragmentParser;
import org.eclipse.hyades.loaders.internal.binary.Offset;
import org.eclipse.hyades.loaders.util.BinaryFragmentLoader;

public class BFMonWaitedParser
extends BinaryFragmentParser {
    public static final Short ID = new Short(1033);
    public static final String NAME = "monWaited";

    public BFMonWaitedParser() {
        super(ID, NAME);
    }

    public boolean parse(BinaryFragment fragment, Offset offset, BFReader reader) {
        byte[] data = fragment.getBody();
        BinaryFragmentLoader loader = this.getLoader();
        loader.addAttribute("threadIdRef", (int)reader.readLong(data, offset));
        loader.addAttribute("time", reader.readTimestampAsString(data, offset));
        loader.addAttribute("objIdRef", reader.readLong(data, offset));
        loader.addAttribute("timeout", reader.readLong(data, offset));
        int stackDepth = (int)reader.readUnsignedInt(data, offset);
        Object[] stackMethods = reader.readStringArray(data, stackDepth, offset);
        this.addAnnotation(loader, stackMethods, "callStackDumpMethods");
        Object[] stackLines = reader.readLongArray(data, stackDepth, offset);
        this.addAnnotation(loader, stackLines, "callStackDumpLineNumbers");
        return true;
    }
}

