/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.internal.binary.v1;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.hyades.loaders.internal.binary.BFParser;
import org.eclipse.hyades.loaders.internal.binary.BFParserFactory;
import org.eclipse.hyades.loaders.internal.binary.BFReader;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragment;
import org.eclipse.hyades.loaders.internal.binary.BinaryFragmentParser;
import org.eclipse.hyades.loaders.internal.binary.IgnoredBinaryFragmentParser;
import org.eclipse.hyades.loaders.internal.binary.Offset;
import org.eclipse.hyades.loaders.internal.binary.v1.BFAGMethodEntryParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFAGMethodExitParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFAgentCreateParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFAgentDestroyParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFCatchParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFClassDefParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFClassUnloadParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFEncodingParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFFilterParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFFrequencyParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFGCFinishParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFGCRootParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFGCStartParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFHeapDumpDefParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFInvocationContextParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFLineParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFMethodCountParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFMethodDefParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFMethodEntryParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFMethodExitParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFMonContendedEnterParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFMonContendedEnteredParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFMonNotifyCalledParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFMonWaitParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFMonWaitedParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFNodeParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFObjAllocParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFObjDefParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFObjFreeParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFObjMoveParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFObjRefParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFOptionParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFProcessCreateParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFRuntimeInitDoneParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFRuntimeShutdownParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFThreadEndParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFThreadInterruptCalledParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFThreadSleepEndParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFThreadSleepStartParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFThreadStartCalledParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFThreadStartParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFThrowParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFTraceEndParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFTraceStartParser;
import org.eclipse.hyades.loaders.internal.binary.v1.BFValueParser;
import org.eclipse.hyades.loaders.util.HierarchyContext;

public class ParserImpl1
implements BFParser {
    private static final Double version = new Double(1.0);
    private int eventsParsed = 0;
    private Map<Short, Class<?>> messageHandlers = new HashMap();
    private final HierarchyContext context;
    private final BFReader reader;

    public void reset() {
        this.eventsParsed = 0;
    }

    public ParserImpl1(HierarchyContext context, BFReader reader) {
        this.context = context;
        this.reader = reader;
        this.initialize();
    }

    private void initialize() {
        this.messageHandlers.put(BFEncodingParser.ID, BFEncodingParser.class);
        this.messageHandlers.put(BFFrequencyParser.ID, BFFrequencyParser.class);
        this.messageHandlers.put(BFNodeParser.ID, BFNodeParser.class);
        this.messageHandlers.put(BFProcessCreateParser.ID, BFProcessCreateParser.class);
        this.messageHandlers.put(BFAgentCreateParser.ID, BFAgentCreateParser.class);
        this.messageHandlers.put(BFAgentDestroyParser.ID, BFAgentDestroyParser.class);
        this.messageHandlers.put(BFTraceStartParser.ID, BFTraceStartParser.class);
        this.messageHandlers.put(BFTraceEndParser.ID, BFTraceEndParser.class);
        this.messageHandlers.put(BFFilterParser.ID, BFFilterParser.class);
        this.messageHandlers.put(BFOptionParser.ID, BFOptionParser.class);
        this.messageHandlers.put(BFThreadStartParser.ID, BFThreadStartParser.class);
        this.messageHandlers.put(BFThreadEndParser.ID, BFThreadEndParser.class);
        this.messageHandlers.put(BFClassDefParser.ID, BFClassDefParser.class);
        this.messageHandlers.put(BFMethodDefParser.ID, BFMethodDefParser.class);
        this.messageHandlers.put(BFObjAllocParser.ID, BFObjAllocParser.class);
        this.messageHandlers.put(BFMethodEntryParser.ID, BFMethodEntryParser.class);
        this.messageHandlers.put(BFMethodExitParser.ID, BFMethodExitParser.class);
        this.messageHandlers.put(BFInvocationContextParser.ID, BFInvocationContextParser.class);
        this.messageHandlers.put(BFObjDefParser.ID, BFObjDefParser.class);
        this.messageHandlers.put(BFValueParser.ID, BFValueParser.class);
        this.messageHandlers.put(BFMethodCountParser.ID, BFMethodCountParser.class);
        this.messageHandlers.put(BFLineParser.ID, BFLineParser.class);
        this.messageHandlers.put(BFGCStartParser.ID, BFGCStartParser.class);
        this.messageHandlers.put(BFObjFreeParser.ID, BFObjFreeParser.class);
        this.messageHandlers.put(BFClassUnloadParser.ID, BFClassUnloadParser.class);
        this.messageHandlers.put(BFObjMoveParser.ID, BFObjMoveParser.class);
        this.messageHandlers.put(BFGCFinishParser.ID, BFGCFinishParser.class);
        this.messageHandlers.put(BFThrowParser.ID, BFThrowParser.class);
        this.messageHandlers.put(BFCatchParser.ID, BFCatchParser.class);
        this.messageHandlers.put(BFRuntimeInitDoneParser.ID, BFRuntimeInitDoneParser.class);
        this.messageHandlers.put(BFRuntimeShutdownParser.ID, BFRuntimeShutdownParser.class);
        this.messageHandlers.put(BFMonWaitParser.ID, BFMonWaitParser.class);
        this.messageHandlers.put(BFMonWaitedParser.ID, BFMonWaitedParser.class);
        this.messageHandlers.put(BFMonContendedEnterParser.ID, BFMonContendedEnterParser.class);
        this.messageHandlers.put(BFMonContendedEnteredParser.ID, BFMonContendedEnteredParser.class);
        this.messageHandlers.put(BFAGMethodEntryParser.ID, BFAGMethodEntryParser.class);
        this.messageHandlers.put(BFAGMethodExitParser.ID, BFAGMethodExitParser.class);
        this.messageHandlers.put(BFHeapDumpDefParser.ID, BFHeapDumpDefParser.class);
        this.messageHandlers.put(BFGCRootParser.ID, BFGCRootParser.class);
        this.messageHandlers.put(BFObjRefParser.ID, BFObjRefParser.class);
        this.messageHandlers.put(BFMonNotifyCalledParser.ID, BFMonNotifyCalledParser.class);
        this.messageHandlers.put(BFThreadInterruptCalledParser.ID, BFThreadInterruptCalledParser.class);
        this.messageHandlers.put(BFThreadStartCalledParser.ID, BFThreadStartCalledParser.class);
        this.messageHandlers.put(BFThreadSleepStartParser.ID, BFThreadSleepStartParser.class);
        this.messageHandlers.put(BFThreadSleepEndParser.ID, BFThreadSleepEndParser.class);
    }

    public void parseEvents(byte[] buffer, Offset marker) {
        try {
            BinaryFragment binaryFragment;
            while ((binaryFragment = this.getBinaryFragment(buffer, marker)) != null) {
                if (binaryFragment.getId() == null) continue;
                this.parseBinaryFragment(binaryFragment, marker);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void parseEvents(InputStream inputStream, Offset marker) {
        try {
            BinaryFragment binaryFragment;
            while ((binaryFragment = this.getBinaryFragment(inputStream, marker)) != null) {
                if (binaryFragment.getId() == null) continue;
                this.parseBinaryFragment(binaryFragment, marker);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private BinaryFragment getBinaryFragment(byte[] buffer, Offset marker) throws IOException {
        if (BinaryFragment.isEOF(buffer, marker.getOffset())) {
            return null;
        }
        BinaryFragment binaryFragment = new BinaryFragment(buffer, marker.getOffset(), this.reader);
        if (marker.increaseOffset(6) < 0) {
            return null;
        }
        binaryFragment.setBody(buffer);
        binaryFragment.setBodyOffset(marker.getOffset());
        if (marker.increaseOffset(binaryFragment.getLength()) < 0) {
            return null;
        }
        binaryFragment.getId();
        return binaryFragment;
    }

    private BinaryFragment getBinaryFragment(InputStream inputStream, Offset marker) throws IOException {
        byte[] header = new byte[6];
        if (inputStream.read(header) < 0) {
            return null;
        }
        if (BinaryFragment.isEOF(header, 0)) {
            return null;
        }
        BinaryFragment binaryFragment = new BinaryFragment(header, 0, this.reader);
        if (marker.increaseOffset(6) < 0) {
            return null;
        }
        byte[] body = new byte[binaryFragment.getLength()];
        if (inputStream.read(body) < 0) {
            return null;
        }
        binaryFragment.setBody(body);
        if (marker.increaseOffset(binaryFragment.getLength()) < 0) {
            return null;
        }
        binaryFragment.getId();
        return binaryFragment;
    }

    private void parseBinaryFragment(BinaryFragment binaryFragment, Offset marker) throws InstantiationException, IllegalAccessException {
        BinaryFragmentParser fragmentParser = this.getFragmentParser(binaryFragment.getId());
        fragmentParser.getClass().equals(IgnoredBinaryFragmentParser.class);
        fragmentParser.initialize(this.context);
        Offset bodyOffset = new Offset(binaryFragment.getBodyOffset(), binaryFragment.getBodyOffset() + binaryFragment.getLength());
        if (fragmentParser.parse(binaryFragment, bodyOffset, this.reader)) {
            fragmentParser.addYourselfInContext();
            ++this.eventsParsed;
            if (this.context.getAgent() != null && this.context.getAgent().eResource() != null && !this.context.getAgent().eResource().isModified()) {
                this.context.getAgent().eResource().setModified(true);
            }
        }
    }

    private BinaryFragmentParser getFragmentParser(Short id) throws InstantiationException, IllegalAccessException {
        Class<?> clazz = this.messageHandlers.get(id);
        if (clazz == null) {
            return new IgnoredBinaryFragmentParser();
        }
        BinaryFragmentParser fragmentParser = (BinaryFragmentParser)clazz.newInstance();
        if (fragmentParser == null) {
            return new IgnoredBinaryFragmentParser();
        }
        return fragmentParser;
    }

    public static void register(BFParserFactory parserFactory) {
        parserFactory.put(version, ParserImpl1.class);
    }

    public int getNumEventsParsed() {
        return this.eventsParsed;
    }
}

