/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.hyades.loaders.internal.binary.BFHeader;
import org.eclipse.hyades.loaders.internal.binary.BFParser;
import org.eclipse.hyades.loaders.internal.binary.BFParserFactory;
import org.eclipse.hyades.loaders.internal.binary.BFReader;
import org.eclipse.hyades.loaders.internal.binary.Offset;
import org.eclipse.hyades.loaders.internal.binary.v1.ParserImpl1;
import org.eclipse.hyades.loaders.util.InvalidXMLException;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.util.internal.InvalidEventException;
import org.eclipse.hyades.models.util.ModelDebugger;

public class BinaryLoader
extends XMLLoader {
    private final BFParserFactory parserFactory = new BFParserFactory();
    private final BFHeader formatHeader = new BFHeader();
    private final BFReader reader = new BFReader();
    private BFParser internalParser;
    private boolean loadXml = true;

    public BinaryLoader(TRCAgent agent) {
        super(agent);
        this.init();
    }

    public BinaryLoader(TRCAgentProxy agentProxy) {
        super(agentProxy);
        this.init();
    }

    public BinaryLoader(TRCMonitor monitor) {
        super(monitor);
        this.init();
    }

    private void init() {
        this.internalParser = new ParserImpl1(this.context, this.reader);
    }

    public boolean isLoadXml() {
        return this.loadXml;
    }

    public void setLoadXml(boolean loadXml) {
        this.loadXml = loadXml;
    }

    public void loadEvent(byte[] buffer, int offset, int length, boolean loadToModel) throws InvalidXMLException {
        if (this.isLoadXml()) {
            super.loadEvent(buffer, offset, length, loadToModel);
            return;
        }
        this.setLoadToModel(loadToModel);
        if (ModelDebugger.INSTANCE.debugEventsToFile) {
            this.writeToBinaryOutputFile(buffer, offset, length);
        } else {
            Offset marker = new Offset(offset, length);
            if (this.formatHeader.parse(buffer, offset, marker)) {
                this.formatHeader.visit(this.reader);
            }
            BFParser parser = this.internalParser;
            parser.reset();
            parser.parseEvents(buffer, marker);
            this.fragmentsCount += parser.getNumEventsParsed();
        }
    }

    public void loadEvents(InputStream inputStream, long offset, long length) throws InvalidEventException {
        if (this.isLoadXml()) {
            super.loadEvents(inputStream, offset, length);
            return;
        }
        if (offset > 0L) {
            try {
                inputStream.skip(offset);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Offset marker = new Offset((int)offset, length);
        try {
            if (!this.formatHeader.parse(inputStream, marker)) {
                return;
            }
            this.formatHeader.visit(this.reader);
            BFParser parser = this.parserFactory.get(this.formatHeader, this.context, this.reader);
            parser.parseEvents(inputStream, marker);
            this.fragmentsCount += parser.getNumEventsParsed();
            if (this.getContext().getAgent() != null && this.getContext().getAgent().eResource() != null && !this.getContext().getAgent().eResource().isModified()) {
                this.getContext().getAgent().eResource().setModified(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidXMLException(e);
        }
    }
}

