/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.util.HyadesResourceRegistryReader;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.plugin.ModelsHierarchyPlugin;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;
import org.eclipse.hyades.models.hierarchy.util.ObjectToIntMap;
import org.eclipse.hyades.models.hierarchy.util.internal.ObjectToIntMapImpl;

public class HyadesResourceExtensions
extends HashMap {
    protected static final long serialVersionUID = 3616443484370843185L;
    protected static HyadesResourceExtensions instance;
    protected IHyadesResourceExtension defaultHyadesResourceFactory;
    protected Properties defaultProperties = new Properties();
    protected HashMap allProperties;
    protected ObjectToIntMap classIdMap;
    protected String[] classIdArray = new String[]{"1", "Hierarchy_AbstractDefaultEvent", "2", "Hierarchy_AbstractTRCCollectionBoundary", "3", "Hierarchy_AbstractTRCDescription", "4", "Hierarchy_AbstractTRCProcess", "5", "Hierarchy_AbstractTRCView", "6", "Hierarchy_Extensions_ArithmeticExpression", "81", "Common_Fragments_BVRCombinedFragment", "82", "Common_Interactions_BVREventOccurrence", "83", "Common_Interactions_BVRExecutionOccurrence", "84", "Common_Fragments_BVRGate", "85", "Common_Interactions_BVRGeneralOrdering", "86", "Common_Fragments_BVRInteraction", "87", "Common_Fragments_BVRInteractionConstraint", "88", "Common_Interactions_BVRInteractionFragment", "89", "Common_Fragments_BVRInteractionOccurrence", "90", "Common_Fragments_BVRInteractionOperand", "91", "Common_Interactions_BVRLifeline", "92", "Common_Interactions_BVRMessage", "93", "Common_Interactions_BVRMessageEnd", "94", "Common_Fragments_BVRPartDecomposition", "95", "Common_Interactions_BVRProperty", "96", "Common_Interactions_BVRStateInvariant", "97", "Common_Interactions_BVRStop", "7", "Hierarchy_Extensions_BinaryExpression", "8", "Cbe_CBEAvailableSituation", "9", "Cbe_CBECommonBaseEvent", "10", "Cbe_CBEComponentIdentification", "11", "Cbe_CBEConfigureSituation", "12", "Cbe_CBEConnectSituation", "13", "Cbe_CBEContextDataElement", "14", "Cbe_CBECreateSituation", "15", "Cbe_CBEDefaultElement", "16", "Cbe_CBEDefaultEvent", "17", "Cbe_CBEDependencySituation", "18", "Cbe_CBEDestroySituation", "19", "Cbe_CBEExtendedDataElement", "20", "Cbe_CBEFeatureSituation", "21", "Cbe_CBEMsgDataElement", "22", "Cbe_CBEOtherSituation", "23", "Cbe_CBEReportSituation", "24", "Cbe_CBERequestSituation", "25", "Cbe_CBESituation", "26", "Cbe_CBEStartSituation", "27", "Cbe_CBEStopSituation", "98", "Common_Configuration_CFGArtifact", "99", "Common_Configuration_CFGArtifactLocationPair", "100", "Common_Configuration_CFGCategory", "101", "Common_Configuration_CFGClass", "102", "Common_Configuration_CFGComparableProperty", "103", "Common_Configuration_CFGConfigurableObject", "104", "Common_Configuration_CFGInstance", "105", "Common_Configuration_CFGLocation", "106", "Common_Configuration_CFGMachine", "107", "Common_Configuration_CFGMachineConstraint", "108", "Common_Configuration_CFGMachineInstance", "109", "Common_Configuration_CFGOperation", "110", "Common_Configuration_CFGPropertyGroup", "111", "Common_Configuration_CFGPsudoEnumeration", "112", "Common_CMNAnnotation", "113", "Common_CMNDefaultProperty", "114", "Common_CMNExtendedProperty", "115", "Common_CMNMachine", "116", "Common_CMNNamedElement", "117", "Common_CMNNodeInstance", "118", "Common_CMNNodeType", "28", "Hierarchy_CorrelationContainer", "29", "Hierarchy_CorrelationContainerProxy", "30", "Hierarchy_CorrelationEngine", "31", "Hierarchy_CorrelationEntry", "32", "Hierarchy_Extensions_CorrelationQuery", "33", "Hierarchy_CorrelationSourceInfo", "119", "Common_Datapool_DPLCell", "120", "Common_Datapool_DPLDatapool", "121", "Common_Datapool_DPLDatapoolSpec", "122", "Common_Datapool_DPLEquivalenceClass", "123", "Common_Datapool_DPLRecord", "124", "Common_Datapool_DPLVariable", "34", "Ecore_EAnnotation", "35", "Ecore_EAttribute", "36", "Ecore_EClass", "37", "Ecore_EClassifier", "38", "Ecore_EDataType", "39", "Ecore_EEnum", "40", "Ecore_EEnumLiteral", "41", "Ecore_EFactory", "42", "Ecore_EModelElement", "43", "Ecore_ENamedElement", "44", "Ecore_EObject", "125", "Common_Testprofile_EObjectReference", "45", "Ecore_EOperation", "46", "Ecore_EPackage", "47", "Ecore_EParameter", "48", "Ecore_EReference", "49", "Ecore_EStringToStringMapEntry", "50", "Ecore_EStructuralFeature", "51", "Ecore_ETypedElement", "126", "Common_Configuration_HyadesBrowserEnumeration", "127", "Common_Configuration_HyadesBrowserTypeCategory", "128", "Common_Configuration_HyadesBrowserVersionCategory", "129", "Common_Configuration_HyadesClasspathCategory", "130", "Common_Configuration_HyadesDatabaseCategory", "131", "Common_Configuration_HyadesDatabaseEnumeration", "132", "Common_Configuration_HyadesDatabaseVersionCategory", "133", "Common_Configuration_HyadesDisplayColorDepthCategory", "134", "Common_Configuration_HyadesDisplayColorDepthEnumeration", "135", "Common_Configuration_HyadesDisplayHeightCategory", "136", "Common_Configuration_HyadesDisplayHeightEnumeration", "137", "Common_Configuration_HyadesDisplayNumberCategory", "138", "Common_Configuration_HyadesDisplayWidthCategory", "139", "Common_Configuration_HyadesDisplayWidthEnumeration", "140", "Common_Configuration_HyadesHostnameCategory", "141", "Common_Configuration_HyadesMajorVersionCategory", "142", "Common_Configuration_HyadesMemorySizeCategory", "143", "Common_Configuration_HyadesMinorVersionCategory", "144", "Common_Configuration_HyadesOperatingSystemCategory", "145", "Common_Configuration_HyadesOperatingSystemEnumeration", "146", "Common_Configuration_HyadesPasswordCategory", "147", "Common_Configuration_HyadesProcessorNumberCategory", "148", "Common_Configuration_HyadesProcessorSpeedCategory", "149", "Common_Configuration_HyadesProcessorTypeCategory", "150", "Common_Configuration_HyadesProcessorTypeEnumeration", "151", "Common_Configuration_HyadesRootDirectroyCategory", "152", "Common_Configuration_HyadesServicePackCategory", "153", "Common_Configuration_HyadesServicePackEnumeration", "154", "Common_Configuration_HyadesUsernameCategory", "155", "Common_Configuration_HyadesWindowsDomainCategory", "156", "Common_Testprofile_ITPFExtendedVerdictReason", "52", "Hierarchy_Extensions_InstanceQuery", "53", "Hierarchy_Extensions_LogicalExpression", "54", "Hierarchy_Extensions_NumericFunction", "55", "Hierarchy_Extensions_Operand", "56", "Hierarchy_Extensions_OrderByElement", "57", "Hierarchy_Extensions_Query", "58", "Hierarchy_Extensions_QueryResult", "59", "Hierarchy_Extensions_ResultEntry", "60", "Sdb_SDBDirective", "61", "Sdb_SDBMatchPattern", "62", "Sdb_SDBRuntime", "63", "Sdb_SDBSolution", "64", "Sdb_SDBSymptom", "157", "Statistical_SDContiguousObservation", "158", "Statistical_SDContiguousRepresentation", "159", "Statistical_SDCounterDescriptor", "160", "Statistical_SDDescriptor", "161", "Statistical_SDDiscreteObservation", "162", "Statistical_SDDiscreteRepresentation", "163", "Statistical_SDGaugeRepresentation", "164", "Statistical_SDMemberDescriptor", "165", "Statistical_SDRangeRepresentation", "166", "Statistical_SDRepresentation", "167", "Statistical_SDSampleDescriptor", "168", "Statistical_SDSampleWindow", "169", "Statistical_SDSnapshotObservation", "170", "Statistical_SDTextObservation", "171", "Statistical_SDTextRepresentation", "172", "Statistical_SDView", "65", "Hierarchy_Extensions_SimpleOperand", "66", "Hierarchy_Extensions_SimpleSearchQuery", "173", "Common_Testprofile_TPFArbiter", "174", "Common_Testprofile_TPFBehavior", "175", "Common_Testprofile_TPFCodingRule", "176", "Common_Testprofile_TPFDefault", "177", "Common_Testprofile_TPFDefaultApplication", "178", "Common_Testprofile_TPFDeployment", "179", "Common_Testprofile_TPFExecutionEvent", "180", "Common_Testprofile_TPFExecutionHistory", "181", "Common_Testprofile_TPFExecutionResult", "182", "Common_Testprofile_TPFExecutionStatus", "183", "Common_Testprofile_TPFExtendedReasonToVerdictMapEntry", "184", "Common_Testprofile_TPFInstanceValue", "185", "Common_Testprofile_TPFInvocationEvent", "186", "Common_Testprofile_TPFLiteralAny", "187", "Common_Testprofile_TPFLiteralAnyorNull", "188", "Common_Testprofile_TPFLogAction", "189", "Common_Testprofile_TPFLoopEvent", "190", "Common_Testprofile_TPFMessageEvent", "191", "Common_Testprofile_TPFReasonToVerdictMapEntry", "192", "Common_Testprofile_TPFRepositoryRecord", "193", "Common_Testprofile_TPFSUT", "194", "Common_Testprofile_TPFTest", "195", "Common_Testprofile_TPFTestCase", "196", "Common_Testprofile_TPFTestComponent", "197", "Common_Testprofile_TPFTestObjective", "198", "Common_Testprofile_TPFTestSuite", "199", "Common_Testprofile_TPFTimedEvent", "200", "Common_Testprofile_TPFTimezone", "201", "Common_Testprofile_TPFTypedEvent", "202", "Common_Testprofile_TPFValidationAction", "203", "Common_Testprofile_TPFVerdictEvent", "204", "Common_Testprofile_TPFVerdictList", "205", "Common_Testprofile_TPFWaitEvent", "67", "Hierarchy_TRCAgent", "68", "Hierarchy_TRCAgentProxy", "206", "Trace_TRCAggregatedMethodInvocation", "207", "Trace_TRCAggregatedObjectReference", "69", "Hierarchy_TRCAnnotation", "208", "Trace_TRCArrayClass", "209", "Trace_TRCCallerCalleeInvocationInfo", "210", "Trace_TRCClass", "211", "Trace_TRCClassLoader", "212", "Trace_TRCCollectionBoundary", "70", "Hierarchy_TRCConfiguration", "71", "Hierarchy_TRCEnvironmentVariable", "72", "Hierarchy_TRCExecParameter", "73", "Hierarchy_TRCFilter", "213", "Trace_TRCFullHeapObject", "214", "Trace_TRCFullMethodInvocation", "215", "Trace_TRCFullTraceObject", "216", "Trace_TRCGCEvent", "217", "Trace_TRCHeapDump", "218", "Trace_TRCHeapObject", "219", "Trace_TRCHeapRoot", "220", "Trace_TRCInputOutputContainer", "221", "Trace_TRCInputOutputEntry", "222", "Trace_TRCLLData", "223", "Trace_TRCLanguageElement", "224", "Trace_TRCLineCoverageData", "225", "Trace_TRCLinePerformanceData", "226", "Trace_TRCLockAccess", "227", "Trace_TRCMethod", "228", "Trace_TRCMethodInvocation", "229", "Trace_TRCMethodWithLLData", "74", "Hierarchy_TRCMonitor", "230", "Trace_TRCMthdLckAccEntry", "75", "Hierarchy_TRCNode", "231", "Trace_TRCObject", "232", "Trace_TRCObjectAllocationAnnotation", "233", "Trace_TRCObjectAllocationSite", "234", "Trace_TRCObjectAllocationSitesEntry", "235", "Trace_TRCObjectReference", "236", "Trace_TRCObjectValue", "76", "Hierarchy_TRCOption", "237", "Trace_TRCPackage", "238", "Trace_TRCProcess", "77", "Hierarchy_TRCProcessProxy", "239", "Trace_TRCSourceInfo", "240", "Trace_TRCSourceInfoWithLLData", "241", "Trace_TRCThread", "242", "Trace_TRCThreadDeadEvent", "243", "Trace_TRCThreadDeadLockEvent", "244", "Trace_TRCThreadEvent", "245", "Trace_TRCThreadRunningEvent", "246", "Trace_TRCThreadSleepingEvent", "247", "Trace_TRCThreadWaitingForLockEvent", "248", "Trace_TRCThreadWaitingForObjectEvent", "249", "Trace_TRCTraceObject", "250", "Trace_TRCTypedObjectValue", "78", "Hierarchy_Extensions_TimeBasedCorrelationQuery", "79", "Hierarchy_UnresolvedCorrelation", "80", "Hierarchy_Extensions_WhereExpression"};

    public static HyadesResourceExtensions getInstance(Properties prop) {
        if (instance == null) {
            instance = new HyadesResourceExtensions();
            instance.initClassIdMap();
            HyadesResourceExtensions.instance.allProperties = new HashMap();
            new HyadesResourceRegistryReader().readRegistry();
            String activeDBType = prop.getProperty("largeResourceSupportStoreType");
            if (activeDBType != null) {
                for (Map.Entry element : instance.entrySet()) {
                    IHyadesResourceExtension hyadesResourceFactory = (IHyadesResourceExtension)element.getValue();
                    if (!activeDBType.equals(hyadesResourceFactory.getStoreType((String)element.getKey()))) continue;
                    HyadesResourceExtensions.instance.defaultHyadesResourceFactory = hyadesResourceFactory;
                    instance.setProperties(activeDBType, prop);
                    break;
                }
            }
        }
        return instance;
    }

    public static HyadesResourceExtensions getInstance() {
        if (instance == null) {
            instance = new HyadesResourceExtensions();
            instance.initClassIdMap();
            HyadesResourceExtensions.instance.allProperties = new HashMap();
            new HyadesResourceRegistryReader().readRegistry();
            try {
                Preferences preferences = ModelsHierarchyPlugin.getPlugin().getPluginPreferences();
                for (Map.Entry element : instance.entrySet()) {
                    IHyadesResourceExtension hyadesResourceFactory = (IHyadesResourceExtension)element.getValue();
                    if (HyadesResourceExtensions.instance.defaultHyadesResourceFactory != null || !preferences.getString("largeResourceSupportCurrentDBType").equals(hyadesResourceFactory.getStoreType((String)element.getKey()))) continue;
                    String defaultStoreTypeName = preferences.getString("largeResourceSupportCurrentDBType");
                    HyadesResourceExtensions.instance.defaultHyadesResourceFactory = hyadesResourceFactory;
                    HyadesResourceExtensions.instance.defaultProperties.setProperty("location", preferences.getString(String.valueOf(defaultStoreTypeName) + "/" + "largeResourceSupportLocation"));
                    HyadesResourceExtensions.instance.defaultProperties.setProperty("user", preferences.getString(String.valueOf(defaultStoreTypeName) + "/" + "largeResourceSupportUsername"));
                    HyadesResourceExtensions.instance.defaultProperties.setProperty("password", LoadersUtils.restorePassword(preferences.getString(String.valueOf(defaultStoreTypeName) + "/" + "largeResourceSupportPassword")));
                    HyadesResourceExtensions.instance.defaultProperties.setProperty("largeResourceSupportStoreType", defaultStoreTypeName);
                    try {
                        HyadesResourceExtensions.instance.defaultProperties.setProperty("largeResourceSupportJDBCLocation", new File(preferences.getString(String.valueOf(defaultStoreTypeName) + "/" + "largeResourceSupportJDBCLocation")).toURL().toString());
                    }
                    catch (MalformedURLException malformedURLException) {}
                    Properties p = instance.getProperties(defaultStoreTypeName);
                    if (p == null) {
                        p = new Properties();
                        instance.setProperties(defaultStoreTypeName, p);
                    }
                    p.setProperty("location", preferences.getString(String.valueOf(defaultStoreTypeName) + "/" + "largeResourceSupportLocation"));
                    p.setProperty("user", preferences.getString(String.valueOf(defaultStoreTypeName) + "/" + "largeResourceSupportUsername"));
                    p.setProperty("password", LoadersUtils.restorePassword(preferences.getString(String.valueOf(defaultStoreTypeName) + "/" + "largeResourceSupportPassword")));
                    p.setProperty("largeResourceSupportStoreType", defaultStoreTypeName);
                    try {
                        p.setProperty("largeResourceSupportJDBCLocation", new File(preferences.getString(String.valueOf(defaultStoreTypeName) + "/" + "largeResourceSupportJDBCLocation")).toURL().toString());
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            }
            catch (Exception exception) {}
        }
        return instance;
    }

    protected void initClassIdMap() {
        this.classIdMap = new ObjectToIntMapImpl(this.classIdArray.length / 2);
        int i = 0;
        while (i < this.classIdArray.length) {
            this.classIdMap.put(this.classIdArray[i + 1], Integer.parseInt(this.classIdArray[i]));
            i += 2;
        }
    }

    public Resource createResource(URI uri, Properties p) {
        IHyadesResourceExtension hyadesResourceExtension = (IHyadesResourceExtension)HyadesResourceExtensions.getInstance().get(LoadersUtils.getPostfix(uri));
        if (hyadesResourceExtension == null) {
            return null;
        }
        return hyadesResourceExtension.createResource(uri, p);
    }

    public Resource createResource(URI uri, Properties p, Collection notLoaded) {
        IHyadesResourceExtension hyadesResourceExtension = (IHyadesResourceExtension)HyadesResourceExtensions.getInstance().get(LoadersUtils.getPostfix(uri));
        if (hyadesResourceExtension == null) {
            return null;
        }
        return hyadesResourceExtension.createResource(uri, p, notLoaded);
    }

    public EList createList(Class dataClass, InternalEObject owner, int featureID, int inverseFeatureID) {
        IHyadesResourceExtension hyadesResourceFactory = this.getHyadesResourceFactory(owner);
        if (hyadesResourceFactory == null) {
            return null;
        }
        return hyadesResourceFactory.createPagingList(dataClass, (EObject)owner, featureID, inverseFeatureID);
    }

    public EList createList(Class dataClass, InternalEObject owner, int featureID) {
        IHyadesResourceExtension hyadesResourceFactory = this.getHyadesResourceFactory(owner);
        if (hyadesResourceFactory == null) {
            return null;
        }
        return hyadesResourceFactory.createPagingList(dataClass, (EObject)owner, featureID);
    }

    public EList createList(InternalEObject owner, EStructuralFeature feature) {
        IHyadesResourceExtension hyadesResourceFactory = this.getHyadesResourceFactory(owner);
        if (hyadesResourceFactory == null) {
            return null;
        }
        return hyadesResourceFactory.createPagingList((EObject)owner, feature);
    }

    protected IHyadesResourceExtension getHyadesResourceFactory(InternalEObject owner) {
        Resource resource = owner.eResource();
        if (resource == null) {
            if (this.defaultHyadesResourceFactory != null) {
                return this.defaultHyadesResourceFactory;
            }
            return null;
        }
        URI uri = resource.getURI();
        if (uri == null) {
            return null;
        }
        IHyadesResourceExtension hyadesResourceFactory = (IHyadesResourceExtension)HyadesResourceExtensions.getInstance().get(LoadersUtils.getPostfix(uri));
        return hyadesResourceFactory;
    }

    public Resource createResource(URI uri, Collection notLoaded) {
        IHyadesResourceExtension hyadesResourceExtension = (IHyadesResourceExtension)HyadesResourceExtensions.getInstance().get(LoadersUtils.getPostfix(uri));
        if (hyadesResourceExtension == null) {
            return null;
        }
        Properties p = (Properties)this.allProperties.get(hyadesResourceExtension.getStoreType(LoadersUtils.getPostfix(uri)));
        if (p == null) {
            p = this.defaultProperties;
        }
        return hyadesResourceExtension.createResource(uri, p, notLoaded);
    }

    public Properties getProperties() {
        return this.defaultProperties;
    }

    public Properties getProperties(String key) {
        return (Properties)this.allProperties.get(key);
    }

    public void setProperties(String key, Properties properties) {
        this.allProperties.put(key, properties);
    }

    public Map getAllProperties() {
        return this.allProperties;
    }

    public ObjectToIntMap getClassIdMap() {
        return this.classIdMap;
    }

    public String getName(EClass eClass, int packageNumber) {
        String name = eClass.getName();
        EPackage ePackage = eClass.getEPackage();
        while (ePackage != null && packageNumber > 0) {
            String pkgName = ePackage.getName();
            pkgName = this.upperCaseFirst(pkgName);
            name = String.valueOf(pkgName) + "_" + name;
            --packageNumber;
            ePackage = ePackage.getESuperPackage();
        }
        return name;
    }

    public String upperCaseFirst(String name) {
        return String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
    }
}

