/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.util.List;
import org.eclipse.hyades.loaders.util.HyadesConfigurationElement;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.IHyadesPluginClassDescriptor;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;
import org.eclipse.hyades.models.util.ModelDebugger;

class HyadesResourceRegistryReader
extends RegistryReader {
    static final String TAG_RESOURCE_EXTENSION = "hyadesResourceExtension";

    public HyadesResourceRegistryReader() {
        super("hyades_resource_extension");
    }

    protected boolean readElement(HyadesConfigurationElement element) {
        if (element.getName().equals(TAG_RESOURCE_EXTENSION)) {
            if (element.getAttribute("class") == null) {
                this.logMissingAttribute(element, "class");
            } else {
                try {
                    float priority = 0.0f;
                    if (element.getAttribute("priority") != null) {
                        priority = Float.parseFloat(element.getAttribute("priority"));
                    }
                    IHyadesPluginClassDescriptor classDescriptor = this.createPluginClassDescriptor(element, "class");
                    IHyadesResourceExtension f = (IHyadesResourceExtension)classDescriptor.createInstance();
                    List postfixes = f.getSupportedPostfixes();
                    for (String postfix : postfixes) {
                        if (HyadesResourceExtensions.getInstance().containsKey(postfix) && ((Float)this.getPriorities().get(postfix)).floatValue() >= priority) {
                            if (!ModelDebugger.INSTANCE.debug) continue;
                            this.logError(element, "A Hyades resource factory extension for this \"" + postfix + "\" with higher or equal priority already exists, this extension will be ignored.");
                            continue;
                        }
                        HyadesResourceExtensions.getInstance().put(postfix, f);
                        this.getPriorities().put(postfix, new Float(priority));
                    }
                }
                catch (Exception e) {
                    this.logError(element, e.getLocalizedMessage());
                }
                return true;
            }
        }
        return false;
    }
}

