/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.util.Set;
import org.eclipse.hyades.loaders.util.HyadesConfigurationElement;
import org.eclipse.hyades.loaders.util.IHyadesPluginClassDescriptor;
import org.eclipse.hyades.loaders.util.LoaderExtensions;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.loaders.util.XMLFragmentLoader;
import org.eclipse.hyades.loaders.util.XMLFragmentLoadersFactory;

class LoadersFactoryRegistryReader
extends RegistryReader {
    static final String TAG_LOADERS_FACTORY = "loadersFactory";

    public LoadersFactoryRegistryReader() {
        super("fragment_loaders_factory");
    }

    protected boolean readElement(HyadesConfigurationElement element) {
        if (element.getName().equals(TAG_LOADERS_FACTORY)) {
            if (element.getAttribute("class") == null) {
                this.logMissingAttribute(element, "class");
            } else {
                try {
                    float priority = 0.0f;
                    if (element.getAttribute("priority") != null) {
                        priority = Float.parseFloat(element.getAttribute("priority"));
                    }
                    IHyadesPluginClassDescriptor factoryClassDescriptor = this.createPluginClassDescriptor(element, "class");
                    XMLFragmentLoadersFactory factory = (XMLFragmentLoadersFactory)factoryClassDescriptor.createInstance();
                    Set elements = factory.getSupportedElements();
                    for (String elementName : elements) {
                        if (LoaderExtensions.getInstance().containsKey(elementName) && ((Float)this.getPriorities().get(elementName)).floatValue() >= priority) {
                            this.logError(element, "A loader for this element with a higher or equal priority already exists, this loader will be ignored.");
                            continue;
                        }
                        try {
                            XMLFragmentLoader loader = (XMLFragmentLoader)factory.getClass().getClassLoader().loadClass(factory.getLoaderClassName(elementName)).newInstance();
                            if (loader == null) continue;
                            LoaderExtensions.getInstance().put(elementName, loader);
                            this.getPriorities().put(elementName, new Float(priority));
                        }
                        catch (Exception e) {
                            this.logError(element, e.getLocalizedMessage());
                        }
                    }
                }
                catch (Exception e) {
                    this.logError(element, e.getLocalizedMessage());
                }
                return true;
            }
        }
        return false;
    }
}

