/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.loaders.util.AgentProxyContext;
import org.eclipse.hyades.loaders.util.AgentsContext;
import org.eclipse.hyades.loaders.util.GenericLookUpEntry;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.InvalidPassword;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.hierarchy.CorrelationContainer;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.impl.CorrelationEngineImpl;
import org.eclipse.hyades.models.hierarchy.plugin.ModelsHierarchyPlugin;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.HyadesExtendedResourceFactory;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;
import org.eclipse.hyades.models.util.ModelDebugger;

public class LoadersUtils {
    protected static final Map threads = new HashMap();
    public static SimpleDateFormat partialCIMDateFormatDashDelimiter = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH:mm:ss", ULocale.ENGLISH);
    public static SimpleDateFormat partialCIMDateFormatPlusDelimiter = new SimpleDateFormat("yyyy'+'MM'+'dd'T'HH:mm:ss", ULocale.ENGLISH);
    public static SimpleDateFormat partialCIMDateFormatNoDelimiter = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss", ULocale.ENGLISH);
    public static long[] powerOf10;
    public static String InternalCorrelationName;
    protected static final char[] SCRAMBLING_TABLE;
    protected static char[] RESTORING_TABLE;

    static {
        TimeZone gmtTimeZone = TimeZone.getTimeZone((String)"GMT");
        partialCIMDateFormatDashDelimiter.setTimeZone(gmtTimeZone);
        partialCIMDateFormatPlusDelimiter.setTimeZone(gmtTimeZone);
        partialCIMDateFormatNoDelimiter.setTimeZone(gmtTimeZone);
        powerOf10 = new long[19];
        LoadersUtils.powerOf10[0] = 1L;
        long power = 1L;
        int i = 1;
        while (i < powerOf10.length) {
            LoadersUtils.powerOf10[i] = power *= 10L;
            ++i;
        }
        InternalCorrelationName = "Internal_";
        char[] cArray = new char[256];
        cArray[1] = '\u0001';
        cArray[2] = 2;
        cArray[3] = 3;
        cArray[4] = 4;
        cArray[5] = 5;
        cArray[6] = 6;
        cArray[7] = 7;
        cArray[8] = 8;
        cArray[9] = 9;
        cArray[10] = 10;
        cArray[11] = 11;
        cArray[12] = 12;
        cArray[13] = 13;
        cArray[14] = 14;
        cArray[15] = 15;
        cArray[16] = 16;
        cArray[17] = 17;
        cArray[18] = 18;
        cArray[19] = 19;
        cArray[20] = 20;
        cArray[21] = 21;
        cArray[22] = 22;
        cArray[23] = 23;
        cArray[24] = 24;
        cArray[25] = 25;
        cArray[26] = 26;
        cArray[27] = 27;
        cArray[28] = 28;
        cArray[29] = 29;
        cArray[30] = 30;
        cArray[31] = 31;
        cArray[32] = 114;
        cArray[33] = 120;
        cArray[34] = 53;
        cArray[35] = 79;
        cArray[36] = 96;
        cArray[37] = 109;
        cArray[38] = 72;
        cArray[39] = 108;
        cArray[40] = 70;
        cArray[41] = 64;
        cArray[42] = 76;
        cArray[43] = 67;
        cArray[44] = 116;
        cArray[45] = 74;
        cArray[46] = 68;
        cArray[47] = 87;
        cArray[48] = 111;
        cArray[49] = 52;
        cArray[50] = 75;
        cArray[51] = 119;
        cArray[52] = 49;
        cArray[53] = 34;
        cArray[54] = 82;
        cArray[55] = 81;
        cArray[56] = 95;
        cArray[57] = 65;
        cArray[58] = 112;
        cArray[59] = 86;
        cArray[60] = 118;
        cArray[61] = 110;
        cArray[62] = 122;
        cArray[63] = 105;
        cArray[64] = 41;
        cArray[65] = 57;
        cArray[66] = 83;
        cArray[67] = 43;
        cArray[68] = 46;
        cArray[69] = 102;
        cArray[70] = 40;
        cArray[71] = 89;
        cArray[72] = 38;
        cArray[73] = 103;
        cArray[74] = 45;
        cArray[75] = 50;
        cArray[76] = 42;
        cArray[77] = 123;
        cArray[78] = 91;
        cArray[79] = 35;
        cArray[80] = 125;
        cArray[81] = 55;
        cArray[82] = 54;
        cArray[83] = 66;
        cArray[84] = 124;
        cArray[85] = 126;
        cArray[86] = 59;
        cArray[87] = 47;
        cArray[88] = 92;
        cArray[89] = 71;
        cArray[90] = 115;
        cArray[91] = 78;
        cArray[92] = 88;
        cArray[93] = 107;
        cArray[94] = 106;
        cArray[95] = 56;
        cArray[96] = 36;
        cArray[97] = 121;
        cArray[98] = 117;
        cArray[99] = 104;
        cArray[100] = 101;
        cArray[101] = 100;
        cArray[102] = 69;
        cArray[103] = 73;
        cArray[104] = 99;
        cArray[105] = 63;
        cArray[106] = 94;
        cArray[107] = 93;
        cArray[108] = 39;
        cArray[109] = 37;
        cArray[110] = 61;
        cArray[111] = 48;
        cArray[112] = 58;
        cArray[113] = 113;
        cArray[114] = 32;
        cArray[115] = 90;
        cArray[116] = 44;
        cArray[117] = 98;
        cArray[118] = 60;
        cArray[119] = 51;
        cArray[120] = 33;
        cArray[121] = 97;
        cArray[122] = 62;
        cArray[123] = 77;
        cArray[124] = 84;
        cArray[125] = 80;
        cArray[126] = 85;
        cArray[127] = 223;
        cArray[128] = 225;
        cArray[129] = 216;
        cArray[130] = 187;
        cArray[131] = 166;
        cArray[132] = 229;
        cArray[133] = 189;
        cArray[134] = 222;
        cArray[135] = 188;
        cArray[136] = 141;
        cArray[137] = 249;
        cArray[138] = 148;
        cArray[139] = 200;
        cArray[140] = 184;
        cArray[141] = 136;
        cArray[142] = 248;
        cArray[143] = 190;
        cArray[144] = 199;
        cArray[145] = 170;
        cArray[146] = 181;
        cArray[147] = 204;
        cArray[148] = 138;
        cArray[149] = 232;
        cArray[150] = 218;
        cArray[151] = 183;
        cArray[152] = 255;
        cArray[153] = 234;
        cArray[154] = 220;
        cArray[155] = 247;
        cArray[156] = 213;
        cArray[157] = 203;
        cArray[158] = 226;
        cArray[159] = 193;
        cArray[160] = 174;
        cArray[161] = 172;
        cArray[162] = 228;
        cArray[163] = 252;
        cArray[164] = 217;
        cArray[165] = 201;
        cArray[166] = 131;
        cArray[167] = 230;
        cArray[168] = 197;
        cArray[169] = 211;
        cArray[170] = 145;
        cArray[171] = 238;
        cArray[172] = 161;
        cArray[173] = 179;
        cArray[174] = 160;
        cArray[175] = 212;
        cArray[176] = 207;
        cArray[177] = 221;
        cArray[178] = 254;
        cArray[179] = 173;
        cArray[180] = 202;
        cArray[181] = 146;
        cArray[182] = 224;
        cArray[183] = 151;
        cArray[184] = 140;
        cArray[185] = 196;
        cArray[186] = 205;
        cArray[187] = 130;
        cArray[188] = 135;
        cArray[189] = 133;
        cArray[190] = 143;
        cArray[191] = 246;
        cArray[192] = 192;
        cArray[193] = 159;
        cArray[194] = 244;
        cArray[195] = 239;
        cArray[196] = 185;
        cArray[197] = 168;
        cArray[198] = 215;
        cArray[199] = 144;
        cArray[200] = 139;
        cArray[201] = 165;
        cArray[202] = 180;
        cArray[203] = 157;
        cArray[204] = 147;
        cArray[205] = 186;
        cArray[206] = 214;
        cArray[207] = 176;
        cArray[208] = 227;
        cArray[209] = 231;
        cArray[210] = 219;
        cArray[211] = 169;
        cArray[212] = 175;
        cArray[213] = 156;
        cArray[214] = 206;
        cArray[215] = 198;
        cArray[216] = 129;
        cArray[217] = 164;
        cArray[218] = 150;
        cArray[219] = 210;
        cArray[220] = 154;
        cArray[221] = 177;
        cArray[222] = 134;
        cArray[223] = 127;
        cArray[224] = 182;
        cArray[225] = 128;
        cArray[226] = 158;
        cArray[227] = 208;
        cArray[228] = 162;
        cArray[229] = 132;
        cArray[230] = 167;
        cArray[231] = 209;
        cArray[232] = 149;
        cArray[233] = 241;
        cArray[234] = 153;
        cArray[235] = 251;
        cArray[236] = 237;
        cArray[237] = 236;
        cArray[238] = 171;
        cArray[239] = 195;
        cArray[240] = 243;
        cArray[241] = 233;
        cArray[242] = 253;
        cArray[243] = 240;
        cArray[244] = 194;
        cArray[245] = 250;
        cArray[246] = 191;
        cArray[247] = 155;
        cArray[248] = 142;
        cArray[249] = 137;
        cArray[250] = 245;
        cArray[251] = 235;
        cArray[252] = 163;
        cArray[253] = 242;
        cArray[254] = 178;
        cArray[255] = 152;
        SCRAMBLING_TABLE = cArray;
        RESTORING_TABLE = null;
    }

    public static void setDefaultContext(HierarchyContext context) {
        String monitorFolder;
        TRCMonitor monitor = context.getMonitor();
        TRCProcessProxy process = context.getProcessProxy();
        TRCNode node = context.getNode();
        if (node == null) {
            node = LoadersUtils.locateNodeFromMonitor(monitor, "Unknown", "0", "0");
            if (node == null) {
                monitorFolder = LoadersUtils.getMonitorFolder(monitor);
                Resource nDoc = null;
                if (monitorFolder != null) {
                    String nName = String.valueOf(StringUtil.change(monitor.getName().trim(), " ", "")) + "_" + "Unknown";
                    String nodeFileName = String.valueOf(monitorFolder) + nName;
                    nDoc = Resource.Factory.Registry.INSTANCE.getFactory(SaveUtil.createURI(String.valueOf(nodeFileName) + ".trcnxmi")).createResource(SaveUtil.createURI(String.valueOf(nodeFileName) + ".trcnxmi"));
                    HierarchyResourceSetImpl.getInstance().getResources().add((Object)nDoc);
                }
                node = HierarchyFactory.eINSTANCE.createTRCNode();
                node.setIpAddress("0");
                node.setRuntimeId("0");
                node.setName("Unknown");
                monitor.getNodes().add((Object)node);
                node.setMonitor(monitor);
                context.setNode(node);
                if (nDoc != null) {
                    nDoc.getContents().add((Object)node);
                    nDoc.setModified(true);
                }
            }
            context.setNode(node);
        }
        if (process == null) {
            process = LoadersUtils.locateProcessFromNode(node, "0");
            if (process != null) {
                context.setProcessProxy(process);
                return;
            }
            monitorFolder = LoadersUtils.getMonitorFolder(monitor);
            Resource procDoc = null;
            if (monitorFolder != null) {
                String pName = String.valueOf(StringUtil.change(monitor.getName().trim(), " ", "")) + "_" + node.getName().trim() + "_" + "-1" + "_" + "0";
                String pFileName = String.valueOf(monitorFolder) + pName;
                procDoc = Resource.Factory.Registry.INSTANCE.getFactory(SaveUtil.createURI(String.valueOf(pFileName) + ".trcpxmi")).createResource(SaveUtil.createURI(String.valueOf(pFileName) + ".trcpxmi"));
                HierarchyResourceSetImpl.getInstance().getResources().add((Object)procDoc);
            }
            process = HierarchyFactory.eINSTANCE.createTRCProcessProxy();
            node.getProcessProxies().add((Object)process);
            process.setNode(node);
            process.setPid(-1);
            process.setRuntimeId("0");
            process.setName("Unknown");
            context.setProcessProxy(process);
            if (procDoc != null) {
                procDoc.getContents().add((Object)process);
                procDoc.setModified(true);
            }
        }
    }

    public static TRCProcessProxy createProcess(HierarchyContext context, String name, String runtimeId, String pid, String processId) {
        TRCMonitor monitor = context.getMonitor();
        TRCProcessProxy process = context.getProcessProxy();
        TRCNode node = context.getNode();
        if (name == null || name.length() == 0) {
            name = "Unknown";
        }
        if (runtimeId == null || runtimeId.length() == 0) {
            runtimeId = "0";
        }
        if (pid == null || pid.length() == 0) {
            pid = "-1";
        }
        if (processId == null || processId.length() == 0) {
            processId = "0";
        }
        if (node != null && (process == null || process.getRuntimeId() != runtimeId)) {
            process = LoadersUtils.locateProcessFromNode(node, runtimeId);
            if (process != null) {
                context.setProcessProxy(process);
                return process;
            }
            String monitorFolder = LoadersUtils.getMonitorFolder(monitor);
            Resource procDoc = null;
            if (monitorFolder != null) {
                String pName = String.valueOf(StringUtil.change(monitor.getName().trim(), " ", "")) + "_" + node.getName().trim() + "_" + pid + "_" + processId;
                String pFileName = String.valueOf(monitorFolder) + pName;
                procDoc = Resource.Factory.Registry.INSTANCE.getFactory(SaveUtil.createURI(String.valueOf(pFileName) + ".trcpxmi")).createResource(SaveUtil.createURI(String.valueOf(pFileName) + ".trcpxmi"));
                HierarchyResourceSetImpl.getInstance().getResources().add((Object)procDoc);
            }
            process = HierarchyFactory.eINSTANCE.createTRCProcessProxy();
            node.getProcessProxies().add((Object)process);
            process.setNode(node);
            process.setPid(Integer.parseInt(pid));
            process.setRuntimeId(runtimeId);
            process.setName(name);
            context.setProcessProxy(process);
            if (procDoc != null) {
                procDoc.getContents().add((Object)process);
                procDoc.setModified(true);
            }
        }
        return process;
    }

    public static TRCAgent createAgent(HierarchyContext context, String agentName, double startTime, double stopTime, String runtimeId, String agentType) {
        TRCAgent agent = context.getAgent();
        TRCAgentProxy agentProxy = context.getAgentProxy();
        TRCProcessProxy process = context.getProcessProxy();
        TRCNode node = context.getNode();
        TRCMonitor monitor = context.getMonitor();
        String monitorFolder = LoadersUtils.getMonitorFolder(monitor);
        Resource agDoc = null;
        agent = LoadersUtils.locateAgentFromProcess(process, agentName, runtimeId);
        if (agent != null) {
            context.setAgent(agent);
            context.setAgentProxy(agent.getAgentProxy());
            return agent;
        }
        if (monitorFolder != null) {
            String aName = String.valueOf(monitor.getName()) + "_" + node.getName().trim() + "_" + process.getPid() + "_" + process.getRuntimeId() + "_" + StringUtil.change(agentName.trim(), " ", "");
            String pFileName = String.valueOf(monitorFolder) + aName;
            String rName = ModelDebugger.INSTANCE.debugDatabaseResourcePostfix != null && ModelDebugger.INSTANCE.debugDatabaseResourcePostfix.length() > 0 ? String.valueOf(pFileName) + ModelDebugger.INSTANCE.debugDatabaseResourcePostfix : String.valueOf(pFileName) + ".trcaxmi";
            URI uri = SaveUtil.createURI(String.valueOf(rName) + "#").trimFragment();
            agDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
            agDoc.setModified(true);
            HierarchyResourceSetImpl.getInstance().getResources().add((Object)agDoc);
        }
        agent = HierarchyFactory.eINSTANCE.createTRCAgent();
        if (agentProxy == null || agentProxy.getProcessProxy() != process) {
            agentProxy = HierarchyFactory.eINSTANCE.createTRCAgentProxy();
            agentProxy.setRuntimeId(runtimeId);
            agent.setRuntimeId(runtimeId);
            agent.setName(agentName);
            agentProxy.setName(agentName);
            agent.setType(agentType);
            agentProxy.setType(agentType);
            agent.setStartTime(startTime);
            agentProxy.setStartTime(startTime);
            agent.setStopTime(stopTime);
            agentProxy.setStopTime(stopTime);
            agent.setAgentProxy(agentProxy);
            agentProxy.setProcessProxy(process);
            agent.setCollectionMode(context.getCollectionMode());
            agentProxy.setCollectionMode(context.getCollectionMode());
            context.setAgent(agent);
            context.setAgentProxy(agentProxy);
        } else {
            agent.setRuntimeId(agentProxy.getRuntimeId());
            agent.setName(agentProxy.getName());
            if (agentProxy.getType() != null) {
                agent.setType(agentProxy.getType());
            } else {
                agent.setType(agentType);
                agentProxy.setType(agentType);
            }
            agent.setStartTime(agentProxy.getStartTime());
            agent.setStopTime(agentProxy.getStopTime());
            agent.setAgentProxy(agentProxy);
            agent.setCollectionMode(context.getCollectionMode());
            context.setAgent(agent);
        }
        if (context.getContextURI() == null) {
            context.setContextURI(agDoc.getURI().toString());
            LookupServiceExtensions.getInstance().register(null, context);
        }
        if (agDoc != null) {
            agDoc.getContents().add((Object)agent);
            agDoc.setModified(true);
        }
        return agent;
    }

    public static synchronized short getDeltaTimeZoneInMinutesFromCIMFormat(String creationTime) throws IllegalArgumentException {
        int creationTimeLength = creationTime.length();
        short timeZoneOffset = 0;
        if (creationTime.charAt(creationTimeLength - 1) != 'Z') {
            try {
                timeZoneOffset = Short.parseShort(creationTime.substring(creationTimeLength - 5, creationTimeLength - 3));
                timeZoneOffset = (short)(timeZoneOffset * 60);
                timeZoneOffset = (short)(timeZoneOffset + Short.parseShort(creationTime.substring(creationTimeLength - 2)));
                if (creationTime.charAt(creationTimeLength - 6) == '-') {
                    timeZoneOffset = (short)(timeZoneOffset * -1);
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Invalid parameter time stamp format.");
            }
        }
        return timeZoneOffset;
    }

    public static synchronized double getMicrosecondsFromCIMFormat(String creationTime) throws IllegalArgumentException {
        double creationTimeInMicros = 0.0;
        int tCharIndex = creationTime.indexOf(84);
        if (tCharIndex != -1) {
            try {
                creationTimeInMicros = (double)partialCIMDateFormatDashDelimiter.parse(creationTime.substring(0, tCharIndex + 9)).getTime() * 1000.0;
            }
            catch (ParseException parseException) {
                try {
                    creationTimeInMicros = creationTime.charAt(tCharIndex - 3) == '+' ? (double)partialCIMDateFormatPlusDelimiter.parse(creationTime.substring(0, tCharIndex + 9)).getTime() * 1000.0 : (double)partialCIMDateFormatNoDelimiter.parse(creationTime.substring(0, tCharIndex + 9)).getTime() * 1000.0;
                }
                catch (ParseException parseException2) {
                    throw new IllegalArgumentException("Invalid parameter time stamp format.");
                }
            }
            creationTimeInMicros -= (double)LoadersUtils.getDeltaTimeZoneInMinutesFromCIMFormat(creationTime) * 6.0E7;
            try {
                creationTimeInMicros += Double.parseDouble("0.".concat(creationTime.substring(tCharIndex + 10, creationTime.endsWith("Z") ? creationTime.length() - 1 : creationTime.length() - 6))) * 1000000.0;
            }
            catch (Exception exception) {}
        } else {
            throw new IllegalArgumentException("Invalid parameter time stamp format.");
        }
        return creationTimeInMicros;
    }

    public static String getMonitorFolder(TRCMonitor monitor) {
        if (monitor == null) {
            return null;
        }
        Resource res = monitor.eResource();
        if (res == null) {
            return null;
        }
        String uri = res.getURI().toString();
        int index = (uri = uri.replace('\\', '/')).lastIndexOf("/");
        if (index >= 0) {
            uri = uri.substring(0, index);
        }
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        if (!uri.endsWith("/")) {
            uri = String.valueOf(uri) + "/";
        }
        return uri;
    }

    public static SimpleDateFormat getPartialCIMDateFormat() {
        return LoadersUtils.getPartialCIMDateFormatDashDelimiter();
    }

    public static SimpleDateFormat getPartialCIMDateFormatDashDelimiter() {
        return partialCIMDateFormatDashDelimiter;
    }

    public static SimpleDateFormat getPartialCIMDateFormatPlusDelimiter() {
        return partialCIMDateFormatPlusDelimiter;
    }

    public static SimpleDateFormat getPartialCIMDateFormatNoDelimiter() {
        return partialCIMDateFormatNoDelimiter;
    }

    public static synchronized double convertCreationTime(String value) {
        return LoadersUtils.getMicrosecondsFromCIMFormat(value);
    }

    public static TRCAgent getOrCreateAgent(HierarchyContext context) {
        TRCAgent agent = context.getAgent();
        if (agent == null) {
            agent = context.getAgentProxy() != null && context.getAgentProxy().getAgent() != null ? context.getAgentProxy().getAgent() : LoadersUtils.createAgent(context);
        }
        return agent;
    }

    public static TRCAgent createAgent(HierarchyContext context) {
        LoadersUtils.setDefaultContext(context);
        TRCAgent agent = context.getAgent();
        TRCAgentProxy agentProxy = context.getAgentProxy();
        TRCProcessProxy process = context.getProcessProxy();
        TRCNode node = context.getNode();
        TRCMonitor monitor = context.getMonitor();
        String agentName = "Unknown-" + System.currentTimeMillis();
        String monitorFolder = LoadersUtils.getMonitorFolder(monitor);
        Resource agDoc = null;
        double startTime = (double)new Date().getTime() / 1000.0;
        if (monitorFolder != null) {
            String aName = String.valueOf(monitor.getName()) + "_" + node.getName().trim() + "_" + process.getPid() + "_" + process.getRuntimeId() + "_" + StringUtil.change(agentName.trim(), " ", "");
            String pFileName = String.valueOf(monitorFolder) + aName;
            String rName = ModelDebugger.INSTANCE.debugDatabaseResourcePostfix != null && ModelDebugger.INSTANCE.debugDatabaseResourcePostfix.length() > 0 ? String.valueOf(pFileName) + ModelDebugger.INSTANCE.debugDatabaseResourcePostfix : String.valueOf(pFileName) + ".trcaxmi";
            URI uri = SaveUtil.createURI(String.valueOf(rName) + "#").trimFragment();
            agDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
            agDoc.setModified(true);
            HierarchyResourceSetImpl.getInstance().getResources().add((Object)agDoc);
        }
        agent = HierarchyFactory.eINSTANCE.createTRCAgent();
        if (agentProxy == null) {
            agentProxy = HierarchyFactory.eINSTANCE.createTRCAgentProxy();
            agentProxy.setRuntimeId("" + startTime);
            agent.setRuntimeId("" + startTime);
            agent.setName(agentName);
            agentProxy.setName(agentName);
            agent.setType("Logging");
            agentProxy.setType("Logging");
            agent.setStartTime(startTime);
            agentProxy.setStartTime(startTime);
            agent.setAgentProxy(agentProxy);
            agentProxy.setProcessProxy(process);
            agent.setCollectionMode(context.getCollectionMode());
            agentProxy.setCollectionMode(context.getCollectionMode());
            context.setAgent(agent);
            context.setAgentProxy(agentProxy);
        } else {
            agent.setRuntimeId(agentProxy.getRuntimeId());
            agent.setName(agentProxy.getName());
            if (agentProxy.getType() != null) {
                agent.setType(agentProxy.getType());
            } else {
                agent.setType("Logging");
                agentProxy.setType("Logging");
            }
            agent.setStartTime(agentProxy.getStartTime());
            agent.setAgentProxy(agentProxy);
            agent.setCollectionMode(context.getCollectionMode());
            context.setAgent(agent);
        }
        if (context.getContextURI() == null) {
            context.setContextURI(agDoc.getURI().toString());
            LookupServiceExtensions.getInstance().register(null, context);
        }
        if (agDoc != null) {
            agDoc.getContents().add((Object)agent);
            agDoc.setModified(true);
        }
        return agent;
    }

    public static void deregisterAgentInstance(TRCAgentProxy agentProxy) {
        AgentProxyContext c = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, AgentProxyContext.class, LoadersUtils.getLookUpKey(agentProxy.hashCode()));
        if (c != null) {
            c.setAgentInstance(null);
        }
    }

    public static void deregisterAgentListener(TRCAgentProxy agentProxy) {
        AgentProxyContext c = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, AgentProxyContext.class, LoadersUtils.getLookUpKey(agentProxy.hashCode()));
        if (c != null) {
            c.setAgentListener(null);
        }
    }

    public static void deregisterAgentProxyContext(TRCAgentProxy agentProxy) {
        AgentProxyContext c = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, AgentProxyContext.class, LoadersUtils.getLookUpKey(agentProxy.hashCode()));
        if (c != null) {
            LookupServiceExtensions.getInstance().deregister(null, c);
            c.cleanUp();
        }
    }

    public static void deregisterDataProcessor(TRCAgentProxy agentProxy) {
        AgentProxyContext c = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, AgentProxyContext.class, LoadersUtils.getLookUpKey(agentProxy.hashCode()));
        if (c != null) {
            c.setDataProcessor(null);
        }
    }

    public static TRCAgent locateAgentFromMonitor(TRCMonitor monitor, String agentRId) {
        EList<TRCNode> nodeList = monitor.getNodes();
        for (TRCNode node : nodeList) {
            if (node.eIsProxy()) continue;
            EList<TRCProcessProxy> processList = node.getProcessProxies();
            for (TRCProcessProxy process : processList) {
                if (process.eIsProxy()) continue;
                EList<TRCAgentProxy> agents = process.getAgentProxies();
                for (TRCAgentProxy agent : agents) {
                    if (agent.eIsProxy() || agent.getRuntimeId() == null || !agent.getRuntimeId().equals(agentRId)) continue;
                    return agent.getAgent();
                }
            }
        }
        return null;
    }

    public static TRCAgent locateAgentFromProcess(TRCProcessProxy process, String aName, String agentRId) {
        EList<TRCAgentProxy> agents = process.getAgentProxies();
        for (TRCAgentProxy agent : agents) {
            if (agent.eIsProxy() || agent.getName() == null || !agent.getName().equals(aName) || agent.getRuntimeId() != null && !agent.getRuntimeId().equals("") && !agent.getRuntimeId().equals(agentRId)) continue;
            return agent.getAgent();
        }
        return null;
    }

    public static Object locateAgentInstance(TRCAgentProxy agentProxy) {
        AgentProxyContext c = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, AgentProxyContext.class, LoadersUtils.getLookUpKey(agentProxy.hashCode()));
        if (c != null) {
            return c.getAgentInstance();
        }
        return null;
    }

    public static Object locateAgentListener(TRCAgentProxy agentProxy) {
        AgentProxyContext c = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, AgentProxyContext.class, LoadersUtils.getLookUpKey(agentProxy.hashCode()));
        if (c != null) {
            return c.getAgentListener();
        }
        return null;
    }

    public static XMLLoader locateDataProcessor(TRCAgentProxy agentProxy) {
        AgentProxyContext c = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, AgentProxyContext.class, LoadersUtils.getLookUpKey(agentProxy.hashCode()));
        if (c != null) {
            return c.getDataProcessor();
        }
        return null;
    }

    public static HierarchyContext locateHierarchyContext(TRCAgent agent) {
        HierarchyContext context = null;
        if (agent.eResource() != null) {
            context = (HierarchyContext)LookupServiceExtensions.getInstance().locate(null, HierarchyContext.class, agent.eResource().getURI().toString());
        }
        if (context == null) {
            context = (HierarchyContext)LookupServiceExtensions.getInstance().locate(null, HierarchyContext.class, agent.getRuntimeId());
        }
        return context;
    }

    /*
     * Exception decompiling
     */
    public static TRCNode locateNodeFromMonitor(TRCMonitor monitor, String hostName, String ipaddr, String nRId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static TRCProcessProxy locateProcessFromNode(TRCNode node, String pRId) {
        EList<TRCProcessProxy> processList = node.getProcessProxies();
        int i = 0;
        while (i < processList.size()) {
            TRCProcessProxy process = (TRCProcessProxy)processList.get(i);
            if (!process.eIsProxy() && process.getRuntimeId() != null && process.getRuntimeId().compareTo(pRId) == 0) {
                return process;
            }
            ++i;
        }
        return null;
    }

    public static TRCProcessProxy locateProcessFromNode(TRCNode node, int pId, String pRId) {
        EList<TRCProcessProxy> processList = node.getProcessProxies();
        int i = 0;
        while (i < processList.size()) {
            String runtimeId;
            int processId;
            TRCProcessProxy process = (TRCProcessProxy)processList.get(i);
            if (!process.eIsProxy() && (processId = process.getPid()) == pId && ((runtimeId = process.getRuntimeId()) == null || runtimeId.equals("") || runtimeId.equals(pRId))) {
                process.setRuntimeId(pRId);
                return process;
            }
            ++i;
        }
        return null;
    }

    public static void log(Throwable e) {
        ModelDebugger.log(e);
    }

    public static void log(Throwable e, String msg) {
        ModelDebugger.log(e, msg);
    }

    public static void logCallstackWithLimit(Throwable e, int limit) {
        ModelDebugger.logCallstackWithLimit(e, limit, System.out);
    }

    public static void log(String s) {
        ModelDebugger.log(s);
    }

    public static String makeString(byte[] data, int offset, int length) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, offset, length, "UTF8");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void registerAgentInstance(TRCAgentProxy agentProxy, Object ai) {
        AgentProxyContext c = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, AgentProxyContext.class, LoadersUtils.getLookUpKey(agentProxy.hashCode()));
        if (c != null) {
            c.setAgentInstance(ai);
        } else {
            c = new AgentProxyContext();
            c.setAgentProxy(agentProxy);
            c.setAgentInstance(ai);
            LookupServiceExtensions.getInstance().register(null, c);
        }
    }

    public static void registerAgentListener(TRCAgentProxy agentProxy, Object al) {
        AgentProxyContext c = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, AgentProxyContext.class, LoadersUtils.getLookUpKey(agentProxy.hashCode()));
        if (c != null) {
            c.setAgentListener(al);
        } else {
            c = new AgentProxyContext();
            c.setAgentProxy(agentProxy);
            c.setAgentListener(al);
            LookupServiceExtensions.getInstance().register(null, c);
        }
    }

    public static void registerDataProcessor(TRCAgentProxy agentProxy, XMLLoader processor) {
        AgentProxyContext c = (AgentProxyContext)LookupServiceExtensions.getInstance().locate(null, AgentProxyContext.class, LoadersUtils.getLookUpKey(agentProxy.hashCode()));
        if (c != null) {
            c.setDataProcessor(processor);
        } else {
            c = new AgentProxyContext();
            c.setAgentProxy(agentProxy);
            c.setDataProcessor(processor);
            LookupServiceExtensions.getInstance().register(null, c);
        }
    }

    public static void loadRootEvent(XMLLoader processor) {
        processor.loadEvent("<TRACE>".getBytes(), "<TRACE>".getBytes().length);
    }

    public static TRCAgent locateAgent(String agentIdRef, TRCAgent agent) {
        AgentsContext agentsContext = (AgentsContext)LookupServiceExtensions.getInstance().locate(null, AgentsContext.class, LoadersUtils.getLookUpKey(agentIdRef));
        if (agentsContext != null) {
            return agentsContext.getActiveAgent(agent);
        }
        return null;
    }

    public static boolean registerAgent(String agentIdRef, TRCAgent agent) {
        AgentsContext agentsContext = (AgentsContext)LookupServiceExtensions.getInstance().locate(null, AgentsContext.class, LoadersUtils.getLookUpKey(agentIdRef));
        if (agentsContext == null) {
            agentsContext = new AgentsContext(agentIdRef);
            LookupServiceExtensions.getInstance().register(null, agentsContext);
        }
        return agentsContext.registerAgent(agent);
    }

    public static Object getLookUpKey(int key) {
        return new Integer(key);
    }

    public static Object getLookUpKey(long key) {
        return new Long(key);
    }

    public static Object getLookUpKey(short key) {
        return new Short(key);
    }

    public static Object getLookUpKey(String key) {
        if (key == null) {
            return new Integer(0);
        }
        return new Integer(key.hashCode());
    }

    public static GenericLookUpEntry getGenericLookUpEntry(Thread thread) {
        Integer key = new Integer(thread.hashCode());
        GenericLookUpEntry entry = (GenericLookUpEntry)threads.get(key);
        if (entry == null) {
            entry = new GenericLookUpEntry();
            threads.put(key, entry);
        }
        return entry;
    }

    public static void registerGenericLookUpEntry(HierarchyContext context, Object key, Object value) {
        GenericLookUpEntry entry = LoadersUtils.getGenericLookUpEntry(Thread.currentThread());
        entry.setKey(key);
        entry.setValue(value);
        LookupServiceExtensions.getInstance().register(context, entry);
        entry.reset();
    }

    public static int getHashCode(byte[] data, int offset, int length) {
        int h = 0;
        int i = 0;
        while (i < length) {
            h = 31 * h + data[offset + i];
            ++i;
        }
        return h;
    }

    public static int getHashCode(String value) {
        if (value == null) {
            return 0;
        }
        int h = 0;
        int len = value.length();
        int i = 0;
        while (i < len) {
            h = 31 * h + value.charAt(i);
            ++i;
        }
        return h;
    }

    public static void setSessionStartTime(double time, TRCAgentProxy agentProxy) {
        TRCAgent agent;
        if (agentProxy == null) {
            return;
        }
        if (!agentProxy.eIsSet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_StartTime())) {
            agentProxy.setStartTime(time);
        }
        if ((agent = (TRCAgent)agentProxy.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false)) != null && !agent.eIsProxy() && !agent.eIsSet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgent_StartTime())) {
            agent.setStartTime(time);
        }
    }

    public static void setSessionStopTime(double time, TRCAgentProxy agentProxy) {
        TRCAgent agent;
        if (agentProxy == null) {
            return;
        }
        if (!agentProxy.eIsSet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_StopTime())) {
            agentProxy.setStopTime(time);
        }
        if ((agent = (TRCAgent)agentProxy.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false)) != null && !agent.eIsProxy() && !agent.eIsSet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgent_StopTime())) {
            agent.setStopTime(time);
        }
    }

    public static CorrelationEngine findCorrelationEngine(String string) {
        return (CorrelationEngine)LookupServiceExtensions.getInstance().locate(null, CorrelationEngineImpl.class, string);
    }

    public static void addCorrelationEngine(CorrelationEngine correlationEngine) {
        Resource resource = HierarchyResourceSetImpl.getInstance().getResource(URI.createURI((String)"http://www.eclipse.org/hyades/correlations.xmi"), false);
        resource.getContents().add((Object)correlationEngine);
    }

    public static CorrelationContainerProxy getInternalCorrelationContainerProxy(TRCAgentProxy agentProxy, String correlationEngineID) {
        URI internalCorrelationURI = LoadersUtils.createCorrelationContainerURI(agentProxy, correlationEngineID, "internalcc");
        for (CorrelationContainerProxy correlationContainerProxy : agentProxy.getInternalCorrelations()) {
            CorrelationContainer correlationContainer = correlationContainerProxy.getCorrelationContainer();
            if (correlationContainer != null) {
                URI ccURI;
                URI uRI = ccURI = correlationContainer.eIsProxy() ? ((InternalEObject)correlationContainer).eProxyURI() : correlationContainer.eResource().getURI();
                if (correlationContainerProxy.eIsProxy() || !ccURI.equals((Object)internalCorrelationURI)) continue;
                return correlationContainerProxy;
            }
            correlationContainer = HierarchyFactory.eINSTANCE.createCorrelationContainer();
            correlationContainer.setCorrelationContainerProxy(correlationContainerProxy);
            LoadersUtils.createCorrelationContainerResource(agentProxy, correlationEngineID, correlationContainer, "internalcc");
            return correlationContainerProxy;
        }
        CorrelationContainerProxy correlationContainerProxy = HierarchyFactory.eINSTANCE.createCorrelationContainerProxy();
        correlationContainerProxy.getCorrelatedAgents().add((Object)agentProxy);
        agentProxy.getInternalCorrelations().add((Object)correlationContainerProxy);
        correlationContainerProxy.setCreationTime(new Date().getTime());
        correlationContainerProxy.setName(InternalCorrelationName);
        correlationContainerProxy.setMonitor(agentProxy.getProcessProxy().getNode().getMonitor());
        agentProxy.getProcessProxy().eResource().setModified(true);
        agentProxy.getProcessProxy().getNode().getMonitor().eResource().setModified(true);
        return correlationContainerProxy;
    }

    public static String getInternalCorrelationName(String correlationEngineName) {
        String name;
        if (ModelsHierarchyPlugin.getPlugin() == null) {
            DateFormat formatter = DateFormat.getDateTimeInstance((int)2, (int)2, (ULocale)ULocale.getDefault());
            String formatDate = formatter.format(new Date());
            name = correlationEngineName != null ? String.valueOf(correlationEngineName) + "_Internal_" + formatDate : String.valueOf(InternalCorrelationName) + formatDate;
        } else {
            long i = ModelsHierarchyPlugin.getPlugin().getPluginPreferences().getLong("internalCorrelation") + 1L;
            ModelsHierarchyPlugin.getPlugin().getPluginPreferences().setValue("internalCorrelation", i);
            name = correlationEngineName != null ? String.valueOf(correlationEngineName) + "_Internal_" + i : String.valueOf(InternalCorrelationName) + i;
        }
        return name;
    }

    public static CorrelationContainerProxy getCorrelationContainerProxy(TRCAgentProxy agentProxy, String correlationEngineID, String correlationTag, String sessionID) {
        CorrelationContainerProxy correlationContainerProxy = HierarchyFactory.eINSTANCE.createCorrelationContainerProxy();
        CorrelationContainer correlationContainer = HierarchyFactory.eINSTANCE.createCorrelationContainer();
        correlationContainer.setCorrelationContainerProxy(correlationContainerProxy);
        LoadersUtils.createCorrelationContainerResource(agentProxy, correlationEngineID, correlationContainer, correlationTag, sessionID);
        correlationContainerProxy.getCorrelatedAgents().add((Object)agentProxy);
        correlationContainerProxy.setCreationTime(new Date().getTime());
        correlationContainerProxy.setName(String.valueOf(correlationTag) + "_" + correlationEngineID);
        correlationContainerProxy.setMonitor(agentProxy.getProcessProxy().getNode().getMonitor());
        agentProxy.getProcessProxy().getNode().getMonitor().eResource().setModified(true);
        return correlationContainerProxy;
    }

    public static CorrelationContainerProxy getSQLCorrelationContainerProxy(TRCAgentProxy agentProxy, String correlationEngineID, String correlationTag) {
        return LoadersUtils.getSQLCorrelationContainerProxy(agentProxy, correlationEngineID, correlationTag, null);
    }

    public static CorrelationContainerProxy getSQLCorrelationContainerProxy(TRCAgentProxy agentProxy, String correlationEngineID, String correlationTag, String sessionID) {
        URI uri = EcoreUtil.getURI((EObject)agentProxy.getAgent());
        Properties p = HyadesExtendedResourceFactory.getPropertiesFromURI(uri);
        String storeType = ((IHyadesResourceExtension)HyadesResourceExtensions.getInstance().get(LoadersUtils.getPostfix(uri.toString()))).getStoreType(LoadersUtils.getPostfix(uri.toString()));
        HyadesResourceExtensions.getInstance().setProperties(storeType, p);
        CorrelationContainerProxy correlationContainerProxy = HierarchyFactory.eINSTANCE.createCorrelationContainerProxy();
        CorrelationContainer correlationContainer = HierarchyFactory.eINSTANCE.createCorrelationContainer();
        URI agentURI = EcoreUtil.getURI((EObject)((TRCAgent)agentProxy.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false)));
        String agentPostfix = LoadersUtils.getPostfix(agentURI);
        String ccPostfix = LoadersUtils.getCorrelationNamePostfix(storeType);
        String ccs = StringUtil.change(agentURI.toString(), agentPostfix, "_" + correlationTag + "-" + correlationEngineID + ccPostfix);
        URI correlationContainerResourceURI = SaveUtil.createURI(LoadersUtils.getContainerResourceURI(ccs));
        Resource ccr = HierarchyResourceSetImpl.getInstance(sessionID).createResource(correlationContainerResourceURI);
        ccr.getContents().add((Object)correlationContainer);
        correlationContainerProxy.setCorrelationContainer(correlationContainer);
        correlationContainerProxy.getCorrelatedAgents().add((Object)agentProxy);
        correlationContainerProxy.setCreationTime(new Date().getTime());
        correlationContainerProxy.setName(String.valueOf(correlationTag) + "_" + correlationEngineID);
        correlationContainerProxy.setMonitor(agentProxy.getProcessProxy().getNode().getMonitor());
        agentProxy.getProcessProxy().getNode().getMonitor().eResource().setModified(true);
        correlationContainerProxy.setName(correlationTag);
        return correlationContainerProxy;
    }

    public static String getContainerResourceURI(String uri) {
        int i = uri.indexOf(35);
        if (i != -1) {
            uri = uri.substring(0, i);
        }
        return uri;
    }

    public static String getCorrelationNamePostfix(String dbType) {
        String res = null;
        for (Map.Entry entry : HyadesResourceExtensions.getInstance().entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            IHyadesResourceExtension hyadesResourceFactory = (IHyadesResourceExtension)entry.getValue();
            String postfix = (String)entry.getKey();
            if (!postfix.endsWith(".corrdb") || !hyadesResourceFactory.getStoreType(postfix).equals(dbType)) continue;
            return postfix;
        }
        res = ".corrxmi";
        return res;
    }

    public static URI createCorrelationContainerURI(TRCAgentProxy agentProxy, String correlationEngineID, String correlationTag) {
        URI internalCorrelationURI = agentProxy.getAgent().eResource().getURI();
        return LoadersUtils.createCorrelationContainerURI(internalCorrelationURI, correlationEngineID, correlationTag);
    }

    public static URI createCorrelationContainerURI(URI agentURI, String correlationEngineID, String correlationTag) {
        URI internalCorrelationURI = agentURI;
        internalCorrelationURI = internalCorrelationURI.trimFileExtension();
        String lastSegment = String.valueOf(internalCorrelationURI.lastSegment()) + "_" + (String.valueOf(correlationTag) + "-" + correlationEngineID + "-" + new Date().getTime()).hashCode();
        internalCorrelationURI = internalCorrelationURI.trimSegments(1);
        internalCorrelationURI = internalCorrelationURI.appendSegment(lastSegment);
        internalCorrelationURI = internalCorrelationURI.appendFileExtension("corrxmi");
        return internalCorrelationURI;
    }

    public static void createCorrelationContainerResource(TRCAgentProxy proxy, String correlationEngineID, CorrelationContainer container, String correlationTag) {
        LoadersUtils.createCorrelationContainerResource(proxy, correlationEngineID, container, correlationTag, null);
    }

    public static void createCorrelationContainerResource(TRCAgentProxy proxy, String correlationEngineID, CorrelationContainer container, String correlationTag, String sessionID) {
        URI internalCorrelationURI = LoadersUtils.createCorrelationContainerURI(proxy, correlationEngineID, correlationTag);
        Resource resource = HierarchyResourceSetImpl.getInstance(sessionID).createResource(internalCorrelationURI);
        resource.setModified(true);
        resource.getContents().add((Object)container);
    }

    public static String getPostfix(URI uri) {
        String postfix = uri.trimFragment().toString();
        return LoadersUtils.getPostfix(postfix);
    }

    public static String getPostfix(String postfix) {
        int index = postfix.lastIndexOf("__");
        if (index > 0) {
            int fragmentIndex = postfix.indexOf("#", index);
            postfix = fragmentIndex > 0 ? postfix.substring(index, fragmentIndex) : postfix.substring(index);
        } else if (postfix.lastIndexOf(46) > -1) {
            postfix = postfix.substring(postfix.lastIndexOf(46));
        }
        return postfix;
    }

    public static String scramblePassword(String password) throws InvalidPassword {
        if (password == null || password.length() == 0) {
            return "";
        }
        int length = password.length();
        char[] out = new char[length];
        int i = 0;
        while (i < length) {
            char value = password.charAt(i);
            if (value < '\u0000' || value > '\u00ff') {
                throw new InvalidPassword(password);
            }
            out[i] = SCRAMBLING_TABLE[value];
            ++i;
        }
        return "A" + new String(out);
    }

    protected static final void resetRESTORINGTALBE() {
        if (RESTORING_TABLE != null) {
            return;
        }
        RESTORING_TABLE = new char[256];
        int i = 0;
        while (i < 256) {
            char value = SCRAMBLING_TABLE[i];
            LoadersUtils.RESTORING_TABLE[value] = (char)i;
            ++i;
        }
    }

    public static String restorePassword(String password) throws InvalidPassword {
        if (password == null || password.length() == 0) {
            return "";
        }
        int length = password.length();
        LoadersUtils.resetRESTORINGTALBE();
        char[] out = new char[length - 1];
        int i = 1;
        while (i < length) {
            char value = password.charAt(i);
            if (value < '\u0000' || value > '\u00ff') {
                throw new InvalidPassword(password);
            }
            out[i - 1] = RESTORING_TABLE[value];
            ++i;
        }
        return new String(out);
    }

    public static String toString(String[] statements) {
        StringBuffer res = new StringBuffer();
        if (statements != null) {
            res.append('[');
            boolean first = true;
            int i = 0;
            while (i < statements.length) {
                if (first) {
                    first = false;
                } else {
                    res.append(",\n");
                }
                res.append(statements[i]);
                ++i;
            }
            res.append(']');
        }
        return res.toString();
    }

    public static String getFirstLine(String name, int maxLength) {
        if (name == null) {
            return null;
        }
        int idx = name.indexOf("\r\n", 0);
        if (idx != -1) {
            name = name.substring(0, idx < maxLength ? idx : maxLength - 1);
        } else {
            idx = name.indexOf("\n");
            if (idx != -1) {
                name = name.substring(0, idx < maxLength ? idx : maxLength - 1);
            }
        }
        name = name.replace('\t', ' ');
        return name;
    }

    public static char[] getChars(StringBuffer sb2) {
        char[] c = new char[sb2.length()];
        sb2.getChars(0, sb2.length(), c, 0);
        return c;
    }

    public static char[] makeCharArray(byte[] buffer, int offset, int length) {
        char[] res = new char[Math.min(buffer.length, length + offset)];
        int i = res.length - 1;
        while (i <= 0) {
            res[i] = (char)buffer[i + offset];
            --i;
        }
        return res;
    }

    public static double parseTraceTime(String value) {
        double res = 0.0;
        if (value != null) {
            long temp = 0L;
            int power = 0;
            int i = value.length() - 1;
            while (i-- > 0) {
                char c = value.charAt(i);
                if (c == '.' || c == ',') {
                    res = (double)temp / (double)powerOf10[power];
                    temp = 0L;
                    power = 0;
                    continue;
                }
                temp += (long)(c - 48) * powerOf10[power++];
            }
            res += (double)temp;
        }
        return res;
    }

    public static long parseLongTraceTime(String value) {
        long res = 0L;
        if (value != null) {
            int power = 0;
            int i = value.length();
            while (i-- > 0) {
                char c = value.charAt(i);
                if (c == '.' || c == ',') {
                    if (power == 9) continue;
                    if (power < 9) {
                        res *= powerOf10[9 - power];
                        power = 9;
                        continue;
                    }
                    res /= powerOf10[power - 9];
                    power = 9;
                    continue;
                }
                res += (long)(c - 48) * powerOf10[power++];
            }
        }
        return res;
    }

    public static void main(String[] args) {
        System.out.println("1118198325.526252508 = " + LoadersUtils.parseLongTraceTime("1118198325.526252508"));
        System.out.println("1118198325.52625250 = " + LoadersUtils.parseLongTraceTime("1118198325.52625250"));
        System.out.println("1118198325.5262 = " + LoadersUtils.parseLongTraceTime("1118198325.5262"));
        System.out.println("9199999999.999999998 = " + LoadersUtils.parseLongTraceTime("9199999999.999999998"));
        int iterations = 10000000;
        PerfUtil p = PerfUtil.createInstance("parseTraceTime iterations=" + iterations, true);
        System.out.println("1118198325.526252508 = " + LoadersUtils.parseTraceTime("1118198325.526252508"));
        int i = iterations;
        while (i-- > 0) {
            LoadersUtils.parseTraceTime("1118198325.526252508");
        }
        p.stopAndPrintStatus();
        p.setMessageAndStart("Long.parseLong iterations=" + iterations);
        System.out.println("1118198325526252508 = " + Long.parseLong("1118198325526252508"));
        i = iterations;
        while (i-- > 0) {
            Long.parseLong("1118198325526252508");
        }
        p.stopAndPrintStatus();
        p.setMessageAndStart("parseLongTraceTime iterations=" + iterations);
        System.out.println("1118198325.526252508 = " + LoadersUtils.parseLongTraceTime("1118198325.526252508"));
        i = iterations;
        while (i-- > 0) {
            LoadersUtils.parseLongTraceTime("1118198325.526252508");
        }
        p.stopAndPrintStatus();
        p.setMessageAndStart("parseTraceTime iterations=" + iterations);
        System.out.println("1118198325.526252508 = " + LoadersUtils.parseTraceTime("1118198325.526252508"));
        i = iterations;
        while (i-- > 0) {
            LoadersUtils.parseTraceTime("1118198325.526252508");
        }
        p.stopAndPrintStatus();
        p.setMessageAndStart("parseLongTraceTime iterations=" + iterations);
        System.out.println("1118198325.526252508 = " + LoadersUtils.parseLongTraceTime("1118198325.526252508"));
        i = iterations;
        while (i-- > 0) {
            LoadersUtils.parseLongTraceTime("1118198325.526252508");
        }
        p.stopAndPrintStatus();
    }

    public static InputStream getFirstFileInputStream(String fileName) {
        try {
            if (LoadersUtils.isZipFile(fileName)) {
                ZipFile zf = new ZipFile(fileName);
                Enumeration<? extends ZipEntry> entries = zf.entries();
                if (entries.hasMoreElements()) {
                    ZipEntry zipEntry = entries.nextElement();
                    return zf.getInputStream(zipEntry);
                }
                return new ZipInputStream(new BufferedInputStream(new FileInputStream(fileName)));
            }
            return new BufferedInputStream(new FileInputStream(fileName));
        }
        catch (Exception e) {
            ModelDebugger.log(e);
            return null;
        }
    }

    public static boolean isZipFile(InputStream readStream) throws IOException {
        byte[] magic = new byte[2];
        return readStream.read(magic) > 1 && magic[0] == 80 && magic[1] == 75;
    }

    public static boolean isZipFile(String fileName) throws IOException {
        FileInputStream readStream = new FileInputStream(fileName);
        boolean ret = LoadersUtils.isZipFile(readStream);
        readStream.close();
        readStream = null;
        return ret;
    }
}

