/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import org.eclipse.hyades.loaders.util.HyadesConfigurationElement;
import org.eclipse.hyades.loaders.util.IHyadesPluginClassDescriptor;
import org.eclipse.hyades.loaders.util.LookupService;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.loaders.util.RegistryReader;

class LookupServiceRegistryReader
extends RegistryReader {
    static final String TAG_LOADER = "lookupService";

    public LookupServiceRegistryReader() {
        super("lookup_service");
    }

    protected boolean readElement(HyadesConfigurationElement element) {
        if (element.getName().equals(TAG_LOADER)) {
            if (element.getAttribute("class") == null) {
                this.logMissingAttribute(element, "class");
            } else {
                try {
                    IHyadesPluginClassDescriptor classDescriptor = this.createPluginClassDescriptor(element, "class");
                    LookupService lookupService = (LookupService)classDescriptor.createInstance();
                    float priority = 0.0f;
                    if (element.getAttribute("priority") != null) {
                        priority = Float.parseFloat(element.getAttribute("priority"));
                    }
                    if (lookupService != null) {
                        for (LookupService l : LookupServiceExtensions.getInstance().values()) {
                            if (element.getClass() != lookupService.getClass()) continue;
                            lookupService = l;
                            break;
                        }
                        for (Class type : lookupService.getSupportedTypes()) {
                            if (LookupServiceExtensions.getInstance().containsKey(type) && ((Float)this.getPriorities().get(type)).floatValue() >= priority) {
                                this.logError(element, "A lookupService for this element with a higher or equal priority already exists, lookupService \"" + lookupService.getClass().getName() + "\" will be ignored for type \"" + type.getName() + "\".");
                                continue;
                            }
                            LookupServiceExtensions.getInstance().put(type, lookupService);
                            this.getPriorities().put(type, new Float(priority));
                        }
                    } else {
                        this.logError(element, "Error when creating instance of lookup service: " + element.getAttribute("class"));
                    }
                }
                catch (Exception e) {
                    this.logError(element, e.getLocalizedMessage());
                }
                return true;
            }
        }
        return false;
    }
}

