/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TRCCollectionMode implements Enumerator
{
    HEAP_STATISTICS_ONLY_LITERAL(0, "HEAP_STATISTICS_ONLY", "HEAP_STATISTICS_ONLY"),
    HEAP_FULL_LITERAL(1, "HEAP_FULL", "HEAP_FULL"),
    HEAP_AND_EXECUTION_FULL_LITERAL(2, "HEAP_AND_EXECUTION_FULL", "HEAP_AND_EXECUTION_FULL"),
    HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL(3, "HEAP_AND_EXECUTION_STATISTICS_ONLY", "HEAP_AND_EXECUTION_STATISTICS_ONLY"),
    EXECUTION_STATISTICS_ONLY_LITERAL(4, "EXECUTION_STATISTICS_ONLY", "EXECUTION_STATISTICS_ONLY"),
    EXECUTION_NO_INSTANCES_LITERAL(5, "EXECUTION_NO_INSTANCES", "EXECUTION_NO_INSTANCES"),
    EXECUTION_FULL_LITERAL(6, "EXECUTION_FULL", "EXECUTION_FULL"),
    HEAP_FULL_AND_EXECUTION_STATISTICS_ONLY_LITERAL(7, "HEAP_FULL_AND_EXECUTION_STATISTICS_ONLY", "HEAP_FULL_AND_EXECUTION_STATISTICS_ONLY"),
    HEAP_STATISTICS_AND_EXECUTION_NO_INSTANCES_LITERAL(8, "HEAP_STATISTICS_AND_EXECUTION_NO_INSTANCES", "HEAP_STATISTICS_AND_EXECUTION_NO_INSTANCES");

    public static final int HEAP_STATISTICS_ONLY = 0;
    public static final int HEAP_FULL = 1;
    public static final int HEAP_AND_EXECUTION_FULL = 2;
    public static final int HEAP_AND_EXECUTION_STATISTICS_ONLY = 3;
    public static final int EXECUTION_STATISTICS_ONLY = 4;
    public static final int EXECUTION_NO_INSTANCES = 5;
    public static final int EXECUTION_FULL = 6;
    public static final int HEAP_FULL_AND_EXECUTION_STATISTICS_ONLY = 7;
    public static final int HEAP_STATISTICS_AND_EXECUTION_NO_INSTANCES = 8;
    private static final TRCCollectionMode[] VALUES_ARRAY;
    public static final List<TRCCollectionMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TRCCollectionMode[]{HEAP_STATISTICS_ONLY_LITERAL, HEAP_FULL_LITERAL, HEAP_AND_EXECUTION_FULL_LITERAL, HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL, EXECUTION_STATISTICS_ONLY_LITERAL, EXECUTION_NO_INSTANCES_LITERAL, EXECUTION_FULL_LITERAL, HEAP_FULL_AND_EXECUTION_STATISTICS_ONLY_LITERAL, HEAP_STATISTICS_AND_EXECUTION_NO_INSTANCES_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TRCCollectionMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TRCCollectionMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TRCCollectionMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TRCCollectionMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TRCCollectionMode get(int value) {
        switch (value) {
            case 0: {
                return HEAP_STATISTICS_ONLY_LITERAL;
            }
            case 1: {
                return HEAP_FULL_LITERAL;
            }
            case 2: {
                return HEAP_AND_EXECUTION_FULL_LITERAL;
            }
            case 3: {
                return HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL;
            }
            case 4: {
                return EXECUTION_STATISTICS_ONLY_LITERAL;
            }
            case 5: {
                return EXECUTION_NO_INSTANCES_LITERAL;
            }
            case 6: {
                return EXECUTION_FULL_LITERAL;
            }
            case 7: {
                return HEAP_FULL_AND_EXECUTION_STATISTICS_ONLY_LITERAL;
            }
            case 8: {
                return HEAP_STATISTICS_AND_EXECUTION_NO_INSTANCES_LITERAL;
            }
        }
        return null;
    }

    private TRCCollectionMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

