/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.extensions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RelationalOperators implements Enumerator
{
    LT_LITERAL(0, "LT", "LT"),
    GT_LITERAL(1, "GT", "GT"),
    EQ_LITERAL(2, "EQ", "EQ"),
    LE_LITERAL(3, "LE", "LE"),
    GE_LITERAL(4, "GE", "GE"),
    NEQ_LITERAL(5, "NEQ", "NEQ"),
    LIKE_LITERAL(6, "LIKE", "LIKE"),
    IN_LITERAL(7, "IN", "IN"),
    BETWEEN_LITERAL(8, "BETWEEN", "BETWEEN");

    public static final int LT = 0;
    public static final int GT = 1;
    public static final int EQ = 2;
    public static final int LE = 3;
    public static final int GE = 4;
    public static final int NEQ = 5;
    public static final int LIKE = 6;
    public static final int IN = 7;
    public static final int BETWEEN = 8;
    private static final RelationalOperators[] VALUES_ARRAY;
    public static final List<RelationalOperators> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RelationalOperators[]{LT_LITERAL, GT_LITERAL, EQ_LITERAL, LE_LITERAL, GE_LITERAL, NEQ_LITERAL, LIKE_LITERAL, IN_LITERAL, BETWEEN_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RelationalOperators get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RelationalOperators result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RelationalOperators getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RelationalOperators result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RelationalOperators get(int value) {
        switch (value) {
            case 0: {
                return LT_LITERAL;
            }
            case 1: {
                return GT_LITERAL;
            }
            case 2: {
                return EQ_LITERAL;
            }
            case 3: {
                return LE_LITERAL;
            }
            case 4: {
                return GE_LITERAL;
            }
            case 5: {
                return NEQ_LITERAL;
            }
            case 6: {
                return LIKE_LITERAL;
            }
            case 7: {
                return IN_LITERAL;
            }
            case 8: {
                return BETWEEN_LITERAL;
            }
        }
        return null;
    }

    private RelationalOperators(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public static String getString(int value) {
        switch (value) {
            case 0: {
                return "<";
            }
            case 3: {
                return "<=";
            }
            case 1: {
                return ">";
            }
            case 4: {
                return ">=";
            }
            case 2: {
                return "=";
            }
            case 5: {
                return "<>";
            }
        }
        return RelationalOperators.get(value).getName();
    }
}

