/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.impl;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.hyades.models.hierarchy.CorrelationContainer;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;
import org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCAnnotation;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable;
import org.eclipse.hyades.models.hierarchy.TRCExecParameter;
import org.eclipse.hyades.models.hierarchy.TRCFilter;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation;
import org.eclipse.hyades.models.hierarchy.impl.CorrelationContainerImpl;
import org.eclipse.hyades.models.hierarchy.impl.CorrelationContainerProxyImpl;
import org.eclipse.hyades.models.hierarchy.impl.CorrelationEngineImpl;
import org.eclipse.hyades.models.hierarchy.impl.CorrelationEntryImpl;
import org.eclipse.hyades.models.hierarchy.impl.CorrelationSourceInfoImpl;
import org.eclipse.hyades.models.hierarchy.impl.TRCAgentImpl;
import org.eclipse.hyades.models.hierarchy.impl.TRCAgentProxyImpl;
import org.eclipse.hyades.models.hierarchy.impl.TRCAnnotationImpl;
import org.eclipse.hyades.models.hierarchy.impl.TRCConfigurationImpl;
import org.eclipse.hyades.models.hierarchy.impl.TRCEnvironmentVariableImpl;
import org.eclipse.hyades.models.hierarchy.impl.TRCExecParameterImpl;
import org.eclipse.hyades.models.hierarchy.impl.TRCFilterImpl;
import org.eclipse.hyades.models.hierarchy.impl.TRCMonitorImpl;
import org.eclipse.hyades.models.hierarchy.impl.TRCNodeImpl;
import org.eclipse.hyades.models.hierarchy.impl.TRCOptionImpl;
import org.eclipse.hyades.models.hierarchy.impl.TRCProcessProxyImpl;
import org.eclipse.hyades.models.hierarchy.impl.UnresolvedCorrelationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyFactoryImpl
extends EFactoryImpl
implements HierarchyFactory {
    public static HierarchyFactory init() {
        try {
            HierarchyFactory theHierarchyFactory = (HierarchyFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/hyades/models/hierarchy.xmi");
            if (theHierarchyFactory != null) {
                return theHierarchyFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new HierarchyFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createTRCProcessProxy();
            }
            case 1: {
                return this.createTRCOption();
            }
            case 2: {
                return this.createTRCAgent();
            }
            case 3: {
                return this.createTRCAgentProxy();
            }
            case 4: {
                return this.createTRCConfiguration();
            }
            case 5: {
                return this.createTRCEnvironmentVariable();
            }
            case 6: {
                return this.createTRCExecParameter();
            }
            case 7: {
                return this.createTRCFilter();
            }
            case 8: {
                return this.createTRCNode();
            }
            case 9: {
                return this.createTRCMonitor();
            }
            case 15: {
                return this.createUnresolvedCorrelation();
            }
            case 16: {
                return this.createCorrelationSourceInfo();
            }
            case 17: {
                return this.createCorrelationContainer();
            }
            case 18: {
                return this.createCorrelationContainerProxy();
            }
            case 19: {
                return (EObject)this.createCorrelationEntry();
            }
            case 20: {
                return this.createCorrelationEngine();
            }
            case 21: {
                return this.createTRCAnnotation();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 22: {
                return this.createTRCCollectionModeFromString(eDataType, initialValue);
            }
            case 23: {
                return this.createBooleanArrayFromString(eDataType, initialValue);
            }
            case 24: {
                return this.createIntArrayFromString(eDataType, initialValue);
            }
            case 25: {
                return this.createDoubleArrayFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 22: {
                return this.convertTRCCollectionModeToString(eDataType, instanceValue);
            }
            case 23: {
                return this.convertBooleanArrayToString(eDataType, instanceValue);
            }
            case 24: {
                return this.convertIntArrayToString(eDataType, instanceValue);
            }
            case 25: {
                return this.convertDoubleArrayToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public TRCProcessProxy createTRCProcessProxy() {
        TRCProcessProxyImpl trcProcessProxy = new TRCProcessProxyImpl();
        return trcProcessProxy;
    }

    @Override
    public TRCOption createTRCOption() {
        TRCOptionImpl trcOption = new TRCOptionImpl();
        return trcOption;
    }

    @Override
    public TRCAgent createTRCAgent() {
        TRCAgentImpl trcAgent = new TRCAgentImpl();
        return trcAgent;
    }

    @Override
    public TRCAgentProxy createTRCAgentProxy() {
        TRCAgentProxyImpl trcAgentProxy = new TRCAgentProxyImpl();
        return trcAgentProxy;
    }

    @Override
    public TRCConfiguration createTRCConfiguration() {
        TRCConfigurationImpl trcConfiguration = new TRCConfigurationImpl();
        return trcConfiguration;
    }

    @Override
    public TRCEnvironmentVariable createTRCEnvironmentVariable() {
        TRCEnvironmentVariableImpl trcEnvironmentVariable = new TRCEnvironmentVariableImpl();
        return trcEnvironmentVariable;
    }

    @Override
    public TRCExecParameter createTRCExecParameter() {
        TRCExecParameterImpl trcExecParameter = new TRCExecParameterImpl();
        return trcExecParameter;
    }

    @Override
    public TRCFilter createTRCFilter() {
        TRCFilterImpl trcFilter = new TRCFilterImpl();
        return trcFilter;
    }

    @Override
    public TRCNode createTRCNode() {
        TRCNodeImpl trcNode = new TRCNodeImpl();
        return trcNode;
    }

    @Override
    public TRCMonitor createTRCMonitor() {
        TRCMonitorImpl trcMonitor = new TRCMonitorImpl();
        return trcMonitor;
    }

    @Override
    public UnresolvedCorrelation createUnresolvedCorrelation() {
        UnresolvedCorrelationImpl unresolvedCorrelation = new UnresolvedCorrelationImpl();
        return unresolvedCorrelation;
    }

    @Override
    public CorrelationSourceInfo createCorrelationSourceInfo() {
        CorrelationSourceInfoImpl correlationSourceInfo = new CorrelationSourceInfoImpl();
        return correlationSourceInfo;
    }

    @Override
    public CorrelationContainer createCorrelationContainer() {
        CorrelationContainerImpl correlationContainer = new CorrelationContainerImpl();
        return correlationContainer;
    }

    @Override
    public CorrelationContainerProxy createCorrelationContainerProxy() {
        CorrelationContainerProxyImpl correlationContainerProxy = new CorrelationContainerProxyImpl();
        return correlationContainerProxy;
    }

    @Override
    public Map.Entry<EObject, EList<EObject>> createCorrelationEntry() {
        CorrelationEntryImpl correlationEntry = new CorrelationEntryImpl();
        return correlationEntry;
    }

    @Override
    public CorrelationEngine createCorrelationEngine() {
        CorrelationEngineImpl correlationEngine = new CorrelationEngineImpl();
        return correlationEngine;
    }

    @Override
    public TRCAnnotation createTRCAnnotation() {
        TRCAnnotationImpl trcAnnotation = new TRCAnnotationImpl();
        return trcAnnotation;
    }

    public TRCCollectionMode createTRCCollectionModeFromString(EDataType eDataType, String initialValue) {
        TRCCollectionMode result = TRCCollectionMode.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertTRCCollectionModeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public boolean[] createBooleanArrayFromString(EDataType eDataType, String initialValue) {
        int hexaDigit;
        int s = 0;
        int padding = 0;
        if (Character.isDigit(initialValue.charAt(0))) {
            padding = initialValue.charAt(0) - 48;
            if (padding < 0 || padding > 3) {
                throw new UnsupportedOperationException("Bad padding at the begining of the string");
            }
            s = 1;
        }
        boolean[] ret = new boolean[(initialValue.length() - s) * 4 - padding];
        int i = s;
        int j = 0;
        while (i < initialValue.length() - s) {
            hexaDigit = initialValue.charAt(i) - 65;
            if (hexaDigit < 0 || hexaDigit > 15) {
                throw new UnsupportedOperationException("Bad character in the string: " + initialValue.charAt(i / 4));
            }
            ret[j] = (hexaDigit & 8) != 0;
            ret[j + 1] = (hexaDigit & 4) != 0;
            ret[j + 2] = (hexaDigit & 2) != 0;
            ret[j + 3] = (hexaDigit & 1) != 0;
            ++i;
            j += 4;
        }
        if (padding > 0) {
            hexaDigit = initialValue.charAt(i) - 65;
            if (hexaDigit < 0 || hexaDigit > 15) {
                throw new UnsupportedOperationException("Bad character in the string: " + initialValue.charAt(i / 4));
            }
            j = 4 - padding;
            while (j > 0) {
                ret[ret.length - j] = (hexaDigit & 8) != 0;
                hexaDigit *= 2;
                --j;
            }
        }
        return ret;
    }

    public String convertBooleanArrayToString(EDataType eDataType, Object instanceValue) {
        boolean[] input;
        String ret = "";
        try {
            input = (boolean[])instanceValue;
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException("instanceValue must be of boolean[] type");
        }
        int padding = 4 - input.length % 4;
        if (padding != 4) {
            ret = String.valueOf(ret) + (char)(48 + padding);
        }
        int i = 0;
        while (i < input.length - (4 - padding)) {
            int hexaDigit = (input[i] ? 8 : 0) + (input[i + 1] ? 4 : 0) + (input[i + 2] ? 2 : 0) + (input[i + 3] ? 1 : 0);
            ret = String.valueOf(ret) + (char)(65 + hexaDigit);
            i += 4;
        }
        if (padding < 4) {
            int hexaDigit = 0;
            switch (padding) {
                case 1: {
                    hexaDigit += input[input.length + padding - 2] ? 2 : 0;
                }
                case 2: {
                    hexaDigit += input[input.length + padding - 3] ? 4 : 0;
                }
                case 3: {
                    hexaDigit += input[input.length + padding - 4] ? 8 : 0;
                }
            }
            ret = String.valueOf(ret) + (char)(65 + hexaDigit);
        }
        return ret;
    }

    public int[] createIntArrayFromString(EDataType eDataType, String initialValue) {
        int length = initialValue.length() / 8;
        if (initialValue.length() % 8 != 0) {
            throw new UnsupportedOperationException("initialValue must be made of 8 digits for each item");
        }
        if (length < 1) {
            return null;
        }
        int[] ret = new int[length];
        int i = 0;
        while (i < initialValue.length()) {
            int j = 0;
            int d = 28;
            while (j < 8) {
                int n = i / 8;
                ret[n] = ret[n] + (initialValue.charAt(i + j) - 65 << d);
                ++j;
                d -= 4;
            }
            i += 8;
        }
        return ret;
    }

    public String convertIntArrayToString(EDataType eDataType, Object instanceValue) {
        int[] input;
        String ret = "";
        try {
            input = (int[])instanceValue;
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException("instanceValue must be of int[] type");
        }
        int i = 0;
        while (i < input.length) {
            int value = input[i];
            int j = 0;
            while (j < 8) {
                ret = String.valueOf(ret) + (char)(65 + ((value & 0x70000000) >> 28 | (value < 0 ? 8 : 0)));
                value = (value & 0xFFFFFFF) << 4;
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public double[] createDoubleArrayFromString(EDataType eDataType, String initialValue) {
        double[] ret = null;
        int index = 0;
        index = 0;
        while (index < initialValue.length() && initialValue.charAt(index) != '#') {
            ++index;
        }
        int length = Integer.parseInt(initialValue.substring(0, index), 16);
        ret = new double[length];
        int start = index + 1;
        int i = 0;
        while (i < length) {
            ++index;
            while (index < initialValue.length() && initialValue.charAt(index) != ':') {
                ++index;
            }
            if (index != start) {
                try {
                    ret[i] = Double.longBitsToDouble(Long.parseLong(initialValue.substring(start, index), 16));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new UnsupportedOperationException("String " + initialValue.substring(start, index) + " is not a long");
                }
                start = index + 1;
            }
            ++i;
        }
        return ret;
    }

    public String convertDoubleArrayToString(EDataType eDataType, Object instanceValue) {
        double[] input;
        StringBuffer ret = new StringBuffer();
        try {
            input = (double[])instanceValue;
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException("instanceValue must be of double[] type");
        }
        ret.append(Integer.toHexString(input.length));
        String prefix = "#";
        String sign = "";
        int i = 0;
        while (i < input.length) {
            long longBits = Double.doubleToRawLongBits(input[i]);
            if (longBits < 0L) {
                sign = "-";
                longBits = -longBits;
            } else {
                sign = "";
            }
            ret.append(String.valueOf(prefix) + sign + Long.toHexString(longBits));
            prefix = ":";
            ++i;
        }
        return ret.toString();
    }

    @Override
    public HierarchyPackage getHierarchyPackage() {
        return (HierarchyPackage)this.getEPackage();
    }

    @Deprecated
    public static HierarchyPackage getPackage() {
        return HierarchyPackage.eINSTANCE;
    }
}

