/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class HierarchyAdaptersFactory
implements IAdapterFactory {
    protected Class[] adapterList = new Class[]{ResourceMapping.class, IResource.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        Notifier notifier;
        if (adaptableObject instanceof EObject) {
            EObject eObject = (EObject)adaptableObject;
            return HierarchyAdaptersFactory.getAdapter(eObject, adapterType);
        }
        if (adaptableObject instanceof AdapterImpl && (notifier = ((AdapterImpl)adaptableObject).getTarget()) instanceof EObject) {
            return HierarchyAdaptersFactory.getAdapter((EObject)notifier, adapterType);
        }
        return null;
    }

    public static Object getAdapter(EObject eObject, Class adapterType) {
        if (adapterType == ResourceMapping.class) {
            return HierarchyAdaptersFactory.createHierarchyResourceMapping(eObject);
        }
        if (adapterType == IResource.class) {
            return HierarchyAdaptersFactory.getPlatformResource(eObject);
        }
        return null;
    }

    public static HierarchyResourceMapping createHierarchyResourceMapping(EObject adaptableObject) {
        return new HierarchyResourceMapping(adaptableObject);
    }

    public static IResource getPlatformResource(EObject eObject) {
        if (eObject != null) {
            return ResourcesPlugin.getWorkspace().getRoot().findMember(EcoreUtil.getURI((EObject)eObject).trimFragment().toString().replaceFirst("platform:/resource", ""));
        }
        return null;
    }

    public static IProject getPlatformProject(EObject eObject) {
        if (eObject != null) {
            try {
                return ResourcesPlugin.getWorkspace().getRoot().getProject(EcoreUtil.getURI((EObject)eObject).segment(1));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
        return null;
    }

    public Class[] getAdapterList() {
        return this.adapterList;
    }

    public static class HierarchyResourceMapping
    extends ResourceMapping {
        protected final EObject modelObject;

        protected HierarchyResourceMapping(EObject unit) {
            Assert.isNotNull((Object)unit);
            this.modelObject = unit;
        }

        public Object getModelObject() {
            return this.modelObject;
        }

        public IProject[] getProjects() {
            IProject project = HierarchyAdaptersFactory.getPlatformProject(this.modelObject);
            if (project != null) {
                return new IProject[]{project};
            }
            return new IProject[0];
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            IResource resource = HierarchyAdaptersFactory.getPlatformResource(this.modelObject);
            if (resource != null) {
                return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{resource}, 1, 0)};
            }
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[0], 1, 0)};
        }

        public String getModelProviderId() {
            return "org.eclipse.tptp.platform.models.hierarchy";
        }
    }
}

