/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceFactoryImpl;
import org.eclipse.hyades.models.hierarchy.util.HierarchyURIConverterImpl;
import org.eclipse.hyades.models.hierarchy.util.HyadesExtendedResourceFactory;
import org.eclipse.hyades.models.hierarchy.util.IUnresolvedResourceHelper;
import org.eclipse.hyades.models.hierarchy.util.internal.SessionManagerWrapper;

public class HierarchyResourceSetImpl
extends ResourceSetImpl {
    protected static HierarchyResourceSetImpl instance;
    protected IUnresolvedResourceHelper helper;

    protected HierarchyResourceSetImpl() {
    }

    public static ResourceSet getInstance(String sessionID) {
        if (sessionID != null) {
            return SessionManagerWrapper.instance().getResourceSet(sessionID);
        }
        return HierarchyResourceSetImpl.getInstance();
    }

    public static HierarchyResourceSetImpl getInstance() {
        if (instance == null) {
            instance = new HierarchyResourceSetImpl();
            instance.setURIConverter((URIConverter)new HierarchyURIConverterImpl());
            HierarchyResourceFactoryImpl perftraceResourceFactory = new HierarchyResourceFactoryImpl();
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trcmxmi", perftraceResourceFactory);
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trcnxmi", perftraceResourceFactory);
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trcpxmi", perftraceResourceFactory);
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trcaxmi", perftraceResourceFactory);
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("corrxmi", perftraceResourceFactory);
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trclxmi", perftraceResourceFactory);
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trciovxmi", perftraceResourceFactory);
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trcdbxmi", perftraceResourceFactory);
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trcadb", new HyadesExtendedResourceFactory());
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("corrdb", new HyadesExtendedResourceFactory());
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("symptomdb", new HyadesExtendedResourceFactory());
        }
        return instance;
    }

    public EObject getObjectAndLoad(URI uri) throws WrappedException {
        EObject obj = null;
        try {
            obj = super.getEObject(uri, true);
        }
        catch (WrappedException e) {
            if (this.helper != null) {
                this.helper.uriException(uri, (Exception)((Object)e));
            }
            throw e;
        }
        return obj;
    }

    public IUnresolvedResourceHelper getUnresolvedException() {
        return this.helper;
    }

    public void setUnresolvedResourceHelper(IUnresolvedResourceHelper helper) {
        this.helper = helper;
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        Resource resource;
        Map map = this.getURIResourceMap();
        if (map != null && (resource = (Resource)map.get(uri)) != null) {
            if (loadOnDemand && !resource.isLoaded()) {
                this.demandLoadHelper(resource);
            }
            return resource;
        }
        URIConverter theURIConverter = this.getURIConverter();
        URI normalizedURI = theURIConverter.normalize(uri);
        EList res = this.getResources();
        for (Resource resource2 : res) {
            if (resource2 == null || !theURIConverter.normalize(resource2.getURI()).equals((Object)normalizedURI)) continue;
            if (loadOnDemand && !resource2.isLoaded()) {
                this.demandLoadHelper(resource2);
            }
            if (map != null) {
                map.put(uri, resource2);
            }
            return resource2;
        }
        Resource delegatedResource = this.delegatedGetResource(uri, loadOnDemand);
        if (delegatedResource != null) {
            if (map != null) {
                map.put(uri, delegatedResource);
            }
            return delegatedResource;
        }
        if (loadOnDemand) {
            Resource resource2;
            resource2 = this.demandCreateResource(uri);
            if (resource2 == null) {
                throw new RuntimeException("Cannot create a resource for '" + uri + "'; a registered resource factory is needed");
            }
            this.demandLoadHelper(resource2);
            if (map != null) {
                map.put(uri, resource2);
            }
            return resource2;
        }
        return null;
    }
}

