/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.hyades.loaders.util.AgentsContext;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.loaders.util.ResourceExtensions;
import org.eclipse.hyades.loaders.util.XMLResourceLoader;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation;
import org.eclipse.hyades.models.hierarchy.plugin.ModelsHierarchyPlugin;
import org.eclipse.hyades.models.hierarchy.util.ContainmentTraverser;
import org.eclipse.hyades.models.hierarchy.util.EMFUtil;
import org.eclipse.hyades.models.hierarchy.util.EObjectVisitor;
import org.eclipse.hyades.models.hierarchy.util.HierarchyXMISaveImpl;
import org.eclipse.hyades.models.hierarchy.util.IHyadesExtendedResource;
import org.eclipse.hyades.models.hierarchy.util.IntToObjectMap;
import org.eclipse.hyades.models.hierarchy.util.ObjectToIntMap;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.models.hierarchy.util.internal.IntToObjectMapImpl;
import org.eclipse.hyades.models.hierarchy.util.internal.ObjectToIntMapImpl;
import org.eclipse.hyades.models.util.ModelDebugger;

public class HierarchyXMIResourceImpl
extends XMIResourceImpl
implements XMIResource,
IHyadesExtendedResource {
    public static final int INDEX_WATERMARK = 10000;
    protected HierarchyContext context = null;
    protected boolean register = true;
    protected ArrayList intAndStrList = new ArrayList(10000);
    protected InversedStringBuffer result = new InversedStringBuffer(2000);
    protected IntToObjectMap objectIndexes;

    public HierarchyXMIResourceImpl() {
        this.initHierarchyResource();
    }

    public HierarchyXMIResourceImpl(URI uri) {
        super(uri);
        this.initHierarchyResource();
    }

    public String getIndexStr(int index) {
        int size = this.intAndStrList.size();
        if (index >= size) {
            this.intAndStrList.ensureCapacity(index + 1);
            int i = size;
            while (i < index) {
                this.intAndStrList.add(i, null);
                ++i;
            }
            String indexStr = Integer.toString(index);
            this.intAndStrList.add(index, indexStr);
            return indexStr;
        }
        if (this.intAndStrList.get(index) == null) {
            String indexStr = Integer.toString(index);
            this.intAndStrList.set(index, indexStr);
            return indexStr;
        }
        return (String)this.intAndStrList.get(index);
    }

    public String getURIFragment(EObject eObject) {
        String id = EcoreUtil.getID((EObject)eObject);
        if (id != null) {
            return id;
        }
        this.result.setLength(0);
        EObject container = eObject.eContainer();
        while (container != null) {
            EReference eStructuralFeature = eObject.eContainmentFeature();
            if (eStructuralFeature.isMany()) {
                EList eList = (EList)container.eGet((EStructuralFeature)eStructuralFeature, false);
                if (this.objectIndexes == null || this.objectIndexes.isEmpty()) {
                    int index = eList.indexOf((Object)eObject);
                    if (index < 10000) {
                        this.result.prepend(this.getIndexStr(index));
                    } else {
                        this.result.prepend(index);
                    }
                } else {
                    this.addIndex(eList, eObject, this.getListKey(container, (EStructuralFeature)eStructuralFeature));
                }
                this.result.prepend('.');
                this.result.prepend(eStructuralFeature.getName());
                this.result.prepend('@');
            } else {
                this.result.prepend(eStructuralFeature.getName());
                this.result.prepend('@');
            }
            this.result.prepend('/');
            eObject = container;
            container = eObject.eContainer();
        }
        this.result.prepend(this.getURIFragmentRootSegment(eObject));
        this.result.prepend('/');
        return this.result.toString();
    }

    protected void addIndex(EList list, EObject object, int listKey) {
        if (list.size() < 10000) {
            int index = list.indexOf((Object)object);
            this.result.prepend(this.getIndexStr(index));
            return;
        }
        ObjectToIntMap objects = (ObjectToIntMap)this.objectIndexes.get(listKey);
        if (objects == null) {
            objects = new ObjectToIntMapImpl(list.size());
            this.objectIndexes.put(list, objects);
            int index = list.indexOf((Object)object);
            objects.put(object, index);
            if (index < 10000) {
                this.result.prepend(this.getIndexStr(index));
            } else {
                this.result.prepend(index);
            }
        } else {
            int index = objects.getInt(object);
            if (index == -1) {
                index = list.indexOf((Object)object);
                objects.put(object, index);
                if (index < 10000) {
                    this.result.prepend(this.getIndexStr(index));
                } else {
                    this.result.prepend(index);
                }
            } else {
                this.result.prepend(index);
            }
        }
    }

    protected void putIndex(EList list, EObject object, int index, int key) {
        ObjectToIntMap objects = (ObjectToIntMap)this.objectIndexes.get(key);
        if (objects == null) {
            objects = new ObjectToIntMapImpl(list.size());
            this.objectIndexes.put(key, objects);
        }
        objects.put(object, index);
    }

    protected int getListKey(EObject container, EStructuralFeature structuralFeature) {
        int hashCode = 31 + container.hashCode();
        hashCode = 31 * hashCode + structuralFeature.hashCode();
        return hashCode;
    }

    public void attached(EObject value) {
        if (this.register) {
            LookupServiceExtensions.getInstance().register(this.getContext(value), value);
        }
    }

    public void detached(EObject value) {
        LookupServiceExtensions.getInstance().deregister(this.getContext(value), value);
    }

    public void doLoad(InputStream inputStream, Map options) throws IOException {
        PerfUtil p = PerfUtil.createInstance("HierarchyXMIResourceImpl.doLoad() uri=" + this.getURI(), true);
        try {
            this.register = false;
            super.doLoad(inputStream, options);
            ContainmentTraverser containmentTraverser = new ContainmentTraverser((Collection)this.getContents());
            EObjectVisitor objectVisitor = new EObjectVisitor(){

                public boolean afterChildren(EObject element) {
                    return true;
                }

                public boolean beforeChildren(EObject element) {
                    LookupServiceExtensions.getInstance().register(HierarchyXMIResourceImpl.this.getContext(element), element);
                    return true;
                }
            };
            containmentTraverser.registerVisitors(objectVisitor);
            containmentTraverser.traverse();
            this.register = true;
        }
        catch (IOException e) {
            p.stopAndPrintStatus(e.getLocalizedMessage());
            throw e;
        }
        if (ModelDebugger.INSTANCE.debug) {
            p.stopAndPrintStatus(Arrays.asList(new Throwable().getStackTrace()).toString());
        } else {
            p.stopAndPrintStatus();
        }
    }

    public void doShallowDelete() {
        this.unloadLookupContext();
        for (Resource res : EMFUtil.delete(this)) {
            if (res == null) continue;
            res.setModified(true);
        }
        if (this.context != null && this.context.getAgentProxy() != null) {
            this.context.getAgentProxy().setAgent(null);
        }
        if (this.context != null) {
            this.context.cleanUp();
            this.context = null;
        }
    }

    public void doShallowUnload() {
        this.unloadLookupContext();
        EMFUtil.unload(this);
        if (this.context != null) {
            this.context.cleanUp();
            this.context = null;
        }
    }

    protected HierarchyContext getContext(EObject object) {
        if (this.context == null && object instanceof TRCAgent) {
            this.context = (HierarchyContext)LookupServiceExtensions.getInstance().locate(null, HierarchyContext.class, this.getURI().toString());
            if (this.context == null) {
                this.context = new HierarchyContext();
            }
            TRCAgent agent = (TRCAgent)object;
            AgentsContext agentsContext = (AgentsContext)LookupServiceExtensions.getInstance().locate(null, AgentsContext.class, LoadersUtils.getLookUpKey(agent.getRuntimeId()));
            if (agentsContext == null) {
                agentsContext = new AgentsContext(agent.getRuntimeId());
                LookupServiceExtensions.getInstance().register(null, agentsContext);
            }
            agentsContext.registerAgent(agent);
            this.context.setAgent(agent);
            this.context.setContextURI(this.getURI().toString());
            LookupServiceExtensions.getInstance().register(null, this.context);
            return null;
        }
        if (object instanceof UnresolvedCorrelation) {
            return null;
        }
        return this.context;
    }

    protected XMLLoad createXMLLoad() {
        XMLResourceLoader resourceLoader = null;
        try {
            resourceLoader = (XMLResourceLoader)ResourceExtensions.getInstance().get(this.getURI().fileExtension());
            if (resourceLoader != null) {
                resourceLoader = (XMLResourceLoader)resourceLoader.getClass().newInstance();
                resourceLoader.setXMLHelper(this.createXMLHelper());
            }
        }
        catch (Exception e) {
            ModelsHierarchyPlugin.log(e.getLocalizedMessage());
        }
        if (resourceLoader == null) {
            return super.createXMLLoad();
        }
        return resourceLoader;
    }

    protected XMLSave createXMLSave() {
        return new HierarchyXMISaveImpl(this.createXMLHelper());
    }

    protected void doUnload() {
        PerfUtil p = PerfUtil.createInstance("HierarchyXMIResourceImpl.doUnload() uri=" + this.getURI(), true);
        this.doShallowUnload();
        p.stopAndPrintStatus();
    }

    public void doSave(OutputStream outputStream, Map options) throws IOException {
        PerfUtil p = PerfUtil.createInstance("HierarchyXMIResourceImpl.doSave() uri=" + this.getURI(), true);
        try {
            this.objectIndexes = new IntToObjectMapImpl();
            this.buildObjectsMap();
            if (this.objectIndexes.isEmpty()) {
                this.objectIndexes = null;
            }
            super.doSave(outputStream, options);
            this.objectIndexes = null;
        }
        catch (IOException e) {
            p.stopAndPrintStatus(e.getLocalizedMessage());
            throw e;
        }
        p.stopAndPrintStatus();
    }

    protected void buildObjectsMap() {
        PerfUtil p = PerfUtil.createInstance("HierarchyXMIResourceImpl.buildObjectsMap() uri=" + this.getURI(), true);
        try {
            int i = this.getContents().size();
            while (i-- > 0) {
                EObject child = (EObject)this.getContents().get(i);
                this.traverseContaintment(child);
            }
        }
        catch (Exception e) {
            ModelDebugger.log(e, "HierarchyXMIResourceImpl.buildObjectsMap()");
        }
        p.stopAndPrintStatus("objectIndexes.size()=" + this.objectIndexes.size());
    }

    protected void traverseContaintment(EObject object) {
        if (object == null) {
            return;
        }
        for (EReference ref : object.eClass().getEAllContainments()) {
            if (ref.isTransient()) continue;
            if (ref.isMany()) {
                EList list = (EList)object.eGet((EStructuralFeature)ref, true);
                if (list.size() < 10000) {
                    int i = list.size();
                    while (i-- > 0) {
                        EObject child = (EObject)list.get(i);
                        this.traverseContaintment(child);
                    }
                    continue;
                }
                int lenght = list.size();
                int i = 0;
                while (i < lenght) {
                    EObject child = (EObject)list.get(i);
                    this.putIndex(list, child, i, this.getListKey(object, (EStructuralFeature)ref));
                    this.traverseContaintment(child);
                    ++i;
                }
                continue;
            }
            EObject child = (EObject)object.eGet((EStructuralFeature)ref, true);
            this.traverseContaintment(child);
        }
    }

    protected void unloadLookupContext() {
        if (this.context != null) {
            if (this.context.getAgent() != null) {
                TRCAgent agent = this.context.getAgent();
                AgentsContext agentsContext = (AgentsContext)LookupServiceExtensions.getInstance().locate(null, AgentsContext.class, LoadersUtils.getLookUpKey(agent.getRuntimeId()));
                if (agentsContext != null) {
                    agentsContext.deregisterAgent(agent);
                }
                if ((agentsContext = (AgentsContext)LookupServiceExtensions.getInstance().locate(null, AgentsContext.class, LoadersUtils.getLookUpKey(null))) != null) {
                    agentsContext.deregisterAgent(agent);
                }
                this.deregisterContents((List)this.getContents());
            }
            LookupServiceExtensions.getInstance().deregister(this.context);
            LookupServiceExtensions.getInstance().deregister(null, HierarchyContext.class, this.getURI().toString());
        }
    }

    protected void deregisterContents(List l) {
        ContainmentTraverser containmentTraverser = new ContainmentTraverser(l);
        EObjectVisitor objectVisitor = new EObjectVisitor(){

            public boolean afterChildren(EObject element) {
                LookupServiceExtensions.getInstance().deregister(HierarchyXMIResourceImpl.this.context, element);
                return true;
            }

            public boolean beforeChildren(EObject element) {
                return true;
            }
        };
        containmentTraverser.registerVisitors(objectVisitor);
        containmentTraverser.traverse();
    }

    protected void initHierarchyResource() {
        int i = 0;
        while (i < 10000) {
            this.intAndStrList.add(i, null);
            ++i;
        }
    }

    public boolean delete() {
        PerfUtil p = PerfUtil.createInstance("HierarchyXMIResourceImpl.delete() uri=" + this.getURI(), true);
        this.doShallowDelete();
        p.stopAndPrintStatus();
        return true;
    }

    public boolean deleteObjects(EList uris) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public boolean unloadObjects(EList uris) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public static class InversedStringBuffer {
        int startOffset;
        int length;
        char[] data;

        public void setLength(int i) {
            this.startOffset = this.data.length;
            this.length = 0;
        }

        public void prepend(String value) {
            if (value == null || value.length() == 0) {
                return;
            }
            this.length += value.length();
            this.startOffset -= value.length();
            value.getChars(0, value.length(), this.data, this.startOffset);
        }

        public void prepend(int value) {
            this.prepend(Integer.toString(value));
        }

        public void prepend(char value) {
            ++this.length;
            --this.startOffset;
            this.data[this.startOffset] = value;
        }

        public InversedStringBuffer(int size) {
            this.data = new char[size];
        }

        public String toString() {
            if (this.length > 0) {
                return new String(this.data, this.startOffset, this.length);
            }
            return "";
        }
    }
}

