/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.util.HierarchyURIConverterImpl;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;
import org.eclipse.hyades.models.util.ModelDebugger;

public class HyadesExtendedResourceFactory
extends ResourceFactoryImpl {
    public Resource createResource(URI uri) {
        ArrayList<EClass> notLoaded = new ArrayList<EClass>();
        notLoaded.add(HierarchyPackage.eINSTANCE.getTRCAgentProxy());
        Properties p = HyadesExtendedResourceFactory.getPropertiesFromURI(uri);
        if (p != null) {
            return HyadesResourceExtensions.getInstance().createResource(uri, p, notLoaded);
        }
        String storeType = ((IHyadesResourceExtension)HyadesResourceExtensions.getInstance().get(LoadersUtils.getPostfix(uri.toString()))).getStoreType(LoadersUtils.getPostfix(uri.toString()));
        p = HyadesResourceExtensions.getInstance().getProperties(storeType);
        if (p == null) {
            p = HyadesResourceExtensions.getInstance().getProperties();
        }
        HyadesExtendedResourceFactory.savePropertiesToURI(uri, p);
        return HyadesResourceExtensions.getInstance().createResource(uri, p, notLoaded);
    }

    public static Properties getPropertiesFromURI(URI uri) {
        HierarchyURIConverterImpl c = new HierarchyURIConverterImpl();
        try {
            InputStream s = c.createInputStream(uri);
            Properties p = new Properties();
            p.load(s);
            String pass = p.getProperty("password");
            if (pass != null && pass.length() > 0) {
                pass = LoadersUtils.restorePassword(pass);
                p.setProperty("password", pass);
            }
            s.close();
            return p;
        }
        catch (IOException e) {
            if (ModelDebugger.INSTANCE.debug) {
                ModelDebugger.log(e);
            }
            return null;
        }
    }

    public static void savePropertiesToURI(URI uri, Properties p) {
        block4: {
            HierarchyURIConverterImpl c = new HierarchyURIConverterImpl();
            try {
                OutputStream s = c.createOutputStream(uri);
                String pass = p.getProperty("password");
                if (pass != null && pass.length() > 0) {
                    String e_pass = LoadersUtils.scramblePassword(pass);
                    p.setProperty("password", e_pass);
                }
                p.store(s, "DBInfo");
                if (pass != null && pass.length() > 0) {
                    p.setProperty("password", pass);
                }
                s.close();
            }
            catch (IOException e) {
                if (!ModelDebugger.INSTANCE.debug) break block4;
                ModelDebugger.log(e);
            }
        }
    }
}

