/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.io.IOException;
import java.io.InputStream;

public abstract class MonitoredInputStream
extends InputStream {
    InputStream delegateInputStream;

    public MonitoredInputStream(InputStream delegateInputStream) {
        this.delegateInputStream = delegateInputStream;
    }

    public synchronized int available() throws IOException {
        if (this.isCanceled()) {
            return 0;
        }
        return super.available();
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.isCanceled()) {
            return -1;
        }
        len = this.beforeRead(len);
        int readBytes = this.delegateInputStream.read(b, off, len);
        return this.afterRead(readBytes);
    }

    protected int beforeRead(int maxBytesToRead) {
        return maxBytesToRead;
    }

    protected int afterRead(int readBytes) {
        return readBytes;
    }

    protected boolean isCanceled() {
        return false;
    }

    public int read() throws IOException {
        if (this.isCanceled()) {
            return -1;
        }
        this.beforeRead(1);
        int ret = this.delegateInputStream.read();
        this.afterRead(1);
        return ret;
    }

    public void close() throws IOException {
        this.delegateInputStream.close();
    }

    public synchronized void mark(int readlimit) {
        this.delegateInputStream.mark(readlimit);
    }

    public boolean markSupported() {
        return this.delegateInputStream.markSupported();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public synchronized void reset() throws IOException {
        this.delegateInputStream.reset();
    }

    public long skip(long n) throws IOException {
        return this.delegateInputStream.skip(n);
    }
}

