/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util.internal;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;

public class EMFWorkspaceUtil {
    public static final String PLATFORM_PROTOCOL = "platform";
    public static final String PLATFORM_RESOURCE = "resource";

    public static boolean isPlatformResourceURI(URI uri) {
        return PLATFORM_PROTOCOL.equals(uri.scheme()) && PLATFORM_RESOURCE.equals(uri.segment(0));
    }

    public static boolean exists(URI uri) {
        File file = EMFWorkspaceUtil.getFileFromURI(uri);
        return file.exists();
    }

    public static String getPlatformResourcePathFromPlatformURI(URI uri) {
        String scheme = uri.scheme();
        StringBuffer platformResourcePath = new StringBuffer();
        if (PLATFORM_PROTOCOL.equals(scheme) && uri.segmentCount() > 1 && PLATFORM_RESOURCE.equals(uri.segment(0))) {
            int i = 1;
            int size = uri.segmentCount();
            while (i < size) {
                platformResourcePath.append('/');
                platformResourcePath.append(URI.decode((String)uri.segment(i)));
                ++i;
            }
        }
        return platformResourcePath.toString();
    }

    public static File getFileFromURI(URI uri) {
        File file = null;
        if (EMFWorkspaceUtil.isPlatformResourceURI(uri)) {
            IPath path;
            String platformResourcePath = EMFWorkspaceUtil.getPlatformResourcePathFromPlatformURI(uri);
            IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourcePath));
            if (ifile != null && (path = ifile.getLocation()) != null) {
                file = ifile.getLocation().toFile();
            }
        } else {
            file = EMFWorkspaceUtil.getFileFromFileURI(uri);
        }
        return file;
    }

    protected static File getFileFromFileURI(URI uri) {
        File file = new File(uri.toFileString().substring("file:".length()));
        return file;
    }

    public static void refreshLocal(URI uri) throws IOException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFile((IPath)new Path(EMFWorkspaceUtil.getPlatformResourcePathFromPlatformURI(uri)));
        if (file != null) {
            try {
                file.refreshLocal(0, null);
            }
            catch (CoreException e) {
                IOException ex = new IOException();
                ex.initCause(e);
                throw ex;
            }
        }
    }
}

