/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.hyades.models.hierarchy.util.IntToObjectMap;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.models.hierarchy.util.internal.SizesAsPrimes;
import org.eclipse.hyades.models.util.ModelDebugger;

public class IntToObjectMapImpl
implements IntToObjectMap {
    protected static final float GROWTH_FACTOR = 1.25f;
    public static final int MASK = Integer.MAX_VALUE;
    protected PerfUtil p = PerfUtil.createInstance();
    protected int elementSize;
    protected int getIterations;
    protected int putIterations;
    protected int[] keyTable;
    protected int threshold;
    protected int sizeIndex = -1;
    protected Object[] valueTable;

    public static void main(String[] args) {
        int nrKeys = 25;
        IntToObjectMapImpl intMap = new IntToObjectMapImpl();
        int i = 1;
        while (i <= nrKeys) {
            try {
                intMap.put(i, (Object)new Integer(i));
            }
            catch (Exception e) {
                System.out.println("i=" + i);
                e.printStackTrace();
                System.exit(-1);
            }
            ++i;
        }
        System.out.println(intMap);
        intMap.remove(10);
        intMap.remove(5);
        System.out.println(intMap);
        System.out.println("List keys:");
        i = 1;
        while (i <= nrKeys) {
            try {
                System.out.println(String.valueOf(i) + " -> " + intMap.get(i));
                System.out.println(String.valueOf(i) + " -> " + intMap.get(new Integer(i)));
            }
            catch (Exception e) {
                System.out.println("i=" + i);
                e.printStackTrace();
                System.exit(-1);
            }
            ++i;
        }
        intMap.put(new Integer(10), new Integer(10));
        intMap.put(new Integer(5), new Integer(5));
        System.out.println(intMap);
        Set set = intMap.entrySet();
        System.out.println("List entrySet.size=" + set.size() + ", entries:");
        for (Map.Entry element : set) {
            System.out.println(element.getKey() + " -> " + element.getValue());
        }
        set = intMap.keySet();
        System.out.println("List keySet.size=" + set.size() + ", entries:");
        for (Map.Entry element : set) {
            System.out.println(element + " -> " + intMap.get(element));
            System.out.println(String.valueOf(((Object)element).hashCode()) + " -> " + intMap.get(((Object)element).hashCode()));
        }
        intMap.clear();
        nrKeys = 10000000;
        PerfUtil p = PerfUtil.createInstance();
        p.setDebug(true);
        p.setMessageAndStart("IntToObjectMap generate nrKeys=" + nrKeys);
        Integer[] keys = new Integer[nrKeys + 1];
        int i2 = nrKeys + 1;
        while (i2-- > 1) {
            keys[i2] = new Integer(i2);
        }
        p.stopAndPrintStatus();
        int j = 0;
        while (j < 10) {
            System.gc();
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            System.out.println("IntToObjectMapImpl.main() - j=" + j);
            p.setMessageAndStart("IntToObjectMap add int descending nrKeys=" + nrKeys);
            int i3 = nrKeys + 1;
            while (i3-- > 1) {
                intMap.put(i3, (Object)keys[i3]);
                if (nrKeys - i3 + 1 == intMap.size()) continue;
                System.out.println("Error at key=" + i3);
            }
            p.stopAndPrintStatus("keyTable.length=" + intMap.getKeys().length);
            intMap.clear();
            p.setMessageAndStart("IntToObjectMap add int ascending nrKeys=" + nrKeys);
            ++nrKeys;
            i3 = 1;
            while (i3 < nrKeys) {
                intMap.put(i3, (Object)keys[i3]);
                ++i3;
            }
            p.stopAndPrintStatus("keyTable.length=" + intMap.getKeys().length);
            p.setMessageAndStart("IntToObjectMap get int descending nrKeys=" + --nrKeys);
            i3 = nrKeys + 1;
            while (i3-- > 1) {
                Object v = intMap.get(i3);
                try {
                    if (v != null && (Integer)v == i3) continue;
                    System.out.println("Invalid entry at: " + i3);
                }
                catch (Exception e) {
                    System.err.println("Invalid entry at: " + i3);
                    e.printStackTrace();
                }
            }
            p.stopAndPrintStatus("keyTable.length=" + intMap.getKeys().length);
            p.setMessageAndStart("IntToObjectMap remove and compact int descending nrKeys=" + nrKeys);
            i3 = nrKeys + 1;
            while (i3-- > 1) {
                intMap.remove(i3);
            }
            intMap.compact();
            p.stopAndPrintStatus("keyTable.length=" + intMap.getKeys().length);
            HashMap<Integer, Integer> hMap = new HashMap<Integer, Integer>(89);
            p.setMessageAndStart("HashMap add descending nrKeys=" + nrKeys);
            int i4 = nrKeys + 1;
            while (i4-- > 1) {
                hMap.put(keys[i4], keys[i4]);
            }
            p.stopAndPrintStatus();
            hMap.clear();
            p.setMessageAndStart("HashMap add ascending nrKeys=" + nrKeys);
            ++nrKeys;
            i4 = 1;
            while (i4 < nrKeys) {
                hMap.put(keys[i4], keys[i4]);
                ++i4;
            }
            p.stopAndPrintStatus();
            p.setMessageAndStart("HashMap get descending nrKeys=" + --nrKeys);
            i4 = nrKeys + 1;
            while (i4-- > 1) {
                hMap.get(keys[i4]);
            }
            p.stopAndPrintStatus();
            p.setMessageAndStart("HashMap remove descending nrKeys=" + nrKeys);
            i4 = nrKeys + 1;
            while (i4-- > 1) {
                hMap.remove(keys[i4]);
            }
            p.stopAndPrintStatus();
            p.setMessageAndStart("IntToObjectMap add object descending nrKeys=" + nrKeys);
            i4 = nrKeys + 1;
            while (i4-- > 1) {
                intMap.put(keys[i4], keys[i4]);
            }
            p.stopAndPrintStatus("keyTable.length=" + intMap.getKeys().length);
            intMap.clear();
            p.setMessageAndStart("IntToObjectMap add object ascending nrKeys=" + nrKeys);
            ++nrKeys;
            i4 = 1;
            while (i4 < nrKeys) {
                intMap.put(keys[i4], keys[i4]);
                ++i4;
            }
            p.stopAndPrintStatus();
            p.setMessageAndStart("IntToObjectMap get object descending nrKeys=" + --nrKeys);
            i4 = nrKeys + 1;
            while (i4-- > 1) {
                intMap.get(keys[i4]);
            }
            p.stopAndPrintStatus("keyTable.length=" + intMap.getKeys().length);
            p.setMessageAndStart("IntToObjectMap remove and compact object descending nrKeys=" + nrKeys);
            i4 = nrKeys + 1;
            while (i4-- > 1) {
                intMap.remove(keys[i4]);
            }
            intMap.compact();
            p.stopAndPrintStatus("keyTable.length=" + intMap.getKeys().length);
            ++j;
        }
    }

    public IntToObjectMapImpl() {
        this.init(13);
    }

    public IntToObjectMapImpl(int size) {
        this.init(size);
    }

    public void clear() {
        this.init(13);
    }

    public int compact() {
        int[] kt = this.keyTable;
        Object[] vt = this.valueTable;
        int newElementSize = 0;
        int i = kt.length;
        while (i-- > 0) {
            if (kt[i] == 0 || vt[i] == MISSING_VALUE) continue;
            ++newElementSize;
        }
        this.elementSize = newElementSize;
        this.rehash();
        return newElementSize;
    }

    protected int computeNewSize(int size) {
        int extraRoom = (int)((float)size * 1.25f);
        if (this.threshold == extraRoom) {
            ++extraRoom;
        }
        extraRoom = SizesAsPrimes.getSize(1.25f, extraRoom);
        return extraRoom;
    }

    public boolean containsKey(int key) {
        int index;
        if (key == 0) {
            --key;
        }
        return (index = this.getIndex(key)) != -1;
    }

    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        return this.containsKey(key.hashCode());
    }

    public boolean containsValue(Object value) {
        if (value == MISSING_VALUE) {
            return false;
        }
        int[] kt = this.keyTable;
        Object[] vt = this.valueTable;
        int i = vt.length;
        while (i-- > 0) {
            if (kt[i] == 0 || vt[i] != value) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        HashSet<1> entries = new HashSet<1>();
        int i = 0;
        while (i < this.keyTable.length) {
            if (this.keyTable[i] != 0) {
                final int currentKey = this.keyTable[i];
                Map.Entry entry = new Map.Entry(){
                    Object key;
                    Object value;

                    public Object getKey() {
                        return this.key;
                    }

                    public Object getValue() {
                        return this.value;
                    }

                    public Object setValue(Object value) {
                        if (this.key != null) {
                            throw new UnsupportedOperationException();
                        }
                        this.value = value;
                        this.key = new Integer(currentKey);
                        return value;
                    }
                };
                entry.setValue(this.valueTable[i]);
                entries.add(entry);
            }
            ++i;
        }
        return entries;
    }

    public Object get(int key) {
        int index;
        if (key == 0) {
            --key;
        }
        if ((index = this.getIndex(key)) != -1) {
            return this.valueTable[index];
        }
        return MISSING_VALUE;
    }

    public Object get(Object key) {
        if (key == null) {
            return MISSING_VALUE;
        }
        return this.get(key.hashCode());
    }

    protected int getFreeSpot(int key, int[] kt) {
        int currentKey;
        int length = kt.length;
        int index = (key & Integer.MAX_VALUE) % length;
        while ((currentKey = kt[index]) != 0) {
            if (currentKey == key) {
                return -index;
            }
            index = (index + 1) % length;
            ++this.putIterations;
        }
        return index;
    }

    protected int getIndex(int key) {
        int currentKey;
        int[] kt = this.keyTable;
        int length = kt.length;
        int index = (key & Integer.MAX_VALUE) % length;
        while ((currentKey = kt[index]) != 0) {
            if (currentKey == key) {
                return index;
            }
            index = (index + 1) % length;
            ++this.getIterations;
        }
        return -1;
    }

    public int[] getKeys() {
        return this.keyTable;
    }

    public Object[] getValues() {
        return this.valueTable;
    }

    protected void init(int size) {
        this.elementSize = 0;
        this.threshold = size;
        int extraRoom = this.computeNewSize(size);
        this.keyTable = new int[extraRoom];
        this.valueTable = new Object[extraRoom];
    }

    public boolean isEmpty() {
        return this.elementSize == 0;
    }

    public Set keySet() {
        HashSet<Integer> keys = new HashSet<Integer>();
        int i = 0;
        while (i < this.keyTable.length) {
            if (this.keyTable[i] != 0) {
                keys.add(new Integer(this.keyTable[i]));
            }
            ++i;
        }
        return keys;
    }

    public Object put(int key, Object value) {
        int index;
        if (key == 0) {
            --key;
        }
        if ((index = this.getFreeSpot(key, this.keyTable)) < 0) {
            index = -index;
            Object oldValue = this.valueTable[index];
            this.valueTable[index] = value;
            return oldValue;
        }
        this.keyTable[index] = key;
        Object oldValue = this.valueTable[index];
        this.valueTable[index] = value;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return oldValue;
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            return value;
        }
        return this.put(key.hashCode(), value);
    }

    public void putAll(Map t) {
        for (Map.Entry element : this.entrySet()) {
            this.put(element.getKey(), element.getValue());
        }
    }

    protected void rehash() {
        if (ModelDebugger.INSTANCE.debugCustomMaps) {
            this.p.setMessageAndStart("IntToObjectMapImpl.rehash() firstValueType=" + this.getFirstValueTypeName() + ", elementSize=" + this.elementSize + ", oldGetIterations=" + this.getIterations + ", oldPutIterations=" + this.putIterations + ", oldKeyTable.lenght=" + this.keyTable.length);
        }
        this.threshold = (int)((float)this.elementSize * 1.25f);
        int extraRoom = this.computeNewSize(this.threshold);
        this.getIterations = 0;
        this.putIterations = 0;
        this.rehash(extraRoom);
        if (ModelDebugger.INSTANCE.debugCustomMaps) {
            this.p.stopAndPrintStatus("newGetIterations=" + this.getIterations + ", newPutIterations=" + this.putIterations + ", newKeyTable.lenght=" + this.keyTable.length);
        }
        this.putIterations = 0;
        this.getIterations = 0;
    }

    protected String getFirstValueTypeName() {
        if (ModelDebugger.INSTANCE.debug) {
            int i = 0;
            while (i < this.valueTable.length) {
                if (this.valueTable[i] != MISSING_VALUE) {
                    return this.valueTable[i].getClass().getName();
                }
                ++i;
            }
            return "null";
        }
        return "";
    }

    protected void rehash(int newSize) {
        int[] oKT = this.keyTable;
        Object[] oVT = this.valueTable;
        int oL = oKT.length;
        int[] nKT = new int[newSize];
        Object[] nVT = new Object[newSize];
        int nElementSize = 0;
        int i = oL;
        while (i-- > 0) {
            if (oKT[i] == 0 || oVT[i] == MISSING_VALUE) continue;
            int o = oKT[i];
            int index = this.getFreeSpot(o, nKT);
            if (index < 0) {
                index = -index;
            }
            nKT[index] = o;
            nVT[index] = oVT[i];
            ++nElementSize;
        }
        this.elementSize = nElementSize;
        this.keyTable = nKT;
        this.valueTable = nVT;
    }

    public Object remove(int key) {
        int index;
        if (key == 0) {
            --key;
        }
        if ((index = this.getIndex(key)) != -1) {
            Object oldValue = this.valueTable[index];
            this.valueTable[index] = MISSING_VALUE;
            return oldValue;
        }
        return MISSING_VALUE;
    }

    public Object remove(Object key) {
        if (key == null) {
            return MISSING_VALUE;
        }
        return this.remove(key.hashCode());
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String s = "IntToObjectMapImpl elementSize=" + this.elementSize + ", keyTable.length=" + this.keyTable.length + ", entries:\n";
        int i = 0;
        int length = this.keyTable.length;
        while (i < length) {
            Object object;
            if (this.keyTable[i] != 0 && (object = this.valueTable[i]) != MISSING_VALUE) {
                s = String.valueOf(s) + this.keyTable[i] + " -> " + object + "\n";
            }
            ++i;
        }
        return s;
    }

    public Collection values() {
        return Arrays.asList(this.valueTable);
    }
}

