/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.hyades.models.hierarchy.util.ObjectToIntMap;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.models.hierarchy.util.internal.SizesAsPrimes;
import org.eclipse.hyades.models.util.ModelDebugger;

public class ObjectToIntMapImpl
implements ObjectToIntMap {
    protected static final float GROWTH_FACTOR = 1.25f;
    public static final int MASK = Integer.MAX_VALUE;
    protected PerfUtil p = PerfUtil.createInstance();
    protected int elementSize;
    protected int getIterations;
    protected int putIterations;
    protected Object[] keyTable;
    protected int threshold;
    protected int[] valueTable;

    public static void main(String[] args) {
        int nrKeys = 25;
        ObjectToIntMapImpl intMap = new ObjectToIntMapImpl();
        int i = 1;
        while (i <= nrKeys) {
            try {
                intMap.put((Object)new Integer(i), i);
            }
            catch (Exception e) {
                System.out.println("i=" + i);
                e.printStackTrace();
                System.exit(-1);
            }
            ++i;
        }
        System.out.println(intMap);
        intMap.remove(new Integer(10));
        intMap.remove(new Integer(5));
        System.out.println(intMap);
        System.out.println("List keys:");
        i = 1;
        while (i <= nrKeys) {
            try {
                System.out.println(String.valueOf(i) + " -> " + intMap.get(new Integer(i)));
            }
            catch (Exception e) {
                System.out.println("i=" + i);
                e.printStackTrace();
                System.exit(-1);
            }
            ++i;
        }
        intMap.put((Object)new Integer(10), 10);
        intMap.put((Object)new Integer(5), 5);
        System.out.println(intMap);
        Set set = intMap.entrySet();
        System.out.println("List entrySet.size=" + set.size() + ", entries:");
        for (Map.Entry element : set) {
            System.out.println(element.getKey() + " -> " + element.getValue());
        }
        set = intMap.keySet();
        System.out.println("List keySet.size=" + set.size() + ", entries:");
        for (Map.Entry element : set) {
            System.out.println(element + " -> " + intMap.get(element));
        }
        intMap.clear();
        nrKeys = 10000000;
        PerfUtil p = PerfUtil.createInstance();
        p.setDebug(true);
        p.setMessageAndStart("ObjectToIntMap generate nrKeys=" + nrKeys);
        Integer[] keys = new Integer[nrKeys + 1];
        int i2 = nrKeys + 1;
        while (i2-- > 1) {
            keys[i2] = new Integer(i2);
        }
        p.stopAndPrintStatus();
        int j = 0;
        while (j < 10) {
            System.gc();
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            System.out.println("ObjectToIntMapImpl.main() - j=" + j);
            p.setMessageAndStart("ObjectToIntMap add int descending nrKeys=" + nrKeys);
            int i3 = nrKeys + 1;
            while (i3-- > 1) {
                intMap.put((Object)keys[i3], i3);
                if (nrKeys - i3 + 1 == intMap.size()) continue;
                System.out.println("Error at key=" + i3);
            }
            p.stopAndPrintStatus("keyTable.length=" + intMap.getKeys().length);
            intMap.clear();
            p.setMessageAndStart("ObjectToIntMap add int ascending nrKeys=" + nrKeys);
            ++nrKeys;
            i3 = 1;
            while (i3 < nrKeys) {
                intMap.put((Object)keys[i3], i3);
                ++i3;
            }
            p.stopAndPrintStatus("keyTable.length=" + intMap.getKeys().length);
            p.setMessageAndStart("ObjectToIntMap get int descending nrKeys=" + --nrKeys);
            i3 = nrKeys + 1;
            while (i3-- > 1) {
                int v = intMap.getInt(keys[i3]);
                try {
                    if (v != -1) continue;
                    System.out.println("Invalid entry at: " + i3);
                }
                catch (Exception e) {
                    System.err.println("Invalid entry at: " + i3);
                    e.printStackTrace();
                }
            }
            p.stopAndPrintStatus("keyTable.length=" + intMap.getKeys().length);
            p.setMessageAndStart("ObjectToIntMap remove and compact int descending nrKeys=" + nrKeys);
            i3 = nrKeys + 1;
            while (i3-- > 1) {
                intMap.removeInt(keys[i3]);
            }
            intMap.compact();
            p.stopAndPrintStatus("keyTable.length=" + intMap.getKeys().length);
            HashMap<Integer, Integer> hMap = new HashMap<Integer, Integer>(89);
            p.setMessageAndStart("HashMap add descending nrKeys=" + nrKeys);
            int i4 = nrKeys + 1;
            while (i4-- > 1) {
                hMap.put(keys[i4], keys[i4]);
            }
            p.stopAndPrintStatus();
            hMap.clear();
            p.setMessageAndStart("HashMap add ascending nrKeys=" + nrKeys);
            ++nrKeys;
            i4 = 1;
            while (i4 < nrKeys) {
                hMap.put(keys[i4], keys[i4]);
                ++i4;
            }
            p.stopAndPrintStatus();
            p.setMessageAndStart("HashMap get descending nrKeys=" + --nrKeys);
            i4 = nrKeys + 1;
            while (i4-- > 1) {
                hMap.get(keys[i4]);
            }
            p.stopAndPrintStatus();
            p.setMessageAndStart("HashMap remove descending nrKeys=" + nrKeys);
            i4 = nrKeys + 1;
            while (i4-- > 1) {
                hMap.remove(keys[i4]);
            }
            p.stopAndPrintStatus();
            p.setMessageAndStart("ObjectToIntMap add object descending nrKeys=" + nrKeys);
            i4 = nrKeys + 1;
            while (i4-- > 1) {
                intMap.put(keys[i4], keys[i4]);
            }
            p.stopAndPrintStatus("keyTable.length=" + intMap.getKeys().length);
            intMap.clear();
            p.setMessageAndStart("ObjectToIntMap add object ascending nrKeys=" + nrKeys);
            ++nrKeys;
            i4 = 1;
            while (i4 < nrKeys) {
                intMap.put(keys[i4], keys[i4]);
                ++i4;
            }
            p.stopAndPrintStatus();
            p.setMessageAndStart("ObjectToIntMap get object descending nrKeys=" + --nrKeys);
            i4 = nrKeys + 1;
            while (i4-- > 1) {
                intMap.get(keys[i4]);
            }
            p.stopAndPrintStatus("keyTable.length=" + intMap.getKeys().length);
            p.setMessageAndStart("ObjectToIntMap remove and compact object descending nrKeys=" + nrKeys);
            i4 = nrKeys + 1;
            while (i4-- > 1) {
                intMap.remove(keys[i4]);
            }
            intMap.compact();
            p.stopAndPrintStatus("keyTable.length=" + intMap.getKeys().length);
            ++j;
        }
    }

    public ObjectToIntMapImpl() {
        this.init(13);
    }

    public ObjectToIntMapImpl(int size) {
        this.init(size);
    }

    public void clear() {
        this.init(13);
    }

    public int compact() {
        Object[] kt = this.keyTable;
        int[] vt = this.valueTable;
        int newElementSize = 0;
        int i = kt.length;
        while (i-- > 0) {
            if (kt[i] == MISSING_KEY || vt[i] == -1) continue;
            ++newElementSize;
        }
        this.elementSize = newElementSize;
        this.rehash();
        return newElementSize;
    }

    protected int computeNewSize(int size) {
        int extraRoom = (int)((float)size * 1.25f);
        if (this.threshold == extraRoom) {
            ++extraRoom;
        }
        extraRoom = SizesAsPrimes.getSize(1.25f, extraRoom);
        return extraRoom;
    }

    public boolean containsKey(Object key) {
        if (key == MISSING_KEY) {
            return false;
        }
        int index = this.getIndex(key);
        return index != -1;
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        Object[] kt = this.keyTable;
        int[] vt = this.valueTable;
        int i = vt.length;
        while (i-- > 0) {
            if (kt[i] == MISSING_KEY || !new Integer(vt[i]).equals(value)) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        HashSet<1> entries = new HashSet<1>();
        int i = 0;
        while (i < this.keyTable.length) {
            if (this.keyTable[i] != MISSING_KEY) {
                final Object currentKey = this.keyTable[i];
                Map.Entry entry = new Map.Entry(){
                    Object key;
                    Object value;

                    public Object getKey() {
                        return this.key;
                    }

                    public Object getValue() {
                        return this.value;
                    }

                    public Object setValue(Object value) {
                        if (this.key != null) {
                            throw new UnsupportedOperationException();
                        }
                        this.value = value;
                        this.key = currentKey;
                        return value;
                    }
                };
                entry.setValue(new Integer(this.valueTable[i]));
                entries.add(entry);
            }
            ++i;
        }
        return entries;
    }

    public int getInt(Object key) {
        int index = this.getIndex(key);
        if (index != -1) {
            return this.valueTable[index];
        }
        return -1;
    }

    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        return new Integer(this.getInt(key));
    }

    protected int getFreeSpot(Object key, Object[] kt) {
        Object currentKey;
        int length = kt.length;
        int index = (key.hashCode() & Integer.MAX_VALUE) % length;
        while ((currentKey = kt[index]) != MISSING_KEY) {
            if (currentKey == key) {
                return -index;
            }
            index = (index + 1) % length;
            ++this.putIterations;
        }
        return index;
    }

    protected int getIndex(Object key) {
        Object currentKey;
        Object[] kt = this.keyTable;
        int length = kt.length;
        int index = (key.hashCode() & Integer.MAX_VALUE) % length;
        while ((currentKey = kt[index]) != MISSING_KEY) {
            if (currentKey == key || currentKey != null && currentKey.equals(key)) {
                return index;
            }
            index = (index + 1) % length;
            ++this.getIterations;
        }
        return -1;
    }

    public Object[] getKeys() {
        return this.keyTable;
    }

    public int[] getValues() {
        return this.valueTable;
    }

    protected void init(int size) {
        this.elementSize = 0;
        this.threshold = size;
        int extraRoom = this.computeNewSize(size);
        this.valueTable = new int[extraRoom];
        this.keyTable = new Object[extraRoom];
    }

    public boolean isEmpty() {
        return this.elementSize == 0;
    }

    public Set keySet() {
        HashSet<Object> keys = new HashSet<Object>();
        int i = 0;
        while (i < this.keyTable.length) {
            if (this.keyTable[i] != MISSING_KEY) {
                keys.add(this.keyTable[i]);
            }
            ++i;
        }
        return keys;
    }

    public int put(Object key, int value) {
        int index = this.getFreeSpot(key, this.keyTable);
        if (index < 0) {
            index = -index;
            int oldValue = this.valueTable[index];
            this.valueTable[index] = value;
            return oldValue;
        }
        this.keyTable[index] = key;
        int oldValue = this.valueTable[index];
        this.valueTable[index] = value;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return oldValue;
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            return value;
        }
        return new Integer(this.put(key, value.hashCode()));
    }

    public void putAll(Map t) {
        for (Map.Entry element : this.entrySet()) {
            this.put(element.getKey(), element.getValue());
        }
    }

    protected void rehash() {
        if (ModelDebugger.INSTANCE.debugCustomMaps) {
            this.p.setMessageAndStart("ObjectToIntMapImpl.rehash() oldGetIterations=" + this.getIterations + ", oldPutIterations=" + this.putIterations + ", oldElementSize=" + this.elementSize + ", oldKeyTable.lenght=" + this.keyTable.length);
        }
        this.threshold = (int)((float)this.elementSize * 1.25f);
        int extraRoom = this.computeNewSize(this.threshold);
        this.getIterations = 0;
        this.putIterations = 0;
        this.rehash(extraRoom);
        if (ModelDebugger.INSTANCE.debugCustomMaps) {
            this.p.stopAndPrintStatus("newGetIterations=" + this.getIterations + ", newPutIterations=" + this.putIterations + ", newElementSize=" + this.elementSize + ", newKeyTable.lenght=" + this.keyTable.length);
        }
        this.putIterations = 0;
        this.getIterations = 0;
    }

    protected void rehash(int newSize) {
        Object[] oKT = this.keyTable;
        int[] oVT = this.valueTable;
        int oL = oKT.length;
        Object[] nKT = new Object[newSize];
        int[] nVT = new int[newSize];
        int nElementSize = 0;
        int i = oL;
        while (i-- > 0) {
            if (oKT[i] == MISSING_KEY || oVT[i] == -1) continue;
            Object o = oKT[i];
            int index = this.getFreeSpot(o, nKT);
            if (index < 0) {
                index = -index;
            }
            nKT[index] = o;
            nVT[index] = oVT[i];
            ++nElementSize;
        }
        this.elementSize = nElementSize;
        this.keyTable = nKT;
        this.valueTable = nVT;
    }

    public int removeInt(Object key) {
        int index = this.getIndex(key);
        if (index != -1) {
            int oldValue = this.valueTable[index];
            this.valueTable[index] = -1;
            return oldValue;
        }
        return -1;
    }

    public Object remove(Object key) {
        if (key == null) {
            return null;
        }
        return new Integer(this.removeInt(key));
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String s = "ObjectToIntMapImpl elementSize=" + this.elementSize + ", keyTable.length=" + this.keyTable.length + ", entries:\n";
        int i = 0;
        int length = this.keyTable.length;
        while (i < length) {
            int object;
            if (this.keyTable[i] != MISSING_KEY && (object = this.valueTable[i]) != -1) {
                s = String.valueOf(s) + this.keyTable[i] + " -> " + object + "\n";
            }
            ++i;
        }
        return s;
    }

    public Collection values() {
        ArrayList<Integer> res = new ArrayList<Integer>();
        int i = 0;
        while (i < this.valueTable.length) {
            res.add(new Integer(this.valueTable[i]));
            ++i;
        }
        return res;
    }
}

