/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util.internal;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.SAXParser;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.IXMLLoader;
import org.eclipse.hyades.loaders.util.InvalidXMLException;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLFragmentHandler;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.models.hierarchy.util.internal.CrimsonFragmentHandler;
import org.eclipse.hyades.models.util.ModelDebugger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SimpleFragmentHandler
implements XMLFragmentHandler {
    protected static final int FORWARD_BUFFER_MAX_SIZE = 65536;
    protected IXMLLoader handler;
    protected int endOffset;
    protected long currentElementNameStart;
    protected long currentElementNameEnd;
    protected long currentAttributeNameStart;
    protected long currentAttributeNameEnd;
    protected long currentAttributeValueStart;
    protected long currentAttributeValueEnd;
    protected byte previousByte;
    protected List elementsStack;
    protected boolean inElementStartTag;
    protected boolean inElementContent;
    protected boolean inElementEndTag;
    protected byte[] currentBuffer;
    protected boolean inAttributeSection;
    protected boolean inIgnoredContent;
    protected long currentElementContentEnd;
    protected long currentElementContentStart;
    protected long globalStartOffset;
    protected long globalIndex;
    protected byte[] forwardBuffer;
    protected String scannerId;
    protected int fragmentCount = 0;
    protected int forwardBufferPosition;

    public void scanContent(byte[] newFragment, int offset, int length) throws InvalidXMLException {
        this.currentBuffer = newFragment;
        this.endOffset = offset + length;
        int j = offset;
        while (j < this.endOffset) {
            this.globalIndex = this.globalStartOffset + (long)j;
            switch (this.currentBuffer[j]) {
                case 9: 
                case 32: {
                    if (this.currentElementNameStart != -1L) {
                        this.currentElementNameEnd = this.globalIndex - 1L;
                        this.startElement();
                        this.inAttributeSection = true;
                        this.currentElementNameStart = -1L;
                        break;
                    }
                    if (this.currentAttributeNameStart == -1L) break;
                    this.currentAttributeNameEnd = this.globalIndex - 1L;
                    this.attributeName();
                    this.currentAttributeNameStart = -1L;
                    break;
                }
                case 10: 
                case 13: {
                    break;
                }
                case 60: {
                    if (this.inElementContent) {
                        this.currentElementContentEnd = this.globalIndex - 1L;
                        if (this.currentAttributeNameEnd > this.currentAttributeNameStart) {
                            this.characters();
                        }
                        this.currentElementContentStart = -1L;
                        this.inElementContent = false;
                    } else if (!this.inIgnoredContent) {
                        this.inElementStartTag = true;
                    }
                    this.previousByte = this.currentBuffer[j];
                    break;
                }
                case 47: {
                    if (this.inElementStartTag) {
                        this.previousByte = this.currentBuffer[j];
                        break;
                    }
                    if (this.inIgnoredContent || this.previousByte != 60) break;
                    this.inElementEndTag = true;
                    break;
                }
                case 62: {
                    if (this.inElementStartTag) {
                        if (this.previousByte == 47) {
                            this.endElement(this.globalIndex);
                        } else if (this.currentElementNameStart != -1L) {
                            this.currentElementNameEnd = this.globalIndex - 1L;
                            this.startElement();
                            this.currentElementNameStart = -1L;
                            this.inElementContent = true;
                            this.currentElementContentStart = this.globalIndex + 1L;
                        }
                        this.inElementStartTag = false;
                        this.inAttributeSection = false;
                    } else if (this.inElementEndTag) {
                        this.endElement(this.globalIndex);
                        this.inElementEndTag = false;
                    } else if (this.inIgnoredContent && (this.previousByte == 45 || this.previousByte == 93 || this.previousByte == 63)) {
                        this.inIgnoredContent = false;
                    }
                    this.previousByte = this.currentBuffer[j];
                    break;
                }
                case 33: {
                    if (!this.inIgnoredContent && this.previousByte == 60) {
                        this.inIgnoredContent = true;
                        this.inElementStartTag = false;
                    }
                    this.previousByte = this.currentBuffer[j];
                    break;
                }
                case 45: {
                    if (!this.inIgnoredContent && this.previousByte == 60) {
                        this.inIgnoredContent = true;
                        this.inElementStartTag = false;
                    }
                    this.previousByte = this.currentBuffer[j];
                    break;
                }
                case 63: {
                    if (!this.inIgnoredContent && this.previousByte == 60) {
                        this.inIgnoredContent = true;
                        this.inElementStartTag = false;
                    }
                    this.previousByte = this.currentBuffer[j];
                    break;
                }
                case 61: {
                    if (!this.inAttributeSection || this.currentAttributeNameStart == -1L) break;
                    this.currentAttributeNameEnd = this.globalIndex - 1L;
                    this.attributeName();
                    this.currentAttributeNameStart = -1L;
                    this.previousByte = this.currentBuffer[j];
                    break;
                }
                case 34: {
                    if (this.currentAttributeValueStart != -1L) {
                        this.currentAttributeValueEnd = this.globalIndex - 1L;
                        this.attributeValue();
                        this.currentAttributeValueStart = -1L;
                    } else if (this.inAttributeSection) {
                        this.currentAttributeValueStart = this.globalIndex + 1L;
                    }
                    this.previousByte = this.currentBuffer[j];
                    break;
                }
                default: {
                    if (this.inElementStartTag) {
                        if (this.inAttributeSection) {
                            if (this.currentAttributeValueStart == -1L && this.currentAttributeNameStart == -1L) {
                                this.currentAttributeNameStart = this.globalIndex;
                            }
                        } else if (this.currentElementNameStart == -1L) {
                            this.currentElementNameStart = this.globalIndex;
                        }
                    }
                    this.previousByte = this.currentBuffer[j];
                }
            }
            ++j;
        }
        if (this.currentAttributeNameStart != -1L) {
            this.addBuffer(this.currentAttributeNameStart);
        } else if (this.currentAttributeValueStart != -1L) {
            this.addBuffer(this.currentAttributeValueStart);
        } else if (this.currentElementNameStart != -1L) {
            this.addBuffer(this.currentElementNameStart);
        } else if (this.currentElementContentStart != -1L) {
            this.currentElementContentEnd = this.globalIndex;
            if (this.currentAttributeNameEnd > this.currentAttributeNameStart) {
                this.characters();
            }
            this.currentElementContentStart = this.globalIndex + 1L;
        }
        this.globalStartOffset += (long)length;
    }

    protected void addBuffer(long globalOffset) {
        int l = this.endOffset - (int)(globalOffset - this.globalStartOffset);
        if (this.forwardBufferPosition + l > this.forwardBuffer.length) {
            this.growForwardBuffer(this.forwardBufferPosition + l);
        }
        System.arraycopy(this.currentBuffer, (int)(globalOffset - this.globalStartOffset), this.forwardBuffer, this.forwardBufferPosition, l);
        this.forwardBufferPosition += l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void growForwardBuffer(int newSize) {
        byte[] b = new byte[newSize];
        byte[] byArray = this.forwardBuffer;
        synchronized (this.forwardBuffer) {
            System.arraycopy(this.forwardBuffer, 0, b, 0, this.forwardBufferPosition);
            this.forwardBuffer = b;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    protected void characters() {
        char[] val = this.makeCharArray(this.currentElementContentStart, (int)(this.currentElementContentEnd - this.currentElementContentStart + 1L));
        this.handler.characters(val, 0, val.length);
    }

    protected void attributeValue() {
        this.handler.attributeValueCharacters(this.makeString(this.currentAttributeValueStart, (int)(this.currentAttributeValueEnd - this.currentAttributeValueStart + 1L)));
    }

    protected char[] makeCharArray(long globalOffset, int length) {
        return this.makeString(globalOffset, length).toCharArray();
    }

    protected String makeString(long globalOffset, int length) {
        String res = null;
        if (this.globalStartOffset <= globalOffset) {
            int localOffset = (int)(globalOffset - this.globalStartOffset);
            res = LoadersUtils.makeString(this.currentBuffer, localOffset, length);
        } else {
            System.arraycopy(this.currentBuffer, 0, this.forwardBuffer, this.forwardBufferPosition, length - this.forwardBufferPosition);
            res = LoadersUtils.makeString(this.forwardBuffer, 0, length);
            this.forwardBufferPosition = 0;
        }
        return res;
    }

    protected void attributeName() {
        this.handler.attributeName(this.makeString(this.currentAttributeNameStart, (int)(this.currentAttributeNameEnd - this.currentAttributeNameStart + 1L)));
    }

    protected void startElement() {
        this.elementsStack.add(this.makeString(this.currentElementNameStart, (int)(this.currentElementNameEnd - this.currentElementNameStart + 1L)));
        this.handler.startElement((String)this.elementsStack.get(this.elementsStack.size() - 1), true, false);
    }

    protected void endElement(long i) {
        this.handler.endElement((String)this.elementsStack.get(this.elementsStack.size() - 1), (int)(i + 1L));
        this.elementsStack.remove(this.elementsStack.size() - 1);
    }

    public void terminateParser() {
        this.elementsStack = null;
        this.forwardBuffer = null;
        this.reset();
    }

    public void setXMLLoader(IXMLLoader handler) {
        this.handler = handler;
        this.reset();
        this.elementsStack = new ArrayList();
        this.forwardBuffer = new byte[131072];
        handler.startDocument();
    }

    protected void reset() {
        this.inIgnoredContent = false;
        this.inElementContent = false;
        this.inElementEndTag = false;
        this.currentAttributeNameEnd = -1L;
        this.currentAttributeNameStart = -1L;
        this.currentAttributeValueEnd = -1L;
        this.currentAttributeValueStart = -1L;
        this.currentElementNameEnd = -1L;
        this.currentElementNameStart = -1L;
        this.currentElementContentEnd = -1L;
        this.currentElementContentStart = -1L;
        this.globalStartOffset = 0L;
        this.globalIndex = 0L;
        this.endOffset = -1;
        this.previousByte = 0;
    }

    public static void main(String[] args) {
        new SimpleFragmentHandler().testScanners();
    }

    protected void testScanners() {
        IXMLLoader x = this.createDebugXMLLoader();
        String inputFileName = "E:\\test\\input\\traces\\defects\\trace27mb.xml";
        this.testSAXFragmentHandler(x, inputFileName);
    }

    protected void testSAXFragmentHandler(IXMLLoader x, String inputFileName) {
        this.scannerId = "SAXScanner";
        this.fragmentCount = 0;
        CrimsonFragmentHandler s = new CrimsonFragmentHandler();
        this.parserTest(s, x, inputFileName);
        PerfUtil p = null;
        try {
            this.fragmentCount = 0;
            SAXParser parser = XMLLoader.makeParser();
            p = PerfUtil.createInstance(parser + " test", true);
            parser.parse(new InputSource(new FileInputStream(inputFileName)), new DefaultHandler(){
                protected boolean hasContent = false;
                protected boolean debug;
                protected int depth = 0;

                public void characters(char[] ch, int start, int length) {
                    if (this.debug) {
                        if (!this.hasContent) {
                            ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, (byte)62);
                            ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, (byte)10);
                        }
                        String s = new String(ch, start, length);
                        ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, s.getBytes());
                        this.hasContent = true;
                    }
                }

                public void endElement(String uri, String localName, String qName) throws SAXException {
                    --this.depth;
                    if (this.debug) {
                        if (this.hasContent) {
                            ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, (byte)60);
                            ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, (byte)47);
                            ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, qName.getBytes());
                            this.hasContent = false;
                        } else {
                            ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, (byte)47);
                        }
                        ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, (byte)62);
                        ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, (byte)10);
                    }
                }

                public void startDocument() {
                }

                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (this.depth == 1) {
                        ++SimpleFragmentHandler.this.fragmentCount;
                    }
                    ++this.depth;
                    if (this.debug) {
                        ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, (byte)60);
                        ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, qName.getBytes());
                        this.hasContent = false;
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        p.stopAndPrintStatus("ProcessedFragments=" + this.fragmentCount);
    }

    public IXMLLoader createDebugXMLLoader() {
        IXMLLoader x = new IXMLLoader(){
            protected boolean hasContent = false;
            protected boolean debug;
            protected int depth = 0;

            public void setCollectionMode(int collectionMode) {
            }

            public HierarchyContext getContext() {
                return null;
            }

            public int getProcessedFragments() {
                return SimpleFragmentHandler.this.fragmentCount;
            }

            public void attributeName(String name) {
                if (this.debug) {
                    ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, (byte)32);
                    ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, name.getBytes());
                    ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, (byte)61);
                }
            }

            public void attributeValueCharacters(String attributeValue) {
                if (this.debug) {
                    ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, (byte)34);
                    ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, attributeValue.getBytes());
                    ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, (byte)34);
                }
            }

            public void characters(char[] ch, int start, int length) {
                if (this.debug) {
                    if (!this.hasContent) {
                        ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, (byte)62);
                        ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, (byte)10);
                    }
                    String s = new String(ch, start, length);
                    ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, s.getBytes());
                    this.hasContent = true;
                }
            }

            public void cleanUp() {
                SimpleFragmentHandler.this.fragmentCount = 0;
                this.depth = 0;
                this.hasContent = false;
            }

            public void endDocument(Object object, int i) {
            }

            public void endElement(String elementName, int currentOffset) {
                --this.depth;
                if (this.debug) {
                    if (this.hasContent) {
                        ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, (byte)60);
                        ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, (byte)47);
                        ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, elementName.getBytes());
                        this.hasContent = false;
                    } else {
                        ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, (byte)47);
                    }
                    ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, (byte)62);
                    ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, (byte)10);
                }
            }

            public void error(InvalidXMLException exception) {
            }

            public void loadEvent(byte[] buffer, int length, boolean loadToModel, boolean toProfileFile) throws InvalidXMLException {
            }

            public void loadEvent(byte[] buffer, int length, boolean loadToModel) throws InvalidXMLException {
            }

            public void loadEvent(byte[] buffer, int length) throws InvalidXMLException {
            }

            public void restartParser() {
            }

            public void startDocument() {
            }

            public void startElement(String elementName, boolean hasAttributes, boolean isEmpty) {
                if (this.depth == 1) {
                    ++SimpleFragmentHandler.this.fragmentCount;
                }
                ++this.depth;
                if (this.debug) {
                    ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, (byte)60);
                    ModelDebugger.INSTANCE.writeBinaryLog(SimpleFragmentHandler.this.scannerId, elementName.getBytes());
                    this.hasContent = false;
                }
            }
        };
        return x;
    }

    public void parserTest(XMLFragmentHandler s, IXMLLoader x, String inputFileName) {
        s.setXMLLoader(x);
        this.processTextFile(this.scannerId, x, s, inputFileName);
        x.cleanUp();
    }

    protected void processFile(String scannerId, IXMLLoader x, XMLFragmentHandler s, String inputFileName) {
        InputStream in = null;
        try {
            int i;
            byte[] b = new byte[65536];
            in = SimpleFragmentHandler.getInputStream(inputFileName);
            if (in == null) {
                System.out.println("SimpleFragmentHandler.processFile() - null input stream");
            }
            PerfUtil p = PerfUtil.createInstance(String.valueOf(scannerId) + " test", true);
            while ((i = in.read(b)) != -1) {
                s.scanContent(b, 0, i);
                Thread.sleep(2000L);
            }
            ModelDebugger.INSTANCE.writeBinaryLog(scannerId, ("\nProcessedFragments=" + x.getProcessedFragments()).getBytes());
            ModelDebugger.INSTANCE.getBinaryLog(scannerId).close();
            p.stopAndPrintStatus("ProcessedFragments=" + x.getProcessedFragments());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void processTextFile(String scannerId, IXMLLoader x, XMLFragmentHandler s, String inputFileName) {
        InputStream in = null;
        try {
            String line;
            byte[] b = new byte[65536];
            in = SimpleFragmentHandler.getInputStream(inputFileName);
            if (in == null) {
                System.out.println("SimpleFragmentHandler.processFile() - null input stream");
            }
            PerfUtil p = PerfUtil.createInstance(String.valueOf(scannerId) + " test", true);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
            StringBuffer sb = new StringBuffer();
            int count = 0;
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
                if (count == 50) {
                    b = sb.toString().getBytes();
                    s.scanContent(b, 0, b.length);
                    sb.setLength(0);
                    count = 0;
                    continue;
                }
                ++count;
            }
            if (sb.length() > 0) {
                b = sb.toString().getBytes();
                s.scanContent(b, 0, b.length);
                sb.setLength(0);
            }
            p.stopAndPrintStatus("ProcessedFragments=" + x.getProcessedFragments());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static InputStream getInputStream(String inputFileName) throws IOException {
        InputStream in = null;
        if (ModelDebugger.isZipFile(inputFileName)) {
            ZipFile zf = new ZipFile(inputFileName);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            if (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                in = zf.getInputStream(zipEntry);
                in = new BufferedInputStream(in, 65536);
            }
        } else {
            in = new BufferedInputStream(new FileInputStream(inputFileName), 65536);
        }
        return in;
    }

    public void scanContent(InputStream inputStream, long offset, long length) {
    }
}

