/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil;
import org.eclipse.hyades.models.hierarchy.extensions.ArithmeticExpression;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.NumericFunction;
import org.eclipse.hyades.models.hierarchy.extensions.Operand;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByElement;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByOperators;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleOperandImpl;
import org.eclipse.hyades.models.hierarchy.util.FastList;
import org.eclipse.hyades.models.hierarchy.util.ModelDebugger;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.models.hierarchy.util.internal.QueryUtils;
import org.eclipse.hyades.models.util.internal.IdentityHashSet;

public class SinglePassSimpleSearchQueryEngine {
    public static final String XMLCALENDAR = "XMLCalendar";
    protected Map classPredicatesIndex = new IdentityHashMap();
    protected Map featurePredicatesIndex = new IdentityHashMap();
    protected Map namesIndex = new HashMap();
    protected Set outputClasses = new IdentityHashSet();
    protected Set outputClassesSuperTypes = new IdentityHashSet();
    protected Set outputClassesSubTypes = new IdentityHashSet();
    protected SimpleSearchQuery query;
    protected QueryResult queryResult;
    protected Set requiredPaths = new IdentityHashSet();
    protected Collection rootClasses = new IdentityHashSet();
    protected Collection rootNodes = new IdentityHashSet();
    protected ResourceSet targetResourceSet;
    protected Map whereExpressionValuesIndex = new IdentityHashMap();
    protected SimpleSearchQueryEvaluator queryEvaluator = new SimpleSearchQueryEvaluator();
    protected EvalResult result;
    protected List resetStack = new FastList();
    protected List resetParentsStack = new FastList();
    protected PerfUtil p;
    protected ArrayList firstResList;
    public static final int IS_COMPLETE = 1;
    public static final int IS_NOT_COMPLETE = 2;
    public static final int IS_TRUE = 4;
    public static final int IS_FALSE = 8;
    public static final int IS_APPLICABLE = 16;

    public SinglePassSimpleSearchQueryEngine(SimpleSearchQuery query, ResourceSet targetResourceSet) {
        this.query = query;
        this.targetResourceSet = targetResourceSet;
        for (EStructuralFeature element : query.getRequiredPaths()) {
            this.requiredPaths.add(element);
        }
    }

    public EvalResult createEvalResult(Operand operand) {
        return new EvalResult(operand);
    }

    protected EvalResult createEvalResult(WhereExpression expression) {
        return new EvalResult(expression);
    }

    protected void addResultValue(EObject element) {
        if (this.queryResult.getResultEntries().size() == 1) {
            if (this.query.isDistinct() && this.firstResList.lastIndexOf(element) >= 0) {
                return;
            }
            this.firstResList.add(element);
            return;
        }
        throw new RuntimeException("Not implemented yet !");
    }

    public QueryResult execute() {
        if (ModelDebugger.INSTANCE.debugPerfUtil) {
            this.p = PerfUtil.createInstance(null, false);
            this.p.setMessageAndStart("SimpleSearchQueryEngine.execute()");
        }
        this.prepareResult();
        this.populateRootNodesAndClasses();
        this.populateResult();
        this.sortResult();
        this.limitResult();
        if (ModelDebugger.INSTANCE.debugPerfUtil) {
            this.p.stopAndPrintStatus("firstResList.size=" + (this.firstResList == null ? "null" : "" + this.firstResList.size()));
        }
        return this.queryResult;
    }

    protected boolean isOutputElement(EObject element) {
        EClass c = element.eClass();
        return this.isOutputElement(c);
    }

    protected boolean isOutputElement(EClass eClass) {
        return this.outputClasses.contains(eClass) || this.outputClassesSubTypes.contains(eClass);
    }

    protected void limitResult() {
        int start;
        if (this.query.getMaxElements() == 0) {
            return;
        }
        ResultEntry tempResult = (ResultEntry)this.queryResult.getResultEntries().get(0);
        List initialList = (List)((ResultEntry)this.queryResult.getResultEntries().get(0)).getValue();
        ArrayList resultList = new ArrayList();
        int end = 0;
        if (this.query.getStartWith() >= 0) {
            start = this.query.getStartWith();
            end = Math.min(start + this.query.getMaxElements() - 1, initialList.size() - 1);
        } else {
            end = Math.max(0, initialList.size() + this.query.getStartWith());
            start = Math.max(0, end - this.query.getMaxElements());
        }
        int i = start;
        while (i <= end) {
            resultList.add(initialList.get(i));
            ++i;
        }
        tempResult.setValue(resultList);
    }

    private void evalElement(Object element) {
        if (element == null || !(element instanceof EObject)) {
            return;
        }
        if (!this.outputClasses.contains(((EObject)element).eClass()) && !this.outputClassesSuperTypes.contains(((EObject)element).eClass())) {
            return;
        }
        this.result.eval((EObject)element);
        if (this.result.isComplete() && this.result.booleanValue().booleanValue()) {
            this.addResultValue((EObject)element);
        }
    }

    private void evalAllElements(Object parent) {
        this.evalElement(parent);
        if (parent instanceof EObject) {
            EList features = ((EObject)parent).eClass().getEAllContainments();
            int i = features.size() - 1;
            while (i >= 0) {
                EStructuralFeature sf = (EStructuralFeature)features.get(i);
                Object output = ((EObject)parent).eGet(sf, true);
                this.evalAllElements(output);
                --i;
            }
        }
        if (parent instanceof EList) {
            Iterator iter = ((EList)parent).iterator();
            while (iter.hasNext()) {
                this.evalAllElements(iter.next());
            }
        }
    }

    protected void populateResult() {
        this.result = this.queryEvaluator.prepareEvalResult();
        if (this.firstResList != null) {
            this.firstResList.clear();
        }
        try {
            for (EObject parent : this.rootNodes) {
                this.evalAllElements(parent);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {}
    }

    protected EObject findOutputElementInParents(EObject element) {
        if (this.rootNodes.contains(element)) {
            return null;
        }
        EObject eContainer = element.eContainer();
        if (eContainer != null) {
            if (this.isOutputElement(eContainer)) {
                return eContainer;
            }
            if (this.rootNodes.contains(eContainer)) {
                return null;
            }
            return this.findOutputElementInParents(eContainer);
        }
        return null;
    }

    protected boolean processResetListIsRequired(EObject eObject) {
        return (this.result.partialEvalOnly(eObject.eClass()) & 0x15) != 21;
    }

    protected boolean addResultValueIfRequired(EObject eObject, int pos) {
        if (this.result.booleanValue().booleanValue()) {
            if (this.isOutputElement(eObject)) {
                this.addResultValue(eObject);
                return false;
            }
            return true;
        }
        return false;
    }

    protected void populateRootNodesAndClasses() {
        this.rootNodes.clear();
        this.rootClasses.clear();
        for (String element : this.query.getSources()) {
            URI uri = SaveUtil.createURI(element);
            EObject n = this.targetResourceSet.getEObject(uri, false);
            EClass c = n.eClass();
            if (!this.rootNodes.contains(n)) {
                this.rootNodes.add(n);
            }
            if (this.rootClasses.contains(c)) continue;
            this.rootClasses.add(c);
        }
    }

    protected void prepareResult() {
        this.queryResult = ExtensionsFactory.eINSTANCE.createQueryResult();
        this.queryResult.setQuery(this.query);
        for (SimpleOperand outputElement : this.query.getOutputElements()) {
            EClass c = outputElement.getType();
            if (c == null && outputElement.getFeature() != null) {
                c = outputElement.getFeature().getEContainingClass();
            }
            if (c != null) {
                this.outputClasses.add(c);
                QueryUtils.addSubTypes(c, this.outputClassesSubTypes);
                QueryUtils.addSuperTypes(c, this.outputClassesSuperTypes);
                this.classPredicatesIndex.put(c, null);
                QueryUtils.addSubTypes(c, this.classPredicatesIndex, null);
            }
            ResultEntry resultEntry = ExtensionsFactory.eINSTANCE.createResultEntry();
            this.queryResult.getResultEntries().add((Object)resultEntry);
            this.firstResList = new ArrayList();
            resultEntry.setValue(this.firstResList);
        }
    }

    protected void sortResult() {
        if (this.query.getOrderByExpresions().size() != 1) {
            return;
        }
        final EAttribute compareAttribute = (EAttribute)((SimpleOperand)((OrderByElement)this.query.getOrderByExpresions().get(0)).getOperand()).getFeature();
        OrderByOperators compareOperator = ((OrderByElement)this.query.getOrderByExpresions().get(0)).getOperator();
        final boolean reversOrder = compareOperator.getValue() == 1;
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                Object o1Value = ((EObject)o1).eGet((EStructuralFeature)compareAttribute);
                Object o2Value = ((EObject)o2).eGet((EStructuralFeature)compareAttribute);
                try {
                    if (o2Value.getClass().getName().endsWith(SinglePassSimpleSearchQueryEngine.XMLCALENDAR)) {
                        return XMLTypeUtil.compareCalendar((Object)o1Value, (Object)o2Value);
                    }
                    return reversOrder ? -((Comparable)o1Value).compareTo(o2Value) : ((Comparable)o1Value).compareTo(o2Value);
                }
                catch (Exception exception) {
                    try {
                        return reversOrder ? -o1Value.toString().compareTo(o2Value.toString()) : o1Value.toString().compareTo(o2Value.toString());
                    }
                    catch (Exception exception2) {
                        return 0;
                    }
                }
            }
        };
        ResultEntry tempResult = (ResultEntry)this.queryResult.getResultEntries().get(0);
        List resultList = (List)tempResult.getValue();
        Collections.sort(resultList, comparator);
        tempResult.setValue(resultList);
    }

    protected void processResetList(List list, int startPosition) {
        int i = list.size() - 1;
        while (i >= startPosition) {
            EObject resetElement = (EObject)list.get(i);
            this.result.reset(resetElement);
            list.remove(i);
            --i;
        }
    }

    public Set getRequiredPaths() {
        return this.requiredPaths;
    }

    protected Object getNonModeledElementValue(EvalResult evalResult, SimpleOperand simpleOperand) {
        return simpleOperand.getValue();
    }

    public class EvalResult {
        public static final int BOOLEAN = 4;
        public static final int NUMERIC = 2;
        public static final int OBJECT = 5;
        public static final int SIMPLE_OPERAND = 1;
        public static final int STRING = 3;
        protected Boolean booleanValue;
        protected int compareResult;
        protected boolean complete;
        protected EObject context;
        protected EClass contextType;
        protected WhereExpression expression;
        protected Number numericValue;
        protected Object objectValue;
        protected Operand operand;
        protected List partialResults = new ArrayList();
        protected String stringValue;
        protected int valueType = -1;

        public EvalResult() {
        }

        public EvalResult(Operand operand) {
            this.operand = operand;
            this.contextType = this.getContextType();
        }

        public EvalResult(WhereExpression expression) {
            this.expression = expression;
        }

        public String toString() {
            StringBuffer result = new StringBuffer("\n" + this.getLevelSpaces().toString());
            result.append(" (complete: ");
            result.append(this.complete);
            result.append(", valueType: ");
            result.append(this.valueType);
            result.append(", booleanValue: ");
            result.append(this.booleanValue);
            result.append(", contextType: ");
            result.append(this.contextType);
            result.append(", numericValue: ");
            result.append(this.numericValue);
            result.append(", stringValue: ");
            result.append(this.stringValue);
            result.append(", partialResults: ");
            for (EvalResult element : this.partialResults) {
                result.append(element.toString());
            }
            result.append(')');
            return result.toString();
        }

        protected StringBuffer getLevelSpaces() {
            StringBuffer s = new StringBuffer();
            if (this.operand != null) {
                this.addLevelSpaces(this.operand, s);
            } else {
                this.addLevelSpaces(this.expression, s);
            }
            return s;
        }

        protected void addLevelSpaces(EObject o, StringBuffer s) {
            if (o == null) {
                return;
            }
            s.append(" ");
            this.addLevelSpaces(o.eContainer(), s);
        }

        protected Number add() {
            Number result = null;
            int i = 0;
            while (i < this.partialResults.size() && i < 2) {
                if (result == null) {
                    result = ((EvalResult)this.partialResults.get(i)).numericValue();
                } else if (result instanceof Double) {
                    result = new Double(result.doubleValue() + ((EvalResult)this.partialResults.get(i)).numericValue().doubleValue());
                } else if (result instanceof Integer) {
                    result = new Integer(result.intValue() + ((EvalResult)this.partialResults.get(i)).numericValue().intValue());
                } else if (result instanceof Float) {
                    result = new Float(result.floatValue() + ((EvalResult)this.partialResults.get(i)).numericValue().floatValue());
                } else if (result instanceof Short) {
                    result = new Short((short)(result.shortValue() + ((EvalResult)this.partialResults.get(i)).numericValue().shortValue()));
                } else if (result instanceof Long) {
                    result = new Long(result.longValue() + ((EvalResult)this.partialResults.get(i)).numericValue().longValue());
                } else if (result instanceof Byte) {
                    result = new Long(result.byteValue() + ((EvalResult)this.partialResults.get(i)).numericValue().byteValue());
                }
                ++i;
            }
            return result;
        }

        public void addPartialResult(EvalResult result) {
            this.partialResults.add(result);
        }

        public Boolean booleanValue() {
            return this.booleanValue;
        }

        protected int compare(EvalResult lhs, EvalResult rhs) {
            if (lhs.isNumeric() && rhs.isNumeric() && lhs.numericValue() instanceof Comparable) {
                return ((Comparable)((Object)lhs.numericValue())).compareTo(rhs.numericValue());
            }
            if (lhs.isBoolean() && lhs.isBoolean()) {
                if (lhs.booleanValue() == Boolean.TRUE) {
                    if (rhs.booleanValue() == Boolean.TRUE) {
                        return 0;
                    }
                    return 1;
                }
                if (rhs.booleanValue() == Boolean.FALSE) {
                    return 0;
                }
                return -1;
            }
            if ((lhs.isObject() || lhs.isString()) && rhs.isObject()) {
                if (rhs.objectValue() instanceof List) {
                    try {
                        if (lhs.objectValue() != null) {
                            return ((List)rhs.objectValue()).contains(lhs.objectValue()) ? 0 : -1;
                        }
                        return ((List)rhs.objectValue()).contains(lhs.stringValue()) ? 0 : -1;
                    }
                    catch (Exception exception) {
                        return -1;
                    }
                }
                if (rhs.objectValue.getClass().getName().endsWith(SinglePassSimpleSearchQueryEngine.XMLCALENDAR) && lhs.objectValue.getClass().getName().endsWith(SinglePassSimpleSearchQueryEngine.XMLCALENDAR)) {
                    try {
                        return XMLTypeUtil.compareCalendar((Object)lhs.objectValue(), (Object)rhs.objectValue());
                    }
                    catch (Exception exception) {}
                }
                return lhs.objectValue().toString().compareTo(rhs.objectValue().toString());
            }
            if (((BinaryExpression)this.expression).isCaseInsensitive()) {
                return lhs.stringValue().toLowerCase().compareTo(rhs.stringValue().toLowerCase());
            }
            return lhs.stringValue().compareTo(rhs.stringValue());
        }

        public EvalResult computePartialResult() {
            if (this.isComplete()) {
                return this;
            }
            if (this.operand != null) {
                if (this.operand instanceof NumericFunction) {
                    this.updateNumericFunctionValue();
                } else if (this.operand instanceof ArithmeticExpression) {
                    this.updateArithmeticExpressionValue();
                } else {
                    this.updateSimpleOperand();
                }
            } else if (this.expression != null) {
                if (this.expression instanceof LogicalExpression) {
                    this.updateLogicalExpressionValue();
                } else {
                    this.updateBinaryExpressionValue();
                }
            }
            return this;
        }

        protected Number divide() {
            Number result = null;
            int i = 0;
            while (i < this.partialResults.size() && i < 2) {
                if (result == null) {
                    result = ((EvalResult)this.partialResults.get(i)).numericValue();
                } else if (result instanceof Double) {
                    result = new Double(result.doubleValue() / ((EvalResult)this.partialResults.get(i)).numericValue().doubleValue());
                } else if (result instanceof Integer) {
                    result = new Integer(result.intValue() / ((EvalResult)this.partialResults.get(i)).numericValue().intValue());
                } else if (result instanceof Float) {
                    result = new Float(result.floatValue() / ((EvalResult)this.partialResults.get(i)).numericValue().floatValue());
                } else if (result instanceof Short) {
                    result = new Short((short)(result.shortValue() / ((EvalResult)this.partialResults.get(i)).numericValue().shortValue()));
                } else if (result instanceof Long) {
                    result = new Long(result.longValue() / ((EvalResult)this.partialResults.get(i)).numericValue().longValue());
                } else if (result instanceof Byte) {
                    result = new Long(result.byteValue() / ((EvalResult)this.partialResults.get(i)).numericValue().byteValue());
                }
                ++i;
            }
            return result;
        }

        public EvalResult eval(EObject element) {
            int i = 0;
            while (i < this.partialResults.size()) {
                EvalResult r = (EvalResult)this.partialResults.get(i);
                r.eval(element);
                ++i;
            }
            if (this.expression != null || !(this.operand instanceof SimpleOperand)) {
                this.resetValues();
                this.complete = false;
            } else if (this.isValidContext(element)) {
                this.context = element;
                this.resetValues();
                this.complete = false;
            }
            this.computePartialResult();
            return this;
        }

        protected EClass getContextType() {
            if (this.operand instanceof SimpleOperandImpl) {
                if (((SimpleOperand)this.operand).getType() != null) {
                    return ((SimpleOperand)this.operand).getType();
                }
                if (((SimpleOperand)this.operand).getFeature() != null) {
                    return ((SimpleOperand)this.operand).getFeature().getEContainingClass();
                }
            }
            return null;
        }

        protected Number integerDevide() {
            int result = 0;
            boolean first = true;
            int i = 0;
            while (i < this.partialResults.size() && i < 2) {
                if (first) {
                    result = ((EvalResult)this.partialResults.get(i)).numericValue().intValue();
                    first = false;
                } else {
                    result /= ((EvalResult)this.partialResults.get(i)).numericValue().intValue();
                }
                ++i;
            }
            return new Integer(result);
        }

        protected boolean isArithmeticExpressionComplete(ArithmeticExpression arithmeticExpression) {
            int i = 0;
            while (i < this.partialResults.size()) {
                if (!((EvalResult)this.partialResults.get(i)).isComplete()) {
                    return false;
                }
                ++i;
            }
            return i == arithmeticExpression.getArguments().size() - 1;
        }

        protected boolean isBetweenComplete() {
            if (this.partialResults.size() == 3) {
                EvalResult lhs = (EvalResult)this.partialResults.get(0);
                EvalResult rhs1 = (EvalResult)this.partialResults.get(1);
                EvalResult rhs2 = (EvalResult)this.partialResults.get(2);
                if (lhs.isComplete() && rhs1.isComplete() && rhs2.isComplete()) {
                    int c2;
                    int c1 = this.compare(rhs1, lhs);
                    this.compareResult = c1 > 0 ? -1 : ((c2 = this.compare(lhs, rhs2)) > 0 ? 1 : 0);
                    this.complete = true;
                    return true;
                }
            }
            return false;
        }

        protected boolean isBinaryComplete() {
            if (this.partialResults.size() == 2) {
                EvalResult lhs = (EvalResult)this.partialResults.get(0);
                EvalResult rhs = (EvalResult)this.partialResults.get(1);
                if (lhs.isComplete() && rhs.isComplete()) {
                    this.compareResult = this.compare(lhs, rhs);
                    this.complete = true;
                    return true;
                }
            }
            return false;
        }

        protected boolean isBoolean() {
            return this.valueType == 4;
        }

        public boolean isComplete() {
            if (this.complete) {
                return true;
            }
            if (this.objectValue != null || this.stringValue != null || this.booleanValue != null || this.numericValue != null) {
                this.complete = true;
                return true;
            }
            return false;
        }

        protected boolean isInComplete() {
            if (this.partialResults.isEmpty()) {
                return false;
            }
            EvalResult lhs = (EvalResult)this.partialResults.get(0);
            if (!lhs.isComplete()) {
                return false;
            }
            int i = 1;
            int j = 1;
            this.compareResult = -1;
            while (i < this.partialResults.size()) {
                EvalResult rhs = (EvalResult)this.partialResults.get(1);
                if (rhs.isComplete()) {
                    ++j;
                    this.compareResult = this.compare(lhs, rhs);
                    if (this.compareResult == 0) {
                        this.complete = true;
                        return true;
                    }
                }
                ++i;
            }
            if (i == j) {
                this.complete = true;
                this.booleanValue = Boolean.FALSE;
            }
            return false;
        }

        protected boolean isLikeComplete() {
            if (this.partialResults.size() == 2) {
                EvalResult lhs = (EvalResult)this.partialResults.get(0);
                EvalResult rhs = (EvalResult)this.partialResults.get(1);
                if (lhs.isComplete() && rhs.isComplete()) {
                    this.compareResult = this.like(lhs, rhs);
                    this.complete = true;
                    return true;
                }
            }
            return false;
        }

        protected boolean isNumeric() {
            return this.valueType == 2;
        }

        protected boolean isObject() {
            return this.valueType == 5;
        }

        protected boolean isString() {
            return this.valueType == 3;
        }

        protected boolean isValidContext(EObject element) {
            return this.contextType != null && element != null && (element.eClass() == this.contextType || QueryUtils.getAllSubTypes(this.contextType).contains(element.eClass()));
        }

        protected int like(EvalResult lhs, EvalResult rhs) {
            return this.like(lhs.stringValue(), rhs.stringValue());
        }

        protected int like(String lhs, String rhs) {
            if (((BinaryExpression)this.expression).isCaseInsensitive()) {
                lhs = lhs.toLowerCase();
                rhs = rhs.toLowerCase();
            }
            return QueryUtils.like(lhs, rhs);
        }

        protected Number mod() {
            Number result = null;
            int i = 0;
            while (i < this.partialResults.size() && i < 2) {
                if (result == null) {
                    result = ((EvalResult)this.partialResults.get(i)).numericValue();
                } else if (result instanceof Double) {
                    result = new Double(result.doubleValue() % ((EvalResult)this.partialResults.get(i)).numericValue().doubleValue());
                } else if (result instanceof Integer) {
                    result = new Integer(result.intValue() % ((EvalResult)this.partialResults.get(i)).numericValue().intValue());
                } else if (result instanceof Float) {
                    result = new Float(result.floatValue() % ((EvalResult)this.partialResults.get(i)).numericValue().floatValue());
                } else if (result instanceof Short) {
                    result = new Short((short)(result.shortValue() % ((EvalResult)this.partialResults.get(i)).numericValue().shortValue()));
                } else if (result instanceof Long) {
                    result = new Long(result.longValue() % ((EvalResult)this.partialResults.get(i)).numericValue().longValue());
                } else if (result instanceof Byte) {
                    result = new Long(result.byteValue() % ((EvalResult)this.partialResults.get(i)).numericValue().byteValue());
                }
                ++i;
            }
            return result;
        }

        protected Number multiply() {
            Number result = null;
            int i = 0;
            while (i < this.partialResults.size()) {
                if (result == null) {
                    result = ((EvalResult)this.partialResults.get(i)).numericValue();
                } else if (result instanceof Double) {
                    result = new Double(result.doubleValue() * ((EvalResult)this.partialResults.get(i)).numericValue().doubleValue());
                } else if (result instanceof Integer) {
                    result = new Integer(result.intValue() * ((EvalResult)this.partialResults.get(i)).numericValue().intValue());
                } else if (result instanceof Float) {
                    result = new Float(result.floatValue() * ((EvalResult)this.partialResults.get(i)).numericValue().floatValue());
                } else if (result instanceof Short) {
                    result = new Short((short)(result.shortValue() * ((EvalResult)this.partialResults.get(i)).numericValue().shortValue()));
                } else if (result instanceof Long) {
                    result = new Long(result.longValue() * ((EvalResult)this.partialResults.get(i)).numericValue().longValue());
                } else if (result instanceof Byte) {
                    result = new Long(result.byteValue() * ((EvalResult)this.partialResults.get(i)).numericValue().byteValue());
                }
                ++i;
            }
            return result;
        }

        public Number numericValue() {
            return this.numericValue;
        }

        public Object objectValue() {
            return this.objectValue;
        }

        public boolean reset(EObject element) {
            if (this.isValidContext(element)) {
                this.context = null;
                this.complete = false;
            }
            int i = 0;
            while (i < this.partialResults.size()) {
                EvalResult r = (EvalResult)this.partialResults.get(i);
                if (!r.reset(element)) {
                    this.complete = false;
                }
                ++i;
            }
            if (!this.complete) {
                this.resetValues();
            }
            return this.isComplete();
        }

        protected void resetValues() {
            this.numericValue = null;
            this.stringValue = null;
            this.objectValue = null;
            this.booleanValue = null;
        }

        public String stringValue() {
            if (this.stringValue != null) {
                return this.stringValue;
            }
            if (this.numericValue != null) {
                return this.numericValue.toString();
            }
            if (this.booleanValue != null) {
                return this.booleanValue.toString();
            }
            if (this.objectValue != null) {
                return this.objectValue.toString();
            }
            return "";
        }

        protected Number substract() {
            Number result = null;
            int i = 0;
            while (i < this.partialResults.size()) {
                if (result == null) {
                    result = ((EvalResult)this.partialResults.get(i)).numericValue();
                } else if (result instanceof Double) {
                    result = new Double(result.doubleValue() - ((EvalResult)this.partialResults.get(i)).numericValue().doubleValue());
                } else if (result instanceof Integer) {
                    result = new Integer(result.intValue() - ((EvalResult)this.partialResults.get(i)).numericValue().intValue());
                } else if (result instanceof Float) {
                    result = new Float(result.floatValue() - ((EvalResult)this.partialResults.get(i)).numericValue().floatValue());
                } else if (result instanceof Short) {
                    result = new Short((short)(result.shortValue() - ((EvalResult)this.partialResults.get(i)).numericValue().shortValue()));
                } else if (result instanceof Long) {
                    result = new Long(result.longValue() - ((EvalResult)this.partialResults.get(i)).numericValue().longValue());
                } else if (result instanceof Byte) {
                    result = new Long(result.byteValue() - ((EvalResult)this.partialResults.get(i)).numericValue().byteValue());
                }
                ++i;
            }
            return result;
        }

        protected void updateArithmeticExpressionValue() {
            ArithmeticExpression arithmeticExpression = (ArithmeticExpression)((Object)this.expression);
            if (this.isArithmeticExpressionComplete(arithmeticExpression)) {
                switch (arithmeticExpression.getOperator().getValue()) {
                    case 0: {
                        this.numericValue = this.add();
                        break;
                    }
                    case 3: {
                        this.numericValue = this.divide();
                        break;
                    }
                    case 4: {
                        this.numericValue = this.integerDevide();
                        break;
                    }
                    case 5: {
                        this.numericValue = this.mod();
                        break;
                    }
                    case 2: {
                        this.numericValue = this.multiply();
                        break;
                    }
                    case 1: {
                        this.numericValue = this.substract();
                    }
                }
            }
        }

        protected void updateBinaryExpressionValue() {
            BinaryExpression binaryExpression = (BinaryExpression)this.expression;
            if (binaryExpression.getOperator() == RelationalOperators.BETWEEN_LITERAL) {
                if (this.isBetweenComplete()) {
                    this.booleanValue = this.compareResult == 0;
                }
            } else if (binaryExpression.getOperator() == RelationalOperators.IN_LITERAL) {
                if (this.isInComplete()) {
                    this.booleanValue = this.compareResult == 0;
                }
            } else if (binaryExpression.getOperator() == RelationalOperators.LIKE_LITERAL) {
                if (this.isLikeComplete()) {
                    this.booleanValue = this.compareResult == 0;
                }
            } else if (this.isBinaryComplete()) {
                switch (binaryExpression.getOperator().getValue()) {
                    case 2: {
                        this.booleanValue = this.compareResult == 0;
                        break;
                    }
                    case 4: {
                        this.booleanValue = this.compareResult >= 0;
                        break;
                    }
                    case 1: {
                        this.booleanValue = this.compareResult > 0;
                        break;
                    }
                    case 3: {
                        this.booleanValue = this.compareResult <= 0;
                        break;
                    }
                    case 0: {
                        this.booleanValue = this.compareResult < 0;
                        break;
                    }
                    case 5: {
                        this.booleanValue = this.compareResult != 0;
                    }
                }
            }
        }

        protected void updateLogicalExpressionValue() {
            LogicalExpression logicalExpression = (LogicalExpression)this.expression;
            int processed = 0;
            int i = 0;
            while (i < this.partialResults.size()) {
                EvalResult result = (EvalResult)this.partialResults.get(i);
                if (result.isComplete()) {
                    if (i == 0 && logicalExpression.getOperator().getValue() == 0) {
                        this.complete = true;
                        this.booleanValue = result.booleanValue() == false;
                    } else if (logicalExpression.getOperator().getValue() == 1) {
                        ++processed;
                        if (!result.booleanValue().booleanValue()) {
                            this.complete = true;
                            this.booleanValue = Boolean.FALSE;
                        }
                    } else if (logicalExpression.getOperator().getValue() == 2) {
                        ++processed;
                        if (result.booleanValue().booleanValue()) {
                            this.complete = true;
                            this.booleanValue = Boolean.TRUE;
                        }
                    }
                }
                if (this.complete) break;
                ++i;
            }
            if (!this.complete && logicalExpression.getArguments().size() == processed) {
                this.complete = true;
                if (logicalExpression.getOperator().getValue() == 1) {
                    this.booleanValue = Boolean.TRUE;
                } else if (logicalExpression.getOperator().getValue() == 2) {
                    this.booleanValue = logicalExpression.getArguments().size() == 0 ? Boolean.TRUE : Boolean.FALSE;
                }
            }
        }

        protected void updateNumericFunctionValue() {
            throw new RuntimeException("Not implemented yet !");
        }

        protected void updateSimpleOperand() {
            if (this.isComplete()) {
                return;
            }
            SimpleOperand simpleOperand = (SimpleOperand)this.operand;
            if (simpleOperand.getType() != null) {
                if (this.context == null) {
                    return;
                }
                this.valueType = 5;
                this.objectValue = this.context;
                this.complete = true;
            } else if (simpleOperand.getFeature() != null) {
                if (this.context == null) {
                    return;
                }
                try {
                    Object v = this.context.eGet(simpleOperand.getFeature(), false);
                    this.updateSimpleOperandValue(v);
                }
                catch (Exception exception) {}
            } else {
                Object v = SinglePassSimpleSearchQueryEngine.this.getNonModeledElementValue(this, simpleOperand);
                this.updateSimpleOperandValue(v);
            }
        }

        protected void updateSimpleOperandValue(Object v) {
            if (v instanceof Number) {
                this.numericValue = (Number)v;
                this.valueType = 2;
            } else if (v instanceof Boolean) {
                this.booleanValue = (Boolean)v;
                this.valueType = 4;
            } else if (v instanceof String) {
                this.stringValue = v.toString();
                this.valueType = 3;
            } else {
                this.objectValue = v;
                this.valueType = 5;
            }
            this.complete = true;
        }

        public EvalResult evalOnly(EStructuralFeature sf, Object value) {
            EClass c = sf.getEContainingClass();
            if (!SinglePassSimpleSearchQueryEngine.this.classPredicatesIndex.containsKey(c)) {
                this.complete = true;
                this.booleanValue = Boolean.TRUE;
                return this;
            }
            this.internalEvalOnly(sf, value);
            return this;
        }

        protected EvalResult internalEvalOnly(EStructuralFeature sf, Object value) {
            if (this.operand instanceof SimpleOperand && ((SimpleOperand)this.operand).getFeature() == sf) {
                this.objectValue = value;
                this.complete = true;
            } else {
                int i = 0;
                while (i < this.partialResults.size()) {
                    EvalResult r = (EvalResult)this.partialResults.get(i);
                    r.internalEvalOnly(sf, value);
                    ++i;
                }
                this.computePartialResult();
            }
            return this;
        }

        public int partialEvalOnly(EClass value) {
            if (!SinglePassSimpleSearchQueryEngine.this.classPredicatesIndex.containsKey(value)) {
                return 0;
            }
            return this.internalEvalOnly(value);
        }

        protected int internalEvalOnly(EClass value) {
            if (this.operand != null) {
                if (this.operand instanceof SimpleOperand) {
                    if (this.contextType == null || this.contextType == value) {
                        return (this.isComplete() ? 1 : 2) | 0x10;
                    }
                    return this.isComplete() ? 1 : 2;
                }
            } else {
                int i = 0;
                int k = 0;
                int f = 0;
                int t = 0;
                while (i < this.partialResults.size()) {
                    EvalResult r = (EvalResult)this.partialResults.get(i);
                    int res = r.internalEvalOnly(value);
                    if ((res & 0x10) != 0) {
                        ++k;
                        if ((res & 1) != 0) {
                            if ((res & 4) != 0) {
                                ++t;
                            } else if ((res & 8) != 0) {
                                ++f;
                            }
                        } else {
                            return 18;
                        }
                    }
                    ++i;
                }
                if (k == 0) {
                    return this.isComplete() ? 1 : 2;
                }
                if (this.expression instanceof BinaryExpression) {
                    if (this.isComplete()) {
                        if (this.booleanValue().booleanValue()) {
                            return 21;
                        }
                        return 25;
                    }
                    return 18;
                }
                if (this.expression instanceof LogicalExpression) {
                    LogicalExpression le = (LogicalExpression)this.expression;
                    if (le.getOperator() == LogicalOperators.AND_LITERAL) {
                        if (k == t) {
                            return 21;
                        }
                        return 25;
                    }
                    if (le.getOperator() == LogicalOperators.OR_LITERAL) {
                        if (t > 0) {
                            return 21;
                        }
                        if (f > 0) {
                            return 25;
                        }
                        return 18;
                    }
                    if (le.getOperator() == LogicalOperators.NOT_LITERAL) {
                        if (t > 0) {
                            return 25;
                        }
                        if (f > 0) {
                            return 21;
                        }
                        return 18;
                    }
                }
            }
            return 0;
        }

        public boolean resetOnly(EStructuralFeature sf) {
            EClass c = sf.getEContainingClass();
            if (!SinglePassSimpleSearchQueryEngine.this.classPredicatesIndex.containsKey(c)) {
                this.complete = false;
                this.booleanValue = null;
                return false;
            }
            return this.internalResetOnly(sf);
        }

        protected boolean internalResetOnly(EStructuralFeature sf) {
            if (this.operand instanceof SimpleOperand && ((SimpleOperand)this.operand).getFeature() == sf) {
                this.objectValue = null;
                this.complete = false;
            } else {
                int i = 0;
                while (i < this.partialResults.size()) {
                    EvalResult r = (EvalResult)this.partialResults.get(i);
                    if (!r.internalResetOnly(sf)) {
                        this.complete = false;
                    }
                    ++i;
                }
                if (!this.complete) {
                    this.resetValues();
                }
            }
            return this.isComplete();
        }

        public EObject getContext() {
            return this.context;
        }
    }

    public class SimpleSearchQueryEvaluator {
        protected WhereExpression getExpression(String string) {
            return (WhereExpression)SinglePassSimpleSearchQueryEngine.this.namesIndex.get(string);
        }

        protected Operand getOperand(String string) {
            return (Operand)SinglePassSimpleSearchQueryEngine.this.namesIndex.get(string);
        }

        protected EvalResult internalPrepareEvalResult() {
            if (SinglePassSimpleSearchQueryEngine.this.query.getWhereExpression() == null) {
                return new EvalResult();
            }
            if (SinglePassSimpleSearchQueryEngine.this.whereExpressionValuesIndex.get(SinglePassSimpleSearchQueryEngine.this.query.getWhereExpression()) != null) {
                return (EvalResult)SinglePassSimpleSearchQueryEngine.this.whereExpressionValuesIndex.get(SinglePassSimpleSearchQueryEngine.this.query.getWhereExpression());
            }
            return this.parseWhereExpression(SinglePassSimpleSearchQueryEngine.this.query.getWhereExpression());
        }

        protected EvalResult parseArithmeticExpression(ArithmeticExpression expression) {
            if (SinglePassSimpleSearchQueryEngine.this.whereExpressionValuesIndex.get(expression) != null) {
                return (EvalResult)SinglePassSimpleSearchQueryEngine.this.whereExpressionValuesIndex.get(expression);
            }
            if (expression.getName() != null && expression.getName().startsWith("$")) {
                return this.parseOperand(this.getOperand(expression.getName().substring(1)));
            }
            EvalResult result = SinglePassSimpleSearchQueryEngine.this.createEvalResult(expression);
            SinglePassSimpleSearchQueryEngine.this.whereExpressionValuesIndex.put(expression, result);
            for (Operand element : expression.getArguments()) {
                result.addPartialResult(this.parseOperand(element));
            }
            return result;
        }

        protected EvalResult parseBinaryExpression(BinaryExpression expression) {
            if (SinglePassSimpleSearchQueryEngine.this.whereExpressionValuesIndex.get(expression) != null) {
                return (EvalResult)SinglePassSimpleSearchQueryEngine.this.whereExpressionValuesIndex.get(expression);
            }
            if (expression.getName() != null && expression.getName().startsWith("$")) {
                return this.parseWhereExpression(this.getExpression(expression.getName().substring(1)));
            }
            EvalResult result = SinglePassSimpleSearchQueryEngine.this.createEvalResult(expression);
            SinglePassSimpleSearchQueryEngine.this.whereExpressionValuesIndex.put(expression, result);
            Operand operand = expression.getLeftOperand();
            result.addPartialResult(this.parseOperand(operand));
            for (Operand element : expression.getRightOperands()) {
                result.addPartialResult(this.parseOperand(element));
            }
            return result;
        }

        protected EvalResult parseLogicalExpression(LogicalExpression expression) {
            if (SinglePassSimpleSearchQueryEngine.this.whereExpressionValuesIndex.get(expression) != null) {
                return (EvalResult)SinglePassSimpleSearchQueryEngine.this.whereExpressionValuesIndex.get(expression);
            }
            if (expression.getName() != null && expression.getName().startsWith("$")) {
                return this.parseWhereExpression(this.getExpression(expression.getName().substring(1)));
            }
            EvalResult result = SinglePassSimpleSearchQueryEngine.this.createEvalResult(expression);
            SinglePassSimpleSearchQueryEngine.this.whereExpressionValuesIndex.put(expression, result);
            for (WhereExpression element : expression.getArguments()) {
                result.addPartialResult(this.parseWhereExpression(element));
            }
            return result;
        }

        protected EvalResult parseNumericFunction(NumericFunction function) {
            if (SinglePassSimpleSearchQueryEngine.this.whereExpressionValuesIndex.get(function) != null) {
                return (EvalResult)SinglePassSimpleSearchQueryEngine.this.whereExpressionValuesIndex.get(function);
            }
            if (function.getName() != null && function.getName().startsWith("$")) {
                return this.parseOperand(this.getOperand(function.getName().substring(1)));
            }
            EvalResult result = SinglePassSimpleSearchQueryEngine.this.createEvalResult(function);
            SinglePassSimpleSearchQueryEngine.this.whereExpressionValuesIndex.put(function, result);
            for (Operand element : function.getArguments()) {
                result.addPartialResult(this.parseOperand(element));
            }
            return result;
        }

        protected EvalResult parseOperand(Operand operand) {
            if (operand instanceof ArithmeticExpression) {
                return this.parseArithmeticExpression((ArithmeticExpression)operand);
            }
            if (operand instanceof NumericFunction) {
                return this.parseNumericFunction((NumericFunction)operand);
            }
            return this.parseSimpleOperand(operand);
        }

        protected EvalResult parseSimpleOperand(Operand operand) {
            if (SinglePassSimpleSearchQueryEngine.this.whereExpressionValuesIndex.get(operand) != null) {
                return (EvalResult)SinglePassSimpleSearchQueryEngine.this.whereExpressionValuesIndex.get(operand);
            }
            if (operand.getName() != null && operand.getName().startsWith("$")) {
                return this.parseSimpleOperand(this.getOperand(operand.getName().substring(1)));
            }
            EvalResult result = SinglePassSimpleSearchQueryEngine.this.createEvalResult(operand);
            SinglePassSimpleSearchQueryEngine.this.whereExpressionValuesIndex.put(operand, result);
            return result;
        }

        protected EvalResult parseWhereExpression(WhereExpression expression) {
            if (expression instanceof LogicalExpression) {
                return this.parseLogicalExpression((LogicalExpression)expression);
            }
            return this.parseBinaryExpression((BinaryExpression)expression);
        }

        public EvalResult prepareEvalResult() {
            return this.internalPrepareEvalResult();
        }
    }
}

