/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util.internal;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.hyades.models.hierarchy.util.ObjectToIntMap;
import org.eclipse.hyades.models.hierarchy.util.internal.ObjectToIntMapImpl;

public class TPTPVirtualMemoryManager {
    Map ownerToData = new IdentityHashMap();
    ObjectToIntMap ownerToIndexBits = new ObjectToIntMapImpl();
    public static final TPTPVirtualMemoryManager INSTANCE = new TPTPVirtualMemoryManager();

    protected TPTPVirtualMemoryManager() {
    }

    public Object getData(Object owner) {
        return this.ownerToData.get(owner);
    }

    public void setData(Object owner, Object data) {
        this.ownerToData.put(owner, data);
    }

    public void dumpStats() {
        ObjectToIntMapImpl objectToCountMap = new ObjectToIntMapImpl();
        ObjectToIntMapImpl objectToSizeMap = new ObjectToIntMapImpl();
        Set entrySet = this.ownerToData.entrySet();
        for (Map.Entry entry : entrySet) {
            int i = objectToCountMap.getInt(entry.getKey().getClass());
            if (i == -1) {
                i = 0;
            }
            objectToCountMap.put((Object)entry.getKey().getClass(), i + 1);
            int size = 0;
            if (entry.getValue() instanceof Object[]) {
                Object[] v = (Object[])entry.getValue();
                int j = v.length;
                while (--j >= 0) {
                    if (v[j] instanceof String) {
                        size += ((String)v[j]).length() * 2;
                    }
                    if (v[j] instanceof byte[]) {
                        size += ((byte[])v[j]).length;
                    }
                    if (!(v[j] instanceof List)) continue;
                    size += ((List)v[j]).size() * 4;
                }
            }
            if (size == 0) {
                size = 4;
            }
            if ((i = objectToSizeMap.getInt(entry.getKey().getClass())) == -1) {
                i = 0;
            }
            objectToSizeMap.put((Object)entry.getKey().getClass(), i + size);
        }
        System.out.println("TPTPVirtualMemoryManager.dumpStats()");
        int i = objectToCountMap.getKeys().length;
        while (--i >= 0) {
            if (objectToCountMap.getKeys()[i] == ObjectToIntMapImpl.MISSING_KEY) continue;
            System.out.println("key=" + ((Class)objectToCountMap.getKeys()[i]).getName() + ", count=" + objectToCountMap.getValues()[i] + ", size=" + objectToSizeMap.getInt(objectToCountMap.getKeys()[i]));
        }
    }

    public void setIndexBits(Object owner, int offset, int indexBits) {
        this.ownerToIndexBits.put(owner, indexBits);
    }

    public int getIndexBits(Object owner, int offset) {
        int i = this.ownerToIndexBits.getInt(owner);
        if (i == -1) {
            return 0;
        }
        return i;
    }
}

