/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.navigator;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.util.HyadesViewerSorter;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.hyades.ui.util.INamedElement;
import org.eclipse.jface.viewers.Viewer;

public class NavigatorViewerSorter
extends HyadesViewerSorter
implements IDisposable {
    private INavigator navigator = null;
    private int criteria = -1;
    public static final int SORTER_TYPE = NavigatorViewerSorter.class.hashCode();
    public static final int NAME = 1;
    public static final int TYPE = 2;
    public static final String RESOURCE_VALUE_DELIMITER = "_+_";

    public NavigatorViewerSorter(INavigator navigator, int criteria) {
        this.navigator = navigator;
        this.criteria = criteria != 1 && criteria != 2 ? 1 : criteria;
    }

    public void dispose() {
        this.navigator = null;
    }

    public INavigator getNavigator() {
        return this.navigator;
    }

    public void setCriteria(int newCriteria) {
        if (this.criteria == newCriteria) {
            return;
        }
        if (newCriteria != 1 && newCriteria != 2) {
            return;
        }
        this.criteria = newCriteria;
        if (this.navigator.getViewer() != null) {
            this.navigator.getViewer().refresh();
        }
        this.navigator.handleChange(SORTER_TYPE);
    }

    public int getCriteria() {
        return this.criteria;
    }

    public int category(Object element) {
        if (element instanceof IProject) {
            return 1000;
        }
        if (element instanceof IFolder) {
            return 400;
        }
        if (element instanceof LogicalFolder) {
            return 200;
        }
        return 600;
    }

    protected String getValue(Viewer viewer, Object e) {
        String value = null;
        if (e instanceof LogicalFolder && (value = this.getLogicalFolderValue(viewer, (LogicalFolder)e)) != null) {
            return value;
        }
        if (e instanceof IResource && (value = this.getResourceValue(viewer, (IResource)e)) != null) {
            return value;
        }
        if (e instanceof IAdaptable && (value = this.getAdaptableValue(viewer, (IAdaptable)e)) != null) {
            return value;
        }
        if (e instanceof INamedElement && (value = this.getNamedElementValue(viewer, (INamedElement)e)) != null) {
            return value;
        }
        return super.getValue(viewer, e);
    }

    protected String getLogicalFolderValue(Viewer viewer, LogicalFolder logicalFolder) {
        return "0";
    }

    protected String getResourceValue(Viewer viewer, IResource resource) {
        String resourceName = resource.getName().trim();
        String fileExtension = resource.getFileExtension();
        if (resource instanceof IContainer || fileExtension == null) {
            fileExtension = "";
        } else if (resourceName.endsWith(".".concat(fileExtension.trim()))) {
            resourceName = resourceName.substring(0, resourceName.length() - fileExtension.length() - 1);
        }
        if (this.getCriteria() == 1) {
            return String.valueOf(resourceName) + RESOURCE_VALUE_DELIMITER + fileExtension;
        }
        return String.valueOf(fileExtension) + RESOURCE_VALUE_DELIMITER + resourceName;
    }

    protected String getAdaptableValue(Viewer viewer, IAdaptable adaptable) {
        IResource resource = (IResource)adaptable.getAdapter(IResource.class);
        if (resource == null) {
            return null;
        }
        return this.getResourceValue(viewer, resource);
    }

    protected String getNamedElementValue(Viewer viewer, INamedElement namedElement) {
        return namedElement.getName();
    }
}

