/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.navigator.action;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.ITreeNavigator;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigator;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.framelist.BackAction;
import org.eclipse.ui.views.framelist.ForwardAction;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.GoIntoAction;
import org.eclipse.ui.views.framelist.UpAction;

public class FrameListActionGroup
extends NavigatorActionGroup {
    private BackAction backAction;
    private ForwardAction forwardAction;
    private GoIntoAction goIntoAction;
    private UpAction upAction;
    private IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            FrameListActionGroup.this.updateActionBars();
        }
    };

    public FrameListActionGroup(ITreeNavigator treeNavigator) {
        super((INavigator)treeNavigator);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.resourceChangeListener = null;
        super.dispose();
    }

    protected void createActions() {
        FrameList frameList = ((TreeNavigator)this.getNavigator()).getFrameList();
        this.goIntoAction = new GoIntoAction(frameList);
        this.backAction = new BackAction(frameList);
        this.forwardAction = new ForwardAction(frameList);
        this.upAction = new UpAction(frameList);
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection structuredSelection = (IStructuredSelection)this.getContext().getSelection();
        if (structuredSelection.size() == 1 && this.canBeFrameRoot(structuredSelection.getFirstElement())) {
            menu.appendToGroup("org.eclipse.ui.OpenWithSubMenu", (IAction)this.goIntoAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler("goInto", (IAction)this.goIntoAction);
        actionBars.setGlobalActionHandler(ActionFactory.BACK.getId(), (IAction)this.backAction);
        actionBars.setGlobalActionHandler(ActionFactory.FORWARD.getId(), (IAction)this.forwardAction);
        actionBars.setGlobalActionHandler("up", (IAction)this.upAction);
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IAction)this.backAction);
        toolBar.add((IAction)this.forwardAction);
        toolBar.add((IAction)this.upAction);
    }

    public void updateActionBars() {
        IStructuredSelection structuredSelection;
        ActionContext context = this.getContext();
        boolean enable = false;
        if (context != null && (structuredSelection = (IStructuredSelection)context.getSelection()).size() == 1) {
            enable = this.canBeFrameRoot(structuredSelection.getFirstElement());
        }
        this.goIntoAction.setEnabled(enable);
    }

    protected boolean canBeFrameRoot(Object element) {
        StructuredViewer viewer = this.getNavigator().getViewer();
        if (viewer instanceof TreeViewer) {
            return ((TreeViewer)viewer).isExpandable(element);
        }
        if (element instanceof IProject && !((IProject)element).isOpen()) {
            return false;
        }
        return element instanceof IContainer;
    }
}

