/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ContentProviderPicker
implements ITreeContentProvider {
    private List providers = new ArrayList();
    private int currentProvider = -1;

    public void dispose() {
        this.currentProvider = -1;
        for (ITreeContentProvider treeContentProvider : this.providers) {
            treeContentProvider.dispose();
        }
        this.providers.clear();
    }

    public void addProvider(ITreeContentProvider contentProvider) {
        if (this.providers.add(contentProvider) && this.currentProvider < 0) {
            this.currentProvider = this.providers.size() - 1;
        }
    }

    public void clearProviders() {
        this.currentProvider = -1;
        this.providers.clear();
    }

    public void removeProvider(int index) {
        if (index == this.currentProvider) {
            this.currentProvider = -1;
        } else if (index < this.currentProvider) {
            --this.currentProvider;
        }
        this.providers.remove(index);
    }

    public boolean setCurrentProvider(int index) {
        if (index < 0 || index >= this.providers.size()) {
            return false;
        }
        if (index == this.currentProvider) {
            return true;
        }
        this.currentProvider = index;
        return true;
    }

    public ITreeContentProvider getCurrentProvider() {
        if (this.currentProvider < 0) {
            return null;
        }
        return (ITreeContentProvider)this.providers.get(this.currentProvider);
    }

    public int getCurrentProviderIndex() {
        return this.currentProvider;
    }

    public Object[] getChildren(Object parentElement) {
        if (this.getCurrentProviderIndex() < 0) {
            return new Object[0];
        }
        return this.getCurrentProvider().getChildren(parentElement);
    }

    public Object getParent(Object element) {
        if (this.getCurrentProviderIndex() < 0) {
            return null;
        }
        return this.getCurrentProvider().getParent(element);
    }

    public boolean hasChildren(Object element) {
        if (this.getCurrentProviderIndex() < 0) {
            return false;
        }
        return this.getCurrentProvider().hasChildren(element);
    }

    public Object[] getElements(Object inputElement) {
        if (this.getCurrentProviderIndex() < 0) {
            return new Object[0];
        }
        return this.getCurrentProvider().getElements(inputElement);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.getCurrentProviderIndex() < 0) {
            return;
        }
        this.getCurrentProvider().inputChanged(viewer, oldInput, newInput);
    }
}

