/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.provider;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.ui.adapter.IHyadesWorkbenchAdapter;
import org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater;
import org.eclipse.hyades.ui.internal.util.UIMessages;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class WorkbenchAdapterContentProvider
implements ITreeContentProvider,
IResourceChangeListener {
    private Class adapterClass;
    private Viewer viewer;
    private IResourceChangeUpdater resourceChangeUpdater;
    private IWorkspace currentWorkspace;

    public WorkbenchAdapterContentProvider(Class adapterClass) throws IllegalArgumentException {
        if (adapterClass == null || !IWorkbenchAdapter.class.isAssignableFrom(adapterClass)) {
            throw new IllegalArgumentException(UIMessages._10);
        }
        this.adapterClass = adapterClass;
        this.inputChanged(null, null, ResourcesPlugin.getWorkspace());
    }

    public void dispose() {
        if (this.currentWorkspace != null) {
            this.currentWorkspace.removeResourceChangeListener((IResourceChangeListener)this);
            this.currentWorkspace = null;
        }
        this.adapterClass = null;
        this.resourceChangeUpdater = null;
        this.viewer = null;
    }

    public void setResourceChangeUpdater(IResourceChangeUpdater resourceChangeUpdater) {
        this.resourceChangeUpdater = resourceChangeUpdater;
    }

    public IResourceChangeUpdater getResourceChangeUpdater() {
        return this.resourceChangeUpdater;
    }

    protected IWorkbenchAdapter getAdapter(Object o) {
        if (!(o instanceof IAdaptable)) {
            return null;
        }
        return (IWorkbenchAdapter)((IAdaptable)o).getAdapter(this.adapterClass);
    }

    public Object getParent(Object element) {
        IWorkbenchAdapter adapter = this.getAdapter(element);
        if (adapter == null) {
            return null;
        }
        return adapter.getParent(element);
    }

    public boolean hasChildren(Object element) {
        IWorkbenchAdapter adapter = this.getAdapter(element);
        if (adapter == null) {
            return false;
        }
        if (adapter instanceof IHyadesWorkbenchAdapter) {
            return ((IHyadesWorkbenchAdapter)adapter).hasChildren(element);
        }
        return adapter.getChildren(element).length > 0;
    }

    public Object[] getChildren(Object parentElement) {
        IWorkbenchAdapter adapter = this.getAdapter(parentElement);
        if (adapter == null) {
            return new Object[0];
        }
        return adapter.getChildren(parentElement);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        IWorkspace newWorkspace = null;
        if (newInput instanceof IWorkspace) {
            newWorkspace = (IWorkspace)newInput;
        } else if (newInput instanceof IContainer) {
            newWorkspace = ((IContainer)newInput).getWorkspace();
        }
        if (newWorkspace != null && this.currentWorkspace != newWorkspace) {
            if (this.currentWorkspace != null) {
                this.currentWorkspace.removeResourceChangeListener((IResourceChangeListener)this);
            }
            this.currentWorkspace = newWorkspace;
            this.currentWorkspace.addResourceChangeListener((IResourceChangeListener)this, 1);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.getResourceChangeUpdater() == null || !this.getResourceChangeUpdater().isActive()) {
            return;
        }
        final IResourceDelta delta = event.getDelta();
        Control ctrl = this.viewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            this.getResourceChangeUpdater().started();
            try {
                ctrl.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        WorkbenchAdapterContentProvider.this.processDelta(delta);
                    }
                });
            }
            finally {
                this.getResourceChangeUpdater().ended();
            }
        }
    }

    protected void processDelta(IResourceDelta delta) {
        int i;
        IResourceChangeUpdater resourceChangeUpdater = this.getResourceChangeUpdater();
        if (resourceChangeUpdater == null || !this.getResourceChangeUpdater().isActive()) {
            return;
        }
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        IResource resource = delta.getResource();
        IResourceDelta[] affectedChildren = delta.getAffectedChildren(4);
        int i2 = 0;
        while (i2 < affectedChildren.length) {
            int flags = affectedChildren[i2].getFlags();
            if ((flags & 0x8000) != 0 ? resourceChangeUpdater.updateChildrenType(resource) : (flags & 0x100) != 0 && resourceChangeUpdater.updateContent(resource, affectedChildren[i2].getResource())) {
                return;
            }
            ++i2;
        }
        int changeFlags = delta.getFlags();
        if ((changeFlags & 0x14000) != 0 && resourceChangeUpdater.updateProperties(resource)) {
            return;
        }
        if ((changeFlags & 0x40000) != 0 && resourceChangeUpdater.replaced(resource)) {
            return;
        }
        int i3 = 0;
        while (i3 < affectedChildren.length) {
            this.processDelta(affectedChildren[i3]);
            ++i3;
        }
        affectedChildren = delta.getAffectedChildren(2);
        if (affectedChildren.length > 0) {
            IResource[] affected = new IResource[affectedChildren.length];
            i = 0;
            while (i < affectedChildren.length) {
                affected[i] = affectedChildren[i].getResource();
                ++i;
            }
            if (resourceChangeUpdater.remove(resource, affected)) {
                return;
            }
        }
        if ((affectedChildren = delta.getAffectedChildren(1)).length > 0) {
            IResource[] affected = new IResource[affectedChildren.length];
            i = 0;
            while (i < affectedChildren.length) {
                affected[i] = affectedChildren[i].getResource();
                ++i;
            }
            if (resourceChangeUpdater.add(resource, affected)) {
                return;
            }
        }
    }
}

