/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.ui.internal.util.ResourceUtil;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaUtil {
    public static void setVariableValue(final String variable, final String value, IProgressMonitor progressMonitor) throws JavaModelException, InterruptedException, InvocationTargetException {
        if (variable == null || value == null) {
            return;
        }
        String currentValue = JavaUtil.getVariableValue(variable);
        if (currentValue != null) {
            if (value.equals(currentValue)) {
                return;
            }
            if (new File(value).equals(new File(currentValue))) {
                return;
            }
        }
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                JavaCore.setClasspathVariable((String)variable, (IPath)new Path(value), (IProgressMonitor)monitor);
            }
        };
        operation.run(progressMonitor);
    }

    public static String getVariableValue(String variable) {
        String value;
        IPath path = JavaCore.getClasspathVariable((String)variable);
        if (path != null && !(value = path.makeAbsolute().toString()).equals("")) {
            return value;
        }
        return null;
    }

    public static String[] getProjectClasspath(IProject project, boolean exportedOnly) {
        if (project == null) {
            return new String[0];
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return new String[0];
        }
        ArrayList<IClasspathEntry> cpEntries = null;
        try {
            cpEntries = new ArrayList<IClasspathEntry>(Arrays.asList(javaProject.getRawClasspath()));
        }
        catch (JavaModelException javaModelException) {}
        if (cpEntries == null || cpEntries.isEmpty()) {
            return new String[0];
        }
        HashSet<String> classpath = new HashSet<String>(cpEntries.size());
        try {
            IPath path = javaProject.getOutputLocation();
            if (path != null) {
                classpath.add(ResourceUtil.getFullPath((IPath)path));
            }
        }
        catch (JavaModelException javaModelException) {}
        Iterator i = cpEntries.iterator();
        while (i.hasNext()) {
            IClasspathEntry entry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)((IClasspathEntry)i.next()));
            if (exportedOnly && !entry.isExported()) continue;
            String strcp = null;
            switch (entry.getEntryKind()) {
                case 1: 
                case 4: {
                    strcp = ResourceUtil.getFullPath((IPath)entry.getPath());
                    if (strcp == null) break;
                    classpath.add(strcp);
                    break;
                }
                case 2: {
                    IPath projectPath = entry.getPath().makeAbsolute();
                    IProject parentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectPath.toString());
                    classpath.addAll(Arrays.asList(JavaUtil.getProjectClasspath(parentProject, true)));
                    break;
                }
                case 5: {
                    break;
                }
                case 3: {
                    strcp = ResourceUtil.getFullPath((IPath)entry.getOutputLocation());
                    if (strcp == null) break;
                    classpath.add(strcp);
                }
            }
        }
        return classpath.toArray(new String[classpath.size()]);
    }

    public static void revealJavaElementAtLine(IJavaElement javaElement, int line) throws CoreException {
        IEditorPart editorPart;
        if (javaElement != null && (editorPart = JavaUI.openInEditor((IJavaElement)javaElement)) != null && editorPart instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editorPart;
            try {
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                textEditor.selectAndReveal(document.getLineOffset(line - 1), document.getLineLength(line - 1));
            }
            catch (BadLocationException badLocationException) {}
        }
    }
}

