/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.hyades.ui.internal.util.CoreUtil;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;

public class UIUtil
extends org.eclipse.tptp.platform.common.ui.internal.util.UIUtil {
    public static boolean fireCurrentSelection(StructuredViewer structuredViewer) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)structuredViewer, structuredViewer.getSelection());
        try {
            CoreUtil.invokeObjectMethod(structuredViewer, "fireSelectionChanged", new Object[]{event}, true);
        }
        catch (RuntimeException e) {
            CommonPlugin.logError((Throwable)e);
            return false;
        }
        return true;
    }

    public static IEditorPart getOpenEditor(IFile inputFile) {
        IWorkbenchPage activePage = UIUtil.getActiveWorkbenchPage();
        if (activePage == null) {
            return null;
        }
        IEditorReference[] editorReferences = activePage.getEditorReferences();
        int i = 0;
        int length = editorReferences.length;
        while (i < length) {
            IEditorInput input;
            IEditorPart editorPart = editorReferences[i].getEditor(false);
            if (editorPart != null && (input = editorPart.getEditorInput()) != null && input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                if (file != null && inputFile != null && file.equals((Object)inputFile)) {
                    return editorPart;
                }
                if (file == null && inputFile == null) {
                    return editorPart;
                }
            }
            ++i;
        }
        return null;
    }

    public static Object[] applyFilters(StructuredViewer structuredViewer, Object parent, Object[] elements) {
        if (elements.length == 0) {
            return elements;
        }
        ViewerFilter[] filters = structuredViewer.getFilters();
        int i = 0;
        int maxi = filters.length;
        while (i < maxi) {
            if ((elements = filters[i].filter((Viewer)structuredViewer, parent, elements)).length == 0) {
                return elements;
            }
            ++i;
        }
        return elements;
    }

    public static void integerStyledTextVerifyKey(VerifyEvent event) {
        if (event.doit) {
            switch (event.keyCode) {
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: 
                case 0x1000007: 
                case 0x1000008: {
                    return;
                }
            }
            switch (event.character) {
                case '\b': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case '\u007f': {
                    return;
                }
            }
            event.doit = false;
            return;
        }
    }

    public static String validateJavaFileName(String valueStr) {
        if (Character.isDigit(valueStr.charAt(0))) {
            return new Character(valueStr.charAt(0)).toString();
        }
        int i = 0;
        while (i < valueStr.length()) {
            char ch = valueStr.charAt(i);
            switch (ch) {
                case '!': {
                    return new Character(ch).toString();
                }
                case '@': {
                    return new Character(ch).toString();
                }
                case '#': {
                    return new Character(ch).toString();
                }
                case '^': {
                    return new Character(ch).toString();
                }
                case '\'': {
                    return new Character(ch).toString();
                }
                case '`': {
                    return new Character(ch).toString();
                }
                case '<': {
                    return new Character(ch).toString();
                }
                case '>': {
                    return new Character(ch).toString();
                }
                case '-': {
                    if (i != 0) {
                        return new Character(ch).toString();
                    }
                }
                case '+': {
                    return new Character(ch).toString();
                }
                case ' ': {
                    return "<space>";
                }
                case '|': {
                    return new Character(ch).toString();
                }
                case '*': {
                    return new Character(ch).toString();
                }
                case '{': {
                    return new Character(ch).toString();
                }
                case '}': {
                    return new Character(ch).toString();
                }
                case '[': {
                    return new Character(ch).toString();
                }
                case ']': {
                    return new Character(ch).toString();
                }
                case '(': {
                    return new Character(ch).toString();
                }
                case ')': {
                    return new Character(ch).toString();
                }
                case ':': {
                    return new Character(ch).toString();
                }
                case ';': {
                    return new Character(ch).toString();
                }
                case ',': {
                    return new Character(ch).toString();
                }
                case '\"': {
                    return new Character(ch).toString();
                }
                case '/': {
                    return new Character(ch).toString();
                }
                case '\\': {
                    return new Character(ch).toString();
                }
                case '~': {
                    return new Character(ch).toString();
                }
                case '=': {
                    return new Character(ch).toString();
                }
                case '?': {
                    return new Character(ch).toString();
                }
            }
            ++i;
        }
        return null;
    }

    public static IProject getFirstOpenProject() {
        IProject[] workspaceProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int counter = 0;
        while (counter < workspaceProjects.length) {
            if (workspaceProjects[counter].isOpen()) {
                return workspaceProjects[counter];
            }
            ++counter;
        }
        return null;
    }
}

