/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.ui.internal.filters.FilterTypesManager;
import org.eclipse.hyades.ui.internal.filters.IFilterType;
import org.eclipse.hyades.ui.internal.util.UIMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardDataTransferPage;

public abstract class ExportImportFilterWizardPage
extends WizardDataTransferPage
implements Listener,
ModifyListener,
SelectionListener,
IRunnableWithProgress {
    protected Button sourceBrowseButton;
    protected Text sourceNameField;
    private DoubleList doubleList;

    public ExportImportFilterWizardPage(String name, IWorkbench aWorkbench, IStructuredSelection selection) {
        super(name);
    }

    protected DoubleList getDoubleList() {
        return this.doubleList;
    }

    protected void initializeValues() {
        List source = new ArrayList();
        ArrayList target = new ArrayList();
        source = this.populateFilterList();
        this.doubleList.removeAll();
        this.doubleList.initializeSourceList(source);
        this.doubleList.initializeTargetList(target);
        this.doubleList.refreshViews();
    }

    public void handleEvent(Event event) {
        if (event.widget == this.sourceBrowseButton) {
            this.handleSourceBrowseButtonPressed();
        }
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.determinePageCompletion());
    }

    public void run(IProgressMonitor mon) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.setPageComplete(this.determinePageCompletion());
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    protected void createSourceGroup(Composite parent) {
        Composite sourceContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        sourceContainerGroup.setLayout((Layout)layout);
        sourceContainerGroup.setLayoutData((Object)new GridData(768));
        new Label(sourceContainerGroup, 0).setText(UIMessages._125);
        this.sourceNameField = new Text(sourceContainerGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.sourceNameField.setLayoutData((Object)data);
        this.sourceBrowseButton = new Button(sourceContainerGroup, 8);
        this.sourceBrowseButton.setText(UIMessages._133);
        this.sourceBrowseButton.addListener(13, (Listener)this);
        this.sourceBrowseButton.setLayoutData((Object)new GridData(256));
        this.sourceNameField.setFocus();
        this.sourceNameField.addModifyListener((ModifyListener)this);
    }

    protected void createDoubleList(Composite composite, String leftListHeading, String rightListHeading) {
        this.doubleList = new DoubleList(composite, 0, leftListHeading, rightListHeading);
        this.doubleList.createControl();
        this.initializeValues();
        this.doubleList.addSelectionListener(this);
    }

    protected boolean determinePageCompletion() {
        boolean complete = this.validateSourceGroup() && this.validateOptionsGroup();
        boolean validLists = this.validateLists();
        if (validLists) {
            this.setErrorMessage(null);
        }
        return complete && validLists;
    }

    protected void handleSourceBrowseButtonPressed() {
        String currentSource = this.sourceNameField.getText();
        FileDialog dlg = new FileDialog(this.sourceNameField.getShell());
        dlg.setFilterPath(currentSource);
        dlg.setFilterExtensions(new String[]{"*.filtxml", "*.*"});
        dlg.open();
        String fileName = dlg.getFileName();
        if (fileName != null && !fileName.equals("")) {
            this.sourceNameField.setText(String.valueOf(dlg.getFilterPath()) + File.separator + fileName);
        }
    }

    protected void updateWidgetEnablements() {
        boolean pageComplete = this.determinePageCompletion();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setMessage(null);
        }
        super.updateWidgetEnablements();
    }

    protected boolean validateSourceGroup() {
        if (this.sourceNameField == null) {
            return false;
        }
        return !this.sourceNameField.getText().trim().equals("") && this.doubleList.getTargetItems().size() > 0;
    }

    public abstract boolean finish();

    protected abstract List populateFilterList();

    public abstract void createControl(Composite var1);

    protected abstract boolean validateLists();

    class DoubleList {
        Group group;
        Composite groupWidget;
        private String NAME_TEXT = "name";
        private String[] tableColumnProperties = new String[]{this.NAME_TEXT};
        private TableViewer sourceList;
        private TableViewer targetList;
        private List sourceContent = new ArrayList();
        private List targetContent = new ArrayList();
        private Button add;
        private Button remove;
        private Button addAll;
        private Button removeAll;
        private List listeners = new ArrayList(2);
        private TableLabelProvider labelProvider;
        private Composite parent;
        private int style;
        private String sourceText;
        private String targetText;

        protected void sourceListDoubleClick() {
            if (this.sourceList.getSelection().isEmpty()) {
                return;
            }
            IStructuredSelection sel = (IStructuredSelection)this.sourceList.getSelection();
            for (Object item : sel) {
                this.targetContent.add(item);
                this.sourceContent.remove(item);
            }
            this.sourceList.setSelection((ISelection)StructuredSelection.EMPTY);
            this.refreshViews();
        }

        protected void targetListDoubleClick() {
            if (this.targetList.getSelection().isEmpty()) {
                return;
            }
            IStructuredSelection sel = (IStructuredSelection)this.targetList.getSelection();
            for (Object item : sel) {
                this.sourceContent.add(item);
                this.targetContent.remove(item);
            }
            this.targetList.setSelection((ISelection)StructuredSelection.EMPTY);
            this.refreshViews();
        }

        public DoubleList(Composite parent, int style, String sourceText, String targetText) {
            this.parent = parent;
            this.style = style;
            this.sourceText = sourceText;
            this.targetText = targetText;
        }

        public Control createControl() {
            this.group = new Group(this.parent, this.style);
            this.group.setText("");
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 0;
            this.group.setLayout((Layout)layout);
            this.group.setLayoutData((Object)GridUtil.createFill());
            this.createDoubleList((Composite)this.group, this.sourceText, this.targetText);
            WidgetListener listener = new WidgetListener();
            this.add.addSelectionListener((SelectionListener)listener);
            this.remove.addSelectionListener((SelectionListener)listener);
            this.addAll.addSelectionListener((SelectionListener)listener);
            this.removeAll.addSelectionListener((SelectionListener)listener);
            this.sourceList.getTable().addSelectionListener((SelectionListener)listener);
            this.targetList.getTable().addSelectionListener((SelectionListener)listener);
            return this.group;
        }

        public void refreshViews() {
            this.sourceList.refresh();
            this.targetList.refresh();
            ExportImportFilterWizardPage.this.updatePageCompletion();
        }

        public void createDoubleList(Composite parent, String sourceText, String targetText) {
            this.groupWidget = parent;
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            this.groupWidget.setLayout((Layout)layout);
            this.createTableGroup(this.groupWidget, sourceText, true);
            this.createButtonGroup(this.groupWidget);
            this.createTableGroup(this.groupWidget, targetText, false);
            this.labelProvider = new TableLabelProvider();
        }

        public void initializeSourceList(List source) {
            this.sourceContent.addAll(source);
            this.sourceList.setContentProvider((IContentProvider)new TableContentProvider());
            this.sourceList.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            this.sourceList.setInput((Object)this.sourceContent);
            if (source.size() > 0) {
                this.sourceList.setSelection((ISelection)new StructuredSelection(source.get(0)));
            }
        }

        public void initializeTargetList(List target) {
            this.targetContent.addAll(target);
            this.targetList.setContentProvider((IContentProvider)new TableContentProvider());
            this.targetList.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            this.targetList.setInput((Object)this.targetContent);
        }

        public void removeAll() {
            this.targetContent.clear();
            this.sourceContent.clear();
        }

        public List getSourceItems() {
            return this.sourceContent;
        }

        public List getTargetItems() {
            return this.targetContent;
        }

        public void addSelectionListener(SelectionListener listener) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }

        public void removeSelectionListener(SelectionListener listener) {
            this.listeners.remove(listener);
        }

        public void fireSelectionNotification(SelectionEvent e) {
            int i = 0;
            while (i < this.listeners.size()) {
                ((SelectionListener)this.listeners.get(i)).widgetSelected(e);
                ++i;
            }
        }

        private void createTableGroup(Composite parent, String text, boolean source) {
            Composite tableGroup = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            tableGroup.setLayout((Layout)layout);
            tableGroup.setLayoutData((Object)GridUtil.createFill());
            Label label = new Label(tableGroup, 0);
            label.setText(text);
            GridData spec = new GridData();
            spec.horizontalAlignment = 4;
            label.setLayoutData((Object)spec);
            CellEditor[] cellEditors = new CellEditor[1];
            if (source) {
                this.sourceList = new TableViewer(this.createTable(tableGroup));
                this.sourceList.getTable().setLayoutData((Object)GridUtil.createFill());
                this.sourceList.addDoubleClickListener(new IDoubleClickListener(){

                    public void doubleClick(DoubleClickEvent event) {
                        DoubleList.this.sourceListDoubleClick();
                    }
                });
                this.sourceList.setColumnProperties(this.tableColumnProperties);
            } else {
                this.targetList = new TableViewer(this.createTable(tableGroup));
                this.targetList.getTable().setLayoutData((Object)GridUtil.createFill());
                cellEditors[0] = new TextCellEditor((Composite)this.targetList.getTable());
                this.targetList.setCellEditors(cellEditors);
                this.targetList.setCellModifier((ICellModifier)new TableCellModifier());
                this.targetList.addDoubleClickListener(new IDoubleClickListener(){

                    public void doubleClick(DoubleClickEvent event) {
                        DoubleList.this.targetListDoubleClick();
                    }
                });
                this.targetList.setColumnProperties(this.tableColumnProperties);
            }
        }

        private Table createTable(Composite parent) {
            Table table = new Table(parent, 68354);
            GridData tblData = GridUtil.createFill();
            table.setLayoutData((Object)tblData);
            new TableColumn(table, 0);
            ColumnWeightData c0Layout = new ColumnWeightData(1, true);
            TableLayout tblLayout = new TableLayout();
            tblLayout.addColumnData((ColumnLayoutData)c0Layout);
            table.setLayout((Layout)tblLayout);
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            return table;
        }

        private void createButtonGroup(Composite groupWidget) {
            Composite buttonGroup = new Composite(groupWidget, 0);
            GridLayout blayout = new GridLayout();
            blayout.numColumns = 1;
            buttonGroup.setLayout((Layout)blayout);
            Label label = new Label(buttonGroup, 8);
            label.setText("");
            GridData spec = new GridData();
            spec.grabExcessVerticalSpace = true;
            spec.verticalAlignment = 4;
            label.setLayoutData((Object)spec);
            this.add = new Button(buttonGroup, 8);
            this.add.setText(UIMessages._134);
            spec = new GridData();
            spec.horizontalAlignment = 4;
            this.add.setLayoutData((Object)spec);
            this.remove = new Button(buttonGroup, 8);
            this.remove.setText(UIMessages._135);
            spec = new GridData();
            spec.horizontalAlignment = 4;
            this.remove.setLayoutData((Object)spec);
            new Label(buttonGroup, 0);
            this.addAll = new Button(buttonGroup, 8);
            this.addAll.setText(UIMessages._136);
            spec = new GridData();
            spec.horizontalAlignment = 4;
            this.addAll.setLayoutData((Object)spec);
            this.removeAll = new Button(buttonGroup, 8);
            this.removeAll.setText(UIMessages._137);
            spec = new GridData();
            spec.horizontalAlignment = 4;
            this.removeAll.setLayoutData((Object)spec);
            Label label1 = new Label(buttonGroup, 8);
            label1.setText("");
            spec = new GridData();
            spec.grabExcessVerticalSpace = true;
            spec.verticalAlignment = 4;
            label.setLayoutData((Object)spec);
        }

        class TableCellModifier
        implements ICellModifier {
            TableCellModifier() {
            }

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                if (DoubleList.this.NAME_TEXT.equals(property)) {
                    return ((FilterQueries)element).name();
                }
                return "";
            }

            public void modify(Object element, String property, Object value) {
                if (DoubleList.this.NAME_TEXT.equals(property)) {
                    ((FilterQueries)((TableItem)element).getData()).name(value.toString());
                    DoubleList.this.refreshViews();
                }
            }
        }

        class TableContentProvider
        implements IStructuredContentProvider {
            private List tableContents = new ArrayList(0);

            TableContentProvider() {
            }

            public Object[] getElements(Object inputElement) {
                return this.tableContents.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.tableContents = (List)newInput;
            }
        }

        class TableLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    if (element instanceof FilterQueries) {
                        FilterQueries fq = (FilterQueries)element;
                        IFilterType filterType = FilterTypesManager.instance().getFilterType(fq.type());
                        return filterType.icon().createImage();
                    }
                    return null;
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    if (element instanceof FilterQueries) {
                        return ((FilterQueries)element).name();
                    }
                    return element.toString();
                }
                return "";
            }

            public void dispose() {
                super.dispose();
            }
        }

        class WidgetListener
        implements SelectionListener {
            WidgetListener() {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem[] sel;
                boolean refreshViews = false;
                if (e.widget == DoubleList.this.add) {
                    IStructuredSelection sel2 = (IStructuredSelection)DoubleList.this.sourceList.getSelection();
                    for (Object item : sel2) {
                        DoubleList.this.targetContent.add(item);
                        DoubleList.this.sourceContent.remove(item);
                    }
                    DoubleList.this.sourceList.setSelection((ISelection)StructuredSelection.EMPTY);
                    refreshViews = true;
                } else if (e.widget == DoubleList.this.addAll) {
                    int i = 0;
                    while (i < DoubleList.this.sourceContent.size()) {
                        Object item = DoubleList.this.sourceContent.get(i);
                        DoubleList.this.targetContent.add(item);
                        ++i;
                    }
                    DoubleList.this.sourceContent.clear();
                    refreshViews = true;
                } else if (e.widget == DoubleList.this.remove) {
                    IStructuredSelection sel3 = (IStructuredSelection)DoubleList.this.targetList.getSelection();
                    for (Object item : sel3) {
                        DoubleList.this.sourceContent.add(item);
                        DoubleList.this.targetContent.remove(item);
                    }
                    DoubleList.this.targetList.setSelection((ISelection)StructuredSelection.EMPTY);
                    refreshViews = true;
                } else if (e.widget == DoubleList.this.removeAll) {
                    int i = 0;
                    while (i < DoubleList.this.targetContent.size()) {
                        Object item = DoubleList.this.targetContent.get(i);
                        DoubleList.this.sourceContent.add(item);
                        ++i;
                    }
                    DoubleList.this.targetContent.clear();
                    refreshViews = true;
                } else if (e.widget instanceof Table && (sel = ((Table)e.widget).getSelection()) != null && sel.length > 0) {
                    ((Table)e.widget).setToolTipText(sel[0].getText());
                }
                if (refreshViews) {
                    DoubleList.this.refreshViews();
                }
                DoubleList.this.fireSelectionNotification(e);
            }
        }
    }
}

