/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.wizard;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.ResourceUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.AttributeWizardPage;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.ui.wizard.LocationPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.NewProjectAction;

public abstract class HyadesNewWizard
extends HyadesWizard
implements INewWizard {
    protected static final String SET_LAST_SELECTION = "LAST_SELECTION";
    private LocationPage locationPage;
    private AttributeWizardPage attributeWizardPage;
    private IFile newFile;

    protected void initPages() {
        this.adjustSeletion();
        this.attributeWizardPage = new AttributeWizardPage("nameDescription");
    }

    protected IStructuredSelection adjustSeletion() {
        IResource resource;
        String lastSelection;
        if (UIUtil.getFirstOpenProject() == null) {
            new NewProjectAction().run();
            IProject newProject = UIUtil.getFirstOpenProject();
            if (newProject != null) {
                this.selection = new StructuredSelection((Object)newProject);
                return this.selection;
            }
        }
        if (this.selection != null && !this.selection.isEmpty()) {
            IResource resource2 = null;
            Object firstSelectedElement = this.selection.getFirstElement();
            if (firstSelectedElement instanceof IResource) {
                resource2 = (IResource)firstSelectedElement;
            } else if (firstSelectedElement instanceof IJavaProject) {
                resource2 = ((IJavaProject)firstSelectedElement).getProject();
            }
            if (resource2 != null && resource2.isAccessible()) {
                return this.selection;
            }
        }
        if (this.getDialogSettings() != null && (lastSelection = this.getDialogSettings().get(SET_LAST_SELECTION)) != null && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember(lastSelection)) != null && resource.isAccessible()) {
            this.selection = new StructuredSelection((Object)resource);
            return this.selection;
        }
        this.selection = StructuredSelection.EMPTY;
        return this.selection;
    }

    protected LocationPage getLocationPage() {
        if (this.locationPage == null) {
            this.locationPage = new LocationPage("location", this.selection);
            String fileExtension = this.getFileExtension();
            if (fileExtension != null) {
                this.locationPage.setFileExtension(fileExtension);
                this.locationPage.setFileName("");
            }
        }
        return this.locationPage;
    }

    protected AttributeWizardPage getAttributeWizardPage() {
        return this.attributeWizardPage;
    }

    public boolean performFinish() {
        String fileExtension;
        String fileName;
        IPath path;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (root.findMember(path = this.getLocationPage().getContainerFullPath()) == null) {
            try {
                ResourceUtil.createContainer((IContainer)root.getFolder(path), null);
            }
            catch (CoreException e) {
                this.handleException(path.toString(), (Exception)((Object)e));
                return false;
            }
        }
        if (!(fileName = this.getLocationPage().getFileName()).endsWith("." + (fileExtension = this.getLocationPage().getFileExtension()))) {
            fileName = String.valueOf(fileName) + "." + fileExtension;
        }
        path = path.append(fileName);
        IFile file = root.getFile(path);
        try {
            if (!this.createObject(file)) {
                return false;
            }
        }
        catch (Exception e) {
            this.handleException(file.getFullPath().toString(), e);
            return false;
        }
        this.newFile = file;
        this.selectAndReveal((IResource)file);
        try {
            this.openEditor(file);
        }
        catch (PartInitException e) {
            this.handleException(file.getFullPath().toString(), (Exception)((Object)e));
        }
        this.getDialogSettings().put(SET_LAST_SELECTION, this.getLocationPage().getContainerFullPath().toString());
        return true;
    }

    protected void selectAndReveal(IResource newResource) {
        ResourceUtil.selectAndReveal((IResource)newResource, (IWorkbenchWindow)this.getWorkbench().getActiveWorkbenchWindow());
    }

    protected String getFileExtension() {
        return null;
    }

    protected void openEditor(IFile file) throws PartInitException {
        UIUtil.openEditor((IFile)file, null, (boolean)false);
    }

    protected void handleException(String filePath, Exception exception) {
        HyadesUIPlugin.logError(exception);
        UIUtil.openSaveFileErrorDialog((Shell)this.getShell(), (String)filePath, (Throwable)exception);
    }

    protected abstract boolean createObject(IFile var1) throws Exception;

    public IFile getNewFile() {
        return this.newFile;
    }

    protected void setAttributeWizardPage(AttributeWizardPage attributeWizardPage) {
        this.attributeWizardPage = attributeWizardPage;
    }

    protected void setLocationPage(LocationPage locationPage) {
        this.locationPage = locationPage;
    }
}

